/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Qt includes
///////////////////////
#include <QtQml>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{

namespace libXpertMassGui
{

class DECLSPEC ScriptingGuiUtils : public QObject
{
  Q_OBJECT
  QML_NAMED_ELEMENT(ScriptingGuiUtils)

  public:
  explicit ScriptingGuiUtils(QWidget *scripting_wnd);
  virtual ~ScriptingGuiUtils();

  Q_INVOKABLE void print(const QString &text);
  Q_INVOKABLE void printToFile(const QString &text, const QString &file_name);
  Q_INVOKABLE void msleep(int milliseconds) const;
  Q_INVOKABLE void sleep(int seconds) const;

  private:
  QWidget *mp_scriptingWnd = nullptr;
};

} // namespace libXpertMassGui
} // namespace MsXpS

