#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 macaron
set -o errexit

###
# Indiana Jones and the Fate of Atlantis
# send your bug reports to contact@dotslashplay.it
###

script_version=20240623.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='indiana-jones-and-the-fate-of-atlantis'
GAME_NAME='Indiana Jones and the Fate of Atlantis'

ARCHIVE_BASE_EN_1_NAME='indiana_jones_and_the_fate_of_atlantis_en_gog_2_20145.sh'
ARCHIVE_BASE_EN_1_MD5='f7c093e148b001520809032095d7e8d7'
ARCHIVE_BASE_EN_1_SIZE='390000'
ARCHIVE_BASE_EN_1_VERSION='1.0-gog20145'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/indiana_jones_and_the_fate_of_atlantis'

ARCHIVE_BASE_FR_1_NAME='indiana_jones_and_the_fate_of_atlantis_fr_gog_2_20145.sh'
ARCHIVE_BASE_FR_1_MD5='edbfebcf9daa23e329e41ccf9c89286c'
ARCHIVE_BASE_FR_1_SIZE='240000'
ARCHIVE_BASE_FR_1_VERSION='1.0-gog20145'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/indiana_jones_and_the_fate_of_atlantis'

ARCHIVE_BASE_EN_0_NAME='gog_indiana_jones_and_the_fate_of_atlantis_2.2.0.27.sh'
ARCHIVE_BASE_EN_0_MD5='d56a5850b9d1d4f82eebc282ef7fb52b'
ARCHIVE_BASE_EN_0_SIZE='250000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog2.2.0.27'

ARCHIVE_BASE_FR_0_NAME='gog_indiana_jones_and_the_fate_of_atlantis_french_2.2.0.27.sh'
ARCHIVE_BASE_FR_0_MD5='0da3a8b3d0505c86a9f863c27debbca7'
ARCHIVE_BASE_FR_0_SIZE='99000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog2.2.0.27'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
atlantis.000
atlantis.001
monster.sou'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
*.pdf
*.txt'

APP_MAIN_SCUMMID='scumm:atlantis'
APP_MAIN_ICON='../support/icon.png'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_EN="${PKG_MAIN_ID}-en"
PKG_MAIN_ID_FR="${PKG_MAIN_ID}-fr"
PKG_MAIN_PROVIDES="
$PKG_MAIN_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Convert all file paths to lowercase.
	tolower .
)

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
