
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*******************************************************************************
*                   Copyright (c) 1991 - 2001 Gemplus
*
* Name        : ApduSpli.c
*
* Description : Module which splits APDU commands for T=0 protocole.
*
*
* Compiler    : Microsoft C PDS 6.0 / 7.0 /8.0
*               Borland   C++   3.x / 4.0
*               Microsoft C++ 1.5 for Windows 16 bits
*               Microsoft C++ 2.0 for Windows 32 bits
*               Borland   C++ 2.0 pour OS/2
*
* Host        : IBM PC and compatible machines under MS/DOS 3.1 and upper.
*               IBM PC and compatible machines under Windows 3.x.
*               IBM PC and compatible machines under Windows 32 bits (W95 or WNT).
*               IBM PC and compatible machines under OS/2 Warp.
*
* Release     : 4.31.002
*
* Last Modif  : 24/08/98: V4.31.002  (GP)
*               13/10/97: V4.31.001  (GP)
*               18/03/97: V4.30.001  (TF)
*                 - Start of development.
*
********************************************************************************
*
* Warning     : The 7616-4 standard indicates that only the transmission system
*               can initiate GET_RESPONSE and ENVELOPE command. This two
*               commands cannot be transmitted by this module.
*
* Remark      : The true cases 2E and 4E.2 are not supported because the command
*               ENVELOPE is not supported by this module.
*
*******************************************************************************/

#define G_NAME     "ApduSpli"
#define G_RELEASE  "4.31.002"

#ifdef _MSC_VER
#pragma comment(exestr,"Gemplus(c) "G_NAME" Ver "G_RELEASE" "__DATE__)
#endif

#include <pcsclite.h>

#include "gemplus.h"
#if (defined WIN32) || (defined G_UNIX) || (defined G_OS2)
#include "gemansi.h"
#endif
#include "gemgcr.h"
#include "t0cases.h"

#include "apduspli.h"

INT16 G_DECL ApduSpliter
	(const WORD32 Timeout,
	const G4_APDU_COMM G_FAR * ApduComm,
	G4_APDU_RESP G_FAR * ApduResp,
	INT16(G_DECL * IsoIn)
	(const WORD32 Timeout,
const WORD8 G_FAR Command[5],
const WORD8 G_FAR Data[],
WORD16 G_FAR * RespLen,
BYTE G_FAR RespBuff[]),
INT16(G_DECL * IsoOut) (const WORD32 Timeout, const WORD8 G_FAR Command[5], WORD16 G_FAR * RespLen, BYTE G_FAR RespBuff[]))
{
	// 2001 Modif--
	// printf("ApduSpliter\n") ;
	// --2001 Modif
	if (ApduComm->LengthExpected == 0)
	{
		if (ApduComm->LengthIn == 0)
		{
			// 2001 Modif--
			// printf("Case 0\n") ;
			// --2001 Modif

			return (G_T0Case1(Timeout, ApduComm, ApduResp, IsoIn));
		} else if (ApduComm->LengthIn <= HT0CASES_LIN_SHORT_MAX)
		{
			// 2001 Modif--
			// printf("Case 2S\n") ;
			// --2001 Modif
			return (G_T0Case2S(Timeout, ApduComm, ApduResp, IsoIn));
		}
		ApduResp->LengthOut = 0;
		ApduResp->Status = HT0CASES_WRONG_LENGTH;
		return (G_OK);
	} else if (ApduComm->LengthIn == 0)
	{
		if (ApduComm->LengthExpected <= HT0CASES_LEX_SHORT_MAX)
		{
			// 2001 Modif--
			// printf("Case 3S\n") ;
			// --2001 Modif
			return (G_T0Case3S(Timeout, ApduComm, ApduResp, IsoOut));
		} else
		{
			return (G_T0Case3E(Timeout, ApduComm, ApduResp, IsoOut));
		}
	}
		else if ((ApduComm->LengthIn <= HT0CASES_LIN_SHORT_MAX)
		&& (ApduComm->LengthExpected <= HT0CASES_LEX_SHORT_MAX))
	{
		// 2001 Modif--
		// printf("T=0 Case 4S\n") ;
		// --2001 Modif
		return (G_T0Case4S(Timeout, ApduComm, ApduResp, IsoIn, IsoOut));
	} else
	{
		return (G_T0Case4E(Timeout, ApduComm, ApduResp, IsoIn, IsoOut));
	}
}
