

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


// ./tests/pappsotree/catch2-only-pappsotree [mzmlname] -s


//    msconvert
//    /gorgone/pappso/formation/Janvier2014/TD/mzXML/20120906_balliau_extract_1_A01_urnb-1.mzXML
//    --filter "index 4291" --mgf

#include <catch2/catch_test_macros.hpp>
#include <catch2/catch_approx.hpp>
#include <catch2/matchers/catch_matchers_vector.hpp>

#include <QString>
#include <QFile>
#include <QJsonObject>
#include <iostream>
#include "../common.h"
#include "tests/tests-config.h"
#include <pappsomspp/core/msfile/msfileaccessor.h>
#include <pappsomspp/core/msrun/msrunreader.h>


TEST_CASE("test msrun sample name in mzml.", "[mzmlname]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION("..:: Check sample name ::..", "[mzmlname]")
  {
    //

    pappso::MsFileAccessor file_access(
      "/gorgone/pappso/moulon/raw/20251015_test_hoac_precipitation/"
      "20251015_test_hoac_precipitation_1_20251016185414.mzML",
      "");
    pappso::MsRunReaderSPtr msrunA01 = file_access.getMsRunReaderSPtrByRunId("", "runa01");

    REQUIRE(msrunA01.get()->getMsRunId().get()->getSampleName().toStdString() ==
            "20251015_test_hoac_precipitation_1_20251016185414");
  }

  //


  SECTION("..:: Check sample name ::..", "[mzmlname]")
  {
    //


    pappso::MsFileAccessor file_access(
      "/gorgone/pappso/moulon/raw/20251127_yeastpep_50_51/"
      "20251127_yeastpeps_51_2024E5_M_acetyl.mzML",
      "");
    pappso::MsRunReaderSPtr msrunA01 = file_access.getMsRunReaderSPtrByRunId("", "runa01");


    std::size_t index              = msrunA01.get()->scanNumber2SpectrumIndex(6587);
    MassSpectrumSPtr mass_spectrum = msrunA01.get()->massSpectrumSPtr(index);


    QFile jsonf(QString("20251127_yeastpeps_51_2024E5_M_acetyl_%1.json").arg(index));


    if(jsonf.open(QIODevice::WriteOnly))
      {
        QJsonDocument doc;
        QJsonObject psm_json;

        QJsonObject spectrum_json;
        spectrum_json.insert("mz", toJson(mass_spectrum.get()->xValues()));
        spectrum_json.insert("intensity", toJson(mass_spectrum.get()->yValues()));

        psm_json.insert("spectra", spectrum_json);

        doc.setObject(psm_json);
        jsonf.write(doc.toJson());
        jsonf.close();
      }
  }
}
