
#pragma once

#include <functional>
#include <unordered_map>

#include <QtQml>
#include <QMap>



/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/jsclassregistrar.h"

namespace MsXpS
{
namespace libXpertMassGui
{

//! Kind of entity handled in a JavaScript object creation operation.
/*!
 * When creating JavaScript objects, define which kind of entity is being
 * created.
 *
 * \sa msXpSlibXpertMassGui::ScriptingWnd
 * \sa msXpSlibXpertMassGui::ScriptingObjectTreeWidgetItem
 */
enum ScriptEntityType
{
  UndefinedEntity,
  StringEntity,
  FunctionEntity,
  ArrayOrListEntity,
  QObjectEntity,
  IntegerEntity,
  DoubleEntity
};

class DECLSPEC ScriptingEnginesBridge: public QObject
{
  Q_OBJECT
  public:
  explicit ScriptingEnginesBridge(QObject *parent = nullptr);

  // Evaluate JavaScript code
  Q_INVOKABLE QJSValue evaluate(const QString &script);

  // Expose QML component creation to JS
  Q_INVOKABLE QObject *createQmlObject(const QString &qml_code,
                                       QObject *parent = nullptr);

  // Get the engines
  Q_INVOKABLE QQmlEngine *getQmlEngine() const;
  Q_INVOKABLE QJSEngine *getJsEngine() const;

  Q_INVOKABLE bool exposeObject(const QString &name,
                                const QString &alias,
                                QObject *object,
                                QJSValue &returned_js_value,
                                QJSEngine::ObjectOwnership ownership =
                                  QJSEngine::ObjectOwnership::CppOwnership);

  Q_INVOKABLE bool exposeJsEngineJsValue(const QString &name,
                                         QJSValue &js_value);

  QJSValue getExposedJsEngineObjectByName(const QString &name);
  QObject *getExposedQmlEngineObjectByName(const QString &name);

  void registerJsConstructorForClassInRegistrarMap(const QString &name_space,
                             const QString &class_name);

  void registerJsConstructorForClassesInRegistrarMap(
    const std::vector<std::pair<QString, QString>> &namespace_class_pairs);

  void registerJsConstructorForEachClassInRegistrarMap();

  void registerOwnJsEntities();
  void registerExternalJsEntities(const QString &name_space);

  signals:
  void errorOccurredSignal(const QString &errorMessage);

  private:
  QQmlEngine *mp_qmlEngine;
  QJSEngine *mp_jsEngine;
  QString m_lastError;

  // Initialize both engines
  void initialize();
};

} // namespace libXpertMassGui
} // namespace MsXpS
