/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehavior<T>
implements Behavior<T>,
ComponentMonitorStrategy,
LifecycleStrategy,
Serializable {
    protected final ComponentAdapter<T> delegate;

    public AbstractBehavior(ComponentAdapter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    @Override
    public Class<? extends T> getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        return this.delegate.getComponentInstance(container, into);
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
        this.delegate.verify(container);
    }

    @Override
    public final ComponentAdapter<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public final <U extends ComponentAdapter> U findAdapterOfType(Class<U> adapterType) {
        if (adapterType.isAssignableFrom(this.getClass())) {
            return (U)this;
        }
        return this.delegate.findAdapterOfType(adapterType);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
        this.delegate.accept(visitor);
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
        }
    }

    @Override
    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        throw new PicoCompositionException("No component monitor found in delegate");
    }

    @Override
    public void start(PicoContainer container) {
        if (this.delegate instanceof Behavior) {
            ((Behavior)this.delegate).start(container);
        }
    }

    @Override
    public void stop(PicoContainer container) {
        if (this.delegate instanceof Behavior) {
            ((Behavior)this.delegate).stop(container);
        }
    }

    @Override
    public void dispose(PicoContainer container) {
        if (this.delegate instanceof Behavior) {
            ((Behavior)this.delegate).dispose(container);
        }
    }

    @Override
    public boolean componentHasLifecycle() {
        if (this.delegate instanceof Behavior) {
            return ((Behavior)this.delegate).componentHasLifecycle();
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        if (this.delegate instanceof Behavior) {
            return ((Behavior)this.delegate).isStarted();
        }
        return false;
    }

    @Override
    public void start(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).start(component);
        }
    }

    @Override
    public void stop(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).stop(component);
        }
    }

    @Override
    public void dispose(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).dispose(component);
        }
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        return this.delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(type);
    }

    @Override
    public boolean isLazy(ComponentAdapter<?> adapter) {
        return this.delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)this.delegate)).isLazy(adapter);
    }

    public String toString() {
        return this.getDescriptor() + ":" + this.delegate.toString();
    }
}

