/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.List;
import java.util.function.Predicate;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class VacantPlayersMessage
extends AttributeMessage {
    public static final String TAG = "vacantPlayers";

    public VacantPlayersMessage() {
        super(TAG);
    }

    public VacantPlayersMessage(Game game, FreeColXMLReader xr) {
        super(TAG, xr.getArrayAttributeMap());
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        List<String> vacant = this.getVacantPlayers();
        freeColClient.setVacantPlayerNames(vacant);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return this.pgc(freeColServer).vacantPlayers();
    }

    public List<String> getVacantPlayers() {
        return this.getArrayAttributes();
    }

    public VacantPlayersMessage setVacantPlayers(Game game) {
        if (game == null) {
            return this;
        }
        Predicate<Player> vacantPred = p -> !p.isREF() && (p.isAI() || !p.isConnected());
        this.setArrayAttributes(CollectionUtils.transform(game.getLiveEuropeanPlayers(new Player[0]), vacantPred, Player::getNationId));
        return this;
    }
}

