/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.Graphics2D;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.codeexplorer.configurator.CodeDependenciesPanel;
import org.freeplane.plugin.codeexplorer.configurator.CodeExplorerConfigurator;
import org.freeplane.plugin.codeexplorer.configurator.RunAnalysisAction;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.map.DependencySelection;
import org.freeplane.plugin.codeexplorer.task.CodeExplorer;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfigurations;

public class CodeProjectController
implements IExtension {
    private CodeDependenciesPanel codeDependenciesPanel;
    private ModeController modeController;
    private JTabbedPane informationPanel;
    private CodeDependency selectedDependency;
    private CodeExplorerConfigurator configurator;
    private CodeExplorerConfigurations explorerConfigurations;

    public CodeProjectController(final ModeController modeController) {
        this.modeController = modeController;
        this.explorerConfigurations = CodeExplorerConfigurations.loadConfigurations();
        Controller controller = modeController.getController();
        ((HighlightController)controller.getExtension(HighlightController.class)).addNodeHighlighter(new NodeHighlighter(){

            public boolean isNodeHighlighted(NodeModel node, boolean isPrinting) {
                return !isPrinting && modeController == Controller.getCurrentModeController() && CodeProjectController.this.isDependencySelectedForNode(node);
            }

            public void configure(NodeModel node, Graphics2D g, boolean isPrinting) {
                g.setColor(FilterController.HIGHLIGHT_COLOR);
            }
        });
        modeController.addAction((AFreeplaneAction)new RunAnalysisAction(this));
    }

    private void hideControlPanel() {
        this.modeController.getController().getViewController().removeSplitPane();
    }

    private void showControlPanel() {
        this.informationPanel = new JTabbedPane();
        this.codeDependenciesPanel = new CodeDependenciesPanel();
        this.codeDependenciesPanel.addDependencySelectionCallback(this::updateSelectedDependency);
        this.configurator = new CodeExplorerConfigurator(this);
        this.informationPanel.addTab("Configurations", this.configurator);
        this.informationPanel.addTab("Dependencies", this.codeDependenciesPanel);
        this.modeController.getController().getViewController().insertComponentIntoSplitPane((JComponent)this.informationPanel);
        this.informationPanel.setVisible(true);
        this.informationPanel.revalidate();
    }

    public void startupController() {
        this.showControlPanel();
        MapController mapController = this.modeController.getMapController();
        mapController.addNodeSelectionListener((INodeSelectionListener)this.codeDependenciesPanel);
        mapController.addMapChangeListener((IMapChangeListener)this.codeDependenciesPanel);
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.codeDependenciesPanel);
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)this.codeDependenciesPanel);
        this.codeDependenciesPanel.update();
    }

    public void shutdownController() {
        MapController mapController = this.modeController.getMapController();
        mapController.removeNodeSelectionListener((INodeSelectionListener)this.codeDependenciesPanel);
        mapController.removeMapChangeListener((IMapChangeListener)this.codeDependenciesPanel);
        Controller.getCurrentController().getMapViewManager().removeMapSelectionListener((IMapSelectionListener)this.codeDependenciesPanel);
        ResourceController.getResourceController().removePropertyChangeListener((IFreeplanePropertyListener)this.codeDependenciesPanel);
        this.hideControlPanel();
        this.informationPanel = null;
        this.configurator = null;
        this.codeDependenciesPanel = null;
        this.selectedDependency = null;
    }

    private boolean isDependencySelectedForNode(NodeModel node) {
        if (this.selectedDependency == null) {
            return false;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null || node.getMap() != selection.getMap()) {
            return false;
        }
        DependencySelection dependencySelection = new DependencySelection(selection);
        JavaClass[] dependencyClasses = new JavaClass[]{this.selectedDependency.getOriginClass(), this.selectedDependency.getTargetClass()};
        return Stream.of(dependencyClasses).anyMatch(javaClass -> node.equals((Object)dependencySelection.getVisibleNode((JavaClass)javaClass)));
    }

    private void updateSelectedDependency(CodeDependency selectedDependency) {
        this.selectedDependency = selectedDependency;
        this.modeController.getController().getMapViewManager().getMapViewComponent().repaint();
    }

    void exploreSelectedConfiguration() {
        if (this.configurator != null) {
            CodeExplorerConfiguration selectedConfiguration = this.configurator.getSelectedConfiguration();
            this.exploreConfiguration(selectedConfiguration);
        }
    }

    void exploreConfiguration(CodeExplorerConfiguration selectedConfiguration) {
        CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
        codeExplorer.explore(selectedConfiguration);
    }

    public void saveConfiguration() {
        this.explorerConfigurations.saveConfiguration();
    }

    public CodeExplorerConfigurations explorerConfigurations() {
        return this.explorerConfigurations;
    }

    public void updateJudge() {
        if (this.configurator != null) {
            CodeExplorerConfiguration selectedConfiguration = this.configurator.getSelectedConfiguration();
            CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
            codeExplorer.setJudge(selectedConfiguration.getDependencyJudge());
            this.codeDependenciesPanel.update();
        }
    }

    public void cancelAnalysis() {
        CodeExplorer codeExplorer = (CodeExplorer)Controller.getCurrentModeController().getMapController();
        codeExplorer.cancelAnalysis();
    }
}

