/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.richtooltip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.gephi.ui.components.richtooltip.JRichTooltipPanel;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.gephi.ui.components.richtooltip.RichTooltipPanelUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

class BasicRichTooltipPanelUI
extends RichTooltipPanelUI {
    protected JRichTooltipPanel richTooltipPanel;
    protected JLabel titleLabel;
    protected List<JLabel> descriptionLabels = new ArrayList<JLabel>();
    protected JLabel mainImageLabel;
    protected JSeparator footerSeparator;
    protected JLabel footerImageLabel;
    protected List<JLabel> footerLabels = new ArrayList<JLabel>();

    public static ComponentUI createUI(JComponent c) {
        return new BasicRichTooltipPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.richTooltipPanel = (JRichTooltipPanel)c;
        super.installUI(this.richTooltipPanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.richTooltipPanel.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.richTooltipPanel);
    }

    protected void installDefaults() {
        Border b = this.richTooltipPanel.getBorder();
        if (b == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("RichTooltipPanel.border");
            if (toSet == null) {
                toSet = new BorderUIResource.CompoundBorderUIResource(new LineBorder(FlamingoUtilities.getBorderColor()), new EmptyBorder(2, 4, 3, 4));
            }
            this.richTooltipPanel.setBorder(toSet);
        }
        LookAndFeel.installProperty(this.richTooltipPanel, "opaque", Boolean.TRUE);
    }

    protected void installListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.richTooltipPanel);
    }

    protected void uninstallListeners() {
    }

    protected void uninstallComponents() {
        this.removeExistingComponents();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paintBackground(g);
        this.paint(g, c);
    }

    protected void paintBackground(Graphics g) {
        Color main = FlamingoUtilities.getColor((Color)Color.gray, (String[])new String[]{"Label.disabledForeground"}).brighter();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getLighterColor((Color)main, (double)0.9), 0.0f, this.richTooltipPanel.getHeight(), FlamingoUtilities.getLighterColor((Color)main, (double)0.4)));
        g2d.fillRect(0, 0, this.richTooltipPanel.getWidth(), this.richTooltipPanel.getHeight());
        g2d.setFont(FlamingoUtilities.getFont((Component)this.richTooltipPanel, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"}));
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    protected LayoutManager createLayoutManager() {
        return new RichTooltipPanelLayout();
    }

    protected int getDescriptionTextWidth() {
        return 200;
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected void removeExistingComponents() {
        if (this.titleLabel != null) {
            this.richTooltipPanel.remove(this.titleLabel);
        }
        if (this.mainImageLabel != null) {
            this.richTooltipPanel.remove(this.mainImageLabel);
        }
        for (JLabel label : this.descriptionLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.footerSeparator != null) {
            this.richTooltipPanel.remove(this.footerSeparator);
        }
        if (this.footerImageLabel != null) {
            this.richTooltipPanel.remove(this.footerImageLabel);
        }
        for (JLabel label : this.footerLabels) {
            this.richTooltipPanel.remove(label);
        }
    }

    protected class RichTooltipPanelLayout
    implements LayoutManager {
        protected RichTooltipPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets ins = parent.getInsets();
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            FontUIResource font = FlamingoUtilities.getFont((Component)parent, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"});
            int descTextWidth = BasicRichTooltipPanelUI.this.getDescriptionTextWidth();
            int width = ins.left + 2 * gap + descTextWidth + ins.right;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            if (tooltipInfo.getMainImage() != null) {
                width += tooltipInfo.getMainImage().getWidth(null);
            }
            int fontHeight = parent.getFontMetrics(font).getHeight();
            int height = ins.top;
            height += fontHeight + gap;
            int descriptionTextHeight = 0;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl;
                AttributedString attributedDescription = new AttributedString(descText);
                attributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                while ((tl = lineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                    descriptionTextHeight += fontHeight;
                }
                descriptionTextHeight += fontHeight;
            }
            height = tooltipInfo.getMainImage() != null ? (height += Math.max(descriptionTextHeight, new JLabel((Icon)new ImageIcon((Image)tooltipInfo.getMainImage())).getPreferredSize().height)) : (height += (descriptionTextHeight -= fontHeight));
            if (tooltipInfo.getFooterImage() != null || tooltipInfo.getFooterSections().size() > 0) {
                height += gap;
                height += new JSeparator((int)0).getPreferredSize().height;
                height += gap;
                int footerTextHeight = 0;
                int availableWidth = descTextWidth;
                if (tooltipInfo.getFooterImage() != null) {
                    availableWidth -= tooltipInfo.getFooterImage().getWidth(null);
                }
                if (tooltipInfo.getMainImage() != null) {
                    availableWidth += tooltipInfo.getMainImage().getWidth(null);
                }
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl;
                    AttributedString attributedDescription = new AttributedString(footerText);
                    attributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                    while ((tl = lineBreakMeasurer.nextLayout(availableWidth)) != null) {
                        footerTextHeight += fontHeight;
                    }
                    footerTextHeight += fontHeight;
                }
                height = tooltipInfo.getFooterImage() != null ? (height += Math.max(footerTextHeight, new JLabel((Icon)new ImageIcon((Image)tooltipInfo.getFooterImage())).getPreferredSize().height)) : (height += (footerTextHeight -= fontHeight));
            }
            return new Dimension(width, height += ins.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent.getWidth() <= 1) {
                return;
            }
            BasicRichTooltipPanelUI.this.removeExistingComponents();
            FontUIResource font = FlamingoUtilities.getFont((Component)parent, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"});
            Insets ins = BasicRichTooltipPanelUI.this.richTooltipPanel.getInsets();
            int y = ins.top;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            int fontHeight = parent.getFontMetrics(font).getHeight();
            BasicRichTooltipPanelUI.this.titleLabel = new JLabel(tooltipInfo.getTitle());
            BasicRichTooltipPanelUI.this.titleLabel.setFont(BasicRichTooltipPanelUI.this.titleLabel.getFont().deriveFont(1));
            BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.titleLabel);
            BasicRichTooltipPanelUI.this.titleLabel.setBounds(ins.left, y, BasicRichTooltipPanelUI.this.titleLabel.getPreferredSize().width, fontHeight);
            y += BasicRichTooltipPanelUI.this.titleLabel.getHeight() + gap;
            int x = ins.left;
            if (tooltipInfo.getMainImage() != null) {
                BasicRichTooltipPanelUI.this.mainImageLabel = new JLabel(new ImageIcon(tooltipInfo.getMainImage()));
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.mainImageLabel);
                BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x, y, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().width, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                x += BasicRichTooltipPanelUI.this.mainImageLabel.getWidth();
            }
            int descLabelWidth = parent.getWidth() - (x += 2 * gap) - ins.right;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl;
                AttributedString attributedDescription = new AttributedString(descText);
                attributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                int currOffset = 0;
                while ((tl = lineBreakMeasurer.nextLayout(descLabelWidth)) != null) {
                    int charCount = tl.getCharacterCount();
                    String line = descText.substring(currOffset, currOffset + charCount);
                    JLabel descLabel = new JLabel(line);
                    BasicRichTooltipPanelUI.this.descriptionLabels.add(descLabel);
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(descLabel);
                    descLabel.setBounds(x, y, descLabel.getPreferredSize().width, fontHeight);
                    y += descLabel.getHeight();
                    currOffset += charCount;
                }
                y += BasicRichTooltipPanelUI.this.titleLabel.getHeight();
            }
            y -= BasicRichTooltipPanelUI.this.titleLabel.getHeight();
            if (BasicRichTooltipPanelUI.this.mainImageLabel != null) {
                y = Math.max(y, BasicRichTooltipPanelUI.this.mainImageLabel.getY() + BasicRichTooltipPanelUI.this.mainImageLabel.getHeight());
            }
            if (tooltipInfo.getFooterImage() != null || tooltipInfo.getFooterSections().size() > 0) {
                BasicRichTooltipPanelUI.this.footerSeparator = new JSeparator(0);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerSeparator);
                BasicRichTooltipPanelUI.this.footerSeparator.setBounds(ins.left, y += gap, parent.getWidth() - ins.left - ins.right, BasicRichTooltipPanelUI.this.footerSeparator.getPreferredSize().height);
                y += BasicRichTooltipPanelUI.this.footerSeparator.getHeight() + gap;
                x = ins.left;
                if (tooltipInfo.getFooterImage() != null) {
                    BasicRichTooltipPanelUI.this.footerImageLabel = new JLabel(new ImageIcon(tooltipInfo.getFooterImage()));
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerImageLabel);
                    BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x, y, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().width, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                    x += BasicRichTooltipPanelUI.this.footerImageLabel.getWidth() + 2 * gap;
                }
                int footerLabelWidth = parent.getWidth() - x - ins.right;
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl;
                    AttributedString attributedDescription = new AttributedString(footerText);
                    attributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                    int currOffset = 0;
                    while ((tl = lineBreakMeasurer.nextLayout(footerLabelWidth)) != null) {
                        int charCount = tl.getCharacterCount();
                        String line = footerText.substring(currOffset, currOffset + charCount);
                        JLabel footerLabel = new JLabel(line);
                        BasicRichTooltipPanelUI.this.footerLabels.add(footerLabel);
                        BasicRichTooltipPanelUI.this.richTooltipPanel.add(footerLabel);
                        footerLabel.setBounds(x, y, footerLabel.getPreferredSize().width, fontHeight);
                        y += footerLabel.getHeight();
                        currOffset += charCount;
                    }
                    y += BasicRichTooltipPanelUI.this.titleLabel.getHeight();
                }
                y -= BasicRichTooltipPanelUI.this.titleLabel.getHeight();
            }
        }
    }
}

