/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.data.DataPoint;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.profile.SpeedData;

public class SelectExtremePoint
extends GenericFunction {
    private final Extreme _extreme;

    public SelectExtremePoint(App app, Extreme extreme) {
        super(app);
        this._extreme = extreme;
    }

    @Override
    public void begin() {
        if (this._extreme == Extreme.HIGHEST || this._extreme == Extreme.LOWEST) {
            this.selectHighestOrLowest();
        } else if (this._extreme == Extreme.FASTEST) {
            this.selectFastest();
        } else {
            throw new IllegalArgumentException("Unexpected extreme: " + (Object)((Object)this._extreme));
        }
    }

    private void selectHighestOrLowest() {
        int n = -1;
        double d = 0.0;
        int n2 = 0;
        while (n2 < this._app.getTrackInfo().getTrack().getNumPoints()) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n2);
            double d2 = 0.0;
            if (dataPoint.hasAltitude()) {
                d2 = dataPoint.getAltitude().getMetricValue();
                if (this._extreme == Extreme.LOWEST) {
                    d2 = -d2;
                }
                if (n == -1 || d2 > d) {
                    d = d2;
                    n = n2;
                }
            }
            ++n2;
        }
        if (n >= 0) {
            this._app.getTrackInfo().selectPoint(n);
        }
    }

    public void selectFastest() {
        SpeedData speedData = new SpeedData(this._app.getTrackInfo().getTrack());
        speedData.init(UnitSetLibrary.getUnitSet(0));
        int n = -1;
        double d = 0.0;
        int n2 = 0;
        while (n2 < this._app.getTrackInfo().getTrack().getNumPoints()) {
            block8: {
                double d2;
                block7: {
                    block6: {
                        d2 = 0.0;
                        DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n2);
                        if (!dataPoint.hasHSpeed()) break block6;
                        d2 = dataPoint.getHSpeed().getValueInMetresPerSec();
                        break block7;
                    }
                    if (!speedData.hasData(n2)) break block8;
                    d2 = speedData.getData(n2);
                }
                if (n == -1 || d2 > d) {
                    d = d2;
                    n = n2;
                }
            }
            ++n2;
        }
        if (n > -1) {
            this._app.getTrackInfo().selectPoint(n);
        }
    }

    @Override
    public String getNameKey() {
        return "menu.point.goto." + this._extreme.toString().toLowerCase();
    }

    public static enum Extreme {
        HIGHEST,
        LOWEST,
        FASTEST;

    }
}

