/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.media;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendMediaCmd;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.ConnectMediaCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.MediaObject;
import tim.prune.data.UnitSetLibrary;
import tim.prune.load.MediaHelper;

public class LinkedMediaLoader {
    private final App _app;
    private final HashSet<String> _blockedDomains = new HashSet();
    private final HashSet<String> _allowedDomains = new HashSet();

    public LinkedMediaLoader(App app) {
        this._app = app;
    }

    public void loadFromUrl(URL uRL, DataPoint dataPoint) {
        if (this.isDomainAllowed(uRL)) {
            this.loadMedia(MediaHelper.createMediaObjectFromUrl(uRL), dataPoint);
        }
        this._app.informDataLoadComplete();
    }

    private void loadMedia(MediaObject mediaObject, DataPoint dataPoint) {
        double d;
        if (mediaObject == null) {
            return;
        }
        DataPoint dataPoint2 = mediaObject.getDataPoint();
        MediaObject.Status status = dataPoint2 == null ? MediaObject.Status.NOT_CONNECTED : MediaObject.Status.TAGGED;
        mediaObject.setOriginalStatus(status);
        MediaObject.Status status2 = MediaObject.Status.TAGGED;
        if (dataPoint2 != null && (d = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween(dataPoint2, dataPoint), UnitSetLibrary.UNITS_METRES)) > 10.0) {
            status2 = MediaObject.Status.CONNECTED;
        }
        mediaObject.setCurrentStatus(status2);
        CompoundCommand compoundCommand = new CompoundCommand().addCommand(new AppendMediaCmd(List.of(mediaObject))).addCommand(new ConnectMediaCmd(dataPoint, mediaObject));
        compoundCommand.setDescription(I18nManager.getText("undo.loadmedia", mediaObject.getName()));
        compoundCommand.setConfirmText(I18nManager.getText("confirm.loadedmedia"));
        this._app.execute(compoundCommand);
    }

    private boolean isDomainAllowed(URL uRL) {
        if (uRL == null) {
            return false;
        }
        String string = uRL.getHost();
        if (this._allowedDomains.contains(string)) {
            return true;
        }
        if (this._blockedDomains.contains(string)) {
            return false;
        }
        Object[] objectArray = new Object[]{I18nManager.getText("button.allow"), I18nManager.getText("button.block")};
        String string2 = String.valueOf(LinkedMediaLoader.splitUrl(uRL.toString())) + "\n\n" + I18nManager.getText("dialog.loadlinkedmedia.allowdomain", string);
        int n = JOptionPane.showOptionDialog(this._app.getFrame(), string2, I18nManager.getText("dialog.loadlinkedmedia.title"), 0, 2, null, objectArray, objectArray[1]);
        if (n == 0) {
            this._allowedDomains.add(string);
        }
        if (n == 1) {
            this._blockedDomains.add(string);
        }
        return n == 0;
    }

    static String splitUrl(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.trim();
        int n = 0;
        while (n + 50 < string2.length()) {
            stringBuilder.append(string2.substring(n, n + 50));
            stringBuilder.append('\n');
            n += 50;
        }
        stringBuilder.append(string2.substring(n));
        return stringBuilder.toString();
    }

    public void loadFromArchive(File file, String string, DataPoint dataPoint) {
        this.loadMedia(MediaHelper.createMediaObjectRelative(file, string, file), dataPoint);
        this._app.informDataLoadComplete();
    }
}

