/* Generated by wayland-scanner 1.22.0 */

#ifndef HYPRLAND_GLOBAL_SHORTCUTS_V1_SERVER_PROTOCOL_H
#define HYPRLAND_GLOBAL_SHORTCUTS_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_hyprland_global_shortcuts_v1 The hyprland_global_shortcuts_v1 protocol
 * registering global shortcuts
 *
 * @section page_desc_hyprland_global_shortcuts_v1 Description
 *
 * This protocol allows a client to register triggerable actions,
 * meant to be global shortcuts.
 *
 * @section page_ifaces_hyprland_global_shortcuts_v1 Interfaces
 * - @subpage page_iface_hyprland_global_shortcuts_manager_v1 - manager to register global shortcuts
 * - @subpage page_iface_hyprland_global_shortcut_v1 - a shortcut
 * @section page_copyright_hyprland_global_shortcuts_v1 Copyright
 * <pre>
 *
 * Copyright © 2022 Vaxry
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 */
struct hyprland_global_shortcut_v1;
struct hyprland_global_shortcuts_manager_v1;

#ifndef HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_INTERFACE
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_INTERFACE
/**
 * @page page_iface_hyprland_global_shortcuts_manager_v1 hyprland_global_shortcuts_manager_v1
 * @section page_iface_hyprland_global_shortcuts_manager_v1_desc Description
 *
 * This object is a manager which offers requests to create global shortcuts.
 * @section page_iface_hyprland_global_shortcuts_manager_v1_api API
 * See @ref iface_hyprland_global_shortcuts_manager_v1.
 */
/**
 * @defgroup iface_hyprland_global_shortcuts_manager_v1 The hyprland_global_shortcuts_manager_v1 interface
 *
 * This object is a manager which offers requests to create global shortcuts.
 */
extern const struct wl_interface hyprland_global_shortcuts_manager_v1_interface;
#endif
#ifndef HYPRLAND_GLOBAL_SHORTCUT_V1_INTERFACE
#define HYPRLAND_GLOBAL_SHORTCUT_V1_INTERFACE
/**
 * @page page_iface_hyprland_global_shortcut_v1 hyprland_global_shortcut_v1
 * @section page_iface_hyprland_global_shortcut_v1_desc Description
 *
 * This object represents a single shortcut.
 * @section page_iface_hyprland_global_shortcut_v1_api API
 * See @ref iface_hyprland_global_shortcut_v1.
 */
/**
 * @defgroup iface_hyprland_global_shortcut_v1 The hyprland_global_shortcut_v1 interface
 *
 * This object represents a single shortcut.
 */
extern const struct wl_interface hyprland_global_shortcut_v1_interface;
#endif

#ifndef HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ENUM
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ENUM
enum hyprland_global_shortcuts_manager_v1_error {
	/**
	 * the app_id + id combination has already been registered.
	 */
	HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ALREADY_TAKEN = 0,
};
#endif /* HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 * @struct hyprland_global_shortcuts_manager_v1_interface
 */
struct hyprland_global_shortcuts_manager_v1_interface {
	/**
	 * register a shortcut
	 *
	 * Register a new global shortcut.
	 *
	 * A global shortcut is anonymous, meaning the app does not know
	 * what key(s) trigger it.
	 *
	 * The shortcut's keybinding shall be dealt with by the compositor.
	 *
	 * In the case of a duplicate app_id + id combination, the
	 * already_taken protocol error is raised.
	 * @param id a unique id for the shortcut
	 * @param app_id the app_id of the application requesting the shortcut
	 * @param description user-readable text describing what the shortcut does.
	 * @param trigger_description user-readable text describing how to trigger the shortcut for the client to render.
	 */
	void (*register_shortcut)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t shortcut,
				  const char *id,
				  const char *app_id,
				  const char *description,
				  const char *trigger_description);
	/**
	 * destroy the manager
	 *
	 * All objects created by the manager will still remain valid,
	 * until their appropriate destroy request has been called.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_REGISTER_SHORTCUT_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 * @struct hyprland_global_shortcut_v1_interface
 */
struct hyprland_global_shortcut_v1_interface {
	/**
	 * delete this object, used or not
	 *
	 * Destroys the shortcut. Can be sent at any time by the client.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define HYPRLAND_GLOBAL_SHORTCUT_V1_PRESSED 0
#define HYPRLAND_GLOBAL_SHORTCUT_V1_RELEASED 1

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUT_V1_PRESSED_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUT_V1_RELEASED_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 * Sends an pressed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
 * @param tv_nsec nanoseconds part of the timestamp
 */
static inline void
hyprland_global_shortcut_v1_send_pressed(struct wl_resource *resource_, uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec)
{
	wl_resource_post_event(resource_, HYPRLAND_GLOBAL_SHORTCUT_V1_PRESSED, tv_sec_hi, tv_sec_lo, tv_nsec);
}

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 * Sends an released event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
 * @param tv_nsec nanoseconds part of the timestamp
 */
static inline void
hyprland_global_shortcut_v1_send_released(struct wl_resource *resource_, uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec)
{
	wl_resource_post_event(resource_, HYPRLAND_GLOBAL_SHORTCUT_V1_RELEASED, tv_sec_hi, tv_sec_lo, tv_nsec);
}

#ifdef  __cplusplus
}
#endif

#endif
