/*******************************************************************************
* Copyright 2020-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
*
*  Content:
*      Common functionality for statistics examples
*
*******************************************************************************/

#ifndef __COMMON_FOR_STATS_EXAMPLES_HPP__
#define __COMMON_FOR_STATS_EXAMPLES_HPP__

// stl includes
#include <algorithm>
#include <random>
#include <vector>

// local includes
#include "common_for_examples.hpp"

template<typename Vec>
void random_vector(Vec &v, int n_observations, int n_dims) {
    using ValueType = typename Vec::value_type;
    v.resize(n_observations * n_dims);

    std::random_device rd;
    std::mt19937 prng(rd());

    std::generate(v.begin(), v.end(),
        [&]() {
            double u = prng() * 0x1p-32; // u \in [0; 1)
            return (1000.0 * (2.0 * u - 1.0)); /// u \in [-1000, +1000)
        }
    );
}

#endif // __COMMON_FOR_STATS_EXAMPLES_HPP__
