/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.SymmetryInterface;

public class GulpReader
extends AtomSetCollectionReader {
    private boolean isSlab;
    private boolean isPolymer;
    private boolean isPrimitive;
    private String sep = "-------";
    private boolean coordinatesArePrimitive;
    private Map<String, Float> atomCharges;
    private boolean bTest;
    private float a;
    private float b;
    private float c;
    private float alpha;
    private float beta;
    private float gamma;
    private float[] primitiveData;
    private static final String[] tags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    private Double totEnergy;
    private String energyUnits;

    @Override
    protected void initializeReader() throws Exception {
        this.isPrimitive = !this.checkFilterKey("CONV");
        this.coordinatesArePrimitive = true;
        this.setFractionalCoordinates(this.readDimensionality());
    }

    @Override
    protected void finalizeSubclassReader() {
        if (this.atomCharges == null) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        int i = this.asc.ac;
        while (--i >= 0) {
            Float f = this.atomCharges.get(atoms[i].atomName);
            if (f == null && (f = this.atomCharges.get(atoms[i].getElementSymbol())) == null) continue;
            atoms[i].partialCharge = f.floatValue();
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("Space group ")) {
            this.readSpaceGroup();
            return true;
        }
        if (this.isSlab ? this.line.contains("Surface cell parameters") : (this.isPolymer ? this.line.contains("Polymer cell parameter") : (this.bTest = this.line.contains("Cartesian lattice vectors")) || this.line.contains("Cell parameters (Angstroms/Degrees)") || this.line.contains("Primitive cell parameters"))) {
            this.readCellParameters(this.bTest);
            return true;
        }
        if (this.line.contains("Monopole - monopole (total)")) {
            this.readEnergy();
            return true;
        }
        if (this.line.contains("Fractional coordinates of asymmetric unit :") || (this.bTest = this.line.contains("Final asymmetric unit coordinates")) || (this.bTest = this.line.contains("Final fractional coordinates ")) || this.line.contains("Mixed fractional/Cartesian coordinates") || this.line.contains("Cartesian coordinates of cluster ") || this.line.contains("Final cartesian coordinates of atoms :") && this.isMolecular) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomicPos(!this.bTest);
            }
            return true;
        }
        if (this.line.contains("Species output for all configurations")) {
            this.readPartialCharges();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.contains("Final cell parameters and derivatives")) {
            this.readFinalCell();
            return true;
        }
        return true;
    }

    private boolean readDimensionality() throws Exception {
        this.discardLinesUntilContains("Dimensionality");
        String[] tokens = this.getTokens();
        switch (this.parseIntStr(tokens[2])) {
            case 0: {
                this.isMolecular = true;
                this.isPrimitive = false;
                return false;
            }
            case 1: {
                this.isPolymer = true;
                this.isPrimitive = false;
                break;
            }
            case 2: {
                this.isSlab = true;
                this.isPrimitive = false;
            }
        }
        return true;
    }

    private void readSpaceGroup() throws Exception {
        this.sgName = this.line.substring(this.line.indexOf(":") + 1).trim();
    }

    private static int parameterIndex(String key) {
        int i = tags.length;
        while (--i >= 0) {
            if (!tags[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    private void setParameter(String key, float value) {
        switch (GulpReader.parameterIndex(key)) {
            case 0: {
                this.a = value;
                break;
            }
            case 1: {
                this.b = value;
                break;
            }
            case 2: {
                this.c = value;
                break;
            }
            case 3: {
                this.alpha = value;
                break;
            }
            case 4: {
                this.beta = value;
                break;
            }
            case 5: {
                this.gamma = value;
            }
        }
    }

    private void newAtomSet(boolean doSetUnitCell) {
        this.asc.newAtomSet();
        if (doSetUnitCell) {
            this.setModelParameters(this.coordinatesArePrimitive);
            if (this.totEnergy != null) {
                this.setEnergy();
            }
        }
    }

    private void setModelParameters(boolean isPrimitive) {
        if (this.sgName != null) {
            this.setSpaceGroupName(isPrimitive ? "P1" : this.sgName);
        }
        if (isPrimitive && this.primitiveData != null) {
            this.addExplicitLatticeVector(0, this.primitiveData, 0);
            this.addExplicitLatticeVector(1, this.primitiveData, 3);
            this.addExplicitLatticeVector(2, this.primitiveData, 6);
        } else if (this.a != 0.0f) {
            if (this.isSlab) {
                this.c = -1.0f;
                this.gamma = 90.0f;
                this.beta = 90.0f;
            } else if (this.isPolymer) {
                this.c = -1.0f;
                this.b = -1.0f;
                this.gamma = 90.0f;
                this.beta = 90.0f;
                this.alpha = 90.0f;
            }
            this.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        }
    }

    private void readCellParameters(boolean isLatticeVectors) throws Exception {
        if (isLatticeVectors) {
            this.rd();
            this.primitiveData = this.fillFloatArray(null, 0, new float[9]);
            this.a = 0.0f;
            return;
        }
        int i0 = this.line.indexOf("Full cell") < 0 ? 0 : 4;
        this.coordinatesArePrimitive = i0 == 0;
        this.rd();
        while (this.rd() != null && this.line.contains("=")) {
            String[] tokens = PT.getTokens(this.line.replace('=', ' '));
            for (int i = i0; i < i0 + 4; i += 2) {
                if (tokens.length <= i + 1) continue;
                this.setParameter(tokens[i], this.parseFloatStr(tokens[i + 1]));
            }
        }
    }

    private void readFinalCell() throws Exception {
        String[] tokens;
        this.discardLinesUntilContains(this.sep);
        while (this.rd() != null && (tokens = this.getTokens()).length >= 2) {
            this.setParameter(tokens[0], this.parseFloatStr(tokens[1]));
        }
        if (this.primitiveData != null) {
            this.scalePrimitiveData(0, this.a);
            this.scalePrimitiveData(3, this.b);
            this.scalePrimitiveData(6, this.c);
            if (!this.coordinatesArePrimitive) {
                while (this.rd() != null && this.line.indexOf("Final") < 0) {
                    if (this.line.indexOf("Non-primitive lattice parameters") <= 0) continue;
                    this.rd();
                    for (int i = 0; i < 2; ++i) {
                        tokens = PT.getTokens(this.rd().replace('=', ' '));
                        this.setParameter(tokens[0], this.parseFloatStr(tokens[1]));
                        this.setParameter(tokens[2], this.parseFloatStr(tokens[3]));
                        this.setParameter(tokens[4], this.parseFloatStr(tokens[5]));
                    }
                }
            }
        }
        this.setModelParameters(this.coordinatesArePrimitive);
        this.applySymmetryAndSetTrajectory();
        if (this.totEnergy != null) {
            this.setEnergy();
        }
    }

    private void scalePrimitiveData(int i, float value) {
        V3 v = V3.new3(this.primitiveData[i], this.primitiveData[i + 1], this.primitiveData[i + 2]);
        v.normalize();
        v.scale(value);
        this.primitiveData[i++] = v.x;
        this.primitiveData[i++] = v.y;
        this.primitiveData[i++] = v.z;
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.coordinatesArePrimitive && this.iHaveUnitCell && this.doCheckUnitCell && this.primitiveData != null && !this.isPrimitive) {
            this.setModelParameters(false);
            SymmetryInterface symFull = this.symmetry;
            this.setModelParameters(true);
            Atom[] atoms = this.asc.atoms;
            int i0 = this.asc.getLastAtomSetAtomIndex();
            int i1 = this.asc.ac;
            for (int i = i0; i < i1; ++i) {
                Atom atom = atoms[i];
                this.symmetry.toCartesian(atom, true);
                symFull.toFractional(atom, true);
                this.fixFloatPt(atom, 100000.0f);
            }
            this.setModelParameters(false);
        }
        this.applySymTrajASCR();
    }

    private void readAtomicPos(boolean finalizeSymmetry) throws Exception {
        this.newAtomSet(finalizeSymmetry);
        this.discardLinesUntilContains(this.sep);
        this.discardLinesUntilContains(this.sep);
        while (this.rd() != null && (this.line.indexOf(this.sep) < 0 || this.rd().indexOf("Region") >= 0)) {
            if (this.line.indexOf("Region") >= 0) {
                this.rd();
                continue;
            }
            this.line = this.line.replace('*', ' ');
            String[] tokens = this.getTokens();
            if (!tokens[2].equals("c")) continue;
            this.addAtomXYZSymName(tokens, 3, null, tokens[1]);
        }
        if (finalizeSymmetry) {
            this.applySymmetryAndSetTrajectory();
        }
    }

    private void readPartialCharges() throws Exception {
        String[] tokens;
        this.atomCharges = new Hashtable<String, Float>();
        this.discardLinesUntilContains(this.sep);
        this.discardLinesUntilContains(this.sep);
        while ((tokens = PT.getTokens(this.rd())).length > 5) {
            String species = tokens[0];
            Float charge = this.atomCharges.get(species);
            float f = charge == null ? 0.0f : charge.floatValue();
            this.atomCharges.put(species, Float.valueOf(f + this.parseFloatStr(tokens[4])));
        }
    }

    private void readEnergy() throws Exception {
        if (this.line.indexOf("=") < 0) {
            this.discardLinesUntilContains("=");
        }
        String[] tokens = PT.getTokens(this.line.substring(this.line.indexOf("=")));
        this.totEnergy = Double.parseDouble(tokens[1]);
        this.energyUnits = tokens[2];
        this.discardLinesUntilContains(this.sep);
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.totEnergy, this.totEnergy.floatValue());
        this.asc.setInfo("Energy", this.totEnergy);
        this.asc.setAtomSetName("E = " + this.totEnergy + " " + this.energyUnits);
        this.totEnergy = null;
    }
}

