/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import sun.java2d.StateTrackable;

public final class DataBufferShort
extends DataBuffer {
    short[] data;
    short[][] bankdata;

    public DataBufferShort(int size) {
        super(StateTrackable.State.STABLE, 2, size);
        this.data = new short[size];
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferShort(int size, int numBanks) {
        super(StateTrackable.State.STABLE, 2, size, numBanks);
        this.bankdata = new short[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            this.bankdata[i] = new short[size];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferShort(short[] dataArray, int size) {
        super(StateTrackable.State.UNTRACKABLE, 2, size);
        this.data = dataArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferShort(short[] dataArray, int size, int offset) {
        super(StateTrackable.State.UNTRACKABLE, 2, size, 1, offset);
        this.data = dataArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferShort(short[][] dataArray, int size) {
        super(StateTrackable.State.UNTRACKABLE, 2, size, dataArray.length);
        this.bankdata = (short[][])dataArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferShort(short[][] dataArray, int size, int[] offsets) {
        super(StateTrackable.State.UNTRACKABLE, 2, size, dataArray.length, offsets);
        this.bankdata = (short[][])dataArray.clone();
        this.data = this.bankdata[0];
    }

    public short[] getData() {
        this.theTrackable.setUntrackable();
        return this.data;
    }

    public short[] getData(int bank) {
        this.theTrackable.setUntrackable();
        return this.bankdata[bank];
    }

    public short[][] getBankData() {
        this.theTrackable.setUntrackable();
        return (short[][])this.bankdata.clone();
    }

    @Override
    public int getElem(int i) {
        return this.data[i + this.offset];
    }

    @Override
    public int getElem(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]];
    }

    @Override
    public void setElem(int i, int val) {
        this.data[i + this.offset] = (short)val;
        this.theTrackable.markDirty();
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.bankdata[bank][i + this.offsets[bank]] = (short)val;
        this.theTrackable.markDirty();
    }
}

