/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.StaticScope;

public class DefsNode
extends MethodDefNode
implements INameNode {
    private final Node receiverNode;

    public DefsNode(int line, Node receiverNode, RubySymbol name2, ArgsNode argsNode, StaticScope scope, Node bodyNode, int endLine) {
        super(line, name2, argsNode, scope, bodyNode, endLine);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.DEFSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitDefsNode(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, (Node)this.argsNode, this.bodyNode);
    }
}

