/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParser {
    private static final TokenSet YIELD_STMT_INDICATOR_TOKENS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.EXCL, JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD, JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.STRING_LITERAL, JavaTokenType.INTEGER_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.IDENTIFIER, JavaTokenType.SWITCH_KEYWORD, JavaTokenType.NEW_KEYWORD, JavaTokenType.LPARENTH, JavaTokenType.RBRACE, JavaTokenType.SEMICOLON, JavaTokenType.CASE_KEYWORD);
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create(JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD);
    private final JavaParser myParser;

    public StatementParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(1);
        }
        return this.parseCodeBlock(builder2, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder2, boolean isStatement) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(2);
        }
        if (builder2.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder2)) {
            return this.parseCodeBlockDeep(builder2, false);
        }
        return PsiBuilderUtil.parseBlockLazy(builder2, JavaTokenType.LBRACE, JavaTokenType.RBRACE, JavaElementType.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder2, boolean parseUntilEof) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(3);
        }
        if (builder2.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder2.mark();
        builder2.advanceLexer();
        this.parseStatements(builder2, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder2, JavaTokenType.RBRACE, "expected.rbrace");
        builder2.getTokenType();
        JavaParserUtil.done(codeBlock, JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        this.parseStatements(builder2, null);
    }

    private void parseStatements(PsiBuilder builder2, @Nullable BraceMode braceMode) {
        while (builder2.getTokenType() != null) {
            PsiBuilder.Marker statement2 = this.parseStatement(builder2);
            if (statement2 != null) continue;
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder2.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder2.mark();
            builder2.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaPsiBundle.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaPsiBundle.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaPsiBundle.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder2) {
        PsiBuilder.Marker statement2;
        IElementType tokenType;
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(5);
        }
        if ((tokenType = builder2.getTokenType()) == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder2);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder2);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder2);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder2);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder2);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder2);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return StatementParser.parseBreakStatement(builder2);
        }
        if (StatementParser.isStmtYieldToken(builder2, tokenType)) {
            return this.parseYieldStatement(builder2);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return StatementParser.parseContinueStatement(builder2);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder2);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder2);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder2);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder2);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder2);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder2);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder2.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty2 = builder2.mark();
            builder2.advanceLexer();
            JavaParserUtil.done(empty2, JavaElementType.EMPTY_STATEMENT);
            return empty2;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder2.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder2);
            StatementParser.skipQualifiedName(builder2);
            IElementType suspectedLT = builder2.getTokenType();
            IElementType next = builder2.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder2.mark();
                if (this.myParser.getDeclarationParser().parse(builder2, DeclarationParser.Context.CODE_BLOCK) != null) {
                    JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                    return declStatement;
                }
                PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder2, 0);
                if (type2 == null || builder2.getTokenType() != JavaTokenType.DOUBLE_COLON) {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    if (type2 == null) {
                        builder2.advanceLexer();
                    }
                    JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                    return declStatement;
                }
                declStatement.rollbackTo();
            }
        }
        PsiBuilder.Marker pos = builder2.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list2 = expr.precede();
            PsiBuilder.Marker statement3 = list2.precede();
            while (builder2.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder2.mark();
                builder2.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder2);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                JavaParserUtil.done(list2, JavaElementType.EXPRESSION_LIST);
                JavaParserUtil.semicolon(builder2);
                JavaParserUtil.done(statement3, JavaElementType.EXPRESSION_LIST_STATEMENT);
                return statement3;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop(list2, pos);
                JavaParserUtil.semicolon(builder2);
                JavaParserUtil.done(statement3, JavaElementType.EXPRESSION_STATEMENT);
                return statement3;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder2, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement2 = decl.precede();
            JavaParserUtil.done(statement2, JavaElementType.DECLARATION_STATEMENT);
            return statement2;
        }
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && builder2.lookAhead(1) == JavaTokenType.COLON) {
            statement2 = builder2.mark();
            PsiBuilderUtil.advance(builder2, 2);
            this.parseStatement(builder2);
            JavaParserUtil.done(statement2, JavaElementType.LABELED_STATEMENT);
            return statement2;
        }
        if (expr != null) {
            statement2 = builder2.mark();
            this.myParser.getExpressionParser().parse(builder2);
            JavaParserUtil.semicolon(builder2);
            JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT);
            return statement2;
        }
        return null;
    }

    private static boolean isStmtYieldToken(@NotNull PsiBuilder builder2, IElementType tokenType) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        if (tokenType != JavaTokenType.IDENTIFIER || !"yield".equals(builder2.getTokenText()) || !JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_14)) {
            return false;
        }
        PsiBuilder.Marker maybeYieldStmt = builder2.mark();
        builder2.advanceLexer();
        IElementType tokenAfterYield = builder2.getTokenType();
        if (tokenAfterYield == null || YIELD_STMT_INDICATOR_TOKENS.contains(tokenAfterYield)) {
            maybeYieldStmt.rollbackTo();
            return true;
        }
        if (JavaTokenType.PLUSPLUS.equals(tokenAfterYield) || JavaTokenType.MINUSMINUS.equals(tokenAfterYield)) {
            builder2.advanceLexer();
            boolean isYieldStmt = !builder2.getTokenType().equals(JavaTokenType.SEMICOLON);
            maybeYieldStmt.rollbackTo();
            return isYieldStmt;
        }
        maybeYieldStmt.rollbackTo();
        return false;
    }

    private static void skipQualifiedName(PsiBuilder builder2) {
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder2.getTokenType() == JavaTokenType.DOT && builder2.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance(builder2, 2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        if (this.parseExprInParenth(builder2)) {
            PsiBuilder.Marker elseStatement;
            PsiBuilder.Marker thenStatement = this.parseStatement(builder2);
            if (thenStatement == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
            } else if (PsiBuilderUtil.expect(builder2, JavaTokenType.ELSE_KEYWORD) && (elseStatement = this.parseStatement(builder2)) == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement2, JavaElementType.IF_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(7);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder2, JavaElementType.WHILE_STATEMENT, false);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(8);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
            PsiBuilder.Marker marker = statement2;
            if (marker == null) {
                StatementParser.$$$reportNull$$$0(9);
            }
            return marker;
        }
        PsiBuilder.Marker afterParenth = builder2.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder2, false, false, true);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder2.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            return this.parseForLoopFromInitializer(builder2, statement2);
        }
        afterParenth.drop();
        return this.parseForEachFromColon(builder2, statement2);
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder2, PsiBuilder.Marker statement2) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
                PsiBuilder.Marker marker = statement2;
                if (marker == null) {
                    StatementParser.$$$reportNull$$$0(10);
                }
                return marker;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (StatementParser.getLastToken(builder2) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !JavaParserUtil.expectOrError(builder2, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder2)) == null;
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement2;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(11);
                    }
                    return marker;
                }
            } else {
                this.parseForUpdateExpressions(builder2);
                if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
                    PsiBuilder.Marker marker = statement2;
                    if (marker == null) {
                        StatementParser.$$$reportNull$$$0(12);
                    }
                    return marker;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder2)) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement2, JavaElementType.FOR_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(13);
        }
        return marker;
    }

    private static IElementType getLastToken(PsiBuilder builder2) {
        IElementType token;
        int offset2 = -1;
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder2.rawLookup(offset2))) {
            --offset2;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder2) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr == null) {
            return;
        }
        if (builder2.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder2.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder2);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            } while (builder2.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder2, PsiBuilder.Marker statement2) {
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        if (JavaParserUtil.expectOrError(builder2, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement2, JavaElementType.FOREACH_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        PsiBuilder.Marker body2 = this.parseStatement(builder2);
        if (body2 == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect(builder2, JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder2)) {
            JavaParserUtil.semicolon(builder2);
        }
        JavaParserUtil.done(statement2, JavaElementType.DO_WHILE_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder2, JavaElementType.SWITCH_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    @NotNull Pair<@Nullable PsiBuilder.Marker, Boolean> parseCaseLabel(PsiBuilder builder2) {
        if (builder2.getTokenType() == JavaTokenType.DEFAULT_KEYWORD) {
            PsiBuilder.Marker defaultElement = builder2.mark();
            builder2.advanceLexer();
            JavaParserUtil.done(defaultElement, JavaElementType.DEFAULT_CASE_LABEL_ELEMENT);
            Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(defaultElement, false);
            if (pair == null) {
                StatementParser.$$$reportNull$$$0(17);
            }
            return pair;
        }
        if (this.myParser.getPatternParser().isPattern(builder2)) {
            Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(this.myParser.getPatternParser().parsePattern(builder2), false);
            if (pair == null) {
                StatementParser.$$$reportNull$$$0(18);
            }
            return pair;
        }
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(this.myParser.getExpressionParser().parseAssignment(builder2, BitUtil.set(0, 1, true)), true);
        if (pair == null) {
            StatementParser.$$$reportNull$$$0(19);
        }
        return pair;
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        boolean isCase = builder2.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder2.advanceLexer();
        if (isCase) {
            boolean patternsAllowed = JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_17);
            PsiBuilder.Marker list2 = builder2.mark();
            do {
                Pair<PsiBuilder.Marker, Boolean> markerAndIsExpression = this.parseCaseLabel(builder2);
                PsiBuilder.Marker caseLabel = (PsiBuilder.Marker)markerAndIsExpression.first;
                if (caseLabel != null) continue;
                JavaParserUtil.error(builder2, JavaPsiBundle.message(patternsAllowed ? "expected.case.label.element" : "expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect(builder2, JavaTokenType.COMMA));
            JavaParserUtil.done(list2, JavaElementType.CASE_LABEL_ELEMENT_LIST);
        }
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.ARROW)) {
            PsiBuilder.Marker body2;
            if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                body2 = builder2.mark();
                this.parseCodeBlock(builder2, true);
                body2.done(JavaElementType.BLOCK_STATEMENT);
                if (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark2 = builder2.mark();
                    while (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder2.advanceLexer();
                    }
                    mark2.error(JavaPsiBundle.message("expected.switch.label", new Object[0]));
                }
            } else if (builder2.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder2);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
                if (expr != null) {
                    body2 = expr.precede();
                    JavaParserUtil.semicolon(builder2);
                    body2.done(JavaElementType.EXPRESSION_STATEMENT);
                } else {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON);
                }
            }
            JavaParserUtil.done(statement2, JavaElementType.SWITCH_LABELED_RULE);
        } else {
            JavaParserUtil.expectOrError(builder2, JavaTokenType.COLON, "expected.colon");
            JavaParserUtil.done(statement2, JavaElementType.SWITCH_LABEL_STATEMENT);
        }
        return statement2;
    }

    @NotNull
    private static PsiBuilder.Marker parseBreakStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder2);
        JavaParserUtil.done(statement2, JavaElementType.BREAK_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(20);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseYieldStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.remapCurrentToken(JavaTokenType.YIELD_KEYWORD);
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder2);
        }
        JavaParserUtil.done(statement2, JavaElementType.YIELD_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(21);
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseContinueStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder2);
        JavaParserUtil.done(statement2, JavaElementType.CONTINUE_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(22);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        this.myParser.getExpressionParser().parse(builder2);
        JavaParserUtil.semicolon(builder2);
        JavaParserUtil.done(statement2, JavaElementType.RETURN_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(23);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder2);
        }
        JavaParserUtil.done(statement2, JavaElementType.THROW_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(24);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseExprInParenthWithBlock(builder2, JavaElementType.SYNCHRONIZED_STATEMENT, true);
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(25);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder2) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        boolean bl = hasResourceList = builder2.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder2);
        }
        if ((tryBlock = this.parseCodeBlock(builder2, true)) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder2.getTokenType())) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder2.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder2)) {
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder2, true)) == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        }
        JavaParserUtil.done(statement2, JavaElementType.TRY_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(26);
        }
        return marker;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(27);
        }
        assert (builder2.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder2.getTokenType();
        PsiBuilder.Marker section = builder2.mark();
        builder2.advanceLexer();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder2, false, true, false);
        if (param == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker body2 = this.parseCodeBlock(builder2, true);
        if (body2 == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect(builder2, JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder2);
        }
        JavaParserUtil.done(statement2, JavaElementType.ASSERT_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(28);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement2 = builder2.mark();
        this.parseCodeBlock(builder2, true);
        JavaParserUtil.done(statement2, JavaElementType.BLOCK_STATEMENT);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(29);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder2, @NotNull IElementType type2, boolean block) {
        if (builder2 == null) {
            StatementParser.$$$reportNull$$$0(30);
        }
        if (type2 == null) {
            StatementParser.$$$reportNull$$$0(31);
        }
        PsiBuilder.Marker statement2 = builder2.mark();
        builder2.advanceLexer();
        if (this.parseExprInParenth(builder2)) {
            PsiBuilder.Marker body2;
            PsiBuilder.Marker marker = body2 = block ? this.parseCodeBlock(builder2, true) : this.parseStatement(builder2);
            if (body2 == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement2, type2);
        PsiBuilder.Marker marker = statement2;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(32);
        }
        return marker;
    }

    private boolean parseExprInParenth(PsiBuilder builder2) {
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder2.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr == null || builder2.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            if (builder2.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder2.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder2.advanceLexer();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/StatementParser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIfStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForLoopFromInitializer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseForEachFromColon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDoWhileStatement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSwitchStatement";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCaseLabel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBreakStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseYieldStatement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContinueStatement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReturnStatement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseThrowStatement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSynchronizedStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTryStatement";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAssertStatement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBlockStatement";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExprInParenthWithBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCodeBlockDeep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStmtYieldToken";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseCatchBlock";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseExprInParenthWithBlock";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

