/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrArithBuilder;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering;
import org.jetbrains.kotlin.ir.backend.js.utils.JsInlineClassesUtils;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\tR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\tR\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010(R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\tR\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\tR\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\tR\u000e\u00103\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\u0002098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "booleanMarker", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "getBooleanMarker", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "booleanNot", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "byteMask", "", "getByteMask", "calculator", "Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "devMode", "", "eqeq", "functionMarker", "getFunctionMarker", "icUtils", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "instanceOfIntrinsicSymbol", "isArraySymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isExternalObjectSymbol", "isInterfaceSymbol", "isSuspendFunctionSymbol", "jsClassIntrinsicSymbol", "lit16", "getLit16", "lit24", "getLit24", "litFalse", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getLitFalse", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "litNull", "getLitNull", "litTrue", "getLitTrue", "numberMarker", "getNumberMarker", "shortMask", "getShortMask", "stringMarker", "getStringMarker", "throwCCE", "throwNPE", "typeOfIntrinsicSymbol", "unit", "Lorg/jetbrains/kotlin/ir/types/IrType;", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "getUnitValue", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class TypeOperatorLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrType unit;
    @NotNull
    private final JsIrArithBuilder calculator;
    private final boolean devMode;
    @NotNull
    private final IrSimpleFunctionSymbol throwCCE;
    @NotNull
    private final IrSimpleFunctionSymbol throwNPE;
    @NotNull
    private final IrSimpleFunctionSymbol eqeq;
    @NotNull
    private final IrSimpleFunctionSymbol booleanNot;
    @NotNull
    private final IrSimpleFunctionSymbol isSuspendFunctionSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol instanceOfIntrinsicSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol isExternalObjectSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol typeOfIntrinsicSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol jsClassIntrinsicSymbol;
    @NotNull
    private final JsInlineClassesUtils icUtils;

    public TypeOperatorLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.unit = this.context.getIrBuiltIns().getUnitType();
        this.calculator = new JsIrArithBuilder(this.context);
        this.devMode = this.context.getDevMode();
        this.throwCCE = this.context.getIr().getSymbols().getThrowTypeCastException();
        this.throwNPE = this.context.getIr().getSymbols().getThrowNullPointerException();
        this.eqeq = this.context.getIrBuiltIns().getEqeqSymbol();
        this.booleanNot = this.context.getIrBuiltIns().getBooleanNotSymbol();
        this.isSuspendFunctionSymbol = this.context.getIntrinsics().isSuspendFunctionSymbol();
        this.instanceOfIntrinsicSymbol = this.context.getIntrinsics().getJsInstanceOf();
        this.isExternalObjectSymbol = this.context.getIntrinsics().isExternalObject();
        this.typeOfIntrinsicSymbol = this.context.getIntrinsics().getJsTypeOf();
        this.jsClassIntrinsicSymbol = this.context.getIntrinsics().getJsClass();
        this.icUtils = this.context.getInlineClassesUtils();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    private final IrGetObjectValueImpl getUnitValue() {
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(this.unit);
        Intrinsics.checkNotNull(irClassifierSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        return JsIrBuilder.INSTANCE.buildGetObjectValue(this.unit, (IrClassSymbol)irClassifierSymbol);
    }

    private final IrConstImpl<Integer> getLit24() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 24);
    }

    private final IrConstImpl<Integer> getLit16() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 16);
    }

    private final IrConstImpl<Integer> getByteMask() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 255);
    }

    private final IrConstImpl<Integer> getShortMask() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 65535);
    }

    private final IrSimpleFunctionSymbol isInterfaceSymbol() {
        return this.context.getIntrinsics().isInterfaceSymbol();
    }

    private final IrSimpleFunctionSymbol isArraySymbol() {
        return this.context.getIntrinsics().isArraySymbol();
    }

    private final IrConstImpl<String> getStringMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "string");
    }

    private final IrConstImpl<String> getBooleanMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "boolean");
    }

    private final IrConstImpl<String> getFunctionMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "function");
    }

    private final IrConstImpl<String> getNumberMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "number");
    }

    private final IrExpression getLitTrue() {
        return JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true);
    }

    private final IrExpression getLitFalse() {
        return JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), false);
    }

    private final IrExpression getLitNull() {
        return JsIrBuilder.INSTANCE.buildNull(this.context.getIrBuiltIns().getNothingNType());
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformer irElementTransformer = new IrElementTransformer<IrDeclarationParent>(this){
            final /* synthetic */ TypeOperatorLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrDeclarationParent data2) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(data2, "data");
                IrDeclarationParent irDeclarationParent = declaration instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration) : null;
                if (irDeclarationParent == null) {
                    irDeclarationParent = data2;
                }
                return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, irDeclarationParent);
            }

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data2, "data");
                IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
                switch (lower.WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
                    case 1: {
                        irExpression = this.lowerImplicitCast(expression2, data2);
                        break;
                    }
                    case 2: {
                        irExpression = this.lowerImplicitDynamicCast(expression2, data2);
                        break;
                    }
                    case 3: {
                        irExpression = this.lowerCoercionToUnit(expression2);
                        break;
                    }
                    case 4: {
                        irExpression = this.lowerIntegerCoercion(expression2, data2);
                        break;
                    }
                    case 5: {
                        irExpression = this.lowerImplicitNotNull(expression2, data2);
                        break;
                    }
                    case 6: {
                        irExpression = this.lowerInstanceOf(expression2, data2, false);
                        break;
                    }
                    case 7: {
                        irExpression = this.lowerInstanceOf(expression2, data2, true);
                        break;
                    }
                    case 8: {
                        irExpression = this.lowerCast(expression2, data2, false);
                        break;
                    }
                    case 9: {
                        irExpression = this.lowerCast(expression2, data2, true);
                        break;
                    }
                    case 10: {
                        irExpression = expression2;
                        break;
                    }
                    case 11: {
                        String string2 = "SAM conversion: " + RenderIrElementKt.render$default(expression2, null, 1, null);
                        throw new NotImplementedError("An operation is not implemented: " + string2);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return irExpression;
            }

            private final IrExpression lowerImplicitNotNull(IrTypeOperatorCall expression2, IrDeclarationParent declaration) {
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_NOTNULL;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                bl = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getTypeOperand()) ^ org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument2 = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrCall irNullCheck = this.nullCheck(argument2.invoke());
                ((Collection)newStatements).add(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, expression2.getTypeOperand(), irNullCheck, JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowNPE$p(this.this$0), null, null, null, null, 30, null), argument2.invoke(), 0, 0, 0, 0, 240, null));
                IrTypeOperatorCall $this$lowerImplicitNotNull_u24lambda_u240 = expression2;
                boolean bl3 = false;
                return new IrCompositeImpl($this$lowerImplicitNotNull_u24lambda_u240.getStartOffset(), $this$lowerImplicitNotNull_u24lambda_u240.getEndOffset(), $this$lowerImplicitNotNull_u24lambda_u240.getTypeOperand(), null, newStatements);
            }

            private final boolean needBoxingOrUnboxing(IrType fromType, IrType toType) {
                return TypeOperatorLowering.access$getIcUtils$p(this.this$0).getInlinedClass(fromType) != null ^ TypeOperatorLowering.access$getIcUtils$p(this.this$0).getInlinedClass(toType) != null || IrTypePredicatesKt.isUnit(fromType) && !IrTypePredicatesKt.isUnit(toType);
            }

            private final IrExpression wrapWithUnsafeCast(IrTypeOperatorCall $this$wrapWithUnsafeCast, IrExpression arg) {
                return !this.needBoxingOrUnboxing(arg.getType(), $this$wrapWithUnsafeCast.getTypeOperand()) ? (IrExpression)new IrTypeOperatorCallImpl($this$wrapWithUnsafeCast.getStartOffset(), $this$wrapWithUnsafeCast.getEndOffset(), $this$wrapWithUnsafeCast.getType(), IrTypeOperator.REINTERPRET_CAST, $this$wrapWithUnsafeCast.getTypeOperand(), arg) : arg;
            }

            private final IrExpression lowerCast(IrTypeOperatorCall expression2, IrDeclarationParent declaration, boolean isSafe) {
                boolean bl;
                IrTypeOperator operator = expression2.getOperator();
                boolean bl2 = bl = operator == IrTypeOperator.CAST || operator == IrTypeOperator.SAFE_CAST || operator == IrTypeOperator.IMPLICIT_CAST || operator == IrTypeOperator.IMPLICIT_DYNAMIC_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = operator == IrTypeOperator.SAFE_CAST == isSafe;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                IrType toType = expression2.getTypeOperand();
                IrExpression failResult = isSafe ? TypeOperatorLowering.access$getLitNull(this.this$0) : (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowCCE$p(this.this$0), null, null, null, null, 30, null);
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument2 = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrExpression check2 = this.generateTypeCheck(argument2, toType);
                IrExpression castedValue = this.wrapWithUnsafeCast(expression2, argument2.invoke());
                ((Collection)newStatements).add(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, expression2.getType(), check2, castedValue, failResult, 0, 0, 0, 0, 240, null));
                IrTypeOperatorCall $this$lowerCast_u24lambda_u241 = expression2;
                boolean bl4 = false;
                return new IrCompositeImpl($this$lowerCast_u24lambda_u241.getStartOffset(), $this$lowerCast_u24lambda_u241.getEndOffset(), expression2.getType(), null, newStatements);
            }

            private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2, IrDeclarationParent data2) {
                boolean bl;
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                TypeOperatorLowering typeOperatorLowering2 = this.this$0;
                IrTypeOperatorCall $this$lowerImplicitCast_u24lambda_u242 = irTypeOperatorCall;
                boolean bl2 = false;
                boolean bl3 = bl = $this$lowerImplicitCast_u24lambda_u242.getOperator() == IrTypeOperator.IMPLICIT_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return TypeOperatorLowering.access$getDevMode$p(typeOperatorLowering2) ? this.lowerCast(expression2, data2, false) : this.wrapWithUnsafeCast($this$lowerImplicitCast_u24lambda_u242, $this$lowerImplicitCast_u24lambda_u242.getArgument());
            }

            private final IrExpression lowerImplicitDynamicCast(IrTypeOperatorCall expression2, IrDeclarationParent data2) {
                boolean bl;
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                TypeOperatorLowering typeOperatorLowering2 = this.this$0;
                IrTypeOperatorCall $this$lowerImplicitDynamicCast_u24lambda_u243 = irTypeOperatorCall;
                boolean bl2 = false;
                boolean bl3 = bl = $this$lowerImplicitDynamicCast_u24lambda_u243.getOperator() == IrTypeOperator.IMPLICIT_DYNAMIC_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return TypeOperatorLowering.access$getDevMode$p(typeOperatorLowering2) ? this.lowerCast(expression2, data2, false) : this.wrapWithUnsafeCast($this$lowerImplicitDynamicCast_u24lambda_u243, $this$lowerImplicitDynamicCast_u24lambda_u243.getArgument());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean advancedCheckRequired(IrType type2) {
                if (IrTypeUtilsKt.isInterface(type2)) return true;
                if (IrTypeUtilsKt.isTypeParameter(type2)) {
                    boolean bl;
                    Iterable $this$any$iv = IrTypeUtilsKt.superTypes(type2);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IrType it = (IrType)element$iv;
                            boolean bl2 = false;
                            if (!IrTypeUtilsKt.isInterface(it)) continue;
                            return true;
                        }
                        bl = false;
                    }
                    if (bl) return true;
                }
                if (IrTypePredicatesKt.isArray(type2)) return true;
                if (IrTypeUtilsKt.isPrimitiveArray(type2)) return true;
                if (!this.isTypeOfCheckingType(type2)) return false;
                return true;
            }

            private final boolean isTypeOfCheckingType(IrType type2) {
                return IrTypePredicatesKt.isByte(type2) || IrTypePredicatesKt.isShort(type2) || IrTypePredicatesKt.isInt(type2) || IrTypePredicatesKt.isFloat(type2) || IrTypePredicatesKt.isDouble(type2) || IrTypePredicatesKt.isBoolean(type2) || IrTypeUtilsKt.isFunctionOrKFunction(type2) || IrTypePredicatesKt.isString(type2);
            }

            @NotNull
            public final IrExpression lowerInstanceOf(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent declaration, boolean inverted) {
                boolean bl;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.INSTANCEOF || expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF == inverted;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                IrType toType = expression2.getTypeOperand();
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument2 = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrExpression check2 = this.generateTypeCheck(argument2, toType);
                IrExpression result2 = inverted ? TypeOperatorLowering.access$getCalculator$p(this.this$0).not(check2) : check2;
                ((Collection)newStatements).add(result2);
                return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), null, newStatements);
            }

            private final IrCall nullCheck(IrExpression value2) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, null, null, 30, null);
                TypeOperatorLowering typeOperatorLowering2 = this.this$0;
                IrCall $this$nullCheck_u24lambda_u245 = irCall;
                boolean bl = false;
                $this$nullCheck_u24lambda_u245.putValueArgument(0, value2);
                $this$nullCheck_u24lambda_u245.putValueArgument(1, TypeOperatorLowering.access$getLitNull(typeOperatorLowering2));
                return irCall;
            }

            private final Function0<IrExpression> cacheValue(IrExpression value2, List<IrStatement> newStatements, IrDeclarationParent declaration) {
                Function0 function0;
                if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(value2, true, false, null, 4, null)) {
                    function0 = new Function0<IrExpression>(value2){
                        final /* synthetic */ IrExpression $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final IrExpression invoke() {
                            void p1;
                            DeepCopyTypeRemapper typeRemapper$iv$iv;
                            void $this$deepCopyWithSymbols$iv$iv;
                            IrElement $this$deepCopyWithSymbols_u24default$iv = this.$value;
                            IrDeclarationParent initialParent$iv = null;
                            boolean $i$f$deepCopyWithSymbols = false;
                            IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                            boolean $i$f$deepCopyWithSymbols2 = false;
                            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                            TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                            void var11_10 = $this$deepCopyWithSymbols$iv$iv;
                            boolean bl = false;
                            typeRemapper = typeRemapper;
                            SymbolRemapper p0 = deepCopySymbolRemapper;
                            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var11_10.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
                            if (irElement2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                            }
                            return (IrExpression)((IrElement)((IrExpression)irElement2));
                        }
                    };
                } else {
                    IrVariable varDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, value2.getType(), declaration, null, false, false, false, value2, null, 188, null);
                    ((Collection)newStatements).add(varDeclaration);
                    function0 = new Function0<IrExpression>(varDeclaration){
                        final /* synthetic */ IrVariable $varDeclaration;
                        {
                            this.$varDeclaration = $varDeclaration;
                            super(0);
                        }

                        @NotNull
                        public final IrExpression invoke() {
                            return JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, this.$varDeclaration.getSymbol(), null, 2, null);
                        }
                    };
                }
                return function0;
            }

            private final IrExpression generateTypeCheck(Function0<? extends IrExpression> argument2, IrType toType) {
                IrExpression irExpression;
                IrType toNotNullable = IrTypesKt.makeNotNull(toType);
                IrExpression argumentInstance = argument2.invoke();
                IrExpression instanceCheck = this.generateTypeCheckNonNull(argumentInstance, toNotNullable);
                boolean isFromNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(argumentInstance.getType());
                boolean isToNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(toType);
                boolean isNativeCheck = !this.advancedCheckRequired(toNotNullable);
                if (!isFromNullable) {
                    irExpression = instanceCheck;
                } else if (isToNullable) {
                    JsIrArithBuilder $this$generateTypeCheck_u24lambda_u246 = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    boolean bl = false;
                    irExpression = $this$generateTypeCheck_u24lambda_u246.oror(this.nullCheck(argument2.invoke()), instanceCheck);
                } else if (isNativeCheck) {
                    irExpression = instanceCheck;
                } else {
                    JsIrArithBuilder $this$generateTypeCheck_u24lambda_u247 = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    boolean bl = false;
                    irExpression = $this$generateTypeCheck_u24lambda_u247.andand($this$generateTypeCheck_u24lambda_u247.not(this.nullCheck(argument2.invoke())), instanceCheck);
                }
                return irExpression;
            }

            private final IrExpression generateTypeCheckNonNull(IrExpression argument2, IrType toType) {
                IrExpression irExpression;
                boolean bl;
                boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable(toType);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (toType instanceof IrDynamicType) {
                    irExpression = argument2;
                } else if (IrTypePredicatesKt.isAny(toType)) {
                    irExpression = this.generateIsObjectCheck(argument2);
                } else if (IrTypePredicatesKt.isNothing(toType)) {
                    IrExpression[] irExpressionArray = new IrExpression[]{argument2, TypeOperatorLowering.access$getLitFalse(this.this$0)};
                    irExpression = JsIrBuilder.INSTANCE.buildComposite(this.this$0.getContext().getIrBuiltIns().getBooleanType(), CollectionsKt.listOf(irExpressionArray));
                } else if (IrTypeUtilsKt.isSuspendFunction(toType)) {
                    irExpression = this.generateSuspendFunctionCheck(argument2, toType);
                } else if (this.isTypeOfCheckingType(toType)) {
                    irExpression = this.generateTypeOfCheck(argument2, toType);
                } else if (IrTypePredicatesKt.isNumber(toType)) {
                    irExpression = this.generateNumberCheck(argument2);
                } else if (IrTypePredicatesKt.isComparable(toType)) {
                    irExpression = this.generateComparableCheck(argument2);
                } else if (IrTypePredicatesKt.isCharSequence(toType)) {
                    irExpression = this.generateCharSequenceCheck(argument2);
                } else if (IrTypePredicatesKt.isArray(toType)) {
                    irExpression = this.generateGenericArrayCheck(argument2);
                } else if (IrTypeUtilsKt.isPrimitiveArray(toType)) {
                    irExpression = this.generatePrimitiveArrayTypeCheck(argument2, toType);
                } else if (IrTypeUtilsKt.isTypeParameter(toType)) {
                    irExpression = this.generateTypeCheckWithTypeParameter(argument2, toType);
                } else if (IrTypeUtilsKt.isInterface(toType)) {
                    IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(toType).getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    irExpression = IrUtilsKt.isEffectivelyExternal((IrClass)irSymbolOwner) ? (IrExpression)this.generateIsObjectCheck(argument2) : this.generateInterfaceCheck(argument2, toType);
                } else {
                    irExpression = IrTypeUtilsKt.isExternalObject(toType) ? this.generateIsExternalObject(argument2, toType) : this.generateNativeInstanceOf(argument2, toType);
                }
                return irExpression;
            }

            private final IrCall generateIsObjectCheck(IrExpression argument2) {
                IrCall irCall;
                IrCall $this$generateIsObjectCheck_u24lambda_u248 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getBooleanNot$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateIsObjectCheck_u24lambda_u248.setDispatchReceiver(this.nullCheck(argument2));
                return irCall;
            }

            /*
             * WARNING - void declaration
             */
            private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument2, IrType toType) {
                void $this$fold$iv;
                void initial$iv;
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
                IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
                if (irTypeParameterSymbol == null) {
                    CompilationExceptionKt.compilationException("expected type parameter, but " + toType, argument2);
                    throw null;
                }
                IrTypeParameterSymbol typeParameterSymbol = irTypeParameterSymbol;
                IrTypeParameter typeParameter2 = (IrTypeParameter)typeParameterSymbol.getOwner();
                Iterable iterable = typeParameter2.getSuperTypes();
                Object var7_7 = null;
                TypeOperatorLowering typeOperatorLowering2 = this.this$0;
                boolean $i$f$fold = false;
                IrExpression accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void t;
                    IrType irType = (IrType)element$iv;
                    void r = accumulator$iv;
                    boolean bl = false;
                    IrExpression irExpression = IrUtilsKt.shallowCopyOrNull(argument2);
                    if (irExpression == null) {
                        void p1;
                        DeepCopyTypeRemapper typeRemapper$iv$iv;
                        void $this$deepCopyWithSymbols$iv$iv;
                        IrElement $this$deepCopyWithSymbols_u24default$iv = argument2;
                        IrDeclarationParent initialParent$iv = null;
                        boolean $i$f$deepCopyWithSymbols = false;
                        IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                        boolean $i$f$deepCopyWithSymbols2 = false;
                        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                        TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                        void var25_25 = $this$deepCopyWithSymbols$iv$iv;
                        boolean bl2 = false;
                        typeRemapper = typeRemapper;
                        SymbolRemapper p0 = deepCopySymbolRemapper;
                        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var25_25.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
                        if (irElement2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                        }
                        irExpression = (IrExpression)((IrElement)((IrExpression)irElement2));
                    }
                    IrExpression copy2 = irExpression;
                    IrExpression check2 = this.generateTypeCheckNonNull(copy2, IrTypesKt.makeNotNull((IrType)t));
                    accumulator$iv = r == null ? check2 : (IrExpression)TypeOperatorLowering.access$getCalculator$p(typeOperatorLowering2).andand((IrExpression)r, check2);
                }
                IrExpression irExpression = accumulator$iv;
                if (irExpression == null) {
                    irExpression = TypeOperatorLowering.access$getLitTrue(this.this$0);
                }
                return irExpression;
            }

            private final IrExpression generateSuspendFunctionCheck(IrExpression argument2, IrType toType) {
                IrCall irCall;
                IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(toType).getOwner();
                Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                int arity = ((IrClass)irSymbolOwner).getTypeParameters().size() - 1;
                IrBuiltIns irBuiltIns = this.this$0.getContext().getIrBuiltIns();
                IrCall $this$generateSuspendFunctionCheck_u24lambda_u2410 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isSuspendFunctionSymbol$p(this.this$0), irBuiltIns.getBooleanType(), null, null, null, 28, null);
                boolean bl = false;
                $this$generateSuspendFunctionCheck_u24lambda_u2410.putValueArgument(0, argument2);
                $this$generateSuspendFunctionCheck_u24lambda_u2410.putValueArgument(1, JsIrBuilder.INSTANCE.buildInt(irBuiltIns.getIntType(), arity));
                return irCall;
            }

            private final IrExpression generateTypeOfCheck(IrExpression argument2, IrType toType) {
                IrCall irCall;
                IrConstImpl marker = IrTypeUtilsKt.isFunctionOrKFunction(toType) ? TypeOperatorLowering.access$getFunctionMarker(this.this$0) : (IrTypePredicatesKt.isBoolean(toType) ? TypeOperatorLowering.access$getBooleanMarker(this.this$0) : (IrTypePredicatesKt.isString(toType) ? TypeOperatorLowering.access$getStringMarker(this.this$0) : TypeOperatorLowering.access$getNumberMarker(this.this$0)));
                IrCall $this$generateTypeOfCheck_u24lambda_u2411 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getTypeOfIntrinsicSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateTypeOfCheck_u24lambda_u2411.putValueArgument(0, argument2);
                IrCall typeOf = irCall;
                IrCall $this$generateTypeOfCheck_u24lambda_u2412 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, null, null, 30, null);
                boolean bl2 = false;
                $this$generateTypeOfCheck_u24lambda_u2412.putValueArgument(0, typeOf);
                $this$generateTypeOfCheck_u24lambda_u2412.putValueArgument(1, marker);
                return irCall;
            }

            private final IrCall wrapTypeReference(IrType toType) {
                IrCall irCall;
                IrCall $this$wrapTypeReference_u24lambda_u2413 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getJsClassIntrinsicSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$wrapTypeReference_u24lambda_u2413.putTypeArgument(0, toType);
                return irCall;
            }

            private final IrCall generateGenericArrayCheck(IrExpression argument2) {
                IrCall irCall;
                IrCall $this$generateGenericArrayCheck_u24lambda_u2414 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isArraySymbol(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateGenericArrayCheck_u24lambda_u2414.putValueArgument(0, argument2);
                return irCall;
            }

            private final IrCall generateNumberCheck(IrExpression argument2) {
                IrCall irCall;
                IrCall $this$generateNumberCheck_u24lambda_u2415 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isNumberSymbol(), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateNumberCheck_u24lambda_u2415.putValueArgument(0, argument2);
                return irCall;
            }

            private final IrCall generateComparableCheck(IrExpression argument2) {
                IrCall irCall;
                IrCall $this$generateComparableCheck_u24lambda_u2416 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isComparableSymbol(), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateComparableCheck_u24lambda_u2416.putValueArgument(0, argument2);
                return irCall;
            }

            private final IrCall generateCharSequenceCheck(IrExpression argument2) {
                IrCall irCall;
                IrCall $this$generateCharSequenceCheck_u24lambda_u2417 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isCharSequenceSymbol(), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateCharSequenceCheck_u24lambda_u2417.putValueArgument(0, argument2);
                return irCall;
            }

            private final IrExpression generatePrimitiveArrayTypeCheck(IrExpression argument2, IrType toType) {
                IrCall irCall;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.this$0.getContext().getIntrinsics().isPrimitiveArray().get((Object)((Object)IrTypeUtilsKt.getPrimitiveArrayElementType(toType)));
                Intrinsics.checkNotNull(irSimpleFunctionSymbol);
                IrSimpleFunctionSymbol f = irSimpleFunctionSymbol;
                IrCall $this$generatePrimitiveArrayTypeCheck_u24lambda_u2418 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, f, null, null, null, null, 30, null);
                boolean bl = false;
                $this$generatePrimitiveArrayTypeCheck_u24lambda_u2418.putValueArgument(0, argument2);
                return irCall;
            }

            private final IrExpression generateInterfaceCheck(IrExpression argument2, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $this$generateInterfaceCheck_u24lambda_u2419 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isInterfaceSymbol(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateInterfaceCheck_u24lambda_u2419.putValueArgument(0, argument2);
                $this$generateInterfaceCheck_u24lambda_u2419.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression generateIsExternalObject(IrExpression argument2, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $this$generateIsExternalObject_u24lambda_u2420 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isExternalObjectSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateIsExternalObject_u24lambda_u2420.putValueArgument(0, argument2);
                $this$generateIsExternalObject_u24lambda_u2420.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression generateNativeInstanceOf(IrExpression argument2, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $this$generateNativeInstanceOf_u24lambda_u2421 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getInstanceOfIntrinsicSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateNativeInstanceOf_u24lambda_u2421.putValueArgument(0, argument2);
                $this$generateNativeInstanceOf_u24lambda_u2421.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression lowerCoercionToUnit(IrTypeOperatorCall expression2) {
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                TypeOperatorLowering typeOperatorLowering2 = this.this$0;
                IrTypeOperatorCall $this$lowerCoercionToUnit_u24lambda_u2422 = irTypeOperatorCall;
                boolean bl3 = false;
                IrExpression[] irExpressionArray = new IrExpression[]{$this$lowerCoercionToUnit_u24lambda_u2422.getArgument(), TypeOperatorLowering.access$getUnitValue(typeOperatorLowering2)};
                return new IrCompositeImpl($this$lowerCoercionToUnit_u24lambda_u2422.getStartOffset(), $this$lowerCoercionToUnit_u24lambda_u2422.getEndOffset(), TypeOperatorLowering.access$getUnit$p(typeOperatorLowering2), null, CollectionsKt.listOf(irExpressionArray));
            }

            private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2, IrDeclarationParent declaration) {
                IrExpression irExpression;
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                bl = IrTypePredicatesKt.isInt(expression2.getArgument().getType());
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                boolean isNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                IrType toType = expression2.getTypeOperand();
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument2 = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                if (IrTypePredicatesKt.isByte(toType)) {
                    irExpression = lower.1.lowerIntegerCoercion$maskOp(this.this$0, argument2.invoke(), TypeOperatorLowering.access$getByteMask(this.this$0), TypeOperatorLowering.access$getLit24(this.this$0));
                } else if (IrTypePredicatesKt.isShort(toType)) {
                    irExpression = lower.1.lowerIntegerCoercion$maskOp(this.this$0, argument2.invoke(), TypeOperatorLowering.access$getShortMask(this.this$0), TypeOperatorLowering.access$getLit16(this.this$0));
                } else if (IrTypePredicatesKt.isLong(toType)) {
                    IrCall irCall;
                    IrCall $this$lowerIntegerCoercion_u24lambda_u2424 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsToLong(), null, null, null, null, 30, null);
                    boolean bl3 = false;
                    $this$lowerIntegerCoercion_u24lambda_u2424.putValueArgument(0, argument2.invoke());
                    irExpression = irCall;
                } else {
                    CompilationExceptionKt.compilationException("Unreachable execution (coercion to non-Integer type)", expression2);
                    throw null;
                }
                IrExpression casted = irExpression;
                ((Collection)newStatements).add(isNullable ? (IrExpression)JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, toType, this.nullCheck(argument2.invoke()), TypeOperatorLowering.access$getLitNull(this.this$0), casted, 0, 0, 0, 0, 240, null) : casted);
                IrTypeOperatorCall $this$lowerIntegerCoercion_u24lambda_u2425 = expression2;
                boolean bl4 = false;
                return new IrCompositeImpl($this$lowerIntegerCoercion_u24lambda_u2425.getStartOffset(), $this$lowerIntegerCoercion_u24lambda_u2425.getEndOffset(), toType, null, newStatements);
            }

            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data2);
            }

            @NotNull
            public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            @NotNull
            public IrBody visitBody(@NotNull IrBody body2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitBody(this, body2, data2);
            }

            @NotNull
            public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data2);
            }

            @NotNull
            public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data2);
            }

            @NotNull
            public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            @NotNull
            public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
            }

            @NotNull
            public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            @NotNull
            public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data2);
            }

            @NotNull
            public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
            }

            @NotNull
            public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
            }

            @NotNull
            public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
            }

            @NotNull
            public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data2);
            }

            @NotNull
            public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data2);
            }

            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            @NotNull
            public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            @NotNull
            public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            @NotNull
            public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitElement(this, element, data2);
            }

            @NotNull
            public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            @NotNull
            public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data2);
            }

            @NotNull
            public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            @NotNull
            public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
            }

            @NotNull
            public IrStatement visitField(@NotNull IrField declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitField(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            @NotNull
            public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data2);
            }

            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data2);
            }

            @NotNull
            public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            @NotNull
            public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            @NotNull
            public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
            }

            @NotNull
            public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data2);
            }

            @NotNull
            public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            @NotNull
            public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data2);
            }

            @NotNull
            public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data2);
            }

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data2);
            }

            @NotNull
            public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitScript(@NotNull IrScript declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            @NotNull
            public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            @NotNull
            public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data2);
            }

            @NotNull
            public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data2);
            }

            @NotNull
            public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data2);
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data2);
            }

            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data2);
            }

            @NotNull
            public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrDeclarationParent data2) {
                return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }

            private static final IrExpression lowerIntegerCoercion$maskOp(TypeOperatorLowering this$0, IrExpression arg, IrExpression mask, IrConst<?> shift) {
                JsIrArithBuilder $this$lowerIntegerCoercion_u24maskOp_u24lambda_u2423 = TypeOperatorLowering.access$getCalculator$p(this$0);
                boolean bl = false;
                return $this$lowerIntegerCoercion_u24maskOp_u24lambda_u2423.shr($this$lowerIntegerCoercion_u24maskOp_u24lambda_u2423.shl($this$lowerIntegerCoercion_u24maskOp_u24lambda_u2423.and(arg, mask), shift), IrUtilsKt.shallowCopy((IrExpression)shift));
            }
        };
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        irBody.transformChildren(irElementTransformer, irDeclarationParent);
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getThrowNPE$p(TypeOperatorLowering $this) {
        return $this.throwNPE;
    }

    public static final /* synthetic */ JsInlineClassesUtils access$getIcUtils$p(TypeOperatorLowering $this) {
        return $this.icUtils;
    }

    public static final /* synthetic */ IrExpression access$getLitNull(TypeOperatorLowering $this) {
        return $this.getLitNull();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getThrowCCE$p(TypeOperatorLowering $this) {
        return $this.throwCCE;
    }

    public static final /* synthetic */ JsIrArithBuilder access$getCalculator$p(TypeOperatorLowering $this) {
        return $this.calculator;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getEqeq$p(TypeOperatorLowering $this) {
        return $this.eqeq;
    }

    public static final /* synthetic */ IrExpression access$getLitFalse(TypeOperatorLowering $this) {
        return $this.getLitFalse();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getBooleanNot$p(TypeOperatorLowering $this) {
        return $this.booleanNot;
    }

    public static final /* synthetic */ IrExpression access$getLitTrue(TypeOperatorLowering $this) {
        return $this.getLitTrue();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isSuspendFunctionSymbol$p(TypeOperatorLowering $this) {
        return $this.isSuspendFunctionSymbol;
    }

    public static final /* synthetic */ IrConstImpl access$getFunctionMarker(TypeOperatorLowering $this) {
        return $this.getFunctionMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getBooleanMarker(TypeOperatorLowering $this) {
        return $this.getBooleanMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getStringMarker(TypeOperatorLowering $this) {
        return $this.getStringMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getNumberMarker(TypeOperatorLowering $this) {
        return $this.getNumberMarker();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getTypeOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.typeOfIntrinsicSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getJsClassIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.jsClassIntrinsicSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isArraySymbol(TypeOperatorLowering $this) {
        return $this.isArraySymbol();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isInterfaceSymbol(TypeOperatorLowering $this) {
        return $this.isInterfaceSymbol();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isExternalObjectSymbol$p(TypeOperatorLowering $this) {
        return $this.isExternalObjectSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getInstanceOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.instanceOfIntrinsicSymbol;
    }

    public static final /* synthetic */ IrConstImpl access$getByteMask(TypeOperatorLowering $this) {
        return $this.getByteMask();
    }

    public static final /* synthetic */ IrConstImpl access$getLit24(TypeOperatorLowering $this) {
        return $this.getLit24();
    }

    public static final /* synthetic */ IrConstImpl access$getShortMask(TypeOperatorLowering $this) {
        return $this.getShortMask();
    }

    public static final /* synthetic */ IrConstImpl access$getLit16(TypeOperatorLowering $this) {
        return $this.getLit16();
    }

    public static final /* synthetic */ boolean access$getDevMode$p(TypeOperatorLowering $this) {
        return $this.devMode;
    }

    public static final /* synthetic */ IrType access$getUnit$p(TypeOperatorLowering $this) {
        return $this.unit;
    }

    public static final /* synthetic */ IrGetObjectValueImpl access$getUnitValue(TypeOperatorLowering $this) {
        return $this.getUnitValue();
    }
}

