/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.Window;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.AppShutdownWindow;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ShutdownState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmediathek/mainwindow/ShutdownDialogController;", "", "gui", "Lmediathek/mainwindow/MediathekGui;", "(Lmediathek/mainwindow/MediathekGui;)V", "curSteps", "", "window", "Lmediathek/gui/AppShutdownWindow;", "setStatus", "", "state", "Lmediathek/tool/ShutdownState;", "show", "MediathekView"})
public final class ShutdownDialogController {
    @NotNull
    private final MediathekGui gui;
    @NotNull
    private final AppShutdownWindow window;
    private double curSteps;

    public ShutdownDialogController(@NotNull MediathekGui gui) {
        Intrinsics.checkNotNullParameter(gui, "gui");
        this.gui = gui;
        this.window = new AppShutdownWindow((Window)this.gui);
        this.window.progress.setMaximum(EnumSet.allOf(ShutdownState.class).size());
    }

    public final void show() {
        this.gui.setEnabled(false);
        this.window.label1.setBusy(true);
        this.window.setVisible(true);
    }

    public final void setStatus(@NotNull ShutdownState state) {
        Intrinsics.checkNotNullParameter((Object)state, "state");
        double d = this.curSteps;
        this.curSteps = d + 1.0;
        this.window.message.setText(state.toString());
        this.window.message.paintImmediately(0, 0, this.window.message.getWidth(), this.window.message.getHeight());
        this.window.progress.setValue((int)this.curSteps);
        this.window.progress.paintImmediately(0, 0, this.window.progress.getWidth(), this.window.progress.getHeight());
        this.window.label1.paintImmediately(0, 0, this.window.label1.getWidth(), this.window.label1.getHeight());
        if (state == ShutdownState.COMPLETE) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                this.window.dispose();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

