# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class InlineObject10(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'reason': 'str',
        'predefined_reasons': 'list[str]',
        'video': 'AbusesVideo',
        'comment': 'AbusesComment',
        'account': 'AbusesAccount'
    }

    attribute_map = {
        'reason': 'reason',
        'predefined_reasons': 'predefinedReasons',
        'video': 'video',
        'comment': 'comment',
        'account': 'account'
    }

    def __init__(self, reason=None, predefined_reasons=None, video=None, comment=None, account=None, local_vars_configuration=None):  # noqa: E501
        """InlineObject10 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._reason = None
        self._predefined_reasons = None
        self._video = None
        self._comment = None
        self._account = None
        self.discriminator = None

        self.reason = reason
        if predefined_reasons is not None:
            self.predefined_reasons = predefined_reasons
        if video is not None:
            self.video = video
        if comment is not None:
            self.comment = comment
        if account is not None:
            self.account = account

    @property
    def reason(self):
        """Gets the reason of this InlineObject10.  # noqa: E501

        Reason why the user reports this video  # noqa: E501

        :return: The reason of this InlineObject10.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this InlineObject10.

        Reason why the user reports this video  # noqa: E501

        :param reason: The reason of this InlineObject10.  # noqa: E501
        :type reason: str
        """
        if self.local_vars_configuration.client_side_validation and reason is None:  # noqa: E501
            raise ValueError("Invalid value for `reason`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                reason is not None and len(reason) < 4):
            raise ValueError("Invalid value for `reason`, length must be greater than or equal to `4`")  # noqa: E501

        self._reason = reason

    @property
    def predefined_reasons(self):
        """Gets the predefined_reasons of this InlineObject10.  # noqa: E501

        Reason categories that help triage reports  # noqa: E501

        :return: The predefined_reasons of this InlineObject10.  # noqa: E501
        :rtype: list[str]
        """
        return self._predefined_reasons

    @predefined_reasons.setter
    def predefined_reasons(self, predefined_reasons):
        """Sets the predefined_reasons of this InlineObject10.

        Reason categories that help triage reports  # noqa: E501

        :param predefined_reasons: The predefined_reasons of this InlineObject10.  # noqa: E501
        :type predefined_reasons: list[str]
        """
        allowed_values = ["violentOrAbusive", "hatefulOrAbusive", "spamOrMisleading", "privacy", "rights", "serverRules", "thumbnails", "captions"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(predefined_reasons).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `predefined_reasons` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(predefined_reasons) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._predefined_reasons = predefined_reasons

    @property
    def video(self):
        """Gets the video of this InlineObject10.  # noqa: E501


        :return: The video of this InlineObject10.  # noqa: E501
        :rtype: AbusesVideo
        """
        return self._video

    @video.setter
    def video(self, video):
        """Sets the video of this InlineObject10.


        :param video: The video of this InlineObject10.  # noqa: E501
        :type video: AbusesVideo
        """

        self._video = video

    @property
    def comment(self):
        """Gets the comment of this InlineObject10.  # noqa: E501


        :return: The comment of this InlineObject10.  # noqa: E501
        :rtype: AbusesComment
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this InlineObject10.


        :param comment: The comment of this InlineObject10.  # noqa: E501
        :type comment: AbusesComment
        """

        self._comment = comment

    @property
    def account(self):
        """Gets the account of this InlineObject10.  # noqa: E501


        :return: The account of this InlineObject10.  # noqa: E501
        :rtype: AbusesAccount
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this InlineObject10.


        :param account: The account of this InlineObject10.  # noqa: E501
        :type account: AbusesAccount
        """

        self._account = account

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineObject10):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineObject10):
            return True

        return self.to_dict() != other.to_dict()
