# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class NotificationVideoImport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'video': 'VideoInfo',
        'torrent_name': 'str',
        'magnet_uri': 'str',
        'target_uri': 'str'
    }

    attribute_map = {
        'id': 'id',
        'video': 'video',
        'torrent_name': 'torrentName',
        'magnet_uri': 'magnetUri',
        'target_uri': 'targetUri'
    }

    def __init__(self, id=None, video=None, torrent_name=None, magnet_uri=None, target_uri=None, local_vars_configuration=None):  # noqa: E501
        """NotificationVideoImport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._video = None
        self._torrent_name = None
        self._magnet_uri = None
        self._target_uri = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if video is not None:
            self.video = video
        self.torrent_name = torrent_name
        self.magnet_uri = magnet_uri
        self.target_uri = target_uri

    @property
    def id(self):
        """Gets the id of this NotificationVideoImport.  # noqa: E501


        :return: The id of this NotificationVideoImport.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NotificationVideoImport.


        :param id: The id of this NotificationVideoImport.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def video(self):
        """Gets the video of this NotificationVideoImport.  # noqa: E501


        :return: The video of this NotificationVideoImport.  # noqa: E501
        :rtype: VideoInfo
        """
        return self._video

    @video.setter
    def video(self, video):
        """Sets the video of this NotificationVideoImport.


        :param video: The video of this NotificationVideoImport.  # noqa: E501
        :type video: VideoInfo
        """

        self._video = video

    @property
    def torrent_name(self):
        """Gets the torrent_name of this NotificationVideoImport.  # noqa: E501


        :return: The torrent_name of this NotificationVideoImport.  # noqa: E501
        :rtype: str
        """
        return self._torrent_name

    @torrent_name.setter
    def torrent_name(self, torrent_name):
        """Sets the torrent_name of this NotificationVideoImport.


        :param torrent_name: The torrent_name of this NotificationVideoImport.  # noqa: E501
        :type torrent_name: str
        """

        self._torrent_name = torrent_name

    @property
    def magnet_uri(self):
        """Gets the magnet_uri of this NotificationVideoImport.  # noqa: E501


        :return: The magnet_uri of this NotificationVideoImport.  # noqa: E501
        :rtype: str
        """
        return self._magnet_uri

    @magnet_uri.setter
    def magnet_uri(self, magnet_uri):
        """Sets the magnet_uri of this NotificationVideoImport.


        :param magnet_uri: The magnet_uri of this NotificationVideoImport.  # noqa: E501
        :type magnet_uri: str
        """

        self._magnet_uri = magnet_uri

    @property
    def target_uri(self):
        """Gets the target_uri of this NotificationVideoImport.  # noqa: E501


        :return: The target_uri of this NotificationVideoImport.  # noqa: E501
        :rtype: str
        """
        return self._target_uri

    @target_uri.setter
    def target_uri(self, target_uri):
        """Sets the target_uri of this NotificationVideoImport.


        :param target_uri: The target_uri of this NotificationVideoImport.  # noqa: E501
        :type target_uri: str
        """

        self._target_uri = target_uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NotificationVideoImport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NotificationVideoImport):
            return True

        return self.to_dict() != other.to_dict()
