/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.opensearch.script.FieldScript;
import org.opensearch.script.GeneralScriptException;

public class ExpressionFieldScript
implements FieldScript.LeafFactory {
    private final Expression exprScript;
    private final DoubleValuesSource source;

    ExpressionFieldScript(Expression e, SimpleBindings b) {
        this.exprScript = e;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)b);
    }

    public FieldScript newInstance(final LeafReaderContext leaf) throws IOException {
        return new FieldScript(){
            DoubleValues values;
            {
                this.values = ExpressionFieldScript.this.source.getValues(leaf, null);
            }

            public Object execute() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + ExpressionFieldScript.this.exprScript, (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + ExpressionFieldScript.this.exprScript, e);
                }
            }
        };
    }
}

