/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class SnapshotIndexStatus
implements Iterable<SnapshotIndexShardStatus>,
ToXContentFragment {
    private final String index;
    private final Map<Integer, SnapshotIndexShardStatus> indexShards;
    private final SnapshotShardsStats shardsStats;
    private final SnapshotStats stats;
    static final ObjectParser.NamedObjectParser<SnapshotIndexStatus, Void> PARSER;

    SnapshotIndexStatus(String index, Collection<SnapshotIndexShardStatus> shards) {
        this.index = index;
        HashMap<Integer, SnapshotIndexShardStatus> indexShards = new HashMap<Integer, SnapshotIndexShardStatus>();
        this.stats = new SnapshotStats();
        for (SnapshotIndexShardStatus shard : shards) {
            indexShards.put(shard.getShardId().getId(), shard);
            this.stats.add(shard.getStats(), true);
        }
        this.shardsStats = new SnapshotShardsStats(shards);
        this.indexShards = Collections.unmodifiableMap(indexShards);
    }

    public SnapshotIndexStatus(String index, Map<Integer, SnapshotIndexShardStatus> indexShards, SnapshotShardsStats shardsStats, SnapshotStats stats) {
        this.index = index;
        this.indexShards = indexShards;
        this.shardsStats = shardsStats;
        this.stats = stats;
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, SnapshotIndexShardStatus> getShards() {
        return this.indexShards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<SnapshotIndexShardStatus> iterator() {
        return this.indexShards.values().iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getIndex());
        builder.field("shards_stats", (ToXContent)this.shardsStats, params);
        builder.field("stats", (ToXContent)this.stats, params);
        builder.startObject("shards");
        for (SnapshotIndexShardStatus shard : this.indexShards.values()) {
            shard.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static SnapshotIndexStatus fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return (SnapshotIndexStatus)PARSER.parse(parser, null, parser.currentName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotIndexStatus that = (SnapshotIndexStatus)o;
        if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
            return false;
        }
        if (this.indexShards != null ? !this.indexShards.equals(that.indexShards) : that.indexShards != null) {
            return false;
        }
        if (this.shardsStats != null ? !this.shardsStats.equals(that.shardsStats) : that.shardsStats != null) {
            return false;
        }
        return this.stats != null ? this.stats.equals(that.stats) : that.stats == null;
    }

    public int hashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + (this.indexShards != null ? this.indexShards.hashCode() : 0);
        result = 31 * result + (this.shardsStats != null ? this.shardsStats.hashCode() : 0);
        result = 31 * result + (this.stats != null ? this.stats.hashCode() : 0);
        return result;
    }

    static {
        ConstructingObjectParser innerParser = new ConstructingObjectParser("snapshot_index_status", true, (parsedObjects, index) -> {
            Map<Integer, SnapshotIndexShardStatus> indexShards;
            int i = 0;
            SnapshotShardsStats shardsStats = (SnapshotShardsStats)parsedObjects[i++];
            SnapshotStats stats = (SnapshotStats)parsedObjects[i++];
            List shardStatuses = (List)parsedObjects[i];
            if (shardStatuses == null || shardStatuses.isEmpty()) {
                indexShards = Collections.emptyMap();
            } else {
                indexShards = new HashMap(shardStatuses.size());
                for (SnapshotIndexShardStatus shardStatus : shardStatuses) {
                    indexShards.put(shardStatus.getShardId().getId(), shardStatus);
                }
            }
            return new SnapshotIndexStatus((String)index, indexShards, shardsStats, stats);
        });
        innerParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (SnapshotShardsStats)SnapshotShardsStats.PARSER.apply(p, null), new ParseField("shards_stats", new String[0]));
        innerParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SnapshotStats.fromXContent(p), new ParseField("stats", new String[0]));
        innerParser.declareNamedObjects(ConstructingObjectParser.constructorArg(), SnapshotIndexShardStatus.PARSER, new ParseField("shards", new String[0]));
        PARSER = (p, c, name) -> (SnapshotIndexStatus)innerParser.apply(p, (Object)name);
    }

    static final class Fields {
        static final String SHARDS = "shards";

        Fields() {
        }
    }
}

