/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.common.settings.Setting;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.percolator.PercolateQueryBuilder;
import org.opensearch.percolator.PercolatorFieldMapper;
import org.opensearch.percolator.PercolatorHighlightSubFetchPhase;
import org.opensearch.percolator.PercolatorMatchedSlotSubFetchPhase;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.search.fetch.FetchSubPhase;

public class PercolatorPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("percolate", PercolateQueryBuilder::new, PercolateQueryBuilder::fromXContent));
    }

    public List<FetchSubPhase> getFetchSubPhases(SearchPlugin.FetchPhaseConstructionContext context) {
        return Arrays.asList(new PercolatorMatchedSlotSubFetchPhase(), new PercolatorHighlightSubFetchPhase(context.getHighlighters()));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("percolator", new PercolatorFieldMapper.TypeParser());
    }
}

