"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;

var _constants = require("../../services/utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alerting = components.clientAction.namespaceFactory();
  const alerting = Client.prototype.alerting.prototype;
  alerting.getFindings = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/findings/_search`
    },
    needBody: true,
    method: 'GET'
  });
  alerting.getWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.createMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.deleteMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.deleteWorkflow = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  }); // TODO DRAFT: May need to add 'refresh' assignment here again.

  alerting.updateMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  }); // TODO DRAFT: May need to add 'refresh' assignment here again.

  alerting.updateWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.getMonitors = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>/_acknowledge/alerts`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeChainedAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>/_acknowledge/alerts`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/alerts`
    },
    method: 'GET'
  });
  alerting.executeMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_execute?dryrun=<%=dryrun%>`,
      req: {
        dryrun: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.searchDestinations = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}`
    },
    method: 'GET'
  });
  alerting.createDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailAccounts = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailGroups = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getWorkflowAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/alerts?workflowIds=<%=workflowIds%>&getAssociatedAlerts=<%=getAssociatedAlerts%>`,
      req: {
        workflowIds: {
          type: 'string',
          required: true
        },
        getAssociatedAlerts: {
          type: 'boolean',
          required: true
        }
      }
    },
    method: 'GET'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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