/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.ManagedPrefixList;

public class DescribeManagedPrefixListsIterable
implements SdkIterable<DescribeManagedPrefixListsResponse> {
    private final Ec2Client client;
    private final DescribeManagedPrefixListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeManagedPrefixListsIterable(Ec2Client client, DescribeManagedPrefixListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeManagedPrefixListsResponseFetcher();
    }

    public Iterator<DescribeManagedPrefixListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedPrefixList> prefixLists() {
        Function<DescribeManagedPrefixListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixLists() != null) {
                return response.prefixLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeManagedPrefixListsResponseFetcher
    implements SyncPageFetcher<DescribeManagedPrefixListsResponse> {
        private DescribeManagedPrefixListsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeManagedPrefixListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeManagedPrefixListsResponse nextPage(DescribeManagedPrefixListsResponse previousPage) {
            if (previousPage == null) {
                return DescribeManagedPrefixListsIterable.this.client.describeManagedPrefixLists(DescribeManagedPrefixListsIterable.this.firstRequest);
            }
            return DescribeManagedPrefixListsIterable.this.client.describeManagedPrefixLists((DescribeManagedPrefixListsRequest)((Object)DescribeManagedPrefixListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

