/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.snapshot;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.SnapshotsInProgress;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.indexstatemanagement.action.SnapshotAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.snapshot.WaitForSnapshotStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000e\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00072\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/snapshot/WaitForSnapshotStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/SnapshotAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/SnapshotAction;)V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSnapshotName", "managedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "indexName", "getUpdatedManagedIndexMetadata", "currentMetadata", "handleException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isIdempotent", "", "Companion", "opensearch-index-management"})
public final class WaitForSnapshotStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SnapshotAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "wait_for_snapshot";

    public WaitForSnapshotStep(@NotNull SnapshotAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
        var17_2 = var1_1;
        if ((var17_2.label & -2147483648) != 0) {
            var17_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForSnapshotStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                managedIndexMetadata = context.getMetadata();
                repository = this.action.getRepository();
                v1 = this.getSnapshotName(managedIndexMetadata, indexName);
                if (v1 == null) {
                    return this;
                }
                snapshotName = v1;
                var8_12 = new String[]{snapshotName};
                request = new SnapshotsStatusRequest().snapshots(var8_12).repository(repository);
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.L$2 = repository;
                $continuation.L$3 = snapshotName;
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().cluster(), (Function2)new Function2<ClusterAdminClient, ActionListener<SnapshotsStatusResponse>, Unit>(request){
                    final /* synthetic */ SnapshotsStatusRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<SnapshotsStatusResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.snapshotsStatus(this.$request, it);
                    }
                }, $continuation);
                ** if (v2 != var18_4) goto lbl35
lbl34:
                // 1 sources

                return var18_4;
lbl35:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                snapshotName = (String)$continuation.L$3;
                repository = (String)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                this = (WaitForSnapshotStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl45:
                    // 2 sources

                    response = (SnapshotsStatusResponse)v2;
                    v3 = response.getSnapshots();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"response\n                .snapshots");
                    var11_15 = v3;
                    for (T var13_17 : var11_15) {
                        snapshotStatus = (SnapshotStatus)var13_17 /* !! */ ;
                        $i$a$-find-WaitForSnapshotStep$execute$status$1 = false;
                        if (!(Intrinsics.areEqual((Object)snapshotStatus.getSnapshot().getSnapshotId().getName(), (Object)snapshotName) != false && Intrinsics.areEqual((Object)snapshotStatus.getSnapshot().getRepository(), (Object)repository) != false)) continue;
                        v4 = var13_17 /* !! */ ;
                        ** GOTO lbl56
                    }
                    v4 = null;
lbl56:
                    // 2 sources

                    status = v4;
                    if (status != null) {
                        v5 = status.getState();
                        switch (v5 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v5.ordinal()]) {
                            case 1: 
                            case 2: {
                                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                                var12_16 = new Pair[]{TuplesKt.to((Object)"message", (Object)WaitForSnapshotStep.Companion.getSnapshotInProgressMessage(indexName)), TuplesKt.to((Object)"state", (Object)status.getState().name())};
                                this.info = MapsKt.mapOf((Pair[])var12_16);
                                break;
                            }
                            case 3: {
                                this.stepStatus = Step.StepStatus.COMPLETED;
                                var12_16 = new Pair[]{TuplesKt.to((Object)"message", (Object)WaitForSnapshotStep.Companion.getSuccessMessage(indexName)), TuplesKt.to((Object)"state", (Object)status.getState().name())};
                                this.info = MapsKt.mapOf((Pair[])var12_16);
                                break;
                            }
                            default: {
                                message = WaitForSnapshotStep.Companion.getFailedExistsMessage(indexName);
                                this.logger.warn(message);
                                this.stepStatus = Step.StepStatus.FAILED;
                                var13_17 /* !! */  = new Pair[]{TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"state", (Object)status.getState().name())};
                                this.info = MapsKt.mapOf(var13_17 /* !! */ );
                                break;
                            }
                        }
                    } else {
                        message = WaitForSnapshotStep.Companion.getFailedExistsMessage(indexName);
                        this.logger.warn(message);
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                    }
                }
                catch (RemoteTransportException e) {
                    var7_14 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)var7_14, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    this.handleException(indexName, (Exception)var7_14);
                }
                catch (Exception e) {
                    this.handleException(indexName, e);
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleException(String indexName, Exception e) {
        String message = Companion.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    private final String getSnapshotName(ManagedIndexMetaData managedIndexMetadata, String indexName) {
        ActionProperties actionProperties;
        ActionMetaData actionMetaData = managedIndexMetadata.getActionMetaData();
        ActionProperties actionProperties2 = actionProperties = actionMetaData != null ? actionMetaData.getActionProperties() : null;
        if ((actionProperties2 != null ? actionProperties2.getSnapshotName() : null) == null) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getFailedActionPropertiesMessage(indexName, actionProperties)));
            return null;
        }
        return actionProperties.getSnapshotName();
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)251647, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/snapshot/WaitForSnapshotStep$Companion;", "", "()V", "name", "", "getFailedActionPropertiesMessage", "index", "actionProperties", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionProperties;", "getFailedExistsMessage", "getFailedMessage", "getSnapshotInProgressMessage", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to get status of snapshot [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedExistsMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Snapshot doesn't exist [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedActionPropertiesMessage(@NotNull String index2, @Nullable ActionProperties actionProperties) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Unable to retrieve [" + ActionProperties.Properties.SNAPSHOT_NAME.getKey() + "] from ActionProperties=" + actionProperties + " [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully created snapshot [index=" + index2 + "]";
        }

        @NotNull
        public final String getSnapshotInProgressMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Snapshot currently in progress [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SnapshotsInProgress.State.values().length];
            try {
                nArray[SnapshotsInProgress.State.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SnapshotsInProgress.State.STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SnapshotsInProgress.State.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

