/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.ssl.transport.DefaultPrincipalExtractor;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.support.ModuleInfo;
import org.opensearch.security.support.ModuleType;
import org.opensearch.security.transport.DefaultInterClusterRequestEvaluator;
import org.opensearch.security.transport.InterClusterRequestEvaluator;

public class ReflectionHelper {
    protected static final Logger log = LogManager.getLogger(ReflectionHelper.class);
    private static Set<ModuleInfo> modulesLoaded = new HashSet<ModuleInfo>();

    public static Set<ModuleInfo> getModulesLoaded() {
        return Collections.unmodifiableSet(modulesLoaded);
    }

    public static <T> T instantiateAAA(String clazz, Settings settings, Path configPath) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            Object ret = clazz0.getConstructor(Settings.class, Path.class).newInstance(settings, configPath);
            ReflectionHelper.addLoadedModule(clazz0);
            return (T)ret;
        }
        catch (Throwable e) {
            log.warn("Unable to enable '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            throw new OpenSearchException(e);
        }
    }

    public static InterClusterRequestEvaluator instantiateInterClusterRequestEvaluator(String clazz, Settings settings) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            InterClusterRequestEvaluator ret = (InterClusterRequestEvaluator)clazz0.getConstructor(Settings.class).newInstance(settings);
            ReflectionHelper.addLoadedModule(clazz0);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to load inter cluster request evaluator '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DefaultInterClusterRequestEvaluator(settings);
        }
    }

    public static PrincipalExtractor instantiatePrincipalExtractor(String clazz) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            PrincipalExtractor ret = (PrincipalExtractor)clazz0.newInstance();
            ReflectionHelper.addLoadedModule(clazz0);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to load pricipal extractor '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DefaultPrincipalExtractor();
        }
    }

    public static boolean addLoadedModule(Class<?> clazz) {
        ModuleInfo moduleInfo = ReflectionHelper.getModuleInfo(clazz);
        if (log.isDebugEnabled()) {
            log.debug("Loaded module {}", (Object)moduleInfo);
        }
        return modulesLoaded.add(moduleInfo);
    }

    private static ModuleInfo getModuleInfo(Class<?> impl) {
        ModuleType moduleType = ModuleType.getByDefaultImplClass(impl);
        ModuleInfo moduleInfo = new ModuleInfo(moduleType, impl.getName());
        try {
            String classPath = impl.getResource(impl.getSimpleName() + ".class").toString();
            moduleInfo.setClasspath(classPath);
            if (!classPath.startsWith("jar")) {
                return moduleInfo;
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            try (InputStream stream = new URL(manifestPath).openStream();){
                Manifest manifest = new Manifest(stream);
                Attributes attr = manifest.getMainAttributes();
                moduleInfo.setVersion(attr.getValue("Implementation-Version"));
                moduleInfo.setBuildTime(attr.getValue("Build-Time"));
                moduleInfo.setGitsha1(attr.getValue("git-sha1"));
            }
        }
        catch (Throwable e) {
            log.error("Unable to retrieve module info for " + impl, e);
        }
        return moduleInfo;
    }
}

