# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BndLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_bndlib.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BndLib
else:
    import _BndLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BndLib.delete_SwigPyIterator

    def value(self):
        return _BndLib.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BndLib.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BndLib.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BndLib.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BndLib.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BndLib.SwigPyIterator_copy(self)

    def next(self):
        return _BndLib.SwigPyIterator_next(self)

    def __next__(self):
        return _BndLib.SwigPyIterator___next__(self)

    def previous(self):
        return _BndLib.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BndLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BndLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BndLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BndLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BndLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BndLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BndLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BndLib:
_BndLib.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BndLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.BVH
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.GeomAbs
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.TopAbs
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD

from enum import IntEnum
from OCC.Core.Exception import *



class bndlib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        L: gp_Lin
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Bounding box for a surface trimmed or not adds the segment of the line l limited by the two parameter values p1 and p2, to the bounding box b, and then enlarges b by the tolerance value tol. tol is the tolerance value to enlarge the minimum and maximum dimension p1 and p2 may represent infinite values. exceptions standard_failure if p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        L: gp_Lin2d
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        P2-p1 can be in [0,2*pi].

        Parameters
        ----------
        C: gp_Circ2d
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Circ2d
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds the circle c, or the arc of the circle c limited by the two parameter values p1 and p2, to the bounding box b, and then enlarges b by the tolerance value tol. p2-p1 can be in [0,2*pi].

        Parameters
        ----------
        C: gp_Elips
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Elips
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        P2-p1 can be in [0,2*pi].

        Parameters
        ----------
        C: gp_Elips2d
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: gp_Elips2d
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds the ellipse e, or the arc of the ellipse e limited by the two parameter values p1 and p2, to the bounding box b, and then enlarges b by the tolerance value tol. p2-p1 can be in [0,2*pi].

        Parameters
        ----------
        P: gp_Parab
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Parab2d
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds the arc of the parabola p limited by the two parameter values p1 and p2, to the bounding box b, and then enlarges b by the tolerance value tol. p1 and p2 may represent infinite values. exceptions standard_failure if p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        H: gp_Hypr
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr2d
        P1: float
        P2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds the arc of the branch of hyperbola h limited by the two parameter values p1 and p2, to the bounding box b, and then enlarges b by the tolerance value tol. p1 and p2 may represent infinite values. exceptions standard_failure if p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        S: gp_Cylinder
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Umax -umin can be in [0,2*pi].

        Parameters
        ----------
        S: gp_Cylinder
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b, the patch of the cylinder s limited - in the v parametric direction, by the two parameter values vmin and vmax - and optionally in the u parametric direction, by the two parameter values umin and umax. b is then enlarged by the tolerance value tol. vmin and vmax may represent infinite values. exceptions standard_failure if vmin and vmax are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        S: gp_Cone
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Umax-umin can be in [0,2*pi].

        Parameters
        ----------
        S: gp_Cone
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b, the patch of the cone s limited - in the v parametric direction, by the two parameter values vmin and vmax - and optionally in the u parametric direction, by the two parameter values umin and umax, b is then enlarged by the tolerance value tol. vmin and vmax may represent infinite values. exceptions standard_failure if vmin and vmax are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        S: gp_Sphere
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: gp_Sphere
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the sphere s, or - the patch of the sphere s, limited in the u parametric direction, by the two parameter values umin and umax, and in the v parametric direction, by the two parameter values vmin and vmax. b is then enlarged by the tolerance value tol. umax-umin can be in [0,2*pi] vmin,vmax can be [-pi/2,pi/2].

        Parameters
        ----------
        P: gp_Torus
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        P: gp_Torus
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b - the torus s, or - the patch of the torus s, limited in the u parametric direction, by the two parameter values umin and umax, and in the v parametric direction, by the two parameter values vmin and vmax. b is then enlarged by the tolerance value tol. umax-umin can be in [0,2*pi], vmin,vmax can be [-pi/2,pi/2].

        """
        return _BndLib.bndlib_Add(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BndLib.bndlib_swiginit(self, _BndLib.new_bndlib())
    __swig_destroy__ = _BndLib.delete_bndlib

# Register bndlib in _BndLib:
_BndLib.bndlib_swigregister(bndlib)
class BndLib_Add2dCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        C: Adaptor2d_Curve2d
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the curve c b is then enlarged by the tolerance value tol. note: depending on the type of curve, one of the following representations of the curve c is used to include it in the bounding box b: - an exact representation if c is built from a line, a circle or a conic curve, - the poles of the curve if c is built from a bezier curve or a bspline curve, - if not, the points of an approximation of the curve c. warning c is an adapted curve, that is, an object which is an interface between: - the services provided by a 2d curve from the package geom2d - and those required of the curve by the computation algorithm. the adapted curve is created in the following way: opencascade::handle<geom2d_curve> mycurve = ... ; geom2dadaptor_curve c(mycurve); the bounding box b is then enlarged by adding it: bnd_box2d b; // ... standard_real tol = ... ; add2dcurve::add ( c, tol, b ); exceptions standard_failure if the curve is built from: - a geom_line, or - a geom_parabola, or - a geom_hyperbola, and p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        C: Adaptor2d_Curve2d
        U1: float
        U2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box bthe arc of the curve c limited by the two parameter values p1 and p2. b is then enlarged by the tolerance value tol. note: depending on the type of curve, one of the following representations of the curve c is used to include it in the bounding box b: - an exact representation if c is built from a line, a circle or a conic curve, - the poles of the curve if c is built from a bezier curve or a bspline curve, - if not, the points of an approximation of the curve c. warning c is an adapted curve, that is, an object which is an interface between: - the services provided by a 2d curve from the package geom2d - and those required of the curve by the computation algorithm. the adapted curve is created in the following way: opencascade::handle<geom2d_curve> mycurve = ... ; geom2dadaptor_curve c(mycurve); the bounding box b is then enlarged by adding it: bnd_box2d b; // ... standard_real tol = ... ; add2dcurve::add ( c, tol, b ); exceptions standard_failure if the curve is built from: - a geom_line, or - a geom_parabola, or - a geom_hyperbola, and p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        C: Geom2d_Curve
        Tol: float
        Box: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the curve c b is then enlarged by the tolerance value tol. note: depending on the type of curve, one of the following representations of the curve c is used to include it in the bounding box b: - an exact representation if c is built from a line, a circle or a conic curve, - the poles of the curve if c is built from a bezier curve or a bspline curve, - if not, the points of an approximation of the curve c.

        Parameters
        ----------
        C: Geom2d_Curve
        U1: float
        U2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the part of curve c b is then enlarged by the tolerance value tol. u1, u2 - the parametric range to compute the bounding box; note: depending on the type of curve, one of the following representations of the curve c is used to include it in the bounding box b: - an exact representation if c is built from a line, a circle or a conic curve, - the poles of the curve if c is built from a bezier curve or a bspline curve, - if not, the points of an approximation of the curve c.

        """
        return _BndLib.BndLib_Add2dCurve_Add(*args)

    @staticmethod
    def AddOptimal(*args):
        r"""

        Parameters
        ----------
        C: Geom2d_Curve
        U1: float
        U2: float
        Tol: float
        B: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the part of curve c b is then enlarged by the tolerance value tol. u1, u2 - the parametric range to compute the bounding box; note: depending on the type of curve, one of the following algorithms is used to include it in the bounding box b: - an exact analytical if c is built from a line, a circle or a conic curve, - numerical calculation of bounding box sizes, based on minimization algorithm, for other types of curve if tol = < precision::pconfusion(), precision::pconfusion is used as tolerance for calculation.

        """
        return _BndLib.BndLib_Add2dCurve_AddOptimal(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BndLib.BndLib_Add2dCurve_swiginit(self, _BndLib.new_BndLib_Add2dCurve())
    __swig_destroy__ = _BndLib.delete_BndLib_Add2dCurve

# Register BndLib_Add2dCurve in _BndLib:
_BndLib.BndLib_Add2dCurve_swigregister(BndLib_Add2dCurve)
class BndLib_Add3dCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the curve c b is then enlarged by the tolerance value tol. note: depending on the type of curve, one of the following representations of the curve c is used to include it in the bounding box b: - an exact representation if c is built from a line, a circle or a conic curve, - the poles of the curve if c is built from a bezier curve or a bspline curve, if not, the points of an approximation of the curve c. warning c is an adapted curve, that is, an object which is an interface between: - the services provided by a 3d curve from the package geom - and those required of the curve by the computation algorithm. the adapted curve is created in the following way: opencascade::handle<geom_curve> mycurve = ... ; geomadaptor_curve c(mycurve); the bounding box b is then enlarged by adding it: bnd_box b; // ... standard_real tol = ... ; add3dcurve::add ( c, tol, b ); exceptions standard_failure if the curve is built from: - a geom_line, or - a geom_parabola, or - a geom_hyperbola, and p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        Parameters
        ----------
        C: Adaptor3d_Curve
        U1: float
        U2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the curve c the arc of the curve c limited by the two parameter values p1 and p2. note: depending on the type of curve, one of the following representations of the curve c is used to include it in the bounding box b: - an exact representation if c is built from a line, a circle or a conic curve, - the poles of the curve if c is built from a bezier curve or a bspline curve, if not, the points of an approximation of the curve c. warning c is an adapted curve, that is, an object which is an interface between: - the services provided by a 3d curve from the package geom - and those required of the curve by the computation algorithm. the adapted curve is created in the following way: opencascade::handle<geom_curve> mycurve = ... ; geomadaptor_curve c(mycurve); the bounding box b is then enlarged by adding it: bnd_box b; // ... standard_real tol = ... ; add3dcurve::add ( c, tol, b ); exceptions standard_failure if the curve is built from: - a geom_line, or - a geom_parabola, or - a geom_hyperbola, and p1 and p2 are either two negative infinite real numbers, or two positive infinite real numbers.

        """
        return _BndLib.BndLib_Add3dCurve_Add(*args)

    @staticmethod
    def AddGenCurv(*args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        UMin: float
        UMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the curve c using numerical minimization algorithms this method is used in addoptimal for not analytical curves. if tol < precision::confusion(), precision:;confusion is used as computation tolerance.

        """
        return _BndLib.BndLib_Add3dCurve_AddGenCurv(*args)

    @staticmethod
    def AddOptimal(*args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the curve c these methods use more precise algorithms for building bnd box then methods add(...).

        Parameters
        ----------
        C: Adaptor3d_Curve
        U1: float
        U2: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BndLib.BndLib_Add3dCurve_AddOptimal(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BndLib.BndLib_Add3dCurve_swiginit(self, _BndLib.new_BndLib_Add3dCurve())
    __swig_destroy__ = _BndLib.delete_BndLib_Add3dCurve

# Register BndLib_Add3dCurve in _BndLib:
_BndLib.BndLib_Add3dCurve_swigregister(BndLib_Add3dCurve)
class BndLib_AddSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        S: Adaptor3d_Surface
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the surface s b is then enlarged by the tolerance value tol. note: depending on the type of curve, one of the following representations of the surface s is used to include it in the bounding box b: - an exact representation if s is built from a plane, a cylinder, a cone, a sphere or a torus, - the poles of the surface if s is built from a bezier surface or a bspline surface, - the points of an approximation of the surface s in cases other than offset surfaces; - in the case of an offset surface, the basis surface is first included according to the previous rules; then the bounding box is enlarged by the offset value. warning do not use these functions to add a non-finite surface to the bounding box b. if umin, umax, vmin or vmax is an infinite value b will become wholespace. s is an adapted surface, that is, an object which is an interface between: - the services provided by a surface from the package geom - and those required of the surface by the computation algorithm. the adapted surface is created in the following way: opencascade::handle<geom_surface> mysurface = ... ; geomadaptor_surface s(mysurface); the bounding box b is then enlarged by adding this surface: bnd_box b; // ... standard_real tol = ... ; addsurface::add ( s, tol, b );.

        Parameters
        ----------
        S: Adaptor3d_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the surface s the patch of the surface s limited in the u parametric direction by the two parameter values umin, umax, and in the v parametric direction by the two parameter values vmin, vmax. note: depending on the type of curve, one of the following representations of the surface s is used to include it in the bounding box b: - an exact representation if s is built from a plane, a cylinder, a cone, a sphere or a torus, - the poles of the surface if s is built from a bezier surface or a bspline surface, - the points of an approximation of the surface s in cases other than offset surfaces; - in the case of an offset surface, the basis surface is first included according to the previous rules; then the bounding box is enlarged by the offset value. warning do not use these functions to add a non-finite surface to the bounding box b. if umin, umax, vmin or vmax is an infinite value b will become wholespace. s is an adapted surface, that is, an object which is an interface between: - the services provided by a surface from the package geom - and those required of the surface by the computation algorithm. the adapted surface is created in the following way: opencascade::handle<geom_surface> mysurface = ... ; geomadaptor_surface s(mysurface); the bounding box b is then enlarged by adding this surface: bnd_box b; // ... standard_real tol = ... ; addsurface::add ( s, tol, b );.

        """
        return _BndLib.BndLib_AddSurface_Add(*args)

    @staticmethod
    def AddGenSurf(*args):
        r"""

        Parameters
        ----------
        S: Adaptor3d_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds to the bounding box b the surface s using numerical minimization algorithms this method is used in addoptimal for not analytical surfaces and torus. if tol < precision::confusion(), precision::confusion is used as computation tolerance.

        """
        return _BndLib.BndLib_AddSurface_AddGenSurf(*args)

    @staticmethod
    def AddOptimal(*args):
        r"""

        Parameters
        ----------
        S: Adaptor3d_Surface
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: Adaptor3d_Surface
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Tol: float
        B: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BndLib.BndLib_AddSurface_AddOptimal(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BndLib.BndLib_AddSurface_swiginit(self, _BndLib.new_BndLib_AddSurface())
    __swig_destroy__ = _BndLib.delete_BndLib_AddSurface

# Register BndLib_AddSurface in _BndLib:
_BndLib.BndLib_AddSurface_swigregister(BndLib_AddSurface)



@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def bndlib_Add(*args):
	return bndlib.Add(*args)

@deprecated
def BndLib_Add2dCurve_Add(*args):
	return BndLib_Add2dCurve.Add(*args)

@deprecated
def BndLib_Add2dCurve_Add(*args):
	return BndLib_Add2dCurve.Add(*args)

@deprecated
def BndLib_Add2dCurve_Add(*args):
	return BndLib_Add2dCurve.Add(*args)

@deprecated
def BndLib_Add2dCurve_Add(*args):
	return BndLib_Add2dCurve.Add(*args)

@deprecated
def BndLib_Add2dCurve_AddOptimal(*args):
	return BndLib_Add2dCurve.AddOptimal(*args)

@deprecated
def BndLib_Add3dCurve_Add(*args):
	return BndLib_Add3dCurve.Add(*args)

@deprecated
def BndLib_Add3dCurve_Add(*args):
	return BndLib_Add3dCurve.Add(*args)

@deprecated
def BndLib_Add3dCurve_AddGenCurv(*args):
	return BndLib_Add3dCurve.AddGenCurv(*args)

@deprecated
def BndLib_Add3dCurve_AddOptimal(*args):
	return BndLib_Add3dCurve.AddOptimal(*args)

@deprecated
def BndLib_Add3dCurve_AddOptimal(*args):
	return BndLib_Add3dCurve.AddOptimal(*args)

@deprecated
def BndLib_AddSurface_Add(*args):
	return BndLib_AddSurface.Add(*args)

@deprecated
def BndLib_AddSurface_Add(*args):
	return BndLib_AddSurface.Add(*args)

@deprecated
def BndLib_AddSurface_AddGenSurf(*args):
	return BndLib_AddSurface.AddGenSurf(*args)

@deprecated
def BndLib_AddSurface_AddOptimal(*args):
	return BndLib_AddSurface.AddOptimal(*args)

@deprecated
def BndLib_AddSurface_AddOptimal(*args):
	return BndLib_AddSurface.AddOptimal(*args)



