/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.QuadToCubicPathConstructor;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdi.CloseFigure;
import org.freehep.graphicsio.emf.gdi.LineTo;
import org.freehep.graphicsio.emf.gdi.MoveToEx;
import org.freehep.graphicsio.emf.gdi.PolyBezierTo;
import org.freehep.graphicsio.emf.gdi.PolyBezierTo16;
import org.freehep.graphicsio.emf.gdi.PolylineTo;
import org.freehep.graphicsio.emf.gdi.PolylineTo16;

public class EMFPathConstructor
extends QuadToCubicPathConstructor
implements EMFConstants {
    private EMFOutputStream os;
    private Rectangle imageBounds;
    private boolean curved;
    private int pointIndex = 0;
    private boolean wide = false;
    private Point[] points = new Point[4];

    public EMFPathConstructor(EMFOutputStream os, Rectangle imageBounds) {
        this.os = os;
        this.imageBounds = imageBounds;
        this.curved = false;
    }

    @Override
    public void move(double x, double y) throws IOException {
        this.flush();
        this.os.writeTag(new MoveToEx(new Point(this.toUnit(x), this.toUnit(y))));
        super.move(x, y);
    }

    private void addPoint(int n, double x, double y) {
        if (n >= this.points.length) {
            Point[] buf = new Point[n << 1];
            System.arraycopy(this.points, 0, buf, 0, this.points.length);
            this.points = buf;
        }
        int ix = this.toUnit(x);
        int iy = this.toUnit(y);
        if (this.wide || ix < Short.MIN_VALUE || ix > Short.MAX_VALUE || iy < Short.MIN_VALUE || iy > Short.MAX_VALUE) {
            this.wide = true;
        }
        if (this.points[n] == null) {
            this.points[n] = new Point(ix, iy);
        } else {
            this.points[n].x = ix;
            this.points[n].y = iy;
        }
    }

    @Override
    public void line(double x, double y) throws IOException {
        if (this.curved && this.pointIndex > 0) {
            this.flush();
        }
        this.curved = false;
        this.addPoint(this.pointIndex++, x, y);
        super.line(x, y);
    }

    @Override
    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        if (!this.curved && this.pointIndex > 0) {
            this.flush();
        }
        this.curved = true;
        this.addPoint(this.pointIndex++, x1, y1);
        this.addPoint(this.pointIndex++, x2, y2);
        this.addPoint(this.pointIndex++, x3, y3);
        super.cubic(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void closePath(double x0, double y0) throws IOException {
        this.flush();
        this.os.writeTag(new CloseFigure());
        super.closePath(x0, y0);
    }

    @Override
    public void flush() throws IOException {
        if (this.curved) {
            if (this.wide) {
                this.os.writeTag(new PolyBezierTo(this.imageBounds, this.pointIndex, this.points));
            } else {
                this.os.writeTag(new PolyBezierTo16(this.imageBounds, this.pointIndex, this.points));
            }
        } else if (this.pointIndex == 1) {
            this.os.writeTag(new LineTo(this.points[0]));
        } else if (this.pointIndex > 1) {
            if (this.wide) {
                this.os.writeTag(new PolylineTo(this.imageBounds, this.pointIndex, this.points));
            } else {
                this.os.writeTag(new PolylineTo16(this.imageBounds, this.pointIndex, this.points));
            }
        }
        this.pointIndex = 0;
        this.wide = false;
        super.flush();
    }

    protected int toUnit(double d) {
        return (int)(d * 1.0 * 20.0);
    }
}

