/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfStormClouds;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.TargetedSpell;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GeyserTrap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class AquaBlast
extends TargetedSpell {
    public AquaBlast() {
        this.image = ItemSpriteSheet.AQUA_BLAST;
        this.usesTargeting = true;
    }

    @Override
    protected void affectTarget(Ballistica bolt, Hero hero) {
        int cell = bolt.collisionPos;
        GeyserTrap geyser = new GeyserTrap();
        geyser.pos = cell;
        geyser.source = this;
        if (bolt.path.size() > bolt.dist + 1) {
            geyser.centerKnockBackDirection = bolt.path.get(bolt.dist + 1);
        }
        geyser.activate();
    }

    @Override
    public int value() {
        return (int)(100.0f * ((float)this.quantity / 8.0f));
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{PotionOfStormClouds.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 2;
            this.output = AquaBlast.class;
            this.outQuantity = 8;
        }
    }
}

