/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.mvel.utils;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.session.ClassLoading;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.core.ui.GUIDialogs;
import org.islandoftex.arara.mvel.utils.MethodUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0007J(\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00112\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0007J(\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0007J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0007J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007JC\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010 J*\u0010!\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0007JC\u0010\"\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010 J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/islandoftex/arara/mvel/utils/ConditionalMethods;", "", "()V", "dialogs", "Lorg/islandoftex/arara/core/ui/GUIDialogs;", "changed", "", "extension", "", "filename", "Lorg/islandoftex/arara/api/files/MPPPath;", "currentFile", "exists", "found", "regex", "file", "loadClass", "Lkotlin/Pair;", "Lorg/islandoftex/arara/core/session/ClassLoading$ClassLoadingStatus;", "Ljava/lang/Class;", "ref", "name", "loadObject", "missing", "showDropdown", "", "width", "type", "title", "text", "elements", "", "(IILjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)I", "showInput", "showOptions", "buttons", "toFile", "unchanged", "mvel"})
public final class ConditionalMethods {
    @NotNull
    public static final ConditionalMethods INSTANCE = new ConditionalMethods();
    @NotNull
    private static final GUIDialogs dialogs = new GUIDialogs(Session.INSTANCE.getUserInterfaceOptions(), 0, 2, null);

    private ConditionalMethods() {
    }

    @JvmStatic
    public static final boolean exists(@NotNull String extension) throws AraraException {
        Intrinsics.checkNotNullParameter(extension, "extension");
        ProjectFile projectFile = LinearExecutor.INSTANCE.getCurrentFile();
        Intrinsics.checkNotNull(projectFile);
        return FileHandling.INSTANCE.changeExtension(projectFile.getPath(), extension).getExists();
    }

    @JvmStatic
    public static final boolean missing(@NotNull String extension) throws AraraException {
        Intrinsics.checkNotNullParameter(extension, "extension");
        return !ConditionalMethods.exists(extension);
    }

    @JvmStatic
    public static final boolean changed(@NotNull String extension) throws AraraException {
        Intrinsics.checkNotNullParameter(extension, "extension");
        ProjectFile projectFile = LinearExecutor.INSTANCE.getCurrentFile();
        Intrinsics.checkNotNull(projectFile);
        return ConditionalMethods.changed(FileHandling.INSTANCE.changeExtension(projectFile.getPath(), extension));
    }

    @JvmStatic
    public static final boolean unchanged(@NotNull String extension) throws AraraException {
        Intrinsics.checkNotNullParameter(extension, "extension");
        return !ConditionalMethods.changed(extension);
    }

    @JvmStatic
    public static final boolean exists(@NotNull MPPPath filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return filename.getExists();
    }

    @JvmStatic
    public static final boolean missing(@NotNull MPPPath filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return !ConditionalMethods.exists(filename);
    }

    @JvmStatic
    public static final boolean changed(@NotNull MPPPath filename) throws AraraException {
        Intrinsics.checkNotNullParameter(filename, "filename");
        Project project = LinearExecutor.INSTANCE.getCurrentProject();
        Intrinsics.checkNotNull(project);
        return FileHandling.INSTANCE.hasChanged(filename, project.getWorkingDirectory().div(LinearExecutor.INSTANCE.getExecutionOptions().getDatabaseName()));
    }

    @JvmStatic
    public static final boolean unchanged(@NotNull MPPPath filename) throws AraraException {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return !ConditionalMethods.changed(filename);
    }

    @JvmStatic
    public static final boolean found(@NotNull String extension, @NotNull String regex) throws AraraException {
        Intrinsics.checkNotNullParameter(extension, "extension");
        Intrinsics.checkNotNullParameter(regex, "regex");
        ProjectFile projectFile = LinearExecutor.INSTANCE.getCurrentFile();
        Intrinsics.checkNotNull(projectFile);
        return ConditionalMethods.found(FileHandling.INSTANCE.changeExtension(projectFile.getPath(), extension), regex);
    }

    @JvmStatic
    public static final boolean found(@NotNull MPPPath file, @NotNull String regex) throws AraraException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(regex, "regex");
        return MethodUtils.checkRegex(file, regex);
    }

    @JvmStatic
    @NotNull
    public static final MPPPath toFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new MPPPath(name);
    }

    @JvmStatic
    @JvmOverloads
    public static final int showOptions(int width, int type2, @NotNull String title, @NotNull String text2, Object ... buttons) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(buttons, "buttons");
        return dialogs.showOptions(width, type2, title, text2, buttons);
    }

    public static /* synthetic */ int showOptions$default(int n, int n2, String string, String string2, Object[] objectArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = dialogs.getDefaultWidth();
        }
        return ConditionalMethods.showOptions(n, n2, string, string2, objectArray);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String showInput(int width, int type2, @NotNull String title, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        return dialogs.showInput(width, type2, title, text2);
    }

    public static /* synthetic */ String showInput$default(int n, int n2, String string, String string2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = dialogs.getDefaultWidth();
        }
        return ConditionalMethods.showInput(n, n2, string, string2);
    }

    @JvmStatic
    @JvmOverloads
    public static final int showDropdown(int width, int type2, @NotNull String title, @NotNull String text2, Object ... elements) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(elements, "elements");
        return dialogs.showDropdown(width, type2, title, text2, elements);
    }

    public static /* synthetic */ int showDropdown$default(int n, int n2, String string, String string2, Object[] objectArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = dialogs.getDefaultWidth();
        }
        return ConditionalMethods.showDropdown(n, n2, string, string2, objectArray);
    }

    @JvmStatic
    @NotNull
    public static final MPPPath currentFile() {
        ProjectFile projectFile = LinearExecutor.INSTANCE.getCurrentFile();
        Intrinsics.checkNotNull(projectFile);
        return projectFile.getPath();
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoading.ClassLoadingStatus, Class<?>> loadClass(@NotNull MPPPath file, @NotNull String name) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(name, "name");
        return ClassLoading.loadClass(file, name);
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoading.ClassLoadingStatus, Class<?>> loadClass(@NotNull String ref, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(name, "name");
        return ConditionalMethods.loadClass(new MPPPath(ref), name);
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoading.ClassLoadingStatus, Object> loadObject(@NotNull MPPPath file, @NotNull String name) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(name, "name");
        return ClassLoading.loadObject(file, name);
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoading.ClassLoadingStatus, Object> loadObject(@NotNull String ref, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(name, "name");
        return ConditionalMethods.loadObject(new MPPPath(ref), name);
    }

    @JvmStatic
    @JvmOverloads
    public static final int showOptions(int type2, @NotNull String title, @NotNull String text2, Object ... buttons) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(buttons, "buttons");
        return ConditionalMethods.showOptions$default(0, type2, title, text2, buttons, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String showInput(int type2, @NotNull String title, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        return ConditionalMethods.showInput$default(0, type2, title, text2, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int showDropdown(int type2, @NotNull String title, @NotNull String text2, Object ... elements) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(elements, "elements");
        return ConditionalMethods.showDropdown$default(0, type2, title, text2, elements, 1, null);
    }
}

