/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.AddPortOffsetRule;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.CatalinaBaseConfigurationSource;
import org.apache.catalina.startup.CertificateCreateRule;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.ListenerCreateRule;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class Catalina {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    public static final String SERVER_XML = "conf/server.xml";
    protected boolean await = false;
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    protected boolean useNaming = true;
    protected boolean loaded = false;
    protected boolean throwOnInitFailure = Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE");
    protected boolean generateCode = false;
    protected File generatedCodeLocation = null;
    protected String generatedCodeLocationParameter = null;
    protected String generatedCodePackage = "catalinaembedded";
    protected boolean useGeneratedCode = false;
    private static final Log log = LogFactory.getLog(Catalina.class);

    public Catalina() {
        this.setSecurityProtection();
        ExceptionUtils.preload();
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean bl) {
        this.useShutdownHook = bl;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public boolean getGenerateCode() {
        return this.generateCode;
    }

    public void setGenerateCode(boolean bl) {
        this.generateCode = bl;
    }

    public boolean getUseGeneratedCode() {
        return this.useGeneratedCode;
    }

    public void setUseGeneratedCode(boolean bl) {
        this.useGeneratedCode = bl;
    }

    public File getGeneratedCodeLocation() {
        return this.generatedCodeLocation;
    }

    public void setGeneratedCodeLocation(File file) {
        this.generatedCodeLocation = file;
    }

    public String getGeneratedCodePackage() {
        return this.generatedCodePackage;
    }

    public void setGeneratedCodePackage(String string) {
        this.generatedCodePackage = string;
    }

    public boolean getThrowOnInitFailure() {
        return this.throwOnInitFailure;
    }

    public void setThrowOnInitFailure(boolean bl) {
        this.throwOnInitFailure = bl;
    }

    public void setParentClassLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        this.useNaming = bl;
    }

    public void setAwait(boolean bl) {
        this.await = bl;
    }

    public boolean isAwait() {
        return this.await;
    }

    protected boolean arguments(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length < 1) {
            this.usage();
            return false;
        }
        for (String string : stringArray) {
            if (bl) {
                this.configFile = string;
                bl = false;
                continue;
            }
            if (string.equals("-config")) {
                bl = true;
                continue;
            }
            if (string.equals("-generateCode")) {
                this.setGenerateCode(true);
                bl2 = true;
                continue;
            }
            if (string.equals("-useGeneratedCode")) {
                this.setUseGeneratedCode(true);
                bl2 = false;
                continue;
            }
            if (string.equals("-nonaming")) {
                this.setUseNaming(false);
                bl2 = false;
                continue;
            }
            if (string.equals("-help")) {
                this.usage();
                return false;
            }
            if (string.equals("start")) {
                bl2 = false;
                continue;
            }
            if (string.equals("configtest")) {
                bl2 = false;
                continue;
            }
            if (string.equals("stop")) {
                bl2 = false;
                continue;
            }
            if (bl2) {
                this.generatedCodeLocationParameter = string;
                bl2 = false;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(Bootstrap.getCatalinaBase(), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("className");
        hashMap.put(Object.class, arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("source");
        hashMap.put(StandardContext.class, arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("portOffset");
        hashMap.put(Connector.class, arrayList3);
        digester.setFakeAttributes(hashMap);
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addRule("Server/Listener", (Rule)new ListenerCreateRule(null, "className"));
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", (Rule)new ConnectorCreateRule());
        digester.addSetProperties("Server/Service/Connector", new String[]{"executor", "sslImplementationName", "protocol"});
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addRule("Server/Service/Connector", (Rule)new AddPortOffsetRule());
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig", "addSslHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", (Rule)new CertificateCreateRule());
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/Certificate", new String[]{"type"});
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/Certificate", "addCertificate", "org.apache.tomcat.util.net.SSLHostConfigCertificate");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "setOpenSslConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "addCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector/UpgradeProtocol", null, "className");
        digester.addSetProperties("Server/Service/Connector/UpgradeProtocol");
        digester.addSetNext("Server/Service/Connector/UpgradeProtocol", "addUpgradeProtocol", "org.apache.coyote.UpgradeProtocol");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Host/Cluster/");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", (Rule)new SetParentClassLoaderRule(this.parentClassLoader));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Cluster/");
        return digester;
    }

    private void addClusterRuleSet(Digester digester, String string) {
        block3: {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName("org.apache.catalina.ha.ClusterRuleSet");
                constructor = clazz.getConstructor(String.class);
                RuleSet ruleSet = (RuleSet)constructor.newInstance(string);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("catalina.noCluster", new Object[]{exception.getClass().getName() + ": " + exception.getMessage()}), (Throwable)exception);
                }
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)sm.getString("catalina.noCluster", new Object[]{exception.getClass().getName() + ": " + exception.getMessage()}));
            }
        }
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    protected void parseServerXml(boolean bl) {
        block28: {
            String string;
            Object object;
            ConfigFileLoader.setSource((ConfigurationSource)new CatalinaBaseConfigurationSource(Bootstrap.getCatalinaBaseFile(), this.getConfigFile()));
            File file = this.configFile();
            if (this.useGeneratedCode && !Digester.isGeneratedCodeLoaderSet()) {
                object = this.generatedCodePackage + ".DigesterGeneratedCodeLoader";
                try {
                    string = (Digester.GeneratedCodeLoader)Catalina.class.getClassLoader().loadClass((String)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Digester.setGeneratedCodeLoader((Digester.GeneratedCodeLoader)string);
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)sm.getString("catalina.noLoader", new Object[]{object}), (Throwable)exception);
                    } else {
                        log.info((Object)sm.getString("catalina.noLoader", new Object[]{object}));
                    }
                    this.useGeneratedCode = false;
                }
            }
            object = null;
            string = null;
            if (this.generateCode || this.useGeneratedCode) {
                String string2 = string = bl ? this.generatedCodePackage + ".ServerXml" : this.generatedCodePackage + ".ServerXmlStop";
            }
            if (this.generateCode) {
                if (this.generatedCodeLocationParameter != null) {
                    this.generatedCodeLocation = new File(this.generatedCodeLocationParameter);
                    if (!this.generatedCodeLocation.isAbsolute()) {
                        this.generatedCodeLocation = new File(Bootstrap.getCatalinaHomeFile(), this.generatedCodeLocationParameter);
                    }
                } else {
                    this.generatedCodeLocation = new File(Bootstrap.getCatalinaHomeFile(), "work");
                }
                if (!((File)(object = new File(this.generatedCodeLocation, this.generatedCodePackage))).isDirectory() && !((File)object).mkdirs()) {
                    log.warn((Object)sm.getString("catalina.generatedCodeLocationError", new Object[]{this.generatedCodeLocation.getAbsolutePath()}));
                    this.generateCode = false;
                }
            }
            ServerXml serverXml = null;
            if (this.useGeneratedCode) {
                serverXml = (ServerXml)Digester.loadGeneratedClass((String)string);
            }
            if (serverXml != null) {
                serverXml.load(this);
            } else {
                try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getServerXml();){
                    Digester digester = bl ? this.createStartDigester() : this.createStopDigester();
                    InputStream inputStream = resource.getInputStream();
                    InputSource inputSource = new InputSource(resource.getURI().toURL().toString());
                    inputSource.setByteStream(inputStream);
                    digester.push((Object)this);
                    if (this.generateCode) {
                        digester.startGeneratingCode();
                        this.generateClassHeader(digester, bl);
                    }
                    digester.parse(inputSource);
                    if (!this.generateCode) break block28;
                    this.generateClassFooter(digester);
                    try (FileWriter fileWriter = new FileWriter(new File((File)object, bl ? "ServerXml.java" : "ServerXmlStop.java"));){
                        fileWriter.write(digester.getGeneratedCode().toString());
                    }
                    digester.endGeneratingCode();
                    Digester.addGeneratedClass((String)string);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("catalina.configFail", new Object[]{file.getAbsolutePath()}), (Throwable)exception);
                    if (!file.exists() || file.canRead()) break block28;
                    log.warn((Object)sm.getString("catalina.incorrectPermissions"));
                }
            }
        }
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] stringArray) {
        Server server;
        if (stringArray != null) {
            this.arguments(stringArray);
        }
        if ((server = this.getServer()) == null) {
            this.parseServerXml(false);
            if (this.getServer() == null) {
                log.error((Object)sm.getString("catalina.stopError"));
                System.exit(1);
            }
        } else {
            try {
                server.stop();
                server.destroy();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("catalina.stopError"), (Throwable)lifecycleException);
            }
            return;
        }
        server = this.getServer();
        if (server.getPortWithOffset() > 0) {
            try (Socket socket = new Socket(server.getAddress(), server.getPortWithOffset());
                 OutputStream outputStream = socket.getOutputStream();){
                String string = server.getShutdown();
                for (int i = 0; i < string.length(); ++i) {
                    outputStream.write(string.charAt(i));
                }
                outputStream.flush();
            }
            catch (ConnectException connectException) {
                log.error((Object)sm.getString("catalina.stopServer.connectException", new Object[]{server.getAddress(), String.valueOf(server.getPortWithOffset()), String.valueOf(server.getPort()), String.valueOf(server.getPortOffset())}));
                log.error((Object)sm.getString("catalina.stopError"), (Throwable)connectException);
                System.exit(1);
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("catalina.stopError"), (Throwable)iOException);
                System.exit(1);
            }
        } else {
            log.error((Object)sm.getString("catalina.stopServer"));
            System.exit(1);
        }
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        long l = System.nanoTime();
        this.initNaming();
        this.parseServerXml(true);
        Server server = this.getServer();
        if (server == null) {
            return;
        }
        this.getServer().setCatalina(this);
        this.getServer().setCatalinaHome(Bootstrap.getCatalinaHomeFile());
        this.getServer().setCatalinaBase(Bootstrap.getCatalinaBaseFile());
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException lifecycleException) {
            if (this.throwOnInitFailure) {
                throw new Error(lifecycleException);
            }
            log.error((Object)sm.getString("catalina.initError"), (Throwable)lifecycleException);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("catalina.init", new Object[]{Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l))}));
        }
    }

    public void load(String[] stringArray) {
        try {
            if (this.arguments(stringArray)) {
                this.load();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void start() {
        if (this.getServer() == null) {
            this.load();
        }
        if (this.getServer() == null) {
            log.fatal((Object)sm.getString("catalina.noServer"));
            return;
        }
        long l = System.nanoTime();
        try {
            this.getServer().start();
        }
        catch (LifecycleException lifecycleException) {
            log.fatal((Object)sm.getString("catalina.serverStartFail"), (Throwable)lifecycleException);
            try {
                this.getServer().destroy();
            }
            catch (LifecycleException lifecycleException2) {
                log.debug((Object)"destroy() failed for failed Server ", (Throwable)lifecycleException2);
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("catalina.startup", new Object[]{Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l))}));
        }
        if (this.generateCode) {
            this.generateLoader();
        }
        if (this.useShutdownHook) {
            if (this.shutdownHook == null) {
                this.shutdownHook = new CatalinaShutdownHook();
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof ClassLoaderLogManager) {
                ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
            }
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        Object object;
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                object = LogManager.getLogManager();
                if (object instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)object).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        try {
            object = this.getServer();
            LifecycleState lifecycleState = object.getState();
            if (LifecycleState.STOPPING_PREP.compareTo(lifecycleState) > 0 || LifecycleState.DESTROYED.compareTo(lifecycleState) < 0) {
                object.stop();
                object.destroy();
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)sm.getString("catalina.stopError"), (Throwable)lifecycleException);
        }
    }

    public void await() {
        this.getServer().await();
    }

    protected void usage() {
        System.out.println(sm.getString("catalina.usage"));
    }

    protected void initStreams() {
        System.setOut((PrintStream)new SystemLogHandler(System.out));
        System.setErr((PrintStream)new SystemLogHandler(System.err));
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info((Object)sm.getString("catalina.noNaming"));
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            Object object = "org.apache.naming";
            String string = System.getProperty("java.naming.factory.url.pkgs");
            if (string != null) {
                object = (String)object + ":" + string;
            }
            System.setProperty("java.naming.factory.url.pkgs", (String)object);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting naming prefix=" + (String)object));
            }
            if ((object = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else {
                log.debug((Object)("INITIAL_CONTEXT_FACTORY already set " + (String)object));
            }
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    protected void generateLoader() {
        String string = "DigesterGeneratedCodeLoader";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("package ").append(this.generatedCodePackage).append(';').append(System.lineSeparator());
        stringBuilder.append("public class ").append(string);
        stringBuilder.append(" implements org.apache.tomcat.util.digester.Digester.GeneratedCodeLoader {").append(System.lineSeparator());
        stringBuilder.append("public Object loadGeneratedCode(String className) {").append(System.lineSeparator());
        stringBuilder.append("switch (className) {").append(System.lineSeparator());
        for (String string2 : Digester.getGeneratedClasses()) {
            stringBuilder.append("case \"").append(string2).append("\" : return new ").append(string2);
            stringBuilder.append("();").append(System.lineSeparator());
        }
        stringBuilder.append("default: return null; }").append(System.lineSeparator());
        stringBuilder.append("}}").append(System.lineSeparator());
        File file = new File(this.generatedCodeLocation, this.generatedCodePackage);
        try (FileWriter iOException = new FileWriter(new File(file, string + ".java"));){
            iOException.write(stringBuilder.toString());
        }
        catch (IOException iOException2) {
            log.debug((Object)"Error writing code loader", (Throwable)iOException2);
        }
    }

    protected void generateClassHeader(Digester digester, boolean bl) {
        StringBuilder stringBuilder = digester.getGeneratedCode();
        stringBuilder.append("package ").append(this.generatedCodePackage).append(';').append(System.lineSeparator());
        stringBuilder.append("public class ServerXml");
        if (!bl) {
            stringBuilder.append("Stop");
        }
        stringBuilder.append(" implements ");
        stringBuilder.append(ServerXml.class.getName().replace('$', '.')).append(" {").append(System.lineSeparator());
        stringBuilder.append("public void load(").append(Catalina.class.getName());
        stringBuilder.append(' ').append(digester.toVariableName((Object)this)).append(") {").append(System.lineSeparator());
    }

    protected void generateClassFooter(Digester digester) {
        StringBuilder stringBuilder = digester.getGeneratedCode();
        stringBuilder.append('}').append(System.lineSeparator());
        stringBuilder.append('}').append(System.lineSeparator());
    }

    final class SetParentClassLoaderRule
    extends Rule {
        ClassLoader parentClassLoader = null;

        SetParentClassLoaderRule(ClassLoader classLoader) {
            this.parentClassLoader = classLoader;
        }

        public void begin(String string, String string2, Attributes attributes) throws Exception {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug((Object)"Setting parent class loader");
            }
            Container container = (Container)this.digester.peek();
            container.setParentClassLoader(this.parentClassLoader);
            StringBuilder stringBuilder = this.digester.getGeneratedCode();
            if (stringBuilder != null) {
                stringBuilder.append(this.digester.toVariableName((Object)container)).append(".setParentClassLoader(");
                stringBuilder.append(this.digester.toVariableName((Object)Catalina.this)).append(".getParentClassLoader());");
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    public static interface ServerXml {
        public void load(Catalina var1);
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (Catalina.this.getServer() != null) {
                    Catalina.this.stop();
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("catalina.shutdownHookFail"), throwable);
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }
}

