"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ButtonGroup = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity");
const buttonGroupStyle = () => ({
    display: 'flex',
    alignItems: 'center',
});
const buttonStyle = (_, { disabled = false }) => (Object.assign({ height: '32px', borderRadius: '12px', padding: '0 12px', background: Identity_1.COLOR_V2.WHITE, border: `1px solid ${Identity_1.COLOR_V2.GRAY_40}`, cursor: 'pointer', display: 'flex', alignItems: 'center', backgroundColor: disabled ? Identity_1.COLOR_V2.GRAY_20 : Identity_1.COLOR_V2.WHITE, svg: {
        fill: disabled ? Identity_1.COLOR_V2.GRAY_70 : Identity_1.COLOR_V2.BLACK,
    }, '&:not(:last-child)': {
        borderTopRightRadius: '0',
        borderBottomRightRadius: '0',
    }, '&:not(:first-child)': {
        borderTopLeftRadius: '0',
        borderBottomLeftRadius: '0',
    }, '&:first-child:last-child': {
        borderRadius: '0',
    } }, (!disabled && {
    '&:hover, &:focus': {
        backgroundColor: Identity_1.COLOR_V2.GRAY_20,
    },
    '&:hover': {
        borderColor: Identity_1.COLOR_V2.GRAY_50,
    },
    '&:focus': {
        borderColor: Identity_1.COLOR_V2.GRAY_60,
    },
    '&:active': {
        backgroundColor: Identity_1.COLOR_V2.BLUE_LIGHT_50,
        borderColor: Identity_1.COLOR_V2.BLUE_LIGHT_300,
        svg: {
            fill: Identity_1.COLOR_V2.BLUE,
        },
    },
})));
const ButtonGroup = ({ children }) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => buttonGroupStyle(theme), role: "group", "aria-label": "Button Group" }, { children: children })));
exports.ButtonGroup = ButtonGroup;
const Button = (_a) => {
    var { children, icon } = _a, props = __rest(_a, ["children", "icon"]);
    return ((0, jsx_runtime_1.jsxs)("button", Object.assign({ css: (theme) => buttonStyle(theme, props) }, props, { children: [icon, children && ((0, jsx_runtime_1.jsx)("span", Object.assign({ css: (theme) => ({
                    marginLeft: !!icon && '6px',
                    fontSize: theme.fontSizes.small,
                    fontWeight: 'bold',
                    lineHeight: '0.875rem',
                    letterSpacing: '0.25px',
                }) }, { children: children })))] })));
};
ButtonGroup.Button = Button;
