/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class Comment
extends SimpleNodeConstructor {
    private static final UnicodeString TWO_HYPHENS = new Twine8(StringConstants.TWO_HYPHENS);

    @Override
    public int getInstructionNameCode() {
        return 144;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Comment exp = new Comment();
        ExpressionTool.copyLocationInfo(this, exp);
        exp.setSelect(this.getSelect().copy(rebindings));
        return exp;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        UnicodeString s;
        UnicodeString s2;
        if (this.getSelect() instanceof Literal && !(s2 = this.checkContent(s = ((Literal)this.getSelect()).getGroundedValue().getUnicodeStringValue(), visitor.getStaticContext().makeEarlyEvaluationContext())).equals(s)) {
            this.setSelect(new StringLiteral(s2));
        }
    }

    @Override
    public void processValue(UnicodeString value, Outputter output, XPathContext context) throws XPathException {
        UnicodeString comment = this.checkContent(value, context);
        output.comment(comment, this.getLocation(), 0);
    }

    @Override
    protected UnicodeString checkContent(UnicodeString comment, XPathContext context) throws XPathException {
        if (this.isXSLT()) {
            return Comment.checkContentXSLT(comment);
        }
        try {
            return Comment.checkContentXQuery(comment);
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.setLocation(this.getLocation());
            throw err;
        }
    }

    public static UnicodeString checkContentXSLT(UnicodeString comment) {
        String message = Comment.invalidity(comment);
        if (message != null) {
            long hh;
            while ((hh = comment.indexOf(TWO_HYPHENS, 0L)) >= 0L) {
                comment = comment.substring(0L, hh + 1L).concat(StringConstants.SINGLE_SPACE).concat(comment.substring(hh + 1L));
            }
            if (comment.codePointAt(comment.length() - 1L) == 45) {
                comment = comment.concat(StringConstants.SINGLE_SPACE);
            }
        }
        return comment;
    }

    public static UnicodeString checkContentXQuery(UnicodeString comment) throws XPathException {
        String message = Comment.invalidity(comment);
        if (message != null) {
            throw new XPathException(message, "XQDY0072");
        }
        return comment;
    }

    private static String invalidity(UnicodeString comment) {
        if (comment.indexOf(TWO_HYPHENS, 0L) >= 0L) {
            return "Invalid characters (--) in comment";
        }
        if (comment.length() > 0L && comment.codePointAt(comment.length() - 1L) == 45) {
            return "Comment cannot end in '-'";
        }
        return null;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("comment", this);
        String flags = "";
        if (this.isLocal()) {
            flags = flags + "l";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        this.getSelect().export(out);
        out.endElement();
    }
}

