/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.jcs3.auxiliary.remote.AbstractRemoteAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.remote.AbstractRemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteCache<K, V>
extends AbstractRemoteAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(RemoteCache.class);
    private final RemoteCacheMonitor monitor;
    private AbstractRemoteCacheNoWaitFacade<K, V> facade;

    public RemoteCache(IRemoteCacheAttributes cattr, ICacheServiceNonLocal<K, V> remote, IRemoteCacheListener<K, V> listener, RemoteCacheMonitor monitor) {
        super(cattr, remote, listener);
        this.monitor = monitor;
        RemoteUtils.configureGlobalCustomSocketFactory(this.getRemoteCacheAttributes().getRmiSocketFactoryTimeoutMillis());
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<String>("Remote Host:Port", this.getIPAddressForService()));
        elems.add(new StatElement<String>("Remote Type", this.getRemoteCacheAttributes().getRemoteTypeName()));
        IStats sStats = super.getStatistics();
        elems.addAll(sStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    protected void setFacade(AbstractRemoteCacheNoWaitFacade<K, V> facade) {
        this.facade = facade;
    }

    protected AbstractRemoteCacheNoWaitFacade<K, V> getFacade() {
        return this.facade;
    }

    @Override
    protected void handleException(Exception ex, String msg, String eventName) throws IOException {
        String message = "Disabling remote cache due to error: " + msg;
        this.logError(this.cacheName, "", message);
        log.error(message, ex);
        if (!(this.getRemoteCacheService() instanceof ZombieCacheServiceNonLocal)) {
            this.setRemoteCacheService(new ZombieCacheServiceNonLocal(this.getRemoteCacheAttributes().getZombieQueueMaxSize()));
        }
        this.monitor.notifyError();
        log.debug("Initiating failover, rcnwf = {0}", this.facade);
        if (this.facade != null && this.facade.getAuxiliaryCacheAttributes().getRemoteType() == RemoteType.LOCAL) {
            log.debug("Found facade, calling failover");
            this.facade.failover(this.facade.getPrimaryServer());
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex);
    }

    public String toString() {
        return "RemoteCache: " + this.cacheName + " attributes = " + this.getRemoteCacheAttributes();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return this.getIPAddressForService();
    }

    protected String getIPAddressForService() {
        String ipAddress = "(null)";
        if (this.getRemoteCacheAttributes().getRemoteLocation() != null) {
            ipAddress = this.getRemoteCacheAttributes().getRemoteLocation().toString();
        }
        return ipAddress;
    }
}

