/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

public class IntegerRange
extends AbstractNumericRange<Integer> {
    protected int _min;
    protected int _max;

    public IntegerRange() {
        this(0, 1);
    }

    public IntegerRange(int min2, int max) {
        this._min = Math.min(min2, max);
        this._max = Math.max(min2, max);
    }

    public IntegerRange(IntegerRange integerRange) {
        this((int)integerRange.minimum(), (int)integerRange.maximum());
    }

    @Override
    public Range<Integer> copy() {
        return new IntegerRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int min2) {
        int old = this._min;
        if (old == min2) {
            return;
        }
        assert (min2 <= this._max) : "minimum " + min2 + " not <= " + this._max;
        this._min = min2;
        this.firePropertyChange("min", old, min2);
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int max) {
        int old = this._max;
        if (old == max) {
            return;
        }
        assert (max >= this._min) : "maximum " + max + " not >= " + this._min;
        this._max = max;
        this.firePropertyChange("max", old, max);
    }

    @Override
    public void adjust(Integer lower, Integer upper) {
        double size = this.size();
        if (lower != null) {
            this.setMin(lower);
        } else if (upper != null) {
            this.setMin(upper - (int)size);
        }
        if (upper != null) {
            this.setMax(upper);
        } else if (lower != null) {
            this.setMin(lower + (int)size);
        }
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Integer lower() {
        return (int)this.minimum();
    }

    @Override
    public Integer upper() {
        return (int)this.maximum();
    }

    @Override
    public boolean contains(Integer x) {
        return x >= this._min && x <= this._max;
    }

    @Override
    public Range<Integer> createIntermediate(Range<Integer> targetRange, double position) {
        double sourceMin = this.minimum();
        double sourceMax = this.maximum();
        double targetMin = targetRange.minimum();
        double targetMax = targetRange.maximum();
        double min2 = sourceMin + position * (targetMin - sourceMin);
        double max = sourceMax + position * (targetMax - sourceMax);
        return new IntegerRange((int)Math.round(min2), (int)Math.round(max));
    }

    public boolean equals(Object other) {
        if (other instanceof IntegerRange) {
            IntegerRange otherRange = (IntegerRange)other;
            return this._min == otherRange._min && this._max == otherRange._max;
        }
        return false;
    }

    public int hashCode() {
        return this._max * 29 + this._min;
    }

    public String toString() {
        return String.format("#<IntegerRange min=%d max=%d>", this._min, this._max);
    }
}

