/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.BinaryRangeDocValuesField;
import org.apache.lucene.document.IntRange;
import org.apache.lucene.document.IntRangeSlowRangeQuery;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;

public class IntRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final int[] min;
    final int[] max;

    public IntRangeDocValuesField(String field, int[] min2, int[] max) {
        super(field, IntRange.encode(min2, max), min2.length, 4);
        IntRangeDocValuesField.checkArgs(min2, max);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    public int getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public int getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, int[] min2, int[] max, RangeFieldQuery.QueryType queryType) {
        IntRangeDocValuesField.checkArgs(min2, max);
        return new IntRangeSlowRangeQuery(field, min2, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, int[] min2, int[] max) {
        return IntRangeDocValuesField.newSlowRangeQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(int[] min2, int[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min2.length; ++i) {
            if (min2[i] <= max[i]) continue;
            throw new IllegalArgumentException("min should be less than max but min = " + min2[i] + " and max = " + max[i]);
        }
    }
}

