import type { ComputedRef, FunctionalComponent, PropType, Ref, SetupContext, VNode } from 'vue';
import type { AutoPlacementOptions, FlipOptions, HideOptions, OffsetOptions, ShiftOptions } from '@floating-ui/core';
import type { AutoUpdateOptions, DetectOverflowOptions, Middleware, Placement, Strategy, VirtualElement } from '@floating-ui/dom';
import type { ClassResolver } from './class-resolvers';
import type { FloatingElement, ReferenceElement, __VLS_WithTemplateSlots } from './types';
interface ReferenceState {
    referenceRef: Ref<ReferenceElement | null>;
    placement: Readonly<Ref<Placement>>;
}
interface FloatingState {
    floatingRef: Ref<FloatingElement | null>;
    props: FloatProps;
    mounted: Ref<boolean>;
    show: Ref<boolean>;
    referenceHidden: Ref<boolean | undefined>;
    escaped: Ref<boolean | undefined>;
    placement: Readonly<Ref<Placement>>;
    floatingStyles: Ref<{
        position: Strategy;
        top: string;
        left: string;
        transform?: string;
        willChange?: string;
    }>;
    referenceElWidth: Ref<number | null>;
    updateFloating: () => void;
}
interface ArrowState {
    ref: Ref<HTMLElement | null>;
    placement: Ref<Placement>;
    x: Ref<number | undefined>;
    y: Ref<number | undefined>;
}
export interface FloatProps {
    as?: string | FunctionalComponent;
    floatingAs?: string | FunctionalComponent;
    show?: boolean;
    placement?: Placement;
    strategy?: Strategy;
    offset?: OffsetOptions;
    shift?: boolean | number | Partial<ShiftOptions & DetectOverflowOptions>;
    flip?: boolean | number | Partial<FlipOptions & DetectOverflowOptions>;
    arrow?: boolean | number;
    autoPlacement?: boolean | Partial<AutoPlacementOptions & DetectOverflowOptions>;
    hide?: boolean | Partial<HideOptions & DetectOverflowOptions> | Partial<HideOptions & DetectOverflowOptions>[];
    referenceHiddenClass?: string;
    escapedClass?: string;
    autoUpdate?: boolean | Partial<AutoUpdateOptions>;
    zIndex?: number | string;
    vueTransition?: boolean;
    transitionName?: string;
    transitionType?: 'transition' | 'animation';
    enter?: string;
    enterFrom?: string;
    enterTo?: string;
    leave?: string;
    leaveFrom?: string;
    leaveTo?: string;
    originClass?: string | ClassResolver;
    tailwindcssOriginClass?: boolean;
    portal?: boolean;
    transform?: boolean;
    adaptiveWidth?: boolean | {
        attribute?: string;
    };
    composable?: boolean;
    dialog?: boolean;
    middleware?: Middleware[] | ((refs: {
        referenceEl: ComputedRef<ReferenceElement | null>;
        floatingEl: ComputedRef<FloatingElement | null>;
    }) => Middleware[]);
    onShow?: () => any;
    onHide?: () => any;
    onUpdate?: () => any;
}
export declare const FloatPropsValidators: {
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    floatingAs: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    show: {
        type: BooleanConstructor;
        default: null;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    hide: {
        type: PropType<boolean | Partial<HideOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }> | Partial<HideOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>[]>;
        default: boolean;
    };
    referenceHiddenClass: StringConstructor;
    escapedClass: StringConstructor;
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    portal: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    adaptiveWidth: {
        type: PropType<boolean | {
            attribute?: string | undefined;
        }>;
        default: boolean;
    };
    composable: {
        type: BooleanConstructor;
        default: boolean;
    };
    dialog: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
};
export interface FloatSlotProps {
    placement: Placement;
}
export type RenderReferenceElementProps = FloatReferenceProps & Required<Pick<FloatReferenceProps, 'as'>>;
export declare function renderReferenceElement(referenceNode: VNode, componentProps: RenderReferenceElementProps, attrs: SetupContext['attrs'], context: ReferenceState): VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>;
export type RenderFloatingElementProps = FloatContentProps & Required<Pick<FloatContentProps, 'as'>> & {
    show?: boolean | null;
};
export declare function renderFloatingElement(floatingNode: VNode, componentProps: RenderFloatingElementProps, attrs: SetupContext['attrs'], context: FloatingState): VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>;
export declare function useFloat<T extends ReferenceElement>(show: Ref<boolean>, reference: Ref<T | null>, floating: Ref<FloatingElement | null>, props: FloatProps, emit: (event: 'show' | 'hide' | 'update', ...args: any[]) => void): {
    referenceApi: ReferenceState;
    floatingApi: FloatingState;
    arrowApi: ArrowState;
    placement: Readonly<Ref<Placement>>;
    referenceEl: ComputedRef<T | null>;
    floatingEl: ComputedRef<HTMLElement | null>;
    middlewareData: Readonly<Ref<import("@floating-ui/core").MiddlewareData>>;
    update: () => void;
};
export declare const Float: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    floatingAs: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    show: {
        type: BooleanConstructor;
        default: null;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    hide: {
        type: PropType<boolean | Partial<HideOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }> | Partial<HideOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>[]>;
        default: boolean;
    };
    referenceHiddenClass: StringConstructor;
    escapedClass: StringConstructor;
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    portal: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    adaptiveWidth: {
        type: PropType<boolean | {
            attribute?: string | undefined;
        }>;
        default: boolean;
    };
    composable: {
        type: BooleanConstructor;
        default: boolean;
    };
    dialog: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>[] | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("show" | "hide" | "update")[], "show" | "hide" | "update", import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    floatingAs: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    show: {
        type: BooleanConstructor;
        default: null;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    hide: {
        type: PropType<boolean | Partial<HideOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }> | Partial<HideOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>[]>;
        default: boolean;
    };
    referenceHiddenClass: StringConstructor;
    escapedClass: StringConstructor;
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    portal: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    adaptiveWidth: {
        type: PropType<boolean | {
            attribute?: string | undefined;
        }>;
        default: boolean;
    };
    composable: {
        type: BooleanConstructor;
        default: boolean;
    };
    dialog: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
}>> & {
    onShow?: ((...args: any[]) => any) | undefined;
    onHide?: ((...args: any[]) => any) | undefined;
    onUpdate?: ((...args: any[]) => any) | undefined;
}, {
    shift: number | boolean | Partial<ShiftOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    strategy: Strategy;
    placement: Placement;
    dialog: boolean;
    as: string | FunctionalComponent<{}, {}, any, {}>;
    vueTransition: boolean;
    tailwindcssOriginClass: boolean;
    show: boolean;
    floatingAs: string | FunctionalComponent<{}, {}, any, {}>;
    flip: number | boolean | Partial<FlipOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    arrow: number | boolean;
    autoPlacement: boolean | Partial<AutoPlacementOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    hide: boolean | Partial<HideOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }> | Partial<HideOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>[];
    autoUpdate: boolean | Partial<AutoUpdateOptions>;
    zIndex: string | number;
    portal: boolean;
    transform: boolean;
    adaptiveWidth: boolean | {
        attribute?: string | undefined;
    };
    composable: boolean;
    middleware: {
        name: string;
        options?: any;
        fn: (state: {
            x: number;
            y: number;
            strategy: Strategy;
            initialPlacement: Placement;
            placement: Placement;
            middlewareData: import("@floating-ui/core").MiddlewareData;
            rects: import("@floating-ui/utils").ElementRects;
            platform: import("@floating-ui/core").Platform;
            elements: import("@floating-ui/dom").Elements;
        }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
    }[] | ((refs: {
        referenceEl: ComputedRef<ReferenceElement | null>;
        floatingEl: ComputedRef<FloatingElement | null>;
    }) => Middleware[]);
}, {}>, Readonly<{
    default: (props: FloatSlotProps) => any;
}> & {
    default: (props: FloatSlotProps) => any;
}>;
export interface FloatReferenceProps extends Pick<FloatProps, 'as'> {
}
export declare const FloatReferencePropsValidators: {
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
};
export interface FloatReferenceSlotProps {
    placement: Placement;
}
export declare const FloatReference: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, import("vue").EmitsOptions, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
}>>, {
    as: string | FunctionalComponent<{}, {}, any, {}>;
}, {}>, Readonly<{
    default: (props: FloatReferenceSlotProps) => any;
}> & {
    default: (props: FloatReferenceSlotProps) => any;
}>;
export interface FloatContentProps extends Pick<FloatProps, 'as' | 'vueTransition' | 'transitionName' | 'transitionType' | 'enter' | 'enterFrom' | 'enterTo' | 'leave' | 'leaveFrom' | 'leaveTo' | 'originClass' | 'tailwindcssOriginClass'> {
    transitionChild?: boolean;
}
export declare const FloatContentPropsValidators: {
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionChild: {
        type: BooleanConstructor;
        default: boolean;
    };
};
export interface FloatContentSlotProps {
    placement: Placement;
}
export declare const FloatContent: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionChild: {
        type: BooleanConstructor;
        default: boolean;
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, import("vue").EmitsOptions, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionChild: {
        type: BooleanConstructor;
        default: boolean;
    };
}>>, {
    as: string | FunctionalComponent<{}, {}, any, {}>;
    vueTransition: boolean;
    tailwindcssOriginClass: boolean;
    transitionChild: boolean;
}, {}>, Readonly<{
    default: (props: FloatContentSlotProps) => any;
}> & {
    default: (props: FloatContentSlotProps) => any;
}>;
export interface FloatArrowProps extends Pick<FloatProps, 'as'> {
    offset?: number;
}
export declare const FloatArrowPropsValidators: {
    as: {
        default: string;
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
    };
    offset: {
        type: NumberConstructor;
        default: number;
    };
};
export interface FloatArrowSlotProps {
    placement: Placement;
}
export declare const FloatArrow: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        default: string;
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
    };
    offset: {
        type: NumberConstructor;
        default: number;
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, import("vue").EmitsOptions, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        default: string;
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
    };
    offset: {
        type: NumberConstructor;
        default: number;
    };
}>>, {
    as: string | FunctionalComponent<{}, {}, any, {}>;
    offset: number;
}, {}>, Readonly<{
    default: (props: FloatArrowSlotProps) => any;
}> & {
    default: (props: FloatArrowSlotProps) => any;
}>;
export interface FloatVirtualProps<FloatingElement = HTMLElement> extends Pick<FloatProps, 'as' | 'show' | 'placement' | 'strategy' | 'offset' | 'shift' | 'flip' | 'arrow' | 'autoPlacement' | 'autoUpdate' | 'zIndex' | 'vueTransition' | 'transitionName' | 'transitionType' | 'enter' | 'enterFrom' | 'enterTo' | 'leave' | 'leaveFrom' | 'leaveTo' | 'originClass' | 'tailwindcssOriginClass' | 'portal' | 'transform' | 'middleware' | 'onShow' | 'onHide' | 'onUpdate'> {
    onInitial?: (props: FloatVirtualInitialProps<FloatingElement>) => any;
}
export declare const FloatVirtualPropsValidators: {
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    show: {
        type: BooleanConstructor;
        default: null;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    portal: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
};
export interface FloatVirtualSlotProps {
    placement: Placement;
    close: () => void;
}
export interface FloatVirtualInitialProps<FloatingElement = HTMLElement> {
    show: Ref<boolean>;
    placement: Readonly<Ref<Placement>>;
    reference: Ref<VirtualElement>;
    floating: Ref<FloatingElement | null>;
}
export declare const FloatVirtual: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    show: {
        type: BooleanConstructor;
        default: null;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    portal: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("show" | "hide" | "update" | "initial")[], "show" | "hide" | "update" | "initial", import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    show: {
        type: BooleanConstructor;
        default: null;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    portal: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
}>> & {
    onShow?: ((...args: any[]) => any) | undefined;
    onHide?: ((...args: any[]) => any) | undefined;
    onUpdate?: ((...args: any[]) => any) | undefined;
    onInitial?: ((...args: any[]) => any) | undefined;
}, {
    shift: number | boolean | Partial<ShiftOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    strategy: Strategy;
    placement: Placement;
    as: string | FunctionalComponent<{}, {}, any, {}>;
    vueTransition: boolean;
    tailwindcssOriginClass: boolean;
    show: boolean;
    flip: number | boolean | Partial<FlipOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    arrow: number | boolean;
    autoPlacement: boolean | Partial<AutoPlacementOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    autoUpdate: boolean | Partial<AutoUpdateOptions>;
    zIndex: string | number;
    portal: boolean;
    transform: boolean;
    middleware: {
        name: string;
        options?: any;
        fn: (state: {
            x: number;
            y: number;
            strategy: Strategy;
            initialPlacement: Placement;
            placement: Placement;
            middlewareData: import("@floating-ui/core").MiddlewareData;
            rects: import("@floating-ui/utils").ElementRects;
            platform: import("@floating-ui/core").Platform;
            elements: import("@floating-ui/dom").Elements;
        }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
    }[] | ((refs: {
        referenceEl: ComputedRef<ReferenceElement | null>;
        floatingEl: ComputedRef<FloatingElement | null>;
    }) => Middleware[]);
}, {}>, Readonly<{
    default: (props: FloatVirtualSlotProps) => any;
}> & {
    default: (props: FloatVirtualSlotProps) => any;
}>;
export interface FloatContextMenuProps extends Omit<FloatVirtualProps, 'show' | 'portal'> {
}
export declare const FloatContextMenuPropsValidators: {
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        default: boolean;
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
};
export declare const FloatContextMenu: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        default: boolean;
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("show" | "hide" | "update")[], "show" | "hide" | "update", import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        default: boolean;
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
}>> & {
    onShow?: ((...args: any[]) => any) | undefined;
    onHide?: ((...args: any[]) => any) | undefined;
    onUpdate?: ((...args: any[]) => any) | undefined;
}, {
    shift: number | boolean | Partial<ShiftOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    strategy: Strategy;
    placement: Placement;
    as: string | FunctionalComponent<{}, {}, any, {}>;
    vueTransition: boolean;
    tailwindcssOriginClass: boolean;
    flip: number | boolean | Partial<FlipOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    arrow: number | boolean;
    autoPlacement: boolean | Partial<AutoPlacementOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    autoUpdate: boolean | Partial<AutoUpdateOptions>;
    zIndex: string | number;
    transform: boolean;
    middleware: {
        name: string;
        options?: any;
        fn: (state: {
            x: number;
            y: number;
            strategy: Strategy;
            initialPlacement: Placement;
            placement: Placement;
            middlewareData: import("@floating-ui/core").MiddlewareData;
            rects: import("@floating-ui/utils").ElementRects;
            platform: import("@floating-ui/core").Platform;
            elements: import("@floating-ui/dom").Elements;
        }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
    }[] | ((refs: {
        referenceEl: ComputedRef<ReferenceElement | null>;
        floatingEl: ComputedRef<FloatingElement | null>;
    }) => Middleware[]);
}, {}>, Readonly<{
    default: (props: FloatVirtualSlotProps) => any;
}> & {
    default: (props: FloatVirtualSlotProps) => any;
}>;
export interface FloatCursorProps extends Omit<FloatVirtualProps, 'show' | 'portal'> {
    globalHideCursor?: boolean;
}
export declare const FloatCursorPropsValidators: {
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
    globalHideCursor: {
        type: BooleanConstructor;
        default: boolean;
    };
};
export declare const FloatCursor: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
    globalHideCursor: {
        type: BooleanConstructor;
        default: boolean;
    };
}, () => VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("show" | "hide" | "update")[], "show" | "hide" | "update", import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    as: {
        type: PropType<string | FunctionalComponent<{}, {}, any, {}>>;
        default: string;
    };
    placement: {
        type: PropType<Placement>;
        default: Placement;
    };
    strategy: {
        type: PropType<Strategy>;
        default: Strategy;
    };
    offset: PropType<OffsetOptions>;
    shift: {
        type: PropType<number | boolean | Partial<ShiftOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    flip: {
        type: PropType<number | boolean | Partial<FlipOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    arrow: {
        type: (NumberConstructor | BooleanConstructor)[];
        default: boolean;
    };
    autoPlacement: {
        type: PropType<boolean | Partial<AutoPlacementOptions & {
            rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
            elementContext?: import("@floating-ui/core").ElementContext | undefined;
            altBoundary?: boolean | undefined;
            padding?: import("@floating-ui/utils").Padding | undefined;
            boundary?: import("@floating-ui/dom").Boundary | undefined;
        }>>;
        default: boolean;
    };
    autoUpdate: {
        type: PropType<boolean | Partial<AutoUpdateOptions>>;
        default: boolean;
    };
    zIndex: {
        type: (NumberConstructor | StringConstructor)[];
        default: number;
    };
    vueTransition: {
        type: BooleanConstructor;
        default: boolean;
    };
    transitionName: StringConstructor;
    transitionType: PropType<"transition" | "animation">;
    enter: StringConstructor;
    enterFrom: StringConstructor;
    enterTo: StringConstructor;
    leave: StringConstructor;
    leaveFrom: StringConstructor;
    leaveTo: StringConstructor;
    originClass: PropType<string | ClassResolver>;
    tailwindcssOriginClass: {
        type: BooleanConstructor;
        default: boolean;
    };
    transform: {
        type: BooleanConstructor;
        default: boolean;
    };
    middleware: {
        type: PropType<{
            name: string;
            options?: any;
            fn: (state: {
                x: number;
                y: number;
                strategy: Strategy;
                initialPlacement: Placement;
                placement: Placement;
                middlewareData: import("@floating-ui/core").MiddlewareData;
                rects: import("@floating-ui/utils").ElementRects;
                platform: import("@floating-ui/core").Platform;
                elements: import("@floating-ui/dom").Elements;
            }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
        }[] | ((refs: {
            referenceEl: ComputedRef<ReferenceElement | null>;
            floatingEl: ComputedRef<FloatingElement | null>;
        }) => Middleware[])>;
        default: () => never[];
    };
    globalHideCursor: {
        type: BooleanConstructor;
        default: boolean;
    };
}>> & {
    onShow?: ((...args: any[]) => any) | undefined;
    onHide?: ((...args: any[]) => any) | undefined;
    onUpdate?: ((...args: any[]) => any) | undefined;
}, {
    shift: number | boolean | Partial<ShiftOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    strategy: Strategy;
    placement: Placement;
    as: string | FunctionalComponent<{}, {}, any, {}>;
    vueTransition: boolean;
    tailwindcssOriginClass: boolean;
    flip: number | boolean | Partial<FlipOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    arrow: number | boolean;
    autoPlacement: boolean | Partial<AutoPlacementOptions & {
        rootBoundary?: import("@floating-ui/core").RootBoundary | undefined;
        elementContext?: import("@floating-ui/core").ElementContext | undefined;
        altBoundary?: boolean | undefined;
        padding?: import("@floating-ui/utils").Padding | undefined;
        boundary?: import("@floating-ui/dom").Boundary | undefined;
    }>;
    autoUpdate: boolean | Partial<AutoUpdateOptions>;
    zIndex: string | number;
    transform: boolean;
    middleware: {
        name: string;
        options?: any;
        fn: (state: {
            x: number;
            y: number;
            strategy: Strategy;
            initialPlacement: Placement;
            placement: Placement;
            middlewareData: import("@floating-ui/core").MiddlewareData;
            rects: import("@floating-ui/utils").ElementRects;
            platform: import("@floating-ui/core").Platform;
            elements: import("@floating-ui/dom").Elements;
        }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
    }[] | ((refs: {
        referenceEl: ComputedRef<ReferenceElement | null>;
        floatingEl: ComputedRef<FloatingElement | null>;
    }) => Middleware[]);
    globalHideCursor: boolean;
}, {}>, Readonly<{
    default: (props: FloatVirtualSlotProps) => any;
}> & {
    default: (props: FloatVirtualSlotProps) => any;
}>;
export {};
