"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDecrypt = void 0;
const decrypt_stream_1 = require("./decrypt_stream");
const decrypt_1 = require("./decrypt");
const material_management_node_1 = require("@aws-crypto/material-management-node");
function buildDecrypt(options = {}) {
    const { commitmentPolicy = material_management_node_1.CommitmentPolicy.REQUIRE_ENCRYPT_REQUIRE_DECRYPT, maxEncryptedDataKeys = false, } = typeof options === 'string' ? { commitmentPolicy: options } : options;
    /* Precondition: node buildDecrypt needs a valid commitmentPolicy. */
    (0, material_management_node_1.needs)(material_management_node_1.CommitmentPolicy[commitmentPolicy], 'Invalid commitment policy.');
    /* Precondition: node buildDecrypt needs a valid maxEncryptedDataKeys. */
    (0, material_management_node_1.needs)(maxEncryptedDataKeys === false || maxEncryptedDataKeys >= 1, 'Invalid maxEncryptedDataKeys value.');
    const clientOptions = {
        commitmentPolicy,
        maxEncryptedDataKeys,
    };
    return {
        decryptUnsignedMessageStream: decrypt_stream_1._decryptStream.bind({}, {
            signaturePolicy: material_management_node_1.SignaturePolicy.ALLOW_ENCRYPT_FORBID_DECRYPT,
            clientOptions,
        }),
        decryptStream: decrypt_stream_1._decryptStream.bind({}, {
            signaturePolicy: material_management_node_1.SignaturePolicy.ALLOW_ENCRYPT_ALLOW_DECRYPT,
            clientOptions,
        }),
        decrypt: decrypt_1._decrypt.bind({}, {
            signaturePolicy: material_management_node_1.SignaturePolicy.ALLOW_ENCRYPT_ALLOW_DECRYPT,
            clientOptions,
        }),
    };
}
exports.buildDecrypt = buildDecrypt;
// @ts-ignore
const { decryptUnsignedMessageStream, decryptStream, decrypt } = buildDecrypt();
decryptUnsignedMessageStream({});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVjcnlwdF9jbGllbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZGVjcnlwdF9jbGllbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7OztBQUV0QyxxREFBaUQ7QUFDakQsdUNBQW9DO0FBQ3BDLG1GQUs2QztBQVM3QyxTQUFnQixZQUFZLENBQzFCLFVBQXFELEVBQUU7SUFVdkQsTUFBTSxFQUNKLGdCQUFnQixHQUFHLDJDQUFnQixDQUFDLCtCQUErQixFQUNuRSxvQkFBb0IsR0FBRyxLQUFLLEdBQzdCLEdBQUcsT0FBTyxPQUFPLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLGdCQUFnQixFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUE7SUFFekUscUVBQXFFO0lBQ3JFLElBQUEsZ0NBQUssRUFBQywyQ0FBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLDRCQUE0QixDQUFDLENBQUE7SUFDdkUseUVBQXlFO0lBQ3pFLElBQUEsZ0NBQUssRUFDSCxvQkFBb0IsS0FBSyxLQUFLLElBQUksb0JBQW9CLElBQUksQ0FBQyxFQUMzRCxxQ0FBcUMsQ0FDdEMsQ0FBQTtJQUVELE1BQU0sYUFBYSxHQUFrQjtRQUNuQyxnQkFBZ0I7UUFDaEIsb0JBQW9CO0tBQ3JCLENBQUE7SUFDRCxPQUFPO1FBQ0wsNEJBQTRCLEVBQUUsK0JBQWMsQ0FBQyxJQUFJLENBQy9DLEVBQUUsRUFDRjtZQUNFLGVBQWUsRUFBRSwwQ0FBZSxDQUFDLDRCQUE0QjtZQUM3RCxhQUFhO1NBQ2QsQ0FDRjtRQUNELGFBQWEsRUFBRSwrQkFBYyxDQUFDLElBQUksQ0FDaEMsRUFBRSxFQUNGO1lBQ0UsZUFBZSxFQUFFLDBDQUFlLENBQUMsMkJBQTJCO1lBQzVELGFBQWE7U0FDZCxDQUNGO1FBQ0QsT0FBTyxFQUFFLGtCQUFRLENBQUMsSUFBSSxDQUNwQixFQUFFLEVBQ0Y7WUFDRSxlQUFlLEVBQUUsMENBQWUsQ0FBQywyQkFBMkI7WUFDNUQsYUFBYTtTQUNkLENBQ0Y7S0FDRixDQUFBO0FBQ0gsQ0FBQztBQW5ERCxvQ0FtREM7QUFFRCxhQUFhO0FBQ2IsTUFBTSxFQUFFLDRCQUE0QixFQUFFLGFBQWEsRUFBRSxPQUFPLEVBQUUsR0FBRyxZQUFZLEVBQUUsQ0FBQTtBQUMvRSw0QkFBNEIsQ0FBQyxFQUFTLENBQUMsQ0FBQSJ9