/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.amazon.dlic.auth.ldap.LdapUser;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.Serializable;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.BytesStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.support.SafeSerializationUtils;
import org.opensearch.security.support.SourceFieldsContext;
import org.opensearch.security.support.StreamableRegistry;
import org.opensearch.security.user.User;

public class Base64CustomHelper {
    private static final BiMap<Class<?>, Integer> writeableClassToIdMap = HashBiMap.create();
    private static final StreamableRegistry streamableRegistry = StreamableRegistry.getInstance();

    protected static String serializeObject(Serializable object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object must not be null");
        SafeBytesStreamOutput streamOutput = new SafeBytesStreamOutput(128);
        Class<?> clazz = object.getClass();
        try {
            SafeSerializationUtils.prohibitUnsafeClasses(clazz);
            CustomSerializationFormat customSerializationFormat = Base64CustomHelper.getCustomSerializationMode(clazz);
            switch (customSerializationFormat) {
                case WRITEABLE: {
                    streamOutput.writeByte((byte)CustomSerializationFormat.WRITEABLE.id);
                    streamOutput.writeByte((byte)Base64CustomHelper.getWriteableClassID(clazz).intValue());
                    ((Writeable)object).writeTo((StreamOutput)streamOutput);
                    break;
                }
                case STREAMABLE: {
                    streamOutput.writeByte((byte)CustomSerializationFormat.STREAMABLE.id);
                    streamableRegistry.writeTo((StreamOutput)streamOutput, object);
                    break;
                }
                case GENERIC: {
                    streamOutput.writeByte((byte)CustomSerializationFormat.GENERIC.id);
                    streamOutput.writeGenericValue(object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Could not determine custom serialization mode for class %s", clazz.getName()));
                }
            }
        }
        catch (Exception e) {
            throw new OpenSearchException("Instance {} of class {} is not serializable", (Throwable)e, new Object[]{object, object.getClass()});
        }
        byte[] bytes = streamOutput.bytes().toBytesRef().bytes;
        streamOutput.close();
        return BaseEncoding.base64().encode(bytes);
    }

    protected static Serializable deserializeObject(String string) {
        Serializable serializable;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)string) ? 1 : 0) != 0, (Object)"object must not be null or empty");
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)string);
        Serializable obj = null;
        SafeBytesStreamInput streamInput = new SafeBytesStreamInput(bytes);
        try {
            CustomSerializationFormat serializationFormat = CustomSerializationFormat.fromId(streamInput.readByte());
            switch (serializationFormat) {
                case WRITEABLE: {
                    byte classId = streamInput.readByte();
                    Class<?> clazz = Base64CustomHelper.getWriteableClassFromId(classId);
                    obj = (Serializable)clazz.getConstructor(StreamInput.class).newInstance(new Object[]{streamInput});
                    break;
                }
                case STREAMABLE: {
                    obj = (Serializable)streamableRegistry.readFrom((StreamInput)streamInput);
                    break;
                }
                case GENERIC: {
                    obj = (Serializable)streamInput.readGenericValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not determine custom deserialization mode");
                }
            }
            SafeSerializationUtils.prohibitUnsafeClasses(obj.getClass());
            serializable = obj;
        }
        catch (Throwable throwable) {
            try {
                try {
                    streamInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new OpenSearchException((Throwable)e);
            }
        }
        streamInput.close();
        return serializable;
    }

    private static boolean isWriteable(Class<?> clazz) {
        return Writeable.class.isAssignableFrom(clazz);
    }

    protected static Integer getWriteableClassID(Class<?> clazz) {
        if (!Base64CustomHelper.isWriteable(clazz)) {
            throw new OpenSearchException("clazz should implement Writeable ", new Object[]{clazz});
        }
        if (!writeableClassToIdMap.containsKey(clazz)) {
            throw new OpenSearchException("Writeable clazz not registered ", new Object[]{clazz});
        }
        return (Integer)writeableClassToIdMap.get(clazz);
    }

    private static Class<?> getWriteableClassFromId(int id) {
        return (Class)writeableClassToIdMap.inverse().get((Object)id);
    }

    private static void registerWriteable(Class<? extends Writeable> clazz) {
        if (writeableClassToIdMap.containsKey(clazz)) {
            throw new OpenSearchException("writeable clazz is already registered ", new Object[]{clazz.getName()});
        }
        int id = writeableClassToIdMap.size() + 1;
        writeableClassToIdMap.put(clazz, (Object)id);
    }

    private static void registerAllWriteables() {
        Base64CustomHelper.registerWriteable(User.class);
        Base64CustomHelper.registerWriteable(LdapUser.class);
        Base64CustomHelper.registerWriteable(UserInjector.InjectedUser.class);
        Base64CustomHelper.registerWriteable(SourceFieldsContext.class);
    }

    private static CustomSerializationFormat getCustomSerializationMode(Class<?> clazz) {
        if (Base64CustomHelper.isWriteable(clazz)) {
            return CustomSerializationFormat.WRITEABLE;
        }
        if (streamableRegistry.isStreamable(clazz)) {
            return CustomSerializationFormat.STREAMABLE;
        }
        return CustomSerializationFormat.GENERIC;
    }

    static {
        Base64CustomHelper.registerAllWriteables();
    }

    private static class SafeBytesStreamInput
    extends BytesStreamInput {
        public SafeBytesStreamInput(byte[] bytes) {
            super(bytes);
        }

        public Object readGenericValue() throws IOException {
            Object object = super.readGenericValue();
            SafeSerializationUtils.prohibitUnsafeClasses(object.getClass());
            return object;
        }
    }

    private static class SafeBytesStreamOutput
    extends BytesStreamOutput {
        public SafeBytesStreamOutput(int expectedSize) {
            super(expectedSize);
        }

        public void writeGenericValue(@Nullable Object value) throws IOException {
            SafeSerializationUtils.prohibitUnsafeClasses(value.getClass());
            super.writeGenericValue(value);
        }
    }

    private static enum CustomSerializationFormat {
        WRITEABLE(1),
        STREAMABLE(2),
        GENERIC(3);

        private final int id;

        private CustomSerializationFormat(int id) {
            this.id = id;
        }

        static CustomSerializationFormat fromId(int id) {
            switch (id) {
                case 1: {
                    return WRITEABLE;
                }
                case 2: {
                    return STREAMABLE;
                }
                case 3: {
                    return GENERIC;
                }
            }
            throw new IllegalArgumentException(String.format("%d is not a valid id", id));
        }
    }
}

