/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.cucadiagram.BodierMap;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateMap
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandCreateMap() {
        super(CommandCreateMap.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateMap.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "map"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), StereotypePattern.optional("STEREO"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), CommandCreateMap.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("##"), new RegexLeaf("LINECOLOR", "(?:\\[(dotted|dashed|bold)\\])?(\\w+)?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        Entity entity1 = this.executeArg0(lines.getLocation(), diagram, line0);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        lines = lines.subExtract(1, 1);
        for (StringLocated sl : lines) {
            String line = sl.getString();
            assert (line.length() > 0);
            boolean ok = entity1.getBodier().addFieldOrMethod(line);
            if (!ok) {
                return CommandExecutionResult.error("Map definition should contains key => value");
            }
            if (BodierMap.getLinkedEntry(line) == null) continue;
            String linkStr = BodierMap.getLinkedEntry(line);
            int x = line.indexOf(linkStr);
            String key = line.substring(0, x).trim();
            String dest = line.substring(x + linkStr.length()).trim();
            Quark<Entity> ident2 = diagram.quarkInContext(true, dest);
            Entity entity2 = ident2.getData();
            if (entity2 == null) {
                return CommandExecutionResult.error("No such entity " + ident2.getName());
            }
            LinkType linkType = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
            int length = linkStr.length() - 2;
            Link link = new Link(lines.getLocation(), diagram, diagram.getSkinParam().getCurrentStyleBuilder(), entity1, entity2, linkType, LinkArg.noDisplay(length));
            link.setPortMembers(key, null);
            diagram.addLink(link);
        }
        return CommandExecutionResult.ok();
    }

    private Entity executeArg0(LineLocation location, AbstractEntityDiagram diagram, RegexResult line0) throws NoSuchColorException {
        HColor lineColor;
        String name = line0.get("NAME", 1);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(name));
        String displayString = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        if (quark.getData() != null) {
            return null;
        }
        Display display = Display.getWithNewlines(diagram.getPragma(), displayString);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(diagram.getPragma(), name).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        Entity entity = diagram.reallyCreateLeaf(location, quark, display, LeafType.MAP, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandCreateMap.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        String s2 = line0.get("LINECOLOR", 1);
        HColor hColor = lineColor = s2 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (line0.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(line0.get("LINECOLOR", 0));
        }
        entity.setColors(colors);
        return entity;
    }
}

