/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.error;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.protege.editor.core.ui.error.ErrorLog;
import org.protege.editor.core.ui.error.SendErrorReportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLogPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ErrorLogPanel.class);
    private ErrorLog errorLog;
    private JTextArea textArea;
    private SendErrorReportHandler errorReportHandler;

    public ErrorLogPanel(ErrorLog errorLog, SendErrorReportHandler handler) {
        this.errorLog = errorLog;
        this.errorReportHandler = handler;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("monospaced", 0, 12));
        JPanel contentPane = new JPanel(new BorderLayout(7, 7));
        contentPane.add(new JScrollPane(this.textArea));
        if (handler != null) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.add((Component)new JButton(new AbstractAction("Clear Errors"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ErrorLogPanel.this.handleSendErrorReport()) {
                        ErrorLogPanel.this.errorLog.clear();
                        ErrorLogPanel.this.fillLog();
                        ErrorLogPanel.this.repaint();
                    }
                }
            }), "West");
            contentPane.add((Component)buttonPanel, "South");
        }
        this.add((Component)contentPane, "Center");
        this.fillLog();
    }

    private boolean handleSendErrorReport() {
        return this.errorReportHandler != null && this.errorReportHandler.sendErrorReport(this.errorLog);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    @Override
    public void setVisible(boolean b) {
        this.fillLog();
        Container parent = this.getParent();
        if (parent != null) {
            int w = (parent.getWidth() - this.getWidth()) / 2;
            int h = (parent.getHeight() - this.getHeight()) / 2;
            this.setLocation(w, h);
        }
        super.setVisible(b);
    }

    public void fillLog() {
        this.textArea.setText("");
        for (ErrorLog.ErrorLogEntry entry : this.errorLog.getEntries()) {
            this.textArea.append(entry.toString());
            this.textArea.append("---------------------------------------------------------------------------------------------------\n\n");
        }
    }

    protected ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public static void showErrorDialog(Throwable throwable) {
        logger.error("An error was thrown: {}", (Object)throwable.getMessage(), (Object)throwable);
        JTextArea textPane = new JTextArea(15, 80);
        textPane.setLineWrap(false);
        textPane.setEditable(false);
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        textPane.setText(sw.toString());
        textPane.setFont(new Font("Monospaced", 0, 12));
        JScrollPane sp = new JScrollPane(textPane);
        sp.setPreferredSize(new Dimension(800, 300));
        JOptionPane op = new JOptionPane(sp, 0);
        JDialog dlg = op.createDialog(null, "An error has occurred");
        dlg.setResizable(true);
        dlg.setVisible(true);
    }
}

