/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Field;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.VariableResolverFactory;

public class FieldAccessorNH
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private boolean coercionRequired = false;
    private PropertyHandler nullHandler;

    public FieldAccessorNH(Field field, PropertyHandler handler2) {
        this.field = field;
        this.nullHandler = handler2;
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            Object v = this.field.get(ctx);
            if (v == null) {
                v = this.nullHandler.getProperty(this.field.getName(), elCtx, vars);
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(v, elCtx, vars);
            }
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        boolean attemptedCoercion = this.coercionRequired;
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(ctx, elCtx, variableFactory, value);
            }
            if (this.coercionRequired) {
                value = DataConversion.convert(ctx, this.field.getClass());
                this.field.set(ctx, value);
                return value;
            }
            this.field.set(ctx, value);
            return value;
        }
        catch (IllegalArgumentException e) {
            if (!attemptedCoercion) {
                this.coercionRequired = true;
                return this.setValue(ctx, elCtx, variableFactory, value);
            }
            throw new RuntimeException("unable to bind property", e);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

