// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC11Axxv0.6.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc11axx

/*
// LPC11Axx
*/

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC11Axx"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// GPIO Modification
	IRQ_PIN_INT0 = 0

	// GPIO Modification
	IRQ_PIN_INT1 = 1

	// GPIO Modification
	IRQ_PIN_INT2 = 2

	// GPIO Modification
	IRQ_PIN_INT3 = 3

	// GPIO Modification
	IRQ_PIN_INT4 = 4

	// GPIO Modification
	IRQ_PIN_INT5 = 5

	// GPIO Modification
	IRQ_PIN_INT6 = 6

	// GPIO Modification
	IRQ_PIN_INT7 = 7

	// GPIO group interrupt
	IRQ_GINT0 = 8

	IRQ_GINT1 = 9

	// Comparator
	IRQ_CMP = 10

	// DAC
	IRQ_DAC = 11

	// System configuration
	IRQ_RESERVED0 = 12

	// System configuration
	IRQ_RESERVED1 = 13

	IRQ_SSP1 = 14

	// I2C-bus controller
	IRQ_I2C = 15

	// 16-bit counter/timers CT16B0/1
	IRQ_CT16B0 = 16

	IRQ_CT16B1 = 17

	// 32-bit counter/timers CT32B0/1
	IRQ_CT32B0 = 18

	IRQ_CT32B1 = 19

	// SSP/SPI
	IRQ_SSP0 = 20

	// USART
	IRQ_USART = 21

	// System configuration
	IRQ_RESERVED2 = 22

	// System configuration
	IRQ_RESERVED3 = 23

	// ADC
	IRQ_ADC = 24

	// Windowed Watchdog Timer (WWDT)
	IRQ_WDT = 25

	// System configuration
	IRQ_BOD = 26

	// Flash controller
	IRQ_FMC = 27

	// System configuration
	IRQ_RESERVED4 = 28

	// System configuration
	IRQ_RESERVED5 = 29

	// System configuration
	IRQ_RESERVED6 = 30

	// System configuration
	IRQ_RESERVED7 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PIN_INT0_IRQHandler
func interruptPIN_INT0() {
	callHandlers(IRQ_PIN_INT0)
}

//export PIN_INT1_IRQHandler
func interruptPIN_INT1() {
	callHandlers(IRQ_PIN_INT1)
}

//export PIN_INT2_IRQHandler
func interruptPIN_INT2() {
	callHandlers(IRQ_PIN_INT2)
}

//export PIN_INT3_IRQHandler
func interruptPIN_INT3() {
	callHandlers(IRQ_PIN_INT3)
}

//export PIN_INT4_IRQHandler
func interruptPIN_INT4() {
	callHandlers(IRQ_PIN_INT4)
}

//export PIN_INT5_IRQHandler
func interruptPIN_INT5() {
	callHandlers(IRQ_PIN_INT5)
}

//export PIN_INT6_IRQHandler
func interruptPIN_INT6() {
	callHandlers(IRQ_PIN_INT6)
}

//export PIN_INT7_IRQHandler
func interruptPIN_INT7() {
	callHandlers(IRQ_PIN_INT7)
}

//export GINT0_IRQHandler
func interruptGINT0() {
	callHandlers(IRQ_GINT0)
}

//export GINT1_IRQHandler
func interruptGINT1() {
	callHandlers(IRQ_GINT1)
}

//export CMP_IRQHandler
func interruptCMP() {
	callHandlers(IRQ_CMP)
}

//export DAC_IRQHandler
func interruptDAC() {
	callHandlers(IRQ_DAC)
}

//export RESERVED0_IRQHandler
func interruptRESERVED0() {
	callHandlers(IRQ_RESERVED0)
}

//export RESERVED1_IRQHandler
func interruptRESERVED1() {
	callHandlers(IRQ_RESERVED1)
}

//export SSP1_IRQHandler
func interruptSSP1() {
	callHandlers(IRQ_SSP1)
}

//export I2C_IRQHandler
func interruptI2C() {
	callHandlers(IRQ_I2C)
}

//export CT16B0_IRQHandler
func interruptCT16B0() {
	callHandlers(IRQ_CT16B0)
}

//export CT16B1_IRQHandler
func interruptCT16B1() {
	callHandlers(IRQ_CT16B1)
}

//export CT32B0_IRQHandler
func interruptCT32B0() {
	callHandlers(IRQ_CT32B0)
}

//export CT32B1_IRQHandler
func interruptCT32B1() {
	callHandlers(IRQ_CT32B1)
}

//export SSP0_IRQHandler
func interruptSSP0() {
	callHandlers(IRQ_SSP0)
}

//export USART_IRQHandler
func interruptUSART() {
	callHandlers(IRQ_USART)
}

//export RESERVED2_IRQHandler
func interruptRESERVED2() {
	callHandlers(IRQ_RESERVED2)
}

//export RESERVED3_IRQHandler
func interruptRESERVED3() {
	callHandlers(IRQ_RESERVED3)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export BOD_IRQHandler
func interruptBOD() {
	callHandlers(IRQ_BOD)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export RESERVED4_IRQHandler
func interruptRESERVED4() {
	callHandlers(IRQ_RESERVED4)
}

//export RESERVED5_IRQHandler
func interruptRESERVED5() {
	callHandlers(IRQ_RESERVED5)
}

//export RESERVED6_IRQHandler
func interruptRESERVED6() {
	callHandlers(IRQ_RESERVED6)
}

//export RESERVED7_IRQHandler
func interruptRESERVED7() {
	callHandlers(IRQ_RESERVED7)
}

// Peripherals.
var (
	// I2C-bus controller
	I2C = (*I2C_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// USART
	USART = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// 16-bit counter/timers CT16B0/1
	CT16B0 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// 16-bit counter/timers CT16B0/1
	CT16B1 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// 32-bit counter/timers CT32B0/1
	CT32B0 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// 32-bit counter/timers CT32B0/1
	CT32B1 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// ADC
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// DAC
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Comparator
	CMP = (*Comparator_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Flash controller
	FMC = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// SSP/SPI
	SSP0 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// IOCON block
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// System configuration
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// GPIO Modification
	GPIO_PIN_INT = (*GPIO_PIN_INT_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// SSP/SPI
	SSP1 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// GPIO group interrupt
	GPIO_GROUP_INT0 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// GPIO group interrupt
	GPIO_GROUP_INT1 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// GPIO port
	GPIO_PORT = (*GPIO_PORT_Type)(unsafe.Pointer(uintptr(0x50000000)))
)

// I2C-bus controller
type I2C_Type struct {
	CONSET      volatile.Register32 // 0x0
	STAT        volatile.Register32 // 0x4
	DAT         volatile.Register32 // 0x8
	ADR0        volatile.Register32 // 0xC
	SCLH        volatile.Register32 // 0x10
	SCLL        volatile.Register32 // 0x14
	CONCLR      volatile.Register32 // 0x18
	MMCTRL      volatile.Register32 // 0x1C
	ADR1        volatile.Register32 // 0x20
	ADR2        volatile.Register32 // 0x24
	ADR3        volatile.Register32 // 0x28
	DATA_BUFFER volatile.Register32 // 0x2C
	MASK0       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	MASK2       volatile.Register32 // 0x38
	MASK3       volatile.Register32 // 0x3C
}

// I2C.CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCONSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONSET.Reg) & 0x3
}
func (o *I2C_Type) SetCONSET_AA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCONSET_AA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCONSET_SI(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCONSET_SI() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCONSET_STO(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCONSET_STO() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCONSET_STA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCONSET_STA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCONSET_I2EN(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCONSET_I2EN() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0xffffff80)|value<<7)
}
func (o *I2C_Type) GetCONSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0xffffff80) >> 7
}

// I2C.STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x7
}
func (o *I2C_Type) SetSTAT_Status(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xf8)|value<<3)
}
func (o *I2C_Type) GetSTAT_Status() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xf8) >> 3
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffffff00) >> 8
}

// I2C.DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
func (o *I2C_Type) SetDAT_Data(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDAT_Data() uint32 {
	return volatile.LoadUint32(&o.DAT.Reg) & 0xff
}
func (o *I2C_Type) SetDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DAT.Reg) & 0xffffff00) >> 8
}

// I2C.ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR0_GC(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR0_GC() uint32 {
	return volatile.LoadUint32(&o.ADR0.Reg) & 0x1
}
func (o *I2C_Type) SetADR0_Address(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR0_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xffffff00) >> 8
}

// I2C.SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
func (o *I2C_Type) SetSCLH(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSCLH() uint32 {
	return volatile.LoadUint32(&o.SCLH.Reg) & 0xffff
}
func (o *I2C_Type) SetSCLH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetSCLH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLH.Reg) & 0xffff0000) >> 16
}

// I2C.SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. I2nSCLL and I2nSCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
func (o *I2C_Type) SetSCLL(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSCLL() uint32 {
	return volatile.LoadUint32(&o.SCLL.Reg) & 0xffff
}
func (o *I2C_Type) SetSCLL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetSCLL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLL.Reg) & 0xffff0000) >> 16
}

// I2C.CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONCLR.Reg) & 0x3
}
func (o *I2C_Type) SetCONCLR_AAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCONCLR_AAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCONCLR_SIC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCONCLR_SIC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCONCLR_STAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCONCLR_STAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCONCLR_I2ENC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCONCLR_I2ENC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0xffffff00) >> 8
}

// I2C.MMCTRL: Monitor mode control register.
func (o *I2C_Type) SetMMCTRL_MM_ENA(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMMCTRL_MM_ENA() uint32 {
	return volatile.LoadUint32(&o.MMCTRL.Reg) & 0x1
}
func (o *I2C_Type) SetMMCTRL_ENA_SCL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetMMCTRL_ENA_SCL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetMMCTRL_MATCH_ALL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetMMCTRL_MATCH_ALL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetMMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *I2C_Type) GetMMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0xfffffff8) >> 3
}

// I2C.ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR1_GC(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR1_GC() uint32 {
	return volatile.LoadUint32(&o.ADR1.Reg) & 0x1
}
func (o *I2C_Type) SetADR1_Address(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR1_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xffffff00) >> 8
}

// I2C.ADR2: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR2_GC(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR2_GC() uint32 {
	return volatile.LoadUint32(&o.ADR2.Reg) & 0x1
}
func (o *I2C_Type) SetADR2_Address(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR2_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xffffff00) >> 8
}

// I2C.ADR3: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR3_GC(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR3_GC() uint32 {
	return volatile.LoadUint32(&o.ADR3.Reg) & 0x1
}
func (o *I2C_Type) SetADR3_Address(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR3_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xffffff00) >> 8
}

// I2C.DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the I2DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
func (o *I2C_Type) SetDATA_BUFFER_Data(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_BUFFER_Data() uint32 {
	return volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xff
}
func (o *I2C_Type) SetDATA_BUFFER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetDATA_BUFFER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xffffff00) >> 8
}

// I2C.MASK0: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C_Type) SetMASK0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMASK0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x1
}
func (o *I2C_Type) SetMASK0_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetMASK0_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetMASK0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMASK0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0xffffff00) >> 8
}

// I2C.MASK1: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C_Type) SetMASK1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMASK1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK1.Reg) & 0x1
}
func (o *I2C_Type) SetMASK1_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetMASK1_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetMASK1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMASK1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0xffffff00) >> 8
}

// I2C.MASK2: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C_Type) SetMASK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMASK2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK2.Reg) & 0x1
}
func (o *I2C_Type) SetMASK2_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetMASK2_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetMASK2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMASK2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0xffffff00) >> 8
}

// I2C.MASK3: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
func (o *I2C_Type) SetMASK3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMASK3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.MASK3.Reg) & 0x1
}
func (o *I2C_Type) SetMASK3_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetMASK3_MASK() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetMASK3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMASK3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0xffffff00) >> 8
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	CLKSEL  volatile.Register32 // 0x10
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// WWDT.MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
func (o *WWDT_Type) SetMOD_WDEN(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetMOD_WDEN() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *WWDT_Type) SetMOD_WDRESET(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *WWDT_Type) GetMOD_WDRESET() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *WWDT_Type) SetMOD_WDTOF(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *WWDT_Type) GetMOD_WDTOF() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *WWDT_Type) SetMOD_WDINT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *WWDT_Type) GetMOD_WDINT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *WWDT_Type) SetMOD_WDPROTECT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x10)|value<<4)
}
func (o *WWDT_Type) GetMOD_WDPROTECT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x10) >> 4
}
func (o *WWDT_Type) SetMOD_LOCK(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x20)|value<<5)
}
func (o *WWDT_Type) GetMOD_LOCK() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x20) >> 5
}
func (o *WWDT_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffffffc0)|value<<6)
}
func (o *WWDT_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xffffffc0) >> 6
}

// WWDT.TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
func (o *WWDT_Type) SetTC_COUNT(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTC_COUNT() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xff000000) >> 24
}

// WWDT.FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
func (o *WWDT_Type) SetFEED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xff)|value)
}
func (o *WWDT_Type) GetFEED() uint32 {
	return volatile.LoadUint32(&o.FEED.Reg) & 0xff
}
func (o *WWDT_Type) SetFEED_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xffffff00)|value<<8)
}
func (o *WWDT_Type) GetFEED_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FEED.Reg) & 0xffffff00) >> 8
}

// WWDT.TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
func (o *WWDT_Type) SetTV_COUNT(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTV_COUNT() uint32 {
	return volatile.LoadUint32(&o.TV.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TV.Reg) & 0xff000000) >> 24
}

// WWDT.CLKSEL: Watchdog clock select register.
func (o *WWDT_Type) SetCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetCLKSEL() uint32 {
	return volatile.LoadUint32(&o.CLKSEL.Reg) & 0x1
}
func (o *WWDT_Type) SetCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x7ffffffe)|value<<1)
}
func (o *WWDT_Type) GetCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKSEL.Reg) & 0x7ffffffe) >> 1
}
func (o *WWDT_Type) SetCLKSEL_LOCK(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x80000000)|value<<31)
}
func (o *WWDT_Type) GetCLKSEL_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CLKSEL.Reg) & 0x80000000) >> 31
}

// WWDT.WARNINT: Watchdog Warning Interrupt compare value.
func (o *WWDT_Type) SetWARNINT(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0x3ff)|value)
}
func (o *WWDT_Type) GetWARNINT() uint32 {
	return volatile.LoadUint32(&o.WARNINT.Reg) & 0x3ff
}
func (o *WWDT_Type) SetWARNINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *WWDT_Type) GetWARNINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WARNINT.Reg) & 0xfffffc00) >> 10
}

// WWDT.WINDOW: Watchdog Window compare value.
func (o *WWDT_Type) SetWINDOW(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetWINDOW() uint32 {
	return volatile.LoadUint32(&o.WINDOW.Reg) & 0xffffff
}
func (o *WWDT_Type) SetWINDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetWINDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WINDOW.Reg) & 0xff000000) >> 24
}

// USART
type USART_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	ICR           volatile.Register32 // 0x24
	FDR           volatile.Register32 // 0x28
	OSR           volatile.Register32 // 0x2C
	TER           volatile.Register32 // 0x30
	_             [12]byte
	HDEN          volatile.Register32 // 0x40
	_             [4]byte
	SCICTRL       volatile.Register32 // 0x48
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	SYNCCTRL      volatile.Register32 // 0x58
}

// USART.RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
func (o *USART_Type) SetRBR(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetRBR() uint32 {
	return volatile.LoadUint32(&o.RBR.Reg) & 0xff
}
func (o *USART_Type) SetRBR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetRBR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RBR.Reg) & 0xffffff00) >> 8
}

// USART.DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
func (o *USART_Type) SetDLM_DLMSB(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetDLM_DLMSB() uint32 {
	return volatile.LoadUint32(&o.DLM.Reg) & 0xff
}
func (o *USART_Type) SetDLM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetDLM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLM.Reg) & 0xffffff00) >> 8
}

// USART.IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
func (o *USART_Type) SetIIR_INTSTATUS(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIIR_INTSTATUS() uint32 {
	return volatile.LoadUint32(&o.IIR.Reg) & 0x1
}
func (o *USART_Type) SetIIR_INTID(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xe)|value<<1)
}
func (o *USART_Type) GetIIR_INTID() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xe) >> 1
}
func (o *USART_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetIIR_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetIIR_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetIIR_ABEOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIIR_ABEOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIIR_ABTOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIIR_ABTOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USART_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xfffffc00) >> 10
}

// USART.LCR: Line Control Register. Contains controls for frame formatting and break generation.
func (o *USART_Type) SetLCR_WLS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x3)|value)
}
func (o *USART_Type) GetLCR_WLS() uint32 {
	return volatile.LoadUint32(&o.LCR.Reg) & 0x3
}
func (o *USART_Type) SetLCR_SBS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetLCR_SBS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetLCR_PE(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetLCR_PE() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetLCR_PS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetLCR_PS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetLCR_BC(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetLCR_BC() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetLCR_DLAB(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetLCR_DLAB() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetLCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetLCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0xffffff00) >> 8
}

// USART.MCR: Modem Control Register.
func (o *USART_Type) SetMCR_DTRCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetMCR_DTRCTRL() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *USART_Type) SetMCR_RTSCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetMCR_RTSCTRL() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xc)|value<<2)
}
func (o *USART_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xc) >> 2
}
func (o *USART_Type) SetMCR_LMS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetMCR_LMS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetMCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetMCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetMCR_CTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetMCR_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xffffff00) >> 8
}

// USART.LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
func (o *USART_Type) SetLSR_RDR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetLSR_RDR() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *USART_Type) SetLSR_OE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetLSR_OE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetLSR_PE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetLSR_PE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetLSR_FE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetLSR_FE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetLSR_BI(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetLSR_BI() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetLSR_THRE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetLSR_THRE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetLSR_TEMT(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetLSR_TEMT() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetLSR_RXFE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetLSR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetLSR_TXERR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetLSR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetLSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART_Type) GetLSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0xfffffe00) >> 9
}

// USART.MSR: Modem Status Register.
func (o *USART_Type) SetMSR_DCTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetMSR_DCTS() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}
func (o *USART_Type) SetMSR_DDSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetMSR_DDSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetMSR_TERI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetMSR_TERI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetMSR_DDCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetMSR_DDCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetMSR_CTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetMSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetMSR_DSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetMSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetMSR_RI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetMSR_RI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetMSR_DCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetMSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetMSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetMSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0xffffff00) >> 8
}

// USART.SCR: Scratch Pad Register. Eight-bit temporary storage for software.
func (o *USART_Type) SetSCR_PAD(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetSCR_PAD() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0xff
}
func (o *USART_Type) SetSCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetSCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xffffff00) >> 8
}

// USART.ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
func (o *USART_Type) SetACR_START(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetACR_START() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *USART_Type) SetACR_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetACR_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetACR_AUTORESTART(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetACR_AUTORESTART() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf8)|value<<3)
}
func (o *USART_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xf8) >> 3
}
func (o *USART_Type) SetACR_ABEOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetACR_ABEOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetACR_ABTOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetACR_ABTOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USART_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xfffffc00) >> 10
}

// USART.ICR: IrDA Control Register. Enables and configures the IrDA (remote control) mode.
func (o *USART_Type) SetICR_IRDAEN(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_IRDAEN() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *USART_Type) SetICR_IRDAINV(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_IRDAINV() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_FIXPULSEEN(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_FIXPULSEEN() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_PULSEDIV(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x38)|value<<3)
}
func (o *USART_Type) GetICR_PULSEDIV() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x38) >> 3
}
func (o *USART_Type) SetICR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USART_Type) GetICR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xffffffc0) >> 6
}

// USART.FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
func (o *USART_Type) SetFDR_DIVADDVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetFDR_DIVADDVAL() uint32 {
	return volatile.LoadUint32(&o.FDR.Reg) & 0xf
}
func (o *USART_Type) SetFDR_MULVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf0)|value<<4)
}
func (o *USART_Type) GetFDR_MULVAL() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xf0) >> 4
}
func (o *USART_Type) SetFDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetFDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xffffff00) >> 8
}

// USART.OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
func (o *USART_Type) SetOSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetOSR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *USART_Type) SetOSR_OSFRAC(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xe)|value<<1)
}
func (o *USART_Type) GetOSR_OSFRAC() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xe) >> 1
}
func (o *USART_Type) SetOSR_OSINT(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xf0)|value<<4)
}
func (o *USART_Type) GetOSR_OSINT() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xf0) >> 4
}
func (o *USART_Type) SetOSR_FDINT(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x7f00)|value<<8)
}
func (o *USART_Type) GetOSR_FDINT() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x7f00) >> 8
}
func (o *USART_Type) SetOSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0xffff8000)|value<<15)
}
func (o *USART_Type) GetOSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0xffff8000) >> 15
}

// USART.TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
func (o *USART_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x7f)|value)
}
func (o *USART_Type) GetTER_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x7f
}
func (o *USART_Type) SetTER_TXEN(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetTER_TXEN() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0xffffff00) >> 8
}

// USART.HDEN: Half duplex enable register.
func (o *USART_Type) SetHDEN(value uint32) {
	volatile.StoreUint32(&o.HDEN.Reg, volatile.LoadUint32(&o.HDEN.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetHDEN() uint32 {
	return volatile.LoadUint32(&o.HDEN.Reg) & 0x1
}
func (o *USART_Type) SetHDEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HDEN.Reg, volatile.LoadUint32(&o.HDEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *USART_Type) GetHDEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HDEN.Reg) & 0xfffffffe) >> 1
}

// USART.SCICTRL: Smart Card Interface Control register. Enables and configures the Smart Card Interface feature.
func (o *USART_Type) SetSCICTRL_SCIEN(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSCICTRL_SCIEN() uint32 {
	return volatile.LoadUint32(&o.SCICTRL.Reg) & 0x1
}
func (o *USART_Type) SetSCICTRL_NACKDIS(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSCICTRL_NACKDIS() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSCICTRL_PROTSEL(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSCICTRL_PROTSEL() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSCICTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0x18)|value<<3)
}
func (o *USART_Type) GetSCICTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0x18) >> 3
}
func (o *USART_Type) SetSCICTRL_TXRETRY(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0xe0)|value<<5)
}
func (o *USART_Type) GetSCICTRL_TXRETRY() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0xe0) >> 5
}
func (o *USART_Type) SetSCICTRL_XTRAGUARD(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetSCICTRL_XTRAGUARD() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetSCICTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCICTRL.Reg, volatile.LoadUint32(&o.SCICTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetSCICTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCICTRL.Reg) & 0xffff0000) >> 16
}

// USART.RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
func (o *USART_Type) SetRS485CTRL_NMMEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRS485CTRL_NMMEN() uint32 {
	return volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x1
}
func (o *USART_Type) SetRS485CTRL_RXDIS(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRS485CTRL_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRS485CTRL_AADEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRS485CTRL_AADEN() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRS485CTRL_SEL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRS485CTRL_SEL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRS485CTRL_DCTRL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRS485CTRL_DCTRL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRS485CTRL_OINV(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetRS485CTRL_OINV() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USART_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0xffffffc0) >> 6
}

// USART.RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
func (o *USART_Type) SetRS485ADRMATCH_ADRMATCH(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetRS485ADRMATCH_ADRMATCH() uint32 {
	return volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xff
}
func (o *USART_Type) SetRS485ADRMATCH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetRS485ADRMATCH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xffffff00) >> 8
}

// USART.RS485DLY: RS-485/EIA-485 direction control delay.
func (o *USART_Type) SetRS485DLY_DLY(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetRS485DLY_DLY() uint32 {
	return volatile.LoadUint32(&o.RS485DLY.Reg) & 0xff
}
func (o *USART_Type) SetRS485DLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetRS485DLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485DLY.Reg) & 0xffffff00) >> 8
}

// USART.SYNCCTRL: Synchronous mode control register.
func (o *USART_Type) SetSYNCCTRL_SYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSYNCCTRL_SYNC() uint32 {
	return volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x1
}
func (o *USART_Type) SetSYNCCTRL_CSRC(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSYNCCTRL_CSRC() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSYNCCTRL_FES(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSYNCCTRL_FES() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSYNCCTRL_TSBYPASS(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetSYNCCTRL_TSBYPASS() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetSYNCCTRL_CSCEN(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetSYNCCTRL_CSCEN() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetSYNCCTRL_SSDIS(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetSYNCCTRL_SSDIS() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetSYNCCTRL_CCCLR(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetSYNCCTRL_CCCLR() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetSYNCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYNCCTRL.Reg, volatile.LoadUint32(&o.SYNCCTRL.Reg)&^(0xffffff80)|value<<7)
}
func (o *USART_Type) GetSYNCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYNCCTRL.Reg) & 0xffffff80) >> 7
}

// 16-bit counter/timers CT16B0/1
type CT16B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	CR3  volatile.Register32 // 0x38
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// CT16B0.IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
func (o *CT16B0_Type) SetIR_MR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetIR_MR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *CT16B0_Type) SetIR_MR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetIR_MR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetIR_MR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetIR_MR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetIR_MR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetIR_MR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetIR_CR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetIR_CR0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetIR_CR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *CT16B0_Type) GetIR_CR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *CT16B0_Type) SetIR_CR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *CT16B0_Type) GetIR_CR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *CT16B0_Type) SetIR_CR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80)|value<<7)
}
func (o *CT16B0_Type) GetIR_CR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80) >> 7
}
func (o *CT16B0_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CT16B0_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xffffff00) >> 8
}

// CT16B0.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
func (o *CT16B0_Type) SetTCR_CEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetTCR_CEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *CT16B0_Type) SetTCR_CRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetTCR_CRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *CT16B0_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xfffffffc) >> 2
}

// CT16B0.TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *CT16B0_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffff
}
func (o *CT16B0_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xffff0000) >> 16
}

// CT16B0.PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
func (o *CT16B0_Type) SetPR_PCVAL(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetPR_PCVAL() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0xffff
}
func (o *CT16B0_Type) SetPR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetPR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0xffff0000) >> 16
}

// CT16B0.PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
func (o *CT16B0_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, volatile.LoadUint32(&o.PC.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg) & 0xffff
}
func (o *CT16B0_Type) SetPC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, volatile.LoadUint32(&o.PC.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetPC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PC.Reg) & 0xffff0000) >> 16
}

// CT16B0.MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
func (o *CT16B0_Type) SetMCR_MR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetMCR_MR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *CT16B0_Type) SetMCR_MR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetMCR_MR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetMCR_MR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetMCR_MR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetMCR_MR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetMCR_MR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetMCR_MR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetMCR_MR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetMCR_MR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CT16B0_Type) GetMCR_MR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CT16B0_Type) SetMCR_MR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CT16B0_Type) GetMCR_MR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CT16B0_Type) SetMCR_MR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CT16B0_Type) GetMCR_MR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CT16B0_Type) SetMCR_MR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *CT16B0_Type) GetMCR_MR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *CT16B0_Type) SetMCR_MR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *CT16B0_Type) GetMCR_MR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *CT16B0_Type) SetMCR_MR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *CT16B0_Type) GetMCR_MR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *CT16B0_Type) SetMCR_MR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *CT16B0_Type) GetMCR_MR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *CT16B0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT16B0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xfffff000) >> 12
}

// CT16B0.MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT16B0_Type) SetMR0_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, volatile.LoadUint32(&o.MR0.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR0_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR0.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, volatile.LoadUint32(&o.MR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR0.Reg) & 0xffff0000) >> 16
}

// CT16B0.MR1: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT16B0_Type) SetMR1_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, volatile.LoadUint32(&o.MR1.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR1_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR1.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, volatile.LoadUint32(&o.MR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR1.Reg) & 0xffff0000) >> 16
}

// CT16B0.MR2: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT16B0_Type) SetMR2_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, volatile.LoadUint32(&o.MR2.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR2_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR2.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, volatile.LoadUint32(&o.MR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR2.Reg) & 0xffff0000) >> 16
}

// CT16B0.MR3: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT16B0_Type) SetMR3_MATCH(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, volatile.LoadUint32(&o.MR3.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetMR3_MATCH() uint32 {
	return volatile.LoadUint32(&o.MR3.Reg) & 0xffff
}
func (o *CT16B0_Type) SetMR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, volatile.LoadUint32(&o.MR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetMR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MR3.Reg) & 0xffff0000) >> 16
}

// CT16B0.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
func (o *CT16B0_Type) SetCCR_CAP0RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetCCR_CAP0RE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *CT16B0_Type) SetCCR_CAP0FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetCCR_CAP0FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetCCR_CAP0I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetCCR_CAP0I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *CT16B0_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xfffffff8) >> 3
}

// CT16B0.CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CT16B0_CAP input.
func (o *CT16B0_Type) SetCR0_CAP(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR0_CAP() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xffff0000) >> 16
}

// CT16B0.CR1: Capture Register. CR is loaded with the value of TC when there is an event on the CT16B0_CAP input.
func (o *CT16B0_Type) SetCR1_CAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR1_CAP() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xffff0000) >> 16
}

// CT16B0.CR2: Capture Register. CR is loaded with the value of TC when there is an event on the CT16B0_CAP input.
func (o *CT16B0_Type) SetCR2_CAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR2_CAP() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xffff0000) >> 16
}

// CT16B0.CR3: Capture Register. CR is loaded with the value of TC when there is an event on the CT16B0_CAP input.
func (o *CT16B0_Type) SetCR3_CAP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xffff)|value)
}
func (o *CT16B0_Type) GetCR3_CAP() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0xffff
}
func (o *CT16B0_Type) SetCR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *CT16B0_Type) GetCR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xffff0000) >> 16
}

// CT16B0.EMR: External Match Register. The EMR controls the match function and the external match pins
func (o *CT16B0_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *CT16B0_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetEMR_EMC0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *CT16B0_Type) GetEMR_EMC0() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *CT16B0_Type) SetEMR_EMC1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc0)|value<<6)
}
func (o *CT16B0_Type) GetEMR_EMC1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc0) >> 6
}
func (o *CT16B0_Type) SetEMR_EMC2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x300)|value<<8)
}
func (o *CT16B0_Type) GetEMR_EMC2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x300) >> 8
}
func (o *CT16B0_Type) SetEMR_EMC3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc00)|value<<10)
}
func (o *CT16B0_Type) GetEMR_EMC3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc00) >> 10
}
func (o *CT16B0_Type) SetEMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT16B0_Type) GetEMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xfffff000) >> 12
}

// CT16B0.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *CT16B0_Type) SetCTCR_CTM(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *CT16B0_Type) GetCTCR_CTM() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *CT16B0_Type) SetCTCR_CIS(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *CT16B0_Type) GetCTCR_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *CT16B0_Type) SetCTCR_ENCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x10)|value<<4)
}
func (o *CT16B0_Type) GetCTCR_ENCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0x10) >> 4
}
func (o *CT16B0_Type) SetCTCR_SELCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xe0)|value<<5)
}
func (o *CT16B0_Type) GetCTCR_SELCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xe0) >> 5
}
func (o *CT16B0_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CT16B0_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xffffff00) >> 8
}

// CT16B0.PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
func (o *CT16B0_Type) SetPWMC_PWMEN0(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x1)|value)
}
func (o *CT16B0_Type) GetPWMC_PWMEN0() uint32 {
	return volatile.LoadUint32(&o.PWMC.Reg) & 0x1
}
func (o *CT16B0_Type) SetPWMC_PWMEN1(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x2)|value<<1)
}
func (o *CT16B0_Type) GetPWMC_PWMEN1() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x2) >> 1
}
func (o *CT16B0_Type) SetPWMC_PWMEN2(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x4)|value<<2)
}
func (o *CT16B0_Type) GetPWMC_PWMEN2() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x4) >> 2
}
func (o *CT16B0_Type) SetPWMC_PWMEN3(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x8)|value<<3)
}
func (o *CT16B0_Type) GetPWMC_PWMEN3() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x8) >> 3
}
func (o *CT16B0_Type) SetPWMC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *CT16B0_Type) GetPWMC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0xfffffff0) >> 4
}

// 32-bit counter/timers CT32B0/1
type CT32B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	CR3  volatile.Register32 // 0x38
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// CT32B0.IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
func (o *CT32B0_Type) SetIR_MR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetIR_MR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *CT32B0_Type) SetIR_MR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetIR_MR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetIR_MR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetIR_MR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetIR_MR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetIR_MR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetIR_CR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetIR_CR0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetIR_CR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *CT32B0_Type) GetIR_CR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *CT32B0_Type) SetIR_CR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x40)|value<<6)
}
func (o *CT32B0_Type) GetIR_CR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x40) >> 6
}
func (o *CT32B0_Type) SetIR_CR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x80)|value<<7)
}
func (o *CT32B0_Type) GetIR_CR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x80) >> 7
}
func (o *CT32B0_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CT32B0_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xffffff00) >> 8
}

// CT32B0.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
func (o *CT32B0_Type) SetTCR_CEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetTCR_CEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *CT32B0_Type) SetTCR_CRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetTCR_CRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *CT32B0_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xfffffffc) >> 2
}

// CT32B0.TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *CT32B0_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *CT32B0_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// CT32B0.PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
func (o *CT32B0_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, value)
}
func (o *CT32B0_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg)
}

// CT32B0.PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
func (o *CT32B0_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, value)
}
func (o *CT32B0_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg)
}

// CT32B0.MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
func (o *CT32B0_Type) SetMCR_MR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetMCR_MR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *CT32B0_Type) SetMCR_MR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetMCR_MR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetMCR_MR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetMCR_MR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetMCR_MR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetMCR_MR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetMCR_MR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetMCR_MR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetMCR_MR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CT32B0_Type) GetMCR_MR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CT32B0_Type) SetMCR_MR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CT32B0_Type) GetMCR_MR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CT32B0_Type) SetMCR_MR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CT32B0_Type) GetMCR_MR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CT32B0_Type) SetMCR_MR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *CT32B0_Type) GetMCR_MR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *CT32B0_Type) SetMCR_MR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *CT32B0_Type) GetMCR_MR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *CT32B0_Type) SetMCR_MR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *CT32B0_Type) GetMCR_MR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *CT32B0_Type) SetMCR_MR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *CT32B0_Type) GetMCR_MR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *CT32B0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT32B0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xfffff000) >> 12
}

// CT32B0.MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT32B0_Type) SetMR0(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, value)
}
func (o *CT32B0_Type) GetMR0() uint32 {
	return volatile.LoadUint32(&o.MR0.Reg)
}

// CT32B0.MR1: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT32B0_Type) SetMR1(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, value)
}
func (o *CT32B0_Type) GetMR1() uint32 {
	return volatile.LoadUint32(&o.MR1.Reg)
}

// CT32B0.MR2: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT32B0_Type) SetMR2(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, value)
}
func (o *CT32B0_Type) GetMR2() uint32 {
	return volatile.LoadUint32(&o.MR2.Reg)
}

// CT32B0.MR3: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
func (o *CT32B0_Type) SetMR3(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, value)
}
func (o *CT32B0_Type) GetMR3() uint32 {
	return volatile.LoadUint32(&o.MR3.Reg)
}

// CT32B0.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
func (o *CT32B0_Type) SetCCR_CAP0RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetCCR_CAP0RE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *CT32B0_Type) SetCCR_CAP0FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetCCR_CAP0FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetCCR_CAP0I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetCCR_CAP0I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetCCR_CAP1RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetCCR_CAP1RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetCCR_CAP1FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetCCR_CAP1FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetCCR_CAP1I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *CT32B0_Type) GetCCR_CAP1I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *CT32B0_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CT32B0_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffc0) >> 6
}

// CT32B0.CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CT32B_CAP0 input.
func (o *CT32B0_Type) SetCR0(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, value)
}
func (o *CT32B0_Type) GetCR0() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg)
}

// CT32B0.CR1: Capture Register. CR is loaded with the value of TC when there is an event on the CT32B_CAP0 input.
func (o *CT32B0_Type) SetCR1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, value)
}
func (o *CT32B0_Type) GetCR1() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg)
}

// CT32B0.CR2: Capture Register. CR is loaded with the value of TC when there is an event on the CT32B_CAP0 input.
func (o *CT32B0_Type) SetCR2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, value)
}
func (o *CT32B0_Type) GetCR2() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg)
}

// CT32B0.CR3: Capture Register. CR is loaded with the value of TC when there is an event on the CT32B_CAP0 input.
func (o *CT32B0_Type) SetCR3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, value)
}
func (o *CT32B0_Type) GetCR3() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg)
}

// CT32B0.EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
func (o *CT32B0_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *CT32B0_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetEMR_EMC0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *CT32B0_Type) GetEMR_EMC0() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *CT32B0_Type) SetEMR_EMC1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc0)|value<<6)
}
func (o *CT32B0_Type) GetEMR_EMC1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc0) >> 6
}
func (o *CT32B0_Type) SetEMR_EMC2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x300)|value<<8)
}
func (o *CT32B0_Type) GetEMR_EMC2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x300) >> 8
}
func (o *CT32B0_Type) SetEMR_EMC3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc00)|value<<10)
}
func (o *CT32B0_Type) GetEMR_EMC3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc00) >> 10
}
func (o *CT32B0_Type) SetEMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xfffff000)|value<<12)
}
func (o *CT32B0_Type) GetEMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xfffff000) >> 12
}

// CT32B0.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *CT32B0_Type) SetCTCR_CTM(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *CT32B0_Type) GetCTCR_CTM() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *CT32B0_Type) SetCTCR_CIS(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *CT32B0_Type) GetCTCR_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *CT32B0_Type) SetCTCR_ENCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x10)|value<<4)
}
func (o *CT32B0_Type) GetCTCR_ENCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0x10) >> 4
}
func (o *CT32B0_Type) SetCTCR_SElCC(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xe0)|value<<5)
}
func (o *CT32B0_Type) GetCTCR_SElCC() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xe0) >> 5
}
func (o *CT32B0_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CT32B0_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xffffff00) >> 8
}

// CT32B0.PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
func (o *CT32B0_Type) SetPWMC_PWMEN0(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x1)|value)
}
func (o *CT32B0_Type) GetPWMC_PWMEN0() uint32 {
	return volatile.LoadUint32(&o.PWMC.Reg) & 0x1
}
func (o *CT32B0_Type) SetPWMC_PWMEN1(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x2)|value<<1)
}
func (o *CT32B0_Type) GetPWMC_PWMEN1() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x2) >> 1
}
func (o *CT32B0_Type) SetPWMC_PWMEN2(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x4)|value<<2)
}
func (o *CT32B0_Type) GetPWMC_PWMEN2() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x4) >> 2
}
func (o *CT32B0_Type) SetPWMC_PWMEN3(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0x8)|value<<3)
}
func (o *CT32B0_Type) GetPWMC_PWMEN3() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0x8) >> 3
}
func (o *CT32B0_Type) SetPWMC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PWMC.Reg, volatile.LoadUint32(&o.PWMC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *CT32B0_Type) GetPWMC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PWMC.Reg) & 0xfffffff0) >> 4
}

// ADC
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	SEL   volatile.Register32 // 0x8
	INTEN volatile.Register32 // 0xC
	DR0   volatile.Register32 // 0x10
	DR1   volatile.Register32 // 0x14
	DR2   volatile.Register32 // 0x18
	DR3   volatile.Register32 // 0x1C
	DR4   volatile.Register32 // 0x20
	DR5   volatile.Register32 // 0x24
	DR6   volatile.Register32 // 0x28
	DR7   volatile.Register32 // 0x2C
	STAT  volatile.Register32 // 0x30
}

// ADC.CR: A/D Control Register. The CR register must be written to select the operating mode before A/D conversion can occur.
func (o *ADC_Type) SetCR_SEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCR_SEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0xff
}
func (o *ADC_Type) SetCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetCR_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetCR_BURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCR_BURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCR_CLKS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCR_CLKS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCR_SINGLEBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCR_SINGLEBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *ADC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7800000)|value<<23)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7800000) >> 23
}
func (o *ADC_Type) SetCR_EDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCR_EDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000000) >> 28
}

// ADC.GDR: A/D Global Data Register. Contains the result of the most recent A/D conversion.
func (o *ADC_Type) SetGDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetGDR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.GDR.Reg) & 0x3f
}
func (o *ADC_Type) SetGDR_V_VREF(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetGDR_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetGDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetGDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetGDR_CHN(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetGDR_CHN() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetGDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetGDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetGDR_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetGDR_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetGDR_DONE(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetGDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x80000000) >> 31
}

// ADC.SEL: A/D Select Register. Selects between external pins and internal sources.
func (o *ADC_Type) SetSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEL.Reg, volatile.LoadUint32(&o.SEL.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetSEL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SEL.Reg) & 0x3ff
}
func (o *ADC_Type) SetSEL_AD5SEL(value uint32) {
	volatile.StoreUint32(&o.SEL.Reg, volatile.LoadUint32(&o.SEL.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetSEL_AD5SEL() uint32 {
	return (volatile.LoadUint32(&o.SEL.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetSEL_AD6SEL(value uint32) {
	volatile.StoreUint32(&o.SEL.Reg, volatile.LoadUint32(&o.SEL.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetSEL_AD6SEL() uint32 {
	return (volatile.LoadUint32(&o.SEL.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetSEL_AD7SEL(value uint32) {
	volatile.StoreUint32(&o.SEL.Reg, volatile.LoadUint32(&o.SEL.Reg)&^(0xc000)|value<<14)
}
func (o *ADC_Type) GetSEL_AD7SEL() uint32 {
	return (volatile.LoadUint32(&o.SEL.Reg) & 0xc000) >> 14
}
func (o *ADC_Type) SetSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEL.Reg, volatile.LoadUint32(&o.SEL.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEL.Reg) & 0xffff0000) >> 16
}

// ADC.INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
func (o *ADC_Type) SetINTEN_ADINTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetINTEN_ADINTEN() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0xff
}
func (o *ADC_Type) SetINTEN_ADGINTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetINTEN_ADGINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ADC_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xfffffe00) >> 9
}

// ADC.DR0: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR0.Reg, volatile.LoadUint32(&o.DR0.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR0.Reg) & 0x3f
}
func (o *ADC_Type) SetDR0_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR0.Reg, volatile.LoadUint32(&o.DR0.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR0_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR0.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR0.Reg, volatile.LoadUint32(&o.DR0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR0.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR0_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR0.Reg, volatile.LoadUint32(&o.DR0.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR0_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR0.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR0_DONE(value uint32) {
	volatile.StoreUint32(&o.DR0.Reg, volatile.LoadUint32(&o.DR0.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR0_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR0.Reg) & 0x80000000) >> 31
}

// ADC.DR1: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR1.Reg, volatile.LoadUint32(&o.DR1.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR1.Reg) & 0x3f
}
func (o *ADC_Type) SetDR1_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR1.Reg, volatile.LoadUint32(&o.DR1.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR1_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR1.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR1.Reg, volatile.LoadUint32(&o.DR1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR1.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR1_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR1.Reg, volatile.LoadUint32(&o.DR1.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR1_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR1.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR1_DONE(value uint32) {
	volatile.StoreUint32(&o.DR1.Reg, volatile.LoadUint32(&o.DR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR1_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR1.Reg) & 0x80000000) >> 31
}

// ADC.DR2: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR2.Reg, volatile.LoadUint32(&o.DR2.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR2.Reg) & 0x3f
}
func (o *ADC_Type) SetDR2_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR2.Reg, volatile.LoadUint32(&o.DR2.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR2_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR2.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR2.Reg, volatile.LoadUint32(&o.DR2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR2.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR2_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR2.Reg, volatile.LoadUint32(&o.DR2.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR2_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR2.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR2_DONE(value uint32) {
	volatile.StoreUint32(&o.DR2.Reg, volatile.LoadUint32(&o.DR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR2_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR2.Reg) & 0x80000000) >> 31
}

// ADC.DR3: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR3.Reg, volatile.LoadUint32(&o.DR3.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR3.Reg) & 0x3f
}
func (o *ADC_Type) SetDR3_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR3.Reg, volatile.LoadUint32(&o.DR3.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR3_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR3.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR3.Reg, volatile.LoadUint32(&o.DR3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR3.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR3_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR3.Reg, volatile.LoadUint32(&o.DR3.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR3_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR3.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR3_DONE(value uint32) {
	volatile.StoreUint32(&o.DR3.Reg, volatile.LoadUint32(&o.DR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR3_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR3.Reg) & 0x80000000) >> 31
}

// ADC.DR4: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR4.Reg, volatile.LoadUint32(&o.DR4.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR4.Reg) & 0x3f
}
func (o *ADC_Type) SetDR4_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR4.Reg, volatile.LoadUint32(&o.DR4.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR4_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR4.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR4.Reg, volatile.LoadUint32(&o.DR4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR4.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR4_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR4.Reg, volatile.LoadUint32(&o.DR4.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR4_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR4.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR4_DONE(value uint32) {
	volatile.StoreUint32(&o.DR4.Reg, volatile.LoadUint32(&o.DR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR4_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR4.Reg) & 0x80000000) >> 31
}

// ADC.DR5: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR5.Reg, volatile.LoadUint32(&o.DR5.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR5_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR5.Reg) & 0x3f
}
func (o *ADC_Type) SetDR5_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR5.Reg, volatile.LoadUint32(&o.DR5.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR5_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR5.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR5.Reg, volatile.LoadUint32(&o.DR5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR5.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR5_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR5.Reg, volatile.LoadUint32(&o.DR5.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR5_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR5.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR5_DONE(value uint32) {
	volatile.StoreUint32(&o.DR5.Reg, volatile.LoadUint32(&o.DR5.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR5_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR5.Reg) & 0x80000000) >> 31
}

// ADC.DR6: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR6.Reg, volatile.LoadUint32(&o.DR6.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR6_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR6.Reg) & 0x3f
}
func (o *ADC_Type) SetDR6_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR6.Reg, volatile.LoadUint32(&o.DR6.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR6_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR6.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR6.Reg, volatile.LoadUint32(&o.DR6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR6.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR6_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR6.Reg, volatile.LoadUint32(&o.DR6.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR6_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR6.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR6_DONE(value uint32) {
	volatile.StoreUint32(&o.DR6.Reg, volatile.LoadUint32(&o.DR6.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR6_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR6.Reg) & 0x80000000) >> 31
}

// ADC.DR7: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
func (o *ADC_Type) SetDR7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR7.Reg, volatile.LoadUint32(&o.DR7.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR7_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DR7.Reg) & 0x3f
}
func (o *ADC_Type) SetDR7_V_VREF(value uint32) {
	volatile.StoreUint32(&o.DR7.Reg, volatile.LoadUint32(&o.DR7.Reg)&^(0xffc0)|value<<6)
}
func (o *ADC_Type) GetDR7_V_VREF() uint32 {
	return (volatile.LoadUint32(&o.DR7.Reg) & 0xffc0) >> 6
}
func (o *ADC_Type) SetDR7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR7.Reg, volatile.LoadUint32(&o.DR7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR7.Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR7_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.DR7.Reg, volatile.LoadUint32(&o.DR7.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR7_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.DR7.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR7_DONE(value uint32) {
	volatile.StoreUint32(&o.DR7.Reg, volatile.LoadUint32(&o.DR7.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR7_DONE() uint32 {
	return (volatile.LoadUint32(&o.DR7.Reg) & 0x80000000) >> 31
}

// ADC.STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt flag.
func (o *ADC_Type) SetSTAT_DONE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetSTAT_DONE() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0xff
}
func (o *ADC_Type) SetSTAT_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetSTAT_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetSTAT_ADINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetSTAT_ADINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffe0000)|value<<17)
}
func (o *ADC_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffe0000) >> 17
}

// DAC
type DAC_Type struct {
	CR       volatile.Register32 // 0x0
	RESERVED volatile.Register32 // 0x4
}

// DAC.CR: D/A control register
func (o *DAC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f)|value)
}
func (o *DAC_Type) GetCR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3f
}
func (o *DAC_Type) SetCR_VALUE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffc0)|value<<6)
}
func (o *DAC_Type) GetCR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffc0) >> 6
}
func (o *DAC_Type) SetCR_BIAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_TRIG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0000)|value<<17)
}
func (o *DAC_Type) GetCR_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0000) >> 17
}
func (o *DAC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *DAC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *DAC_Type) SetCR_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *DAC_Type) GetCR_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *DAC_Type) SetCR_TRIGERD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *DAC_Type) GetCR_TRIGERD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *DAC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *DAC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// DAC.RESERVED: Reserved
func (o *DAC_Type) SetRESERVED(value uint32) {
	volatile.StoreUint32(&o.RESERVED.Reg, value)
}
func (o *DAC_Type) GetRESERVED() uint32 {
	return volatile.LoadUint32(&o.RESERVED.Reg)
}

// Comparator
type Comparator_Type struct {
	CTL volatile.Register32 // 0x0
	LAD volatile.Register32 // 0x4
}

// Comparator.CTL: Comparator control register
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x7)|value)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CTL.Reg) & 0x7
}
func (o *Comparator_Type) SetCTL_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x18)|value<<3)
}
func (o *Comparator_Type) GetCTL_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x18) >> 3
}
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x20)|value<<5)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x20) >> 5
}
func (o *Comparator_Type) SetCTL_COMPSA(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *Comparator_Type) GetCTL_COMPSA() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x40) >> 6
}
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x80)|value<<7)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x80) >> 7
}
func (o *Comparator_Type) SetCTL_COMP_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x700)|value<<8)
}
func (o *Comparator_Type) GetCTL_COMP_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x700) >> 8
}
func (o *Comparator_Type) SetCTL_COMP_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x3800)|value<<11)
}
func (o *Comparator_Type) GetCTL_COMP_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x3800) >> 11
}
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0xfc000)|value<<14)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0xfc000) >> 14
}
func (o *Comparator_Type) SetCTL_EDGECLR(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x100000)|value<<20)
}
func (o *Comparator_Type) GetCTL_EDGECLR() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x100000) >> 20
}
func (o *Comparator_Type) SetCTL_COMPSTAT(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x200000)|value<<21)
}
func (o *Comparator_Type) GetCTL_COMPSTAT() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x200000) >> 21
}
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x400000)|value<<22)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x400000) >> 22
}
func (o *Comparator_Type) SetCTL_COMPEDGE(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x800000)|value<<23)
}
func (o *Comparator_Type) GetCTL_COMPEDGE() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x800000) >> 23
}
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1000000)|value<<24)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x1000000) >> 24
}
func (o *Comparator_Type) SetCTL_HYS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x6000000)|value<<25)
}
func (o *Comparator_Type) GetCTL_HYS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x6000000) >> 25
}
func (o *Comparator_Type) SetCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0xf8000000)|value<<27)
}
func (o *Comparator_Type) GetCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0xf8000000) >> 27
}

// Comparator.LAD: Voltage ladder register
func (o *Comparator_Type) SetLAD_LADEN(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0x1)|value)
}
func (o *Comparator_Type) GetLAD_LADEN() uint32 {
	return volatile.LoadUint32(&o.LAD.Reg) & 0x1
}
func (o *Comparator_Type) SetLAD_LADSEL(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0x3e)|value<<1)
}
func (o *Comparator_Type) GetLAD_LADSEL() uint32 {
	return (volatile.LoadUint32(&o.LAD.Reg) & 0x3e) >> 1
}
func (o *Comparator_Type) SetLAD_LADREF(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0x40)|value<<6)
}
func (o *Comparator_Type) GetLAD_LADREF() uint32 {
	return (volatile.LoadUint32(&o.LAD.Reg) & 0x40) >> 6
}
func (o *Comparator_Type) SetLAD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0xffffff80)|value<<7)
}
func (o *Comparator_Type) GetLAD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LAD.Reg) & 0xffffff80) >> 7
}

// Flash controller
type FLASHCTRL_Type struct {
	_         [16]byte
	FLASHCFG  volatile.Register32 // 0x10
	_         [12]byte
	FMSSTART  volatile.Register32 // 0x20
	FMSSTOP   volatile.Register32 // 0x24
	_         [4]byte
	FMSW0     volatile.Register32 // 0x2C
	FMSW1     volatile.Register32 // 0x30
	FMSW2     volatile.Register32 // 0x34
	FMSW3     volatile.Register32 // 0x38
	_         [96]byte
	EEMSSTART volatile.Register32 // 0x9C
	EEMSSTOP  volatile.Register32 // 0xA0
	EEMSSIG   volatile.Register32 // 0xA4
	_         [3896]byte
	FMSTAT    volatile.Register32 // 0xFE0
	_         [4]byte
	FMSTATCLR volatile.Register32 // 0xFE8
}

// FLASHCTRL.FLASHCFG: Flash memory access time configuration register
func (o *FLASHCTRL_Type) SetFLASHCFG_FLASHTIM(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetFLASHCFG_FLASHTIM() uint32 {
	return volatile.LoadUint32(&o.FLASHCFG.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetFLASHCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *FLASHCTRL_Type) GetFLASHCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFG.Reg) & 0xfffffffc) >> 2
}

// FLASHCTRL.FMSSTART: Signature start address register
func (o *FLASHCTRL_Type) SetFMSSTART_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTART_START() uint32 {
	return volatile.LoadUint32(&o.FMSSTART.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0xfffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTART.Reg) & 0xfffe0000) >> 17
}

// FLASHCTRL.FMSSTOP: Signature stop-address register
func (o *FLASHCTRL_Type) SetFMSSTOP_STOP(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STOP() uint32 {
	return volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTOP_SIG_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x20000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_SIG_START() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x20000) >> 17
}
func (o *FLASHCTRL_Type) SetFMSSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0xfffc0000)|value<<18)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0xfffc0000) >> 18
}

// FLASHCTRL.FMSW0: Word 0 [31:0]
func (o *FLASHCTRL_Type) SetFMSW0(value uint32) {
	volatile.StoreUint32(&o.FMSW0.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW0() uint32 {
	return volatile.LoadUint32(&o.FMSW0.Reg)
}

// FLASHCTRL.FMSW1: Word 1 [63:32]
func (o *FLASHCTRL_Type) SetFMSW1(value uint32) {
	volatile.StoreUint32(&o.FMSW1.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW1() uint32 {
	return volatile.LoadUint32(&o.FMSW1.Reg)
}

// FLASHCTRL.FMSW2: Word 2 [95:64]
func (o *FLASHCTRL_Type) SetFMSW2(value uint32) {
	volatile.StoreUint32(&o.FMSW2.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW2() uint32 {
	return volatile.LoadUint32(&o.FMSW2.Reg)
}

// FLASHCTRL.FMSW3: Word 3 [127:96]
func (o *FLASHCTRL_Type) SetFMSW3(value uint32) {
	volatile.StoreUint32(&o.FMSW3.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW3() uint32 {
	return volatile.LoadUint32(&o.FMSW3.Reg)
}

// FLASHCTRL.EEMSSTART: EEPROM BIST start address register
func (o *FLASHCTRL_Type) SetEEMSSTART_STARTA(value uint32) {
	volatile.StoreUint32(&o.EEMSSTART.Reg, volatile.LoadUint32(&o.EEMSSTART.Reg)&^(0x3fff)|value)
}
func (o *FLASHCTRL_Type) GetEEMSSTART_STARTA() uint32 {
	return volatile.LoadUint32(&o.EEMSSTART.Reg) & 0x3fff
}
func (o *FLASHCTRL_Type) SetEEMSSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EEMSSTART.Reg, volatile.LoadUint32(&o.EEMSSTART.Reg)&^(0xffffc000)|value<<14)
}
func (o *FLASHCTRL_Type) GetEEMSSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EEMSSTART.Reg) & 0xffffc000) >> 14
}

// FLASHCTRL.EEMSSTOP: EEPROM BIST stop address register
func (o *FLASHCTRL_Type) SetEEMSSTOP_STOPA(value uint32) {
	volatile.StoreUint32(&o.EEMSSTOP.Reg, volatile.LoadUint32(&o.EEMSSTOP.Reg)&^(0x3fff)|value)
}
func (o *FLASHCTRL_Type) GetEEMSSTOP_STOPA() uint32 {
	return volatile.LoadUint32(&o.EEMSSTOP.Reg) & 0x3fff
}
func (o *FLASHCTRL_Type) SetEEMSSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EEMSSTOP.Reg, volatile.LoadUint32(&o.EEMSSTOP.Reg)&^(0x3fffc000)|value<<14)
}
func (o *FLASHCTRL_Type) GetEEMSSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EEMSSTOP.Reg) & 0x3fffc000) >> 14
}
func (o *FLASHCTRL_Type) SetEEMSSTOP_DEVSEL(value uint32) {
	volatile.StoreUint32(&o.EEMSSTOP.Reg, volatile.LoadUint32(&o.EEMSSTOP.Reg)&^(0x40000000)|value<<30)
}
func (o *FLASHCTRL_Type) GetEEMSSTOP_DEVSEL() uint32 {
	return (volatile.LoadUint32(&o.EEMSSTOP.Reg) & 0x40000000) >> 30
}
func (o *FLASHCTRL_Type) SetEEMSSTOP_STRTBIST(value uint32) {
	volatile.StoreUint32(&o.EEMSSTOP.Reg, volatile.LoadUint32(&o.EEMSSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASHCTRL_Type) GetEEMSSTOP_STRTBIST() uint32 {
	return (volatile.LoadUint32(&o.EEMSSTOP.Reg) & 0x80000000) >> 31
}

// FLASHCTRL.EEMSSIG: EEPROM 24-bit BIST signature register
func (o *FLASHCTRL_Type) SetEEMSSIG_DATA_SIG(value uint32) {
	volatile.StoreUint32(&o.EEMSSIG.Reg, volatile.LoadUint32(&o.EEMSSIG.Reg)&^(0xffff)|value)
}
func (o *FLASHCTRL_Type) GetEEMSSIG_DATA_SIG() uint32 {
	return volatile.LoadUint32(&o.EEMSSIG.Reg) & 0xffff
}
func (o *FLASHCTRL_Type) SetEEMSSIG_PARITY_SIG(value uint32) {
	volatile.StoreUint32(&o.EEMSSIG.Reg, volatile.LoadUint32(&o.EEMSSIG.Reg)&^(0xffff0000)|value<<16)
}
func (o *FLASHCTRL_Type) GetEEMSSIG_PARITY_SIG() uint32 {
	return (volatile.LoadUint32(&o.EEMSSIG.Reg) & 0xffff0000) >> 16
}

// FLASHCTRL.FMSTAT: Signature generation status register
func (o *FLASHCTRL_Type) SetFMSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSTAT.Reg, volatile.LoadUint32(&o.FMSTAT.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetFMSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.FMSTAT.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetFMSTAT_SIG_DONE(value uint32) {
	volatile.StoreUint32(&o.FMSTAT.Reg, volatile.LoadUint32(&o.FMSTAT.Reg)&^(0x4)|value<<2)
}
func (o *FLASHCTRL_Type) GetFMSTAT_SIG_DONE() uint32 {
	return (volatile.LoadUint32(&o.FMSTAT.Reg) & 0x4) >> 2
}
func (o *FLASHCTRL_Type) SetFMSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSTAT.Reg, volatile.LoadUint32(&o.FMSTAT.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FLASHCTRL_Type) GetFMSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSTAT.Reg) & 0xfffffff8) >> 3
}

// FLASHCTRL.FMSTATCLR: Signature generation status clear register
func (o *FLASHCTRL_Type) SetFMSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSTATCLR.Reg, volatile.LoadUint32(&o.FMSTATCLR.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetFMSTATCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.FMSTATCLR.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetFMSTATCLR_SIG_DONE_CLR(value uint32) {
	volatile.StoreUint32(&o.FMSTATCLR.Reg, volatile.LoadUint32(&o.FMSTATCLR.Reg)&^(0x4)|value<<2)
}
func (o *FLASHCTRL_Type) GetFMSTATCLR_SIG_DONE_CLR() uint32 {
	return (volatile.LoadUint32(&o.FMSTATCLR.Reg) & 0x4) >> 2
}
func (o *FLASHCTRL_Type) SetFMSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSTATCLR.Reg, volatile.LoadUint32(&o.FMSTATCLR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FLASHCTRL_Type) GetFMSTATCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSTATCLR.Reg) & 0xfffffff8) >> 3
}

// SSP/SPI
type SSP0_Type struct {
	CR0  volatile.Register32 // 0x0
	CR1  volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	CPSR volatile.Register32 // 0x10
	IMSC volatile.Register32 // 0x14
	RIS  volatile.Register32 // 0x18
	MIS  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
}

// SSP0.CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
func (o *SSP0_Type) SetCR0_DSS(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xf)|value)
}
func (o *SSP0_Type) GetCR0_DSS() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg) & 0xf
}
func (o *SSP0_Type) SetCR0_FRF(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x30)|value<<4)
}
func (o *SSP0_Type) GetCR0_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x30) >> 4
}
func (o *SSP0_Type) SetCR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x40)|value<<6)
}
func (o *SSP0_Type) GetCR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x40) >> 6
}
func (o *SSP0_Type) SetCR0_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x80)|value<<7)
}
func (o *SSP0_Type) GetCR0_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x80) >> 7
}
func (o *SSP0_Type) SetCR0_SCR(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xff00)|value<<8)
}
func (o *SSP0_Type) GetCR0_SCR() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xff00) >> 8
}
func (o *SSP0_Type) SetCR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SSP0_Type) GetCR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xffff0000) >> 16
}

// SSP0.CR1: Control Register 1. Selects master/slave and other modes.
func (o *SSP0_Type) SetCR1_LBM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetCR1_LBM() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *SSP0_Type) SetCR1_SSE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetCR1_SSE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetCR1_MS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetCR1_MS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetCR1_SOD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetCR1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetCR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetCR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xfffffff0) >> 4
}

// SSP0.DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
func (o *SSP0_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SSP0_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}
func (o *SSP0_Type) SetDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SSP0_Type) GetDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xffff0000) >> 16
}

// SSP0.SR: Status Register
func (o *SSP0_Type) SetSR_TFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetSR_TFE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSP0_Type) SetSR_TNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetSR_TNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetSR_RNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetSR_RNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetSR_RFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetSR_RFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSP0_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSP0_Type) SetSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SSP0_Type) GetSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xffffffe0) >> 5
}

// SSP0.CPSR: Clock Prescale Register
func (o *SSP0_Type) SetCPSR_CPSDVSR(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xff)|value)
}
func (o *SSP0_Type) GetCPSR_CPSDVSR() uint32 {
	return volatile.LoadUint32(&o.CPSR.Reg) & 0xff
}
func (o *SSP0_Type) SetCPSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSP0_Type) GetCPSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CPSR.Reg) & 0xffffff00) >> 8
}

// SSP0.IMSC: Interrupt Mask Set and Clear Register
func (o *SSP0_Type) SetIMSC_RORIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetIMSC_RORIM() uint32 {
	return volatile.LoadUint32(&o.IMSC.Reg) & 0x1
}
func (o *SSP0_Type) SetIMSC_RTIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetIMSC_RTIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetIMSC_RXIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetIMSC_RXIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetIMSC_TXIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetIMSC_TXIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetIMSC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetIMSC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0xfffffff0) >> 4
}

// SSP0.RIS: Raw Interrupt Status Register
func (o *SSP0_Type) SetRIS_RORRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetRIS_RORRIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}
func (o *SSP0_Type) SetRIS_RTRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetRIS_RTRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetRIS_RXRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetRIS_RXRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetRIS_TXRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetRIS_TXRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetRIS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetRIS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0xfffffff0) >> 4
}

// SSP0.MIS: Masked Interrupt Status Register
func (o *SSP0_Type) SetMIS_RORMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetMIS_RORMIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}
func (o *SSP0_Type) SetMIS_RTMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetMIS_RTMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetMIS_RXMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *SSP0_Type) GetMIS_RXMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *SSP0_Type) SetMIS_TXMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *SSP0_Type) GetMIS_TXMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *SSP0_Type) SetMIS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP0_Type) GetMIS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0xfffffff0) >> 4
}

// SSP0.ICR: SSPICR Interrupt Clear Register
func (o *SSP0_Type) SetICR_RORIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SSP0_Type) GetICR_RORIC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *SSP0_Type) SetICR_RTIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SSP0_Type) GetICR_RTIC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SSP0_Type) SetICR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SSP0_Type) GetICR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xfffffffc) >> 2
}

// IOCON block
type IOCON_Type struct {
	RESET_PIO0_0     volatile.Register32 // 0x0
	PIO0_1           volatile.Register32 // 0x4
	PIO0_2           volatile.Register32 // 0x8
	PIO0_3           volatile.Register32 // 0xC
	PIO0_4           volatile.Register32 // 0x10
	TCK_SWCLK_PIO0_5 volatile.Register32 // 0x14
	TDI_PIO0_6       volatile.Register32 // 0x18
	TMS_PIO0_7       volatile.Register32 // 0x1C
	TDO_PIO0_8       volatile.Register32 // 0x20
	TRST_PIO0_9      volatile.Register32 // 0x24
	SWDIO_PIO0_10    volatile.Register32 // 0x28
	PIO0_11          volatile.Register32 // 0x2C
	PIO0_12          volatile.Register32 // 0x30
	PIO0_13          volatile.Register32 // 0x34
	PIO0_14          volatile.Register32 // 0x38
	PIO0_15          volatile.Register32 // 0x3C
	PIO0_16          volatile.Register32 // 0x40
	PIO0_17          volatile.Register32 // 0x44
	PIO0_18          volatile.Register32 // 0x48
	PIO0_19          volatile.Register32 // 0x4C
	PIO0_20          volatile.Register32 // 0x50
	PIO0_21          volatile.Register32 // 0x54
	PIO0_22          volatile.Register32 // 0x58
	PIO0_23          volatile.Register32 // 0x5C
	PIO0_24          volatile.Register32 // 0x60
	PIO0_25          volatile.Register32 // 0x64
	PIO0_26          volatile.Register32 // 0x68
	PIO0_27          volatile.Register32 // 0x6C
	PIO0_28          volatile.Register32 // 0x70
	PIO0_29          volatile.Register32 // 0x74
	PIO0_30          volatile.Register32 // 0x78
	PIO0_31          volatile.Register32 // 0x7C
	PIO1_0           volatile.Register32 // 0x80
	PIO1_1           volatile.Register32 // 0x84
	PIO1_2           volatile.Register32 // 0x88
	PIO1_3           volatile.Register32 // 0x8C
	PIO1_4           volatile.Register32 // 0x90
	PIO1_5           volatile.Register32 // 0x94
	PIO1_6           volatile.Register32 // 0x98
	PIO1_7           volatile.Register32 // 0x9C
	PIO1_8           volatile.Register32 // 0xA0
	PIO1_9           volatile.Register32 // 0xA4
}

// IOCON.RESET_PIO0_0: I/O configuration register for pin RESET/PIO0_0
func (o *IOCON_Type) SetRESET_PIO0_0_FUNC(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetRESET_PIO0_0_FUNC() uint32 {
	return volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x7
}
func (o *IOCON_Type) SetRESET_PIO0_0_MODE(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetRESET_PIO0_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetRESET_PIO0_0_HYS(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetRESET_PIO0_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetRESET_PIO0_0_INV(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetRESET_PIO0_0_INV() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetRESET_PIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetRESET_PIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetRESET_PIO0_0_SLEW(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetRESET_PIO0_0_SLEW() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetRESET_PIO0_0_OD(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetRESET_PIO0_0_OD() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetRESET_PIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RESET_PIO0_0.Reg, volatile.LoadUint32(&o.RESET_PIO0_0.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetRESET_PIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RESET_PIO0_0.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_1: I/O configuration register for pin PIO0_1/RXD/CLKOUT/ CT32B0_MAT2/SSEL0/ CLKIN
func (o *IOCON_Type) SetPIO0_1_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_1_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_1_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_1_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_2: I/O configuration register for pin PIO0_2/SCL/ACMP_O/ TCK/SWCLK/ CT16B0_CAP0
func (o *IOCON_Type) SetPIO0_2_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_2_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xf8)|value<<3)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xf8) >> 3
}
func (o *IOCON_Type) SetPIO0_2_HS(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_2_HS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_2_HIDRIVE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_2_HIDRIVE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xfffffc00)|value<<10)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xfffffc00) >> 10
}

// IOCON.PIO0_3: I/O configuration register for pin PIO0_3/SDA/ACMP_O/ SWDIO/CT16B1_CAP0
func (o *IOCON_Type) SetPIO0_3_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_3_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xf8)|value<<3)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xf8) >> 3
}
func (o *IOCON_Type) SetPIO0_3_HS(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_3_HS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_3_HIDRIVE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_3_HIDRIVE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xfffffc00)|value<<10)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xfffffc00) >> 10
}

// IOCON.PIO0_4: I/O configuration register for pin PIO0_4/R/AOUT/ CT16B0_MAT1/MOSI0
func (o *IOCON_Type) SetPIO0_4_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_4_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_4_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_4_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_4_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_4_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_4_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_4_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_4_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_4_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_4_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_4_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_4_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_4_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xfffff800) >> 11
}

// IOCON.TCK_SWCLK_PIO0_5: I/O configuration register for pin TCK/SWCLK/PIO0_5/ R/CT16B0_MAT2/ SCK0
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_FUNC(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_FUNC() uint32 {
	return volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x7
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_MODE(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_MODE() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_HYS(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_HYS() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_INV(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_INV() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_ADMODE(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_FILTR(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_FILTR() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_OD(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_OD() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetTCK_SWCLK_PIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCK_SWCLK_PIO0_5.Reg, volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetTCK_SWCLK_PIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCK_SWCLK_PIO0_5.Reg) & 0xfffff800) >> 11
}

// IOCON.TDI_PIO0_6: I/O configuration register for pin TDI/PIO0_6/AD0/ CT32B0_MAT3/MISO0
func (o *IOCON_Type) SetTDI_PIO0_6_FUNC(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetTDI_PIO0_6_FUNC() uint32 {
	return volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x7
}
func (o *IOCON_Type) SetTDI_PIO0_6_MODE(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetTDI_PIO0_6_MODE() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetTDI_PIO0_6_HYS(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetTDI_PIO0_6_HYS() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetTDI_PIO0_6_INV(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetTDI_PIO0_6_INV() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetTDI_PIO0_6_ADMODE(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetTDI_PIO0_6_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetTDI_PIO0_6_FILTR(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetTDI_PIO0_6_FILTR() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetTDI_PIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetTDI_PIO0_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetTDI_PIO0_6_OD(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetTDI_PIO0_6_OD() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetTDI_PIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TDI_PIO0_6.Reg, volatile.LoadUint32(&o.TDI_PIO0_6.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetTDI_PIO0_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TDI_PIO0_6.Reg) & 0xfffff800) >> 11
}

// IOCON.TMS_PIO0_7: I/O configuration register for pin TMS/PIO0_7/AD1/ CT32B1_CAP0/ CT16B0_MAT0
func (o *IOCON_Type) SetTMS_PIO0_7_FUNC(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetTMS_PIO0_7_FUNC() uint32 {
	return volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x7
}
func (o *IOCON_Type) SetTMS_PIO0_7_MODE(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetTMS_PIO0_7_MODE() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetTMS_PIO0_7_HYS(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetTMS_PIO0_7_HYS() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetTMS_PIO0_7_INV(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetTMS_PIO0_7_INV() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetTMS_PIO0_7_ADMODE(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetTMS_PIO0_7_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetTMS_PIO0_7_FILTR(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetTMS_PIO0_7_FILTR() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetTMS_PIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetTMS_PIO0_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetTMS_PIO0_7_OD(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetTMS_PIO0_7_OD() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetTMS_PIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TMS_PIO0_7.Reg, volatile.LoadUint32(&o.TMS_PIO0_7.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetTMS_PIO0_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TMS_PIO0_7.Reg) & 0xfffff800) >> 11
}

// IOCON.TDO_PIO0_8: I/O configuration register for pin TDO/PIO0_8/AD2/ CT32B1_MAT0/SCK1
func (o *IOCON_Type) SetTDO_PIO0_8_FUNC(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetTDO_PIO0_8_FUNC() uint32 {
	return volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x7
}
func (o *IOCON_Type) SetTDO_PIO0_8_MODE(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetTDO_PIO0_8_MODE() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetTDO_PIO0_8_HYS(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetTDO_PIO0_8_HYS() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetTDO_PIO0_8_INV(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetTDO_PIO0_8_INV() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetTDO_PIO0_8_ADMODE(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetTDO_PIO0_8_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetTDO_PIO0_8_FILTR(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetTDO_PIO0_8_FILTR() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetTDO_PIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetTDO_PIO0_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetTDO_PIO0_8_OD(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetTDO_PIO0_8_OD() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetTDO_PIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TDO_PIO0_8.Reg, volatile.LoadUint32(&o.TDO_PIO0_8.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetTDO_PIO0_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TDO_PIO0_8.Reg) & 0xfffff800) >> 11
}

// IOCON.TRST_PIO0_9: I/O configuration register for pin TRST/PIO0_9/AD3/CT32B1_MAT1/CT16B0_MAT1/CTS
func (o *IOCON_Type) SetTRST_PIO0_9_FUNC(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetTRST_PIO0_9_FUNC() uint32 {
	return volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x7
}
func (o *IOCON_Type) SetTRST_PIO0_9_MODE(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetTRST_PIO0_9_MODE() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetTRST_PIO0_9_HYS(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetTRST_PIO0_9_HYS() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetTRST_PIO0_9_INV(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetTRST_PIO0_9_INV() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetTRST_PIO0_9_ADMODE(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetTRST_PIO0_9_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetTRST_PIO0_9_FILTR(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetTRST_PIO0_9_FILTR() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetTRST_PIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetTRST_PIO0_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetTRST_PIO0_9_OD(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetTRST_PIO0_9_OD() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetTRST_PIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRST_PIO0_9.Reg, volatile.LoadUint32(&o.TRST_PIO0_9.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetTRST_PIO0_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TRST_PIO0_9.Reg) & 0xfffff800) >> 11
}

// IOCON.SWDIO_PIO0_10: I/O configuration register for pin SWDIO/PIO0_10/AD4/ CT32B1_MAT2/ CT16B0_MAT2/RTS
func (o *IOCON_Type) SetSWDIO_PIO0_10_FUNC(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_FUNC() uint32 {
	return volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x7
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_MODE(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_MODE() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_HYS(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_HYS() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_INV(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_INV() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_ADMODE(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_FILTR(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_FILTR() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_OD(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_OD() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetSWDIO_PIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SWDIO_PIO0_10.Reg, volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetSWDIO_PIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SWDIO_PIO0_10.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_11: I/O configuration register for pin PIO0_11/SCLK/ AD5/CT32B1_MAT3/ CT32B0_CAP0
func (o *IOCON_Type) SetPIO0_11_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_11_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_11.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_11_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_11_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_11_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_11_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_11_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_11_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_11_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_11_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_11_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_11_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_11_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_11_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_12: I/O configuration register for pin PIO0_12/RXD/ ACMP_O/ CT32B0_MAT0/SCL/ CLKIN
func (o *IOCON_Type) SetPIO0_12_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_12_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_12.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_12_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_12_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_12_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_12_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_12_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_12_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_12_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_12_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_12_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_12_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_13: I/O configuration register for pin PIO0_13/TXD/ ACMP_I2/ CT32B0_MAT1/SDA
func (o *IOCON_Type) SetPIO0_13_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_13_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_13.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_13_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_13_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_13_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_13_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_13_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_13_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_13_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_13_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_13_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_13_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_13_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_13_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_14: I/O configuration register for pin PIO0_14/MISO1/AD6/CT32B0_CAP1/CT16B1_MAT1/VDDCMP
func (o *IOCON_Type) SetPIO0_14_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_14_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_14.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_14_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_14_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_14_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_14_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_14_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_14_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_14_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_14_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_14_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_14_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_14_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_14_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_15: I/O configuration register for pin PIO0_15/TXD/AD7/ CT32B0_CAP2/SDA
func (o *IOCON_Type) SetPIO0_15_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_15_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_15.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_15_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_15_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_15_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_15_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_15_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_15_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_15_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_15_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_15_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_15_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_15_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_15_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_16: I/O configuration register for pin PIO0_16/ ATRG0/ACMP_I3/ CT16B0_CAP1/SCL
func (o *IOCON_Type) SetPIO0_16_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_16_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_16.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_16_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_16_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_16_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_16_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_16_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_16_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_16_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_16_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_16_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_16_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_16_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_16_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_17: I/O configuration register for pin PIO0_17/ ATRG1/ACMP_I4/ CT16B0_CAP2/ CT16B0_MAT0
func (o *IOCON_Type) SetPIO0_17_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_17_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_17.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_17_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_17_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_17_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_17_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_17_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_17_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_17_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_17_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_17_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_17_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_17_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_17_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_18: I/O configuration register for pin PIO0_18/R/SSEL0/ CT16B0_CAP0/ CT16B1_CAP1
func (o *IOCON_Type) SetPIO0_18_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_18_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_18.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_18_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_18_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_18_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_18_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_18_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_18_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_18_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_18_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_18_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_18_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_18_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_18.Reg, volatile.LoadUint32(&o.PIO0_18.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_18_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_18.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_19: I/O configuration register for pin PIO0_19/CLKIN/ CLKOUT/ MOSI0/CT16B1_MAT0
func (o *IOCON_Type) SetPIO0_19_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_19_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_19.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_19_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_19_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_19_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_19_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_19_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_19_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_19_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_19_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_19_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_19_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_19_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_19.Reg, volatile.LoadUint32(&o.PIO0_19.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_19_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_19.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_20: I/O configuration register for pin PIO0_20/R/SCK0/ CT32B1_CAP0/ CT16B1_MAT2
func (o *IOCON_Type) SetPIO0_20_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_20_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_20.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_20_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_20_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_20_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_20_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_20_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_20_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_20_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_20_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_20_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_20_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_20_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_20.Reg, volatile.LoadUint32(&o.PIO0_20.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_20_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_20.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_21: I/O configuration register for pin PIO0_21/CTS/ ACMP_O/ CT32B1_CAP1/SCLK
func (o *IOCON_Type) SetPIO0_21_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_21_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_21.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_21_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_21_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_21_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_21_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_21_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_21_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_21_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_21_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_21_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_21_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_21_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_21.Reg, volatile.LoadUint32(&o.PIO0_21.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_21_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_21.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_22: I/O configuration register for pin PIO0_22/MISO0/ ACMP_I5/ CT32B1_MAT2/ CT32B1_CAP2
func (o *IOCON_Type) SetPIO0_22_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_22_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_22.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_22_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_22_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_22_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_22_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_22_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_22_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_22_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_22_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_22_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_22_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_22_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_22_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_22_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_22.Reg, volatile.LoadUint32(&o.PIO0_22.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_22_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_22.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_23: I/O configuration register for pin PIO0_23/RTS/ ACMP_O/ CT32B0_CAP0/SCLK
func (o *IOCON_Type) SetPIO0_23_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_23_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_23.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_23_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_23_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_23_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_23_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_23_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_23_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_23_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_23_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_23_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_23_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_23_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_23_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_23_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_23.Reg, volatile.LoadUint32(&o.PIO0_23.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_23_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_23.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_24: I/O configuration register for pin PIO0_24/SCL/CLKIN/ CT16B1_CAP0
func (o *IOCON_Type) SetPIO0_24_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_24_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_24.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_24_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_24_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_24_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_24_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_24_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_24_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_24_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_24_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_24_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_24_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_24_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_24_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_24_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_24.Reg, volatile.LoadUint32(&o.PIO0_24.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_24_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_24.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_25: I/O configuration register for pin PIO0_25/SDA/SSEL1/ CT16B1_MAT0
func (o *IOCON_Type) SetPIO0_25_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_25_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_25.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_25_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_25_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_25_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_25_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_25_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_25_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_25_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_25_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_25_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_25_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_25_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_25_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_25_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_25.Reg, volatile.LoadUint32(&o.PIO0_25.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_25_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_25.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_26: I/O configuration register for pin PIO0_26/TXD/MISO1/ CT16B1_CAP1/ CT32B0_CAP2
func (o *IOCON_Type) SetPIO0_26_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_26_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_26.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_26_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_26_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_26_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_26_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_26_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_26_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_26_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_26_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_26_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_26_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_26_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_26_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_26_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_26.Reg, volatile.LoadUint32(&o.PIO0_26.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_26_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_26.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_27: I/O configuration register for pin PIO0_27/MOSI1/ ACMP_I1/ CT32B1_MAT1/ CT16B1_CAP2
func (o *IOCON_Type) SetPIO0_27_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_27_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_27.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_27_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_27_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_27_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_27_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_27_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_27_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_27_ADMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_27_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_27_FILTR(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x100)|value<<8)
}
func (o *IOCON_Type) GetPIO0_27_FILTR() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x100) >> 8
}
func (o *IOCON_Type) SetPIO0_27_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_27_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_27_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_27_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_27_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_27.Reg, volatile.LoadUint32(&o.PIO0_27.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_27_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_27.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_28: I/O configuration register for pin PIO0_28/DTR/SSEL1/ CT32B0_CAP0
func (o *IOCON_Type) SetPIO0_28_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_28_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_28.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_28_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_28_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_28_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_28_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_28_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_28_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_28_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_28_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_28_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_28_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_28_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_28_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_28_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_28.Reg, volatile.LoadUint32(&o.PIO0_28.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_28_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_28.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_29: I/O configuration register for pin PIO0_29/DSR/SCK1/ CT32B0_CAP1
func (o *IOCON_Type) SetPIO0_29_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_29_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_29.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_29_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_29_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_29_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_29_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_29_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_29_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_29_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_29_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_29_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_29_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_29_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_29_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_29_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_29.Reg, volatile.LoadUint32(&o.PIO0_29.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_29_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_29.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_30: I/O configuration register for pin PIO0_30/RI/MOSI1/ CT32B0_MAT0/ CT16B0_CAP0
func (o *IOCON_Type) SetPIO0_30_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_30_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_30.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_30_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_30_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_30_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_30_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_30_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_30_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_30_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_30_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_30_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_30_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_30_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_30_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_30_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_30.Reg, volatile.LoadUint32(&o.PIO0_30.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_30_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_30.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO0_31: I/O configuration register for pin PIO0_31/RI/MOSI1/ CT32B1_MAT0/ CT16B1_CAP1
func (o *IOCON_Type) SetPIO0_31_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_31_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO0_31.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_31_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_31_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_31_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_31_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_31_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_31_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_31_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO0_31_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO0_31_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO0_31_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO0_31_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_31_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_31_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_31.Reg, volatile.LoadUint32(&o.PIO0_31.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_31_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_31.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_0: I/O configuration register for pin PIO1_0/DCD/SCK0/ CT32B1_MAT3/ CT16B0_MAT1
func (o *IOCON_Type) SetPIO1_0_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_0_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_0.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_0_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_0_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_0_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_0_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_0_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_0_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_0_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_0_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_0.Reg, volatile.LoadUint32(&o.PIO1_0.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_0.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_1: I/O configuration register for pin PIO1_1/DTR/SSEL0/ CT32B1_MAT3/ CT16B1_MAT0
func (o *IOCON_Type) SetPIO1_1_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_1_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_1_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_1_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_1.Reg, volatile.LoadUint32(&o.PIO1_1.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_1.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_2: I/O configuration register for pin PIO1_2/DSR/MISO0/ CT16B1_MAT2/ CT16B1_MAT1
func (o *IOCON_Type) SetPIO1_2_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_2_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_2_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_2_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_2_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_2_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_2_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_2_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_2_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_2_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_2.Reg, volatile.LoadUint32(&o.PIO1_2.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_2.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_3: I/O configuration register for pin PIO1_3/RI/MOSI0/ CT16B1_CAP0
func (o *IOCON_Type) SetPIO1_3_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_3_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_3_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_3_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_3_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_3_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_3_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_3_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_3_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_3_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_3.Reg, volatile.LoadUint32(&o.PIO1_3.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_3.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_4: I/O configuration register for pin PIO1_4/RXD/SSEL1/ CT32B0_MAT1/ CT32B1_CAP0/ CT16B0_CAP1
func (o *IOCON_Type) SetPIO1_4_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_4_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_4_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_4_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_4_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_4_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_4_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_4_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_4_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_4_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_4_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_4_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_4.Reg, volatile.LoadUint32(&o.PIO1_4.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_4.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_5: I/O configuration register for pin PIO1_5/TXD/SCK1/ CT32B0_MAT2/ CT32B1_CAP1/ CT16B0_CAP2
func (o *IOCON_Type) SetPIO1_5_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_5_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_5.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_5_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_5_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_5_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_5_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_5_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_5_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_5_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_5_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_5_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_5_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_5.Reg, volatile.LoadUint32(&o.PIO1_5.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_5.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_6: I/O configuration register for pin PIO1_6/RTS/MOSI1/ CT32B0_MAT3/ CT32B1_CAP2/ CT16B0_MAT0
func (o *IOCON_Type) SetPIO1_6_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_6_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_6.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_6_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_6_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_6_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_6_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_6_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_6_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_6_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_6_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_6_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_6_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_6.Reg, volatile.LoadUint32(&o.PIO1_6.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_6.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_7: I/O configuration register for pin PIO1_7/CTS/MOSI0/ CT32B1_MAT1/ CT16B0_MAT2/ CT16B1_CAP2
func (o *IOCON_Type) SetPIO1_7_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_7_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_7.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_7_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_7_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_7_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_7_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_7_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_7_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_7_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_7_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_7_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_7_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_7.Reg, volatile.LoadUint32(&o.PIO1_7.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_7.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_8: I/O configuration register for pin PIO1_8/RXD / MISO1/ CT32B1_MAT0/ CT16B1_MAT1
func (o *IOCON_Type) SetPIO1_8_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_8_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_8.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_8_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_8_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_8_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_8_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_8_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_8_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_8_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_8_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_8_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_8_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_8.Reg, volatile.LoadUint32(&o.PIO1_8.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_8.Reg) & 0xfffff800) >> 11
}

// IOCON.PIO1_9: I/O configuration register for pin PIO1_9/DCD/R/ CT32B1_MAT2 / CT16B1_MAT2
func (o *IOCON_Type) SetPIO1_9_FUNC(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO1_9_FUNC() uint32 {
	return volatile.LoadUint32(&o.PIO1_9.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO1_9_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO1_9_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO1_9_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO1_9_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO1_9_INV(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO1_9_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO1_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetPIO1_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetPIO1_9_SLEW(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetPIO1_9_SLEW() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetPIO1_9_OD(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO1_9_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO1_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO1_9.Reg, volatile.LoadUint32(&o.PIO1_9.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetPIO1_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO1_9.Reg) & 0xfffff800) >> 11
}

// System configuration
type SYSCON_Type struct {
	SYSMEMREMAP   volatile.Register32 // 0x0
	PRESETCTRL    volatile.Register32 // 0x4
	SYSPLLCTRL    volatile.Register32 // 0x8
	SYSPLLSTAT    volatile.Register32 // 0xC
	_             [16]byte
	SYSOSCCTRL    volatile.Register32 // 0x20
	WDTOSCCTRL    volatile.Register32 // 0x24
	IRCCTRL       volatile.Register32 // 0x28
	LFOSCCTRL     volatile.Register32 // 0x2C
	SYSRSTSTAT    volatile.Register32 // 0x30
	_             [12]byte
	SYSPLLCLKSEL  volatile.Register32 // 0x40
	SYSPLLCLKUEN  volatile.Register32 // 0x44
	_             [40]byte
	MAINCLKSEL    volatile.Register32 // 0x70
	MAINCLKUEN    volatile.Register32 // 0x74
	SYSAHBCLKDIV  volatile.Register32 // 0x78
	_             [4]byte
	SYSAHBCLKCTRL volatile.Register32 // 0x80
	_             [16]byte
	SSP0CLKDIV    volatile.Register32 // 0x94
	UARTCLKDIV    volatile.Register32 // 0x98
	SSP1CLKDIV    volatile.Register32 // 0x9C
	_             [64]byte
	CLKOUTSEL     volatile.Register32 // 0xE0
	CLKOUTUEN     volatile.Register32 // 0xE4
	CLKOUTDIV     volatile.Register32 // 0xE8
	_             [20]byte
	PIOPORCAP0    volatile.Register32 // 0x100
	PIOPORCAP1    volatile.Register32 // 0x104
	_             [72]byte
	BODR          volatile.Register32 // 0x150
	_             [4]byte
	SYSTCKCAL     volatile.Register32 // 0x158
	_             [24]byte
	NMISRC        volatile.Register32 // 0x174
	PINTSEL0      volatile.Register32 // 0x178
	PINTSEL1      volatile.Register32 // 0x17C
	PINTSEL2      volatile.Register32 // 0x180
	PINTSEL3      volatile.Register32 // 0x184
	PINTSEL4      volatile.Register32 // 0x188
	PINTSEL5      volatile.Register32 // 0x18C
	PINTSEL6      volatile.Register32 // 0x190
	PINTSEL7      volatile.Register32 // 0x194
	_             [160]byte
	PDRUNCFG      volatile.Register32 // 0x238
	_             [440]byte
	DEVICE_ID     volatile.Register32 // 0x3F4
}

// SYSCON.SYSMEMREMAP: System memory remap
func (o *SYSCON_Type) SetSYSMEMREMAP_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSMEMREMAP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PRESETCTRL: Peripheral reset control
func (o *SYSCON_Type) SetPRESETCTRL_SSP0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPRESETCTRL_SSP0_RST_N() uint32 {
	return volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetPRESETCTRL_I2C_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPRESETCTRL_I2C_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPRESETCTRL_SSP1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPRESETCTRL_SSP1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPRESETCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPRESETCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPRESETCTRL_UART_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPRESETCTRL_UART_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPRESETCTRL_CT16B0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPRESETCTRL_CT16B0_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPRESETCTRL_CT16B1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPRESETCTRL_CT16B1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPRESETCTRL_CT32B0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPRESETCTRL_CT32B0_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPRESETCTRL_CT32B1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPRESETCTRL_CT32B1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPRESETCTRL_ACOMP_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPRESETCTRL_ACOMP_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPRESETCTRL_DAC_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPRESETCTRL_DAC_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPRESETCTRL_ADC_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPRESETCTRL_ADC_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPRESETCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0xfffff000)|value<<12)
}
func (o *SYSCON_Type) GetPRESETCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0xfffff000) >> 12
}

// SYSCON.SYSPLLCTRL: System PLL control
func (o *SYSCON_Type) SetSYSPLLCTRL_MSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_MSEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetSYSPLLCTRL_PSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x60)|value<<5)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_PSEL() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x60) >> 5
}
func (o *SYSCON_Type) SetSYSPLLCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0xffffff80) >> 7
}

// SYSCON.SYSPLLSTAT: System PLL status
func (o *SYSCON_Type) SetSYSPLLSTAT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_LOCK() uint32 {
	return volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSOSCCTRL: System oscillator control
func (o *SYSCON_Type) SetSYSOSCCTRL_BYPASS(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_BYPASS() uint32 {
	return volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_FREQRANGE(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_FREQRANGE() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.WDTOSCCTRL: Watchdog oscillator control
func (o *SYSCON_Type) SetWDTOSCCTRL_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_DIVSEL() uint32 {
	return volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetWDTOSCCTRL_FREQSEL(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_FREQSEL() uint32 {
	return (volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0x1e0) >> 5
}
func (o *SYSCON_Type) SetWDTOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0xfffffe00) >> 9
}

// SYSCON.IRCCTRL: IRC oscillator control
func (o *SYSCON_Type) SetIRCCTRL_TRIM(value uint32) {
	volatile.StoreUint32(&o.IRCCTRL.Reg, volatile.LoadUint32(&o.IRCCTRL.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIRCCTRL_TRIM() uint32 {
	return volatile.LoadUint32(&o.IRCCTRL.Reg) & 0xff
}
func (o *SYSCON_Type) SetIRCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRCCTRL.Reg, volatile.LoadUint32(&o.IRCCTRL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SYSCON_Type) GetIRCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRCCTRL.Reg) & 0xfffffe00) >> 9
}

// SYSCON.LFOSCCTRL: LF oscillator control
func (o *SYSCON_Type) SetLFOSCCTRL_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.LFOSCCTRL.Reg, volatile.LoadUint32(&o.LFOSCCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetLFOSCCTRL_DIVSEL() uint32 {
	return volatile.LoadUint32(&o.LFOSCCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetLFOSCCTRL_FREQSEL(value uint32) {
	volatile.StoreUint32(&o.LFOSCCTRL.Reg, volatile.LoadUint32(&o.LFOSCCTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *SYSCON_Type) GetLFOSCCTRL_FREQSEL() uint32 {
	return (volatile.LoadUint32(&o.LFOSCCTRL.Reg) & 0x1e0) >> 5
}
func (o *SYSCON_Type) SetLFOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LFOSCCTRL.Reg, volatile.LoadUint32(&o.LFOSCCTRL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SYSCON_Type) GetLFOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LFOSCCTRL.Reg) & 0xfffffe00) >> 9
}

// SYSCON.SYSRSTSTAT: System reset status register
func (o *SYSCON_Type) SetSYSRSTSTAT_POR(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_POR() uint32 {
	return volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_EXTRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_WDT(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_WDT() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSRSTSTAT_BOD(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_BOD() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSRSTSTAT_SYSRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_SYSRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSRSTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0xffffffe0) >> 5
}

// SYSCON.SYSPLLCLKSEL: System PLL clock source select
func (o *SYSCON_Type) SetSYSPLLCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSPLLCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SYSPLLCLKUEN: System PLL clock source update enable
func (o *SYSCON_Type) SetSYSPLLCLKUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKUEN.Reg, volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLCLKUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKUEN.Reg, volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLCLKUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.MAINCLKSEL: Main clock source select
func (o *SYSCON_Type) SetMAINCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSEL.Reg, volatile.LoadUint32(&o.MAINCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetMAINCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.MAINCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetMAINCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSEL.Reg, volatile.LoadUint32(&o.MAINCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetMAINCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.MAINCLKUEN: Main clock source update enable
func (o *SYSCON_Type) SetMAINCLKUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.MAINCLKUEN.Reg, volatile.LoadUint32(&o.MAINCLKUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetMAINCLKUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.MAINCLKUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetMAINCLKUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKUEN.Reg, volatile.LoadUint32(&o.MAINCLKUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetMAINCLKUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSAHBCLKDIV: System clock divider
func (o *SYSCON_Type) SetSYSAHBCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSYSAHBCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.SYSAHBCLKCTRL: System clock control
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SYS(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SYS() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ROM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ROM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RAM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RAM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_FLASHREG(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_FLASHREG() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_FLASHARRAY(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_FLASHARRAY() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_I2C(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_I2C() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_GPIO(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_GPIO() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT16B0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT16B0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT16B1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT16B1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT32B0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT32B0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CT32B1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CT32B1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SSP0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SSP0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_UART(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_UART() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ADC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ADC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_WDT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_WDT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_IOCON(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_IOCON() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SSP1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SSP1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_PINT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_PINT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ACOMP(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ACOMP() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_DAC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_DAC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_P0INT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_P0INT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_P1INT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_P1INT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0xfe000000)|value<<25)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0xfe000000) >> 25
}

// SYSCON.SSP0CLKDIV: SSP0 clock divider
func (o *SYSCON_Type) SetSSP0CLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SSP0CLKDIV.Reg, volatile.LoadUint32(&o.SSP0CLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSSP0CLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SSP0CLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSSP0CLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SSP0CLKDIV.Reg, volatile.LoadUint32(&o.SSP0CLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSSP0CLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SSP0CLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.UARTCLKDIV: UART clock divider
func (o *SYSCON_Type) SetUARTCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.UARTCLKDIV.Reg, volatile.LoadUint32(&o.UARTCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.UARTCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTCLKDIV.Reg, volatile.LoadUint32(&o.UARTCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.SSP1CLKDIV: SSP1 clock divider
func (o *SYSCON_Type) SetSSP1CLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SSP1CLKDIV.Reg, volatile.LoadUint32(&o.SSP1CLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSSP1CLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SSP1CLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSSP1CLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SSP1CLKDIV.Reg, volatile.LoadUint32(&o.SSP1CLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSSP1CLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SSP1CLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.CLKOUTSEL: CLKOUT clock source select
func (o *SYSCON_Type) SetCLKOUTSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSEL.Reg, volatile.LoadUint32(&o.CLKOUTSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetCLKOUTSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.CLKOUTSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetCLKOUTSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSEL.Reg, volatile.LoadUint32(&o.CLKOUTSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetCLKOUTSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.CLKOUTUEN: CLKOUT clock source update enable
func (o *SYSCON_Type) SetCLKOUTUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.CLKOUTUEN.Reg, volatile.LoadUint32(&o.CLKOUTUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetCLKOUTUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.CLKOUTUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetCLKOUTUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTUEN.Reg, volatile.LoadUint32(&o.CLKOUTUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetCLKOUTUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.CLKOUTDIV: CLKOUT clock divider
func (o *SYSCON_Type) SetCLKOUTDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetCLKOUTDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetCLKOUTDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetCLKOUTDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.PIOPORCAP0: POR captured PIO status 0
func (o *SYSCON_Type) SetPIOPORCAP0(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP0.Reg, value)
}
func (o *SYSCON_Type) GetPIOPORCAP0() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP0.Reg)
}

// SYSCON.PIOPORCAP1: POR captured PIO status 1
func (o *SYSCON_Type) SetPIOPORCAP1_PIOSTAT(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP1.Reg, volatile.LoadUint32(&o.PIOPORCAP1.Reg)&^(0x3ff)|value)
}
func (o *SYSCON_Type) GetPIOPORCAP1_PIOSTAT() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP1.Reg) & 0x3ff
}
func (o *SYSCON_Type) SetPIOPORCAP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP1.Reg, volatile.LoadUint32(&o.PIOPORCAP1.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SYSCON_Type) GetPIOPORCAP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIOPORCAP1.Reg) & 0xfffffc00) >> 10
}

// SYSCON.BODR: Brown-Out Detect
func (o *SYSCON_Type) SetBODR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODR.Reg, volatile.LoadUint32(&o.BODR.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetBODR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.BODR.Reg) & 0x3
}
func (o *SYSCON_Type) SetBODR_BODINTVAL(value uint32) {
	volatile.StoreUint32(&o.BODR.Reg, volatile.LoadUint32(&o.BODR.Reg)&^(0xc)|value<<2)
}
func (o *SYSCON_Type) GetBODR_BODINTVAL() uint32 {
	return (volatile.LoadUint32(&o.BODR.Reg) & 0xc) >> 2
}
func (o *SYSCON_Type) SetBODR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODR.Reg, volatile.LoadUint32(&o.BODR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetBODR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BODR.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetBODR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODR.Reg, volatile.LoadUint32(&o.BODR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetBODR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BODR.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetBODR_BODINT(value uint32) {
	volatile.StoreUint32(&o.BODR.Reg, volatile.LoadUint32(&o.BODR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetBODR_BODINT() uint32 {
	return (volatile.LoadUint32(&o.BODR.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetBODR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODR.Reg, volatile.LoadUint32(&o.BODR.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetBODR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BODR.Reg) & 0xffffff80) >> 7
}

// SYSCON.SYSTCKCAL: System tick counter calibration
func (o *SYSCON_Type) SetSYSTCKCAL_CAL(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0x3ffffff)|value)
}
func (o *SYSCON_Type) GetSYSTCKCAL_CAL() uint32 {
	return volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0x3ffffff
}
func (o *SYSCON_Type) SetSYSTCKCAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCON_Type) GetSYSTCKCAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0xfc000000) >> 26
}

// SYSCON.NMISRC: NMI Source Control
func (o *SYSCON_Type) SetNMISRC_IRQNO(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetNMISRC_IRQNO() uint32 {
	return volatile.LoadUint32(&o.NMISRC.Reg) & 0x1f
}
func (o *SYSCON_Type) SetNMISRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x7fffffe0)|value<<5)
}
func (o *SYSCON_Type) GetNMISRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x7fffffe0) >> 5
}
func (o *SYSCON_Type) SetNMISRC_NMIEN(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetNMISRC_NMIEN() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x80000000) >> 31
}

// SYSCON.PINTSEL0: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL0_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL0_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL0.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL0_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL0_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL0.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL0.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL1: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL1_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL1_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL1.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL1_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL1_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL1.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL1.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL2: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL2_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL2_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL2.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL2_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL2_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL2.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL2.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL3: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL3_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL3_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL3.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL3_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL3_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL3.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL3.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL4: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL4_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL4_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL4.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL4_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL4_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL4.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL4.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL5: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL5_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL5_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL5.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL5_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL5_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL5.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL5.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL6: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL6_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL6_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL6.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL6_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL6_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL6.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL6.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL7: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL7_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPINTSEL7_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL7.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPINTSEL7_INTPORT(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPINTSEL7_INTPORT() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL7.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPINTSEL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL7.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PDRUNCFG: Power configuration register
func (o *SYSCON_Type) SetPDRUNCFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRCOUT_PD() uint32 {
	return volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1
}
func (o *SYSCON_Type) SetPDRUNCFG_IRC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPDRUNCFG_FLASH_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPDRUNCFG_FLASH_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDRUNCFG_ADC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDRUNCFG_ADC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDRUNCFG_XTAL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDRUNCFG_XTAL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDRUNCFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDRUNCFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPDRUNCFG_LFOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPDRUNCFG_LFOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPDRUNCFG_DAC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetPDRUNCFG_DAC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetPDRUNCFG_TS_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPDRUNCFG_TS_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPDRUNCFG_ACOMP_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetPDRUNCFG_ACOMP_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0xfffe0000)|value<<17)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0xfffe0000) >> 17
}

// SYSCON.DEVICE_ID: Device ID
func (o *SYSCON_Type) SetDEVICE_ID(value uint32) {
	volatile.StoreUint32(&o.DEVICE_ID.Reg, value)
}
func (o *SYSCON_Type) GetDEVICE_ID() uint32 {
	return volatile.LoadUint32(&o.DEVICE_ID.Reg)
}

// GPIO Modification
type GPIO_PIN_INT_Type struct {
	ISEL  volatile.Register32 // 0x0
	IENR  volatile.Register32 // 0x4
	SIENR volatile.Register32 // 0x8
	CIENR volatile.Register32 // 0xC
	IENF  volatile.Register32 // 0x10
	SIENF volatile.Register32 // 0x14
	CIENF volatile.Register32 // 0x18
	RISE  volatile.Register32 // 0x1C
	FALL  volatile.Register32 // 0x20
	IST   volatile.Register32 // 0x24
}

// GPIO_PIN_INT.ISEL: Pin Interrupt Mode register
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE0(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE0() uint32 {
	return volatile.LoadUint32(&o.ISEL.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE1(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE1() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE2(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE2() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE3(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE3() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE4(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE4() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE5(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE5() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE6(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE6() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE7(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE7() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetISEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetISEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.IENR: Pin Interrupt Enable (Rising) register
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL0(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL0() uint32 {
	return volatile.LoadUint32(&o.IENR.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL1(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL1() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL2(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL2() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL3(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL3() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL4(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL4() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL5(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL5() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL6(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL6() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL7(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL7() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.SIENR: Set Pin Interrupt Enable (Rising) register
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL0(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL0() uint32 {
	return volatile.LoadUint32(&o.SIENR.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL1(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL1() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL2(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL2() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL3(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL3() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL4(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL4() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL5(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL5() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL6(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL6() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL7(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL7() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetSIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.CIENR: Clear Pin Interrupt Enable (Rising) register
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL0(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL0() uint32 {
	return volatile.LoadUint32(&o.CIENR.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL1(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL1() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL2(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL2() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL3(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL3() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL4(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL4() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL5(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL5() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL6(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL6() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL7(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL7() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetCIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.IENF: Pin Interrupt Enable Falling Edge / Active Level register
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF0(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF0() uint32 {
	return volatile.LoadUint32(&o.IENF.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF1(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF1() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF2(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF2() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF3(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF3() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF4(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF4() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF5(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF5() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF6(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF6() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF7(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF7() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.SIENF: Set Pin Interrupt Enable Falling Edge / Active Level register
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF0(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF0() uint32 {
	return volatile.LoadUint32(&o.SIENF.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF1(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF1() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF2(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF2() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF3(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF3() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF4(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF4() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF5(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF5() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF6(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF6() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF7(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF7() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetSIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.CIENF: Clear Pin Interrupt Enable Falling Edge / Active Level address
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF0(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF0() uint32 {
	return volatile.LoadUint32(&o.CIENF.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF1(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF1() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF2(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF2() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF3(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF3() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF4(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF4() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF5(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF5() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF6(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF6() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF7(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF7() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetCIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.RISE: Pin Interrupt Rising Edge register
func (o *GPIO_PIN_INT_Type) SetRISE_RDET0(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET0() uint32 {
	return volatile.LoadUint32(&o.RISE.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET1(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET1() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET2(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET2() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET3(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET3() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET4(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET4() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET5(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET5() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET6(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET6() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetRISE_RDET7(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET7() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetRISE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.FALL: Pin Interrupt Falling Edge register
func (o *GPIO_PIN_INT_Type) SetFALL_FDET0(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET0() uint32 {
	return volatile.LoadUint32(&o.FALL.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET1(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET1() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET2(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET2() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET3(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET3() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET4(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET4() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET5(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET5() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET6(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET6() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetFALL_FDET7(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET7() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetFALL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetFALL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.IST: Pin Interrupt Status register
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT0(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT0() uint32 {
	return volatile.LoadUint32(&o.IST.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT1(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT1() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT2(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT2() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x4) >> 2
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT3(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT3() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x8) >> 3
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT4(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT4() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x10) >> 4
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT5(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT5() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x20) >> 5
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT6(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT6() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x40) >> 6
}
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT7(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT7() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetIST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetIST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0xffffff00) >> 8
}

// GPIO group interrupt
type GPIO_GROUP_INT0_Type struct {
	CTRL      volatile.Register32 // 0x0
	_         [28]byte
	PORT_POL0 volatile.Register32 // 0x20
	PORT_POL1 volatile.Register32 // 0x24
	_         [24]byte
	PORT_ENA0 volatile.Register32 // 0x40
	PORT_ENA1 volatile.Register32 // 0x44
}

// GPIO_GROUP_INT0.CTRL: GPIO grouped interrupt control register
func (o *GPIO_GROUP_INT0_Type) SetCTRL_INT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *GPIO_GROUP_INT0_Type) GetCTRL_INT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *GPIO_GROUP_INT0_Type) SetCTRL_COMB(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_GROUP_INT0_Type) GetCTRL_COMB() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *GPIO_GROUP_INT0_Type) SetCTRL_TRIG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_GROUP_INT0_Type) GetCTRL_TRIG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *GPIO_GROUP_INT0_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *GPIO_GROUP_INT0_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff8) >> 3
}

// GPIO_GROUP_INT0.PORT_POL0: GPIO grouped interrupt port 0 polarity register
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_0(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x1)|value)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_0() uint32 {
	return volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_1(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_1() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x2) >> 1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_2(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_2() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x4) >> 2
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_3(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_3() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x8) >> 3
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_4(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_4() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x10) >> 4
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_5(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_5() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x20) >> 5
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_6(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_6() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x40) >> 6
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_7(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_7() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x80) >> 7
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_8(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_8() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x100) >> 8
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_9(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_9() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x200) >> 9
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_10(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_10() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x400) >> 10
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_11(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_11() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x800) >> 11
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_12(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_12() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x1000) >> 12
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_13(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_13() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x2000) >> 13
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_14(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_14() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x4000) >> 14
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_15(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_15() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x8000) >> 15
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_16(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_16() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x10000) >> 16
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_17(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_17() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x20000) >> 17
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_18(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_18() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x40000) >> 18
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_19(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_19() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x80000) >> 19
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_20(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_20() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x100000) >> 20
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_21(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_21() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x200000) >> 21
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_22(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_22() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x400000) >> 22
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_23(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_23() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x800000) >> 23
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_24(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_24() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_25(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_25() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_26(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_26() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_27(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_27() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_28(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_28() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_29(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_29() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_30(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_30() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL0_POL_31(value uint32) {
	volatile.StoreUint32(&o.PORT_POL0.Reg, volatile.LoadUint32(&o.PORT_POL0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL0_POL_31() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL0.Reg) & 0x80000000) >> 31
}

// GPIO_GROUP_INT0.PORT_POL1: GPIO grouped interrupt port 0 polarity register
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_0(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x1)|value)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_0() uint32 {
	return volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_1(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_1() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x2) >> 1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_2(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_2() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x4) >> 2
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_3(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_3() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x8) >> 3
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_4(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_4() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x10) >> 4
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_5(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_5() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x20) >> 5
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_6(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_6() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x40) >> 6
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_7(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_7() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x80) >> 7
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_8(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_8() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x100) >> 8
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_9(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_9() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x200) >> 9
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_10(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_10() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x400) >> 10
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_11(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_11() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x800) >> 11
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_12(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_12() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x1000) >> 12
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_13(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_13() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x2000) >> 13
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_14(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_14() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x4000) >> 14
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_15(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_15() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x8000) >> 15
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_16(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_16() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x10000) >> 16
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_17(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_17() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x20000) >> 17
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_18(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_18() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x40000) >> 18
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_19(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_19() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x80000) >> 19
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_20(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_20() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x100000) >> 20
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_21(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_21() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x200000) >> 21
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_22(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_22() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x400000) >> 22
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_23(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_23() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x800000) >> 23
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_24(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_24() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_25(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_25() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_26(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_26() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_27(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_27() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_28(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_28() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_29(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_29() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_30(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_30() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_POL1_POL_31(value uint32) {
	volatile.StoreUint32(&o.PORT_POL1.Reg, volatile.LoadUint32(&o.PORT_POL1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_POL1_POL_31() uint32 {
	return (volatile.LoadUint32(&o.PORT_POL1.Reg) & 0x80000000) >> 31
}

// GPIO_GROUP_INT0.PORT_ENA0: GPIO grouped interrupt port 0/1 enable register
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_0(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x1)|value)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_0() uint32 {
	return volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_1(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_1() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x2) >> 1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_2(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_2() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x4) >> 2
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_3(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_3() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x8) >> 3
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_4(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_4() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x10) >> 4
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_5(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_5() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x20) >> 5
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_6(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_6() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x40) >> 6
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_7(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_7() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x80) >> 7
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_8(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_8() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x100) >> 8
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_9(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_9() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x200) >> 9
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_10(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_10() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x400) >> 10
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_11(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_11() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x800) >> 11
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_12(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_12() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x1000) >> 12
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_13(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_13() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x2000) >> 13
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_14(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_14() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x4000) >> 14
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_15(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_15() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x8000) >> 15
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_16(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_16() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x10000) >> 16
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_17(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_17() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x20000) >> 17
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_18(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_18() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x40000) >> 18
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_19(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_19() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x80000) >> 19
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_20(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_20() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x100000) >> 20
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_21(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_21() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x200000) >> 21
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_22(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_22() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x400000) >> 22
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_23(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_23() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x800000) >> 23
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_24(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_24() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_25(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_25() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_26(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_26() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_27(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_27() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_28(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_28() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_29(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_29() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_30(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_30() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA0_ENA_31(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA0.Reg, volatile.LoadUint32(&o.PORT_ENA0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA0_ENA_31() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA0.Reg) & 0x80000000) >> 31
}

// GPIO_GROUP_INT0.PORT_ENA1: GPIO grouped interrupt port 0/1 enable register
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_0(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x1)|value)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_0() uint32 {
	return volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_1(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_1() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x2) >> 1
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_2(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_2() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x4) >> 2
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_3(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_3() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x8) >> 3
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_4(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_4() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x10) >> 4
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_5(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_5() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x20) >> 5
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_6(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_6() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x40) >> 6
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_7(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_7() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x80) >> 7
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_8(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_8() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x100) >> 8
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_9(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_9() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x200) >> 9
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_10(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_10() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x400) >> 10
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_11(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_11() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x800) >> 11
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_12(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_12() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x1000) >> 12
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_13(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_13() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x2000) >> 13
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_14(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_14() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x4000) >> 14
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_15(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_15() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x8000) >> 15
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_16(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_16() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x10000) >> 16
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_17(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_17() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x20000) >> 17
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_18(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_18() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x40000) >> 18
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_19(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_19() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x80000) >> 19
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_20(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_20() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x100000) >> 20
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_21(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_21() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x200000) >> 21
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_22(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_22() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x400000) >> 22
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_23(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_23() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x800000) >> 23
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_24(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_24() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_25(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_25() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_26(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_26() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_27(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_27() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_28(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_28() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_29(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_29() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_30(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_30() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_GROUP_INT0_Type) SetPORT_ENA1_ENA_31(value uint32) {
	volatile.StoreUint32(&o.PORT_ENA1.Reg, volatile.LoadUint32(&o.PORT_ENA1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_GROUP_INT0_Type) GetPORT_ENA1_ENA_31() uint32 {
	return (volatile.LoadUint32(&o.PORT_ENA1.Reg) & 0x80000000) >> 31
}

// GPIO port
type GPIO_PORT_Type struct {
	B0    volatile.Register8 // 0x0
	B1    volatile.Register8 // 0x1
	B2    volatile.Register8 // 0x2
	B3    volatile.Register8 // 0x3
	B4    volatile.Register8 // 0x4
	B5    volatile.Register8 // 0x5
	B6    volatile.Register8 // 0x6
	B7    volatile.Register8 // 0x7
	B8    volatile.Register8 // 0x8
	B9    volatile.Register8 // 0x9
	B10   volatile.Register8 // 0xA
	B11   volatile.Register8 // 0xB
	B12   volatile.Register8 // 0xC
	B13   volatile.Register8 // 0xD
	B14   volatile.Register8 // 0xE
	B15   volatile.Register8 // 0xF
	B16   volatile.Register8 // 0x10
	B17   volatile.Register8 // 0x11
	B18   volatile.Register8 // 0x12
	B19   volatile.Register8 // 0x13
	B20   volatile.Register8 // 0x14
	B21   volatile.Register8 // 0x15
	B22   volatile.Register8 // 0x16
	B23   volatile.Register8 // 0x17
	B24   volatile.Register8 // 0x18
	B25   volatile.Register8 // 0x19
	B26   volatile.Register8 // 0x1A
	B27   volatile.Register8 // 0x1B
	B28   volatile.Register8 // 0x1C
	B29   volatile.Register8 // 0x1D
	B30   volatile.Register8 // 0x1E
	B31   volatile.Register8 // 0x1F
	B32   volatile.Register8 // 0x20
	B33   volatile.Register8 // 0x21
	B34   volatile.Register8 // 0x22
	B35   volatile.Register8 // 0x23
	B36   volatile.Register8 // 0x24
	B37   volatile.Register8 // 0x25
	B38   volatile.Register8 // 0x26
	B39   volatile.Register8 // 0x27
	B40   volatile.Register8 // 0x28
	B41   volatile.Register8 // 0x29
	_     [4054]byte
	W0    volatile.Register32 // 0x1000
	W1    volatile.Register32 // 0x1004
	W2    volatile.Register32 // 0x1008
	W3    volatile.Register32 // 0x100C
	W4    volatile.Register32 // 0x1010
	W5    volatile.Register32 // 0x1014
	W6    volatile.Register32 // 0x1018
	W7    volatile.Register32 // 0x101C
	W8    volatile.Register32 // 0x1020
	W9    volatile.Register32 // 0x1024
	W10   volatile.Register32 // 0x1028
	W11   volatile.Register32 // 0x102C
	W12   volatile.Register32 // 0x1030
	W13   volatile.Register32 // 0x1034
	W14   volatile.Register32 // 0x1038
	W15   volatile.Register32 // 0x103C
	W16   volatile.Register32 // 0x1040
	W17   volatile.Register32 // 0x1044
	W18   volatile.Register32 // 0x1048
	W19   volatile.Register32 // 0x104C
	W20   volatile.Register32 // 0x1050
	W21   volatile.Register32 // 0x1054
	W22   volatile.Register32 // 0x1058
	W23   volatile.Register32 // 0x105C
	W24   volatile.Register32 // 0x1060
	W25   volatile.Register32 // 0x1064
	W26   volatile.Register32 // 0x1068
	W27   volatile.Register32 // 0x106C
	W28   volatile.Register32 // 0x1070
	W29   volatile.Register32 // 0x1074
	W30   volatile.Register32 // 0x1078
	W31   volatile.Register32 // 0x107C
	W32   volatile.Register32 // 0x1080
	W33   volatile.Register32 // 0x1084
	W34   volatile.Register32 // 0x1088
	W35   volatile.Register32 // 0x108C
	W36   volatile.Register32 // 0x1090
	W37   volatile.Register32 // 0x1094
	W38   volatile.Register32 // 0x1098
	W39   volatile.Register32 // 0x109C
	W40   volatile.Register32 // 0x10A0
	W41   volatile.Register32 // 0x10A4
	_     [3928]byte
	DIR0  volatile.Register32 // 0x2000
	DIR1  volatile.Register32 // 0x2004
	_     [120]byte
	MASK0 volatile.Register32 // 0x2080
	MASK1 volatile.Register32 // 0x2084
	_     [120]byte
	PIN0  volatile.Register32 // 0x2100
	PIN1  volatile.Register32 // 0x2104
	_     [120]byte
	MPIN0 volatile.Register32 // 0x2180
	MPIN1 volatile.Register32 // 0x2184
	_     [120]byte
	SET0  volatile.Register32 // 0x2200
	SET1  volatile.Register32 // 0x2204
	_     [120]byte
	CLR0  volatile.Register32 // 0x2280
	CLR1  volatile.Register32 // 0x2284
	_     [120]byte
	NOT0  volatile.Register32 // 0x2300
	NOT1  volatile.Register32 // 0x2304
}

// GPIO_PORT.B0: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB0_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B0.Reg, volatile.LoadUint8(&o.B0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB0_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B0.Reg) & 0x1
}

// GPIO_PORT.B1: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB1_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B1.Reg, volatile.LoadUint8(&o.B1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB1_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B1.Reg) & 0x1
}

// GPIO_PORT.B2: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB2_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B2.Reg, volatile.LoadUint8(&o.B2.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB2_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B2.Reg) & 0x1
}

// GPIO_PORT.B3: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB3_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B3.Reg, volatile.LoadUint8(&o.B3.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB3_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B3.Reg) & 0x1
}

// GPIO_PORT.B4: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB4_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B4.Reg, volatile.LoadUint8(&o.B4.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB4_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B4.Reg) & 0x1
}

// GPIO_PORT.B5: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB5_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B5.Reg, volatile.LoadUint8(&o.B5.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB5_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B5.Reg) & 0x1
}

// GPIO_PORT.B6: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB6_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B6.Reg, volatile.LoadUint8(&o.B6.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB6_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B6.Reg) & 0x1
}

// GPIO_PORT.B7: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB7_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B7.Reg, volatile.LoadUint8(&o.B7.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB7_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B7.Reg) & 0x1
}

// GPIO_PORT.B8: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB8_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B8.Reg, volatile.LoadUint8(&o.B8.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB8_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B8.Reg) & 0x1
}

// GPIO_PORT.B9: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB9_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B9.Reg, volatile.LoadUint8(&o.B9.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB9_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B9.Reg) & 0x1
}

// GPIO_PORT.B10: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB10_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B10.Reg, volatile.LoadUint8(&o.B10.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB10_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B10.Reg) & 0x1
}

// GPIO_PORT.B11: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB11_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B11.Reg, volatile.LoadUint8(&o.B11.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB11_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B11.Reg) & 0x1
}

// GPIO_PORT.B12: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB12_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B12.Reg, volatile.LoadUint8(&o.B12.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB12_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B12.Reg) & 0x1
}

// GPIO_PORT.B13: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB13_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B13.Reg, volatile.LoadUint8(&o.B13.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB13_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B13.Reg) & 0x1
}

// GPIO_PORT.B14: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB14_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B14.Reg, volatile.LoadUint8(&o.B14.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB14_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B14.Reg) & 0x1
}

// GPIO_PORT.B15: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB15_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B15.Reg, volatile.LoadUint8(&o.B15.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB15_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B15.Reg) & 0x1
}

// GPIO_PORT.B16: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB16_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B16.Reg, volatile.LoadUint8(&o.B16.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB16_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B16.Reg) & 0x1
}

// GPIO_PORT.B17: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB17_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B17.Reg, volatile.LoadUint8(&o.B17.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB17_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B17.Reg) & 0x1
}

// GPIO_PORT.B18: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB18_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B18.Reg, volatile.LoadUint8(&o.B18.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB18_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B18.Reg) & 0x1
}

// GPIO_PORT.B19: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB19_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B19.Reg, volatile.LoadUint8(&o.B19.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB19_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B19.Reg) & 0x1
}

// GPIO_PORT.B20: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB20_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B20.Reg, volatile.LoadUint8(&o.B20.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB20_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B20.Reg) & 0x1
}

// GPIO_PORT.B21: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB21_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B21.Reg, volatile.LoadUint8(&o.B21.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB21_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B21.Reg) & 0x1
}

// GPIO_PORT.B22: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB22_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B22.Reg, volatile.LoadUint8(&o.B22.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB22_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B22.Reg) & 0x1
}

// GPIO_PORT.B23: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB23_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B23.Reg, volatile.LoadUint8(&o.B23.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB23_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B23.Reg) & 0x1
}

// GPIO_PORT.B24: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB24_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B24.Reg, volatile.LoadUint8(&o.B24.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB24_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B24.Reg) & 0x1
}

// GPIO_PORT.B25: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB25_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B25.Reg, volatile.LoadUint8(&o.B25.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB25_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B25.Reg) & 0x1
}

// GPIO_PORT.B26: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB26_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B26.Reg, volatile.LoadUint8(&o.B26.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB26_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B26.Reg) & 0x1
}

// GPIO_PORT.B27: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB27_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B27.Reg, volatile.LoadUint8(&o.B27.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB27_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B27.Reg) & 0x1
}

// GPIO_PORT.B28: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB28_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B28.Reg, volatile.LoadUint8(&o.B28.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB28_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B28.Reg) & 0x1
}

// GPIO_PORT.B29: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB29_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B29.Reg, volatile.LoadUint8(&o.B29.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB29_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B29.Reg) & 0x1
}

// GPIO_PORT.B30: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB30_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B30.Reg, volatile.LoadUint8(&o.B30.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB30_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B30.Reg) & 0x1
}

// GPIO_PORT.B31: Byte pin registers port 0; pins PIO0_0 to PIO0_31
func (o *GPIO_PORT_Type) SetB31_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B31.Reg, volatile.LoadUint8(&o.B31.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB31_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B31.Reg) & 0x1
}

// GPIO_PORT.B32: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB32_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B32.Reg, volatile.LoadUint8(&o.B32.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB32_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B32.Reg) & 0x1
}

// GPIO_PORT.B33: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB33_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B33.Reg, volatile.LoadUint8(&o.B33.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB33_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B33.Reg) & 0x1
}

// GPIO_PORT.B34: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB34_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B34.Reg, volatile.LoadUint8(&o.B34.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB34_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B34.Reg) & 0x1
}

// GPIO_PORT.B35: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB35_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B35.Reg, volatile.LoadUint8(&o.B35.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB35_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B35.Reg) & 0x1
}

// GPIO_PORT.B36: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB36_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B36.Reg, volatile.LoadUint8(&o.B36.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB36_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B36.Reg) & 0x1
}

// GPIO_PORT.B37: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB37_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B37.Reg, volatile.LoadUint8(&o.B37.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB37_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B37.Reg) & 0x1
}

// GPIO_PORT.B38: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB38_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B38.Reg, volatile.LoadUint8(&o.B38.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB38_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B38.Reg) & 0x1
}

// GPIO_PORT.B39: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB39_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B39.Reg, volatile.LoadUint8(&o.B39.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB39_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B39.Reg) & 0x1
}

// GPIO_PORT.B40: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB40_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B40.Reg, volatile.LoadUint8(&o.B40.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB40_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B40.Reg) & 0x1
}

// GPIO_PORT.B41: Byte pin registers port 1
func (o *GPIO_PORT_Type) SetB41_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B41.Reg, volatile.LoadUint8(&o.B41.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB41_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B41.Reg) & 0x1
}

// GPIO_PORT.W0: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW0(value uint32) {
	volatile.StoreUint32(&o.W0.Reg, value)
}
func (o *GPIO_PORT_Type) GetW0() uint32 {
	return volatile.LoadUint32(&o.W0.Reg)
}

// GPIO_PORT.W1: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW1(value uint32) {
	volatile.StoreUint32(&o.W1.Reg, value)
}
func (o *GPIO_PORT_Type) GetW1() uint32 {
	return volatile.LoadUint32(&o.W1.Reg)
}

// GPIO_PORT.W2: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW2(value uint32) {
	volatile.StoreUint32(&o.W2.Reg, value)
}
func (o *GPIO_PORT_Type) GetW2() uint32 {
	return volatile.LoadUint32(&o.W2.Reg)
}

// GPIO_PORT.W3: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW3(value uint32) {
	volatile.StoreUint32(&o.W3.Reg, value)
}
func (o *GPIO_PORT_Type) GetW3() uint32 {
	return volatile.LoadUint32(&o.W3.Reg)
}

// GPIO_PORT.W4: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW4(value uint32) {
	volatile.StoreUint32(&o.W4.Reg, value)
}
func (o *GPIO_PORT_Type) GetW4() uint32 {
	return volatile.LoadUint32(&o.W4.Reg)
}

// GPIO_PORT.W5: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW5(value uint32) {
	volatile.StoreUint32(&o.W5.Reg, value)
}
func (o *GPIO_PORT_Type) GetW5() uint32 {
	return volatile.LoadUint32(&o.W5.Reg)
}

// GPIO_PORT.W6: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW6(value uint32) {
	volatile.StoreUint32(&o.W6.Reg, value)
}
func (o *GPIO_PORT_Type) GetW6() uint32 {
	return volatile.LoadUint32(&o.W6.Reg)
}

// GPIO_PORT.W7: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW7(value uint32) {
	volatile.StoreUint32(&o.W7.Reg, value)
}
func (o *GPIO_PORT_Type) GetW7() uint32 {
	return volatile.LoadUint32(&o.W7.Reg)
}

// GPIO_PORT.W8: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW8(value uint32) {
	volatile.StoreUint32(&o.W8.Reg, value)
}
func (o *GPIO_PORT_Type) GetW8() uint32 {
	return volatile.LoadUint32(&o.W8.Reg)
}

// GPIO_PORT.W9: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW9(value uint32) {
	volatile.StoreUint32(&o.W9.Reg, value)
}
func (o *GPIO_PORT_Type) GetW9() uint32 {
	return volatile.LoadUint32(&o.W9.Reg)
}

// GPIO_PORT.W10: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW10(value uint32) {
	volatile.StoreUint32(&o.W10.Reg, value)
}
func (o *GPIO_PORT_Type) GetW10() uint32 {
	return volatile.LoadUint32(&o.W10.Reg)
}

// GPIO_PORT.W11: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW11(value uint32) {
	volatile.StoreUint32(&o.W11.Reg, value)
}
func (o *GPIO_PORT_Type) GetW11() uint32 {
	return volatile.LoadUint32(&o.W11.Reg)
}

// GPIO_PORT.W12: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW12(value uint32) {
	volatile.StoreUint32(&o.W12.Reg, value)
}
func (o *GPIO_PORT_Type) GetW12() uint32 {
	return volatile.LoadUint32(&o.W12.Reg)
}

// GPIO_PORT.W13: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW13(value uint32) {
	volatile.StoreUint32(&o.W13.Reg, value)
}
func (o *GPIO_PORT_Type) GetW13() uint32 {
	return volatile.LoadUint32(&o.W13.Reg)
}

// GPIO_PORT.W14: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW14(value uint32) {
	volatile.StoreUint32(&o.W14.Reg, value)
}
func (o *GPIO_PORT_Type) GetW14() uint32 {
	return volatile.LoadUint32(&o.W14.Reg)
}

// GPIO_PORT.W15: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW15(value uint32) {
	volatile.StoreUint32(&o.W15.Reg, value)
}
func (o *GPIO_PORT_Type) GetW15() uint32 {
	return volatile.LoadUint32(&o.W15.Reg)
}

// GPIO_PORT.W16: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW16(value uint32) {
	volatile.StoreUint32(&o.W16.Reg, value)
}
func (o *GPIO_PORT_Type) GetW16() uint32 {
	return volatile.LoadUint32(&o.W16.Reg)
}

// GPIO_PORT.W17: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW17(value uint32) {
	volatile.StoreUint32(&o.W17.Reg, value)
}
func (o *GPIO_PORT_Type) GetW17() uint32 {
	return volatile.LoadUint32(&o.W17.Reg)
}

// GPIO_PORT.W18: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW18(value uint32) {
	volatile.StoreUint32(&o.W18.Reg, value)
}
func (o *GPIO_PORT_Type) GetW18() uint32 {
	return volatile.LoadUint32(&o.W18.Reg)
}

// GPIO_PORT.W19: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW19(value uint32) {
	volatile.StoreUint32(&o.W19.Reg, value)
}
func (o *GPIO_PORT_Type) GetW19() uint32 {
	return volatile.LoadUint32(&o.W19.Reg)
}

// GPIO_PORT.W20: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW20(value uint32) {
	volatile.StoreUint32(&o.W20.Reg, value)
}
func (o *GPIO_PORT_Type) GetW20() uint32 {
	return volatile.LoadUint32(&o.W20.Reg)
}

// GPIO_PORT.W21: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW21(value uint32) {
	volatile.StoreUint32(&o.W21.Reg, value)
}
func (o *GPIO_PORT_Type) GetW21() uint32 {
	return volatile.LoadUint32(&o.W21.Reg)
}

// GPIO_PORT.W22: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW22(value uint32) {
	volatile.StoreUint32(&o.W22.Reg, value)
}
func (o *GPIO_PORT_Type) GetW22() uint32 {
	return volatile.LoadUint32(&o.W22.Reg)
}

// GPIO_PORT.W23: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW23(value uint32) {
	volatile.StoreUint32(&o.W23.Reg, value)
}
func (o *GPIO_PORT_Type) GetW23() uint32 {
	return volatile.LoadUint32(&o.W23.Reg)
}

// GPIO_PORT.W24: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW24(value uint32) {
	volatile.StoreUint32(&o.W24.Reg, value)
}
func (o *GPIO_PORT_Type) GetW24() uint32 {
	return volatile.LoadUint32(&o.W24.Reg)
}

// GPIO_PORT.W25: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW25(value uint32) {
	volatile.StoreUint32(&o.W25.Reg, value)
}
func (o *GPIO_PORT_Type) GetW25() uint32 {
	return volatile.LoadUint32(&o.W25.Reg)
}

// GPIO_PORT.W26: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW26(value uint32) {
	volatile.StoreUint32(&o.W26.Reg, value)
}
func (o *GPIO_PORT_Type) GetW26() uint32 {
	return volatile.LoadUint32(&o.W26.Reg)
}

// GPIO_PORT.W27: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW27(value uint32) {
	volatile.StoreUint32(&o.W27.Reg, value)
}
func (o *GPIO_PORT_Type) GetW27() uint32 {
	return volatile.LoadUint32(&o.W27.Reg)
}

// GPIO_PORT.W28: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW28(value uint32) {
	volatile.StoreUint32(&o.W28.Reg, value)
}
func (o *GPIO_PORT_Type) GetW28() uint32 {
	return volatile.LoadUint32(&o.W28.Reg)
}

// GPIO_PORT.W29: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW29(value uint32) {
	volatile.StoreUint32(&o.W29.Reg, value)
}
func (o *GPIO_PORT_Type) GetW29() uint32 {
	return volatile.LoadUint32(&o.W29.Reg)
}

// GPIO_PORT.W30: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW30(value uint32) {
	volatile.StoreUint32(&o.W30.Reg, value)
}
func (o *GPIO_PORT_Type) GetW30() uint32 {
	return volatile.LoadUint32(&o.W30.Reg)
}

// GPIO_PORT.W31: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW31(value uint32) {
	volatile.StoreUint32(&o.W31.Reg, value)
}
func (o *GPIO_PORT_Type) GetW31() uint32 {
	return volatile.LoadUint32(&o.W31.Reg)
}

// GPIO_PORT.W32: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW32(value uint32) {
	volatile.StoreUint32(&o.W32.Reg, value)
}
func (o *GPIO_PORT_Type) GetW32() uint32 {
	return volatile.LoadUint32(&o.W32.Reg)
}

// GPIO_PORT.W33: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW33(value uint32) {
	volatile.StoreUint32(&o.W33.Reg, value)
}
func (o *GPIO_PORT_Type) GetW33() uint32 {
	return volatile.LoadUint32(&o.W33.Reg)
}

// GPIO_PORT.W34: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW34(value uint32) {
	volatile.StoreUint32(&o.W34.Reg, value)
}
func (o *GPIO_PORT_Type) GetW34() uint32 {
	return volatile.LoadUint32(&o.W34.Reg)
}

// GPIO_PORT.W35: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW35(value uint32) {
	volatile.StoreUint32(&o.W35.Reg, value)
}
func (o *GPIO_PORT_Type) GetW35() uint32 {
	return volatile.LoadUint32(&o.W35.Reg)
}

// GPIO_PORT.W36: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW36(value uint32) {
	volatile.StoreUint32(&o.W36.Reg, value)
}
func (o *GPIO_PORT_Type) GetW36() uint32 {
	return volatile.LoadUint32(&o.W36.Reg)
}

// GPIO_PORT.W37: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW37(value uint32) {
	volatile.StoreUint32(&o.W37.Reg, value)
}
func (o *GPIO_PORT_Type) GetW37() uint32 {
	return volatile.LoadUint32(&o.W37.Reg)
}

// GPIO_PORT.W38: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW38(value uint32) {
	volatile.StoreUint32(&o.W38.Reg, value)
}
func (o *GPIO_PORT_Type) GetW38() uint32 {
	return volatile.LoadUint32(&o.W38.Reg)
}

// GPIO_PORT.W39: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW39(value uint32) {
	volatile.StoreUint32(&o.W39.Reg, value)
}
func (o *GPIO_PORT_Type) GetW39() uint32 {
	return volatile.LoadUint32(&o.W39.Reg)
}

// GPIO_PORT.W40: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW40(value uint32) {
	volatile.StoreUint32(&o.W40.Reg, value)
}
func (o *GPIO_PORT_Type) GetW40() uint32 {
	return volatile.LoadUint32(&o.W40.Reg)
}

// GPIO_PORT.W41: Word pin registers port 1
func (o *GPIO_PORT_Type) SetW41(value uint32) {
	volatile.StoreUint32(&o.W41.Reg, value)
}
func (o *GPIO_PORT_Type) GetW41() uint32 {
	return volatile.LoadUint32(&o.W41.Reg)
}

// GPIO_PORT.DIR0: Direction registers port 0/1
func (o *GPIO_PORT_Type) SetDIR0_DIRP0(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP0() uint32 {
	return volatile.LoadUint32(&o.DIR0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP1(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP1() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP2(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP2() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP3(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP3() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP4(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP4() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP5(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP5() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP6(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP6() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP7(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP7() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP8(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP8() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP9(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP9() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP10(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP10() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP11(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP11() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP12(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP12() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP13(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP13() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP14(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP14() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP15(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP15() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP16(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP16() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP17(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP17() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP18(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP18() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP19(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP19() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP20(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP20() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP21(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP21() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP22(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP22() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP23(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP23() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP24(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP24() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP25(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP25() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP26(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP26() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP27(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP27() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP28(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP28() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP29(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP29() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP30(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP30() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetDIR0_DIRP31(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP31() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.DIR1: Direction registers port 0/1
func (o *GPIO_PORT_Type) SetDIR1_DIRP0(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP0() uint32 {
	return volatile.LoadUint32(&o.DIR1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP1(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP1() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP2(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP2() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP3(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP3() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP4(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP4() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP5(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP5() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP6(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP6() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP7(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP7() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP8(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP8() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP9(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP9() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP10(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP10() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP11(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP11() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP12(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP12() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP13(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP13() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP14(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP14() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP15(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP15() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP16(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP16() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP17(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP17() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP18(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP18() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP19(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP19() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP20(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP20() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP21(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP21() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP22(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP22() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP23(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP23() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP24(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP24() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP25(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP25() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP26(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP26() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP27(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP27() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP28(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP28() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP29(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP29() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP30(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP30() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetDIR1_DIRP31(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetDIR1_DIRP31() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.MASK0: Mask register port 0/1
func (o *GPIO_PORT_Type) SetMASK0_MASKP0(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP0() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP1(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP1() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP2(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP2() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP3(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP3() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP4(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP4() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP5(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP5() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP6(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP6() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP7(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP7() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP8(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP8() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP9(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP9() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP10(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP10() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP11(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP11() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP12(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP12() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP13(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP13() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP14(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP14() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP15(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP15() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP16(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP16() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP17(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP17() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP18(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP18() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP19(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP19() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP20(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP20() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP21(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP21() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP22(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP22() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP23(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP23() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP24(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP24() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP25(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP25() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP26(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP26() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP27(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP27() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP28(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP28() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP29(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP29() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP30(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP30() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetMASK0_MASKP31(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP31() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.MASK1: Mask register port 0/1
func (o *GPIO_PORT_Type) SetMASK1_MASKP0(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP0() uint32 {
	return volatile.LoadUint32(&o.MASK1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP1(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP1() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP2(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP2() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP3(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP3() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP4(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP4() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP5(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP5() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP6(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP6() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP7(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP7() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP8(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP8() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP9(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP9() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP10(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP10() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP11(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP11() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP12(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP12() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP13(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP13() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP14(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP14() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP15(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP15() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP16(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP16() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP17(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP17() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP18(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP18() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP19(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP19() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP20(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP20() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP21(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP21() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP22(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP22() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP23(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP23() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP24(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP24() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP25(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP25() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP26(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP26() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP27(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP27() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP28(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP28() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP29(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP29() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP30(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP30() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetMASK1_MASKP31(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetMASK1_MASKP31() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.PIN0: Portpin register port 0
func (o *GPIO_PORT_Type) SetPIN0_PORT0(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT0() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetPIN0_PORT1(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT1() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetPIN0_PORT2(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT2() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetPIN0_PORT3(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT3() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetPIN0_PORT4(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT4() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetPIN0_PORT5(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT5() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetPIN0_PORT6(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT6() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetPIN0_PORT7(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT7() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetPIN0_PORT8(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT8() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetPIN0_PORT9(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT9() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetPIN0_PORT10(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT10() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetPIN0_PORT11(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT11() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetPIN0_PORT12(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT12() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetPIN0_PORT13(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT13() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetPIN0_PORT14(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT14() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetPIN0_PORT15(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT15() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetPIN0_PORT16(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT16() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetPIN0_PORT17(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT17() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetPIN0_PORT18(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT18() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetPIN0_PORT19(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT19() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetPIN0_PORT20(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT20() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetPIN0_PORT21(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT21() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetPIN0_PORT22(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT22() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetPIN0_PORT23(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT23() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetPIN0_PORT24(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT24() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetPIN0_PORT25(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT25() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetPIN0_PORT26(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT26() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetPIN0_PORT27(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT27() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetPIN0_PORT28(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT28() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetPIN0_PORT29(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT29() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetPIN0_PORT30(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT30() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetPIN0_PORT31(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT31() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.PIN1: Portpin register port 0
func (o *GPIO_PORT_Type) SetPIN1_PORT0(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT0() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetPIN1_PORT1(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT1() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetPIN1_PORT2(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT2() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetPIN1_PORT3(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT3() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetPIN1_PORT4(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT4() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetPIN1_PORT5(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT5() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetPIN1_PORT6(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT6() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetPIN1_PORT7(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT7() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetPIN1_PORT8(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT8() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetPIN1_PORT9(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT9() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetPIN1_PORT10(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT10() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetPIN1_PORT11(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT11() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetPIN1_PORT12(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT12() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetPIN1_PORT13(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT13() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetPIN1_PORT14(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT14() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetPIN1_PORT15(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT15() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetPIN1_PORT16(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT16() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetPIN1_PORT17(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT17() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetPIN1_PORT18(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT18() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetPIN1_PORT19(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT19() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetPIN1_PORT20(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT20() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetPIN1_PORT21(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT21() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetPIN1_PORT22(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT22() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetPIN1_PORT23(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT23() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetPIN1_PORT24(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT24() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetPIN1_PORT25(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT25() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetPIN1_PORT26(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT26() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetPIN1_PORT27(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT27() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetPIN1_PORT28(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT28() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetPIN1_PORT29(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT29() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetPIN1_PORT30(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT30() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetPIN1_PORT31(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetPIN1_PORT31() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.MPIN0: Masked port register port 0/1
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP0(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP0() uint32 {
	return volatile.LoadUint32(&o.MPIN0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP1(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP1() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP2(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP2() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP3(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP3() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP4(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP4() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP5(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP5() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP6(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP6() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP7(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP7() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP8(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP8() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP9(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP9() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP10(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP10() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP11(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP11() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP12(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP12() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP13(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP13() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP14(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP14() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP15(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP15() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP16(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP16() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP17(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP17() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP18(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP18() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP19(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP19() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP20(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP20() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP21(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP21() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP22(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP22() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP23(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP23() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP24(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP24() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP25(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP25() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP26(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP26() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP27(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP27() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP28(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP28() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP29(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP29() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP30(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP30() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP31(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP31() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.MPIN1: Masked port register port 0/1
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP0(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP0() uint32 {
	return volatile.LoadUint32(&o.MPIN1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP1(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP1() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP2(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP2() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP3(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP3() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP4(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP4() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP5(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP5() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP6(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP6() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP7(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP7() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP8(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP8() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP9(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP9() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP10(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP10() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP11(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP11() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP12(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP12() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP13(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP13() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP14(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP14() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP15(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP15() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP16(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP16() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP17(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP17() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP18(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP18() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP19(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP19() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP20(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP20() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP21(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP21() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP22(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP22() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP23(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP23() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP24(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP24() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP25(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP25() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP26(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP26() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP27(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP27() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP28(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP28() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP29(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP29() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP30(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP30() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetMPIN1_MPORTP31(value uint32) {
	volatile.StoreUint32(&o.MPIN1.Reg, volatile.LoadUint32(&o.MPIN1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetMPIN1_MPORTP31() uint32 {
	return (volatile.LoadUint32(&o.MPIN1.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.SET0: Write: Set register for port 0/1 Read: output bits for port 0/1
func (o *GPIO_PORT_Type) SetSET0_SETP0(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetSET0_SETP0() uint32 {
	return volatile.LoadUint32(&o.SET0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetSET0_SETP1(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetSET0_SETP1() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetSET0_SETP2(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetSET0_SETP2() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetSET0_SETP3(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetSET0_SETP3() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetSET0_SETP4(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetSET0_SETP4() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetSET0_SETP5(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetSET0_SETP5() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetSET0_SETP6(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetSET0_SETP6() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetSET0_SETP7(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetSET0_SETP7() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetSET0_SETP8(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetSET0_SETP8() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetSET0_SETP9(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetSET0_SETP9() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetSET0_SETP10(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetSET0_SETP10() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetSET0_SETP11(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetSET0_SETP11() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetSET0_SETP12(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetSET0_SETP12() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetSET0_SETP13(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetSET0_SETP13() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetSET0_SETP14(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetSET0_SETP14() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetSET0_SETP15(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetSET0_SETP15() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetSET0_SETP16(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetSET0_SETP16() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetSET0_SETP17(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetSET0_SETP17() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetSET0_SETP18(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetSET0_SETP18() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetSET0_SETP19(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetSET0_SETP19() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetSET0_SETP20(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetSET0_SETP20() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetSET0_SETP21(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetSET0_SETP21() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetSET0_SETP22(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetSET0_SETP22() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetSET0_SETP23(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetSET0_SETP23() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetSET0_SETP24(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetSET0_SETP24() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetSET0_SETP25(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetSET0_SETP25() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetSET0_SETP26(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetSET0_SETP26() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetSET0_SETP27(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetSET0_SETP27() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetSET0_SETP28(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetSET0_SETP28() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetSET0_SETP29(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetSET0_SETP29() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetSET0_SETP30(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetSET0_SETP30() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetSET0_SETP31(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetSET0_SETP31() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.SET1: Write: Set register for port 0/1 Read: output bits for port 0/1
func (o *GPIO_PORT_Type) SetSET1_SETP0(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetSET1_SETP0() uint32 {
	return volatile.LoadUint32(&o.SET1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetSET1_SETP1(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetSET1_SETP1() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetSET1_SETP2(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetSET1_SETP2() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetSET1_SETP3(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetSET1_SETP3() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetSET1_SETP4(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetSET1_SETP4() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetSET1_SETP5(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetSET1_SETP5() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetSET1_SETP6(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetSET1_SETP6() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetSET1_SETP7(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetSET1_SETP7() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetSET1_SETP8(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetSET1_SETP8() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetSET1_SETP9(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetSET1_SETP9() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetSET1_SETP10(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetSET1_SETP10() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetSET1_SETP11(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetSET1_SETP11() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetSET1_SETP12(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetSET1_SETP12() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetSET1_SETP13(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetSET1_SETP13() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetSET1_SETP14(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetSET1_SETP14() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetSET1_SETP15(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetSET1_SETP15() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetSET1_SETP16(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetSET1_SETP16() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetSET1_SETP17(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetSET1_SETP17() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetSET1_SETP18(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetSET1_SETP18() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetSET1_SETP19(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetSET1_SETP19() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetSET1_SETP20(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetSET1_SETP20() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetSET1_SETP21(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetSET1_SETP21() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetSET1_SETP22(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetSET1_SETP22() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetSET1_SETP23(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetSET1_SETP23() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetSET1_SETP24(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetSET1_SETP24() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetSET1_SETP25(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetSET1_SETP25() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetSET1_SETP26(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetSET1_SETP26() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetSET1_SETP27(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetSET1_SETP27() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetSET1_SETP28(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetSET1_SETP28() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetSET1_SETP29(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetSET1_SETP29() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetSET1_SETP30(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetSET1_SETP30() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetSET1_SETP31(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetSET1_SETP31() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.CLR0: Clear port 0/1
func (o *GPIO_PORT_Type) SetCLR0_CLRP00(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP00() uint32 {
	return volatile.LoadUint32(&o.CLR0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP01(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP01() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP02(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP02() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP03(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP03() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP04(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP04() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP05(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP05() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP06(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP06() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP07(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP07() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP08(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP08() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP09(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP09() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP010(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP010() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP011(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP011() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP012(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP012() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP013(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP013() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP014(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP014() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP015(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP015() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP016(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP016() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP017(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP017() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP018(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP018() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP019(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP019() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP020(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP020() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP021(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP021() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP022(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP022() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP023(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP023() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP024(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP024() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP025(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP025() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP026(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP026() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP027(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP027() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP028(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP028() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP029(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP029() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP030(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP030() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetCLR0_CLRP031(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP031() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.CLR1: Clear port 0/1
func (o *GPIO_PORT_Type) SetCLR1_CLRP00(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP00() uint32 {
	return volatile.LoadUint32(&o.CLR1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP01(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP01() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP02(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP02() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP03(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP03() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP04(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP04() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP05(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP05() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP06(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP06() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP07(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP07() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP08(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP08() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP09(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP09() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP010(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP010() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP011(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP011() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP012(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP012() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP013(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP013() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP014(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP014() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP015(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP015() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP016(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP016() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP017(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP017() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP018(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP018() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP019(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP019() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP020(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP020() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP021(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP021() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP022(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP022() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP023(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP023() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP024(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP024() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP025(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP025() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP026(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP026() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP027(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP027() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP028(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP028() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP029(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP029() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP030(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP030() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetCLR1_CLRP031(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetCLR1_CLRP031() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.NOT0: Toggle port 0/1
func (o *GPIO_PORT_Type) SetNOT0_NOTP0(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP0() uint32 {
	return volatile.LoadUint32(&o.NOT0.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP1(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP1() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP2(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP2() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP3(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP3() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP4(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP4() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP5(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP5() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP6(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP6() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP7(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP7() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP8(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP8() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP9(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP9() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP10(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP10() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP11(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP11() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP12(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP12() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP13(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP13() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP14(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP14() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP15(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP15() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP16(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP16() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP17(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP17() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP18(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP18() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP19(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP19() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP20(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP20() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP21(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP21() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP22(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP22() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP23(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP23() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP24(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP24() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP25(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP25() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP26(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP26() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP27(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP27() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP28(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP28() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP29(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP29() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP30(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP30() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetNOT0_NOTP31(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP31() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0x80000000) >> 31
}

// GPIO_PORT.NOT1: Toggle port 0/1
func (o *GPIO_PORT_Type) SetNOT1_NOTP0(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP0() uint32 {
	return volatile.LoadUint32(&o.NOT1.Reg) & 0x1
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP1(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP1() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x2) >> 1
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP2(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP2() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x4) >> 2
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP3(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP3() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x8) >> 3
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP4(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP4() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x10) >> 4
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP5(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP5() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x20) >> 5
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP6(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP6() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x40) >> 6
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP7(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP7() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x80) >> 7
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP8(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP8() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x100) >> 8
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP9(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP9() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x200) >> 9
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP10(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP10() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x400) >> 10
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP11(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP11() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x800) >> 11
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP12(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP12() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x1000) >> 12
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP13(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP13() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x2000) >> 13
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP14(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP14() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x4000) >> 14
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP15(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP15() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x8000) >> 15
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP16(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP16() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x10000) >> 16
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP17(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP17() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x20000) >> 17
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP18(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP18() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x40000) >> 18
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP19(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP19() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x80000) >> 19
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP20(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP20() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x100000) >> 20
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP21(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP21() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x200000) >> 21
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP22(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP22() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x400000) >> 22
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP23(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP23() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x800000) >> 23
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP24(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP24() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP25(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP25() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP26(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP26() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP27(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP27() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP28(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP28() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP29(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP29() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP30(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP30() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_PORT_Type) SetNOT1_NOTP31(value uint32) {
	volatile.StoreUint32(&o.NOT1.Reg, volatile.LoadUint32(&o.NOT1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_PORT_Type) GetNOT1_NOTP31() uint32 {
	return (volatile.LoadUint32(&o.NOT1.Reg) & 0x80000000) >> 31
}

// Constants for I2C: I2C-bus controller
const (
	// CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C_CONSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0x3
	// Position of AA field.
	I2C_CONSET_AA_Pos = 0x2
	// Bit mask of AA field.
	I2C_CONSET_AA_Msk = 0x4
	// Bit AA.
	I2C_CONSET_AA = 0x4
	// Position of SI field.
	I2C_CONSET_SI_Pos = 0x3
	// Bit mask of SI field.
	I2C_CONSET_SI_Msk = 0x8
	// Bit SI.
	I2C_CONSET_SI = 0x8
	// Position of STO field.
	I2C_CONSET_STO_Pos = 0x4
	// Bit mask of STO field.
	I2C_CONSET_STO_Msk = 0x10
	// Bit STO.
	I2C_CONSET_STO = 0x10
	// Position of STA field.
	I2C_CONSET_STA_Pos = 0x5
	// Bit mask of STA field.
	I2C_CONSET_STA_Msk = 0x20
	// Bit STA.
	I2C_CONSET_STA = 0x20
	// Position of I2EN field.
	I2C_CONSET_I2EN_Pos = 0x6
	// Bit mask of I2EN field.
	I2C_CONSET_I2EN_Msk = 0x40
	// Bit I2EN.
	I2C_CONSET_I2EN = 0x40
	// Position of RESERVED field.
	I2C_CONSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0xffffff80

	// STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0x7
	// Position of Status field.
	I2C_STAT_Status_Pos = 0x3
	// Bit mask of Status field.
	I2C_STAT_Status_Msk = 0xf8
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0xffffff00

	// DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
	// Position of Data field.
	I2C_DAT_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C_DAT_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C_DAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_DAT_RESERVED_Msk = 0xffffff00

	// ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C_ADR0_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C_ADR0_GC_Msk = 0x1
	// Bit GC.
	I2C_ADR0_GC = 0x1
	// Position of Address field.
	I2C_ADR0_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C_ADR0_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C_ADR0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_ADR0_RESERVED_Msk = 0xffffff00

	// SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
	// Position of SCLH field.
	I2C_SCLH_SCLH_Pos = 0x0
	// Bit mask of SCLH field.
	I2C_SCLH_SCLH_Msk = 0xffff
	// Position of RESERVED field.
	I2C_SCLH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_SCLH_RESERVED_Msk = 0xffff0000

	// SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. I2nSCLL and I2nSCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
	// Position of SCLL field.
	I2C_SCLL_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_SCLL_SCLL_Msk = 0xffff
	// Position of RESERVED field.
	I2C_SCLL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_SCLL_RESERVED_Msk = 0xffff0000

	// CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x3
	// Position of AAC field.
	I2C_CONCLR_AAC_Pos = 0x2
	// Bit mask of AAC field.
	I2C_CONCLR_AAC_Msk = 0x4
	// Bit AAC.
	I2C_CONCLR_AAC = 0x4
	// Position of SIC field.
	I2C_CONCLR_SIC_Pos = 0x3
	// Bit mask of SIC field.
	I2C_CONCLR_SIC_Msk = 0x8
	// Bit SIC.
	I2C_CONCLR_SIC = 0x8
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	I2C_CONCLR_RESERVED = 0x10
	// Position of STAC field.
	I2C_CONCLR_STAC_Pos = 0x5
	// Bit mask of STAC field.
	I2C_CONCLR_STAC_Msk = 0x20
	// Bit STAC.
	I2C_CONCLR_STAC = 0x20
	// Position of I2ENC field.
	I2C_CONCLR_I2ENC_Pos = 0x6
	// Bit mask of I2ENC field.
	I2C_CONCLR_I2ENC_Msk = 0x40
	// Bit I2ENC.
	I2C_CONCLR_I2ENC = 0x40
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_CONCLR_RESERVED = 0x80
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0xffffff00

	// MMCTRL: Monitor mode control register.
	// Position of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Pos = 0x0
	// Bit mask of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Msk = 0x1
	// Bit MM_ENA.
	I2C_MMCTRL_MM_ENA = 0x1
	// Monitor mode disabled.
	I2C_MMCTRL_MM_ENA_MONITOR_MODE_DISABLE = 0x0
	// The I2C module will enter monitor mode. In this mode the SDA output will be forced high. This will prevent the I2C module from outputting data of any kind (including ACK) onto the I 2C data bus. Depending on the state of the ENA_SCL bit, the output may be also forced high, preventing the module from having control over the I2C clock line.
	I2C_MMCTRL_MM_ENA_THE_I2C_MODULE_WILL_ = 0x1
	// Position of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Pos = 0x1
	// Bit mask of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Msk = 0x2
	// Bit ENA_SCL.
	I2C_MMCTRL_ENA_SCL = 0x2
	// When this bit is cleared to 0, the SCL output will be forced high when the module is in monitor mode. As described above, this will prevent the module from having any control over the I2C clock line.
	I2C_MMCTRL_ENA_SCL_HIGH = 0x0
	// When this bit is set, the I2C module may exercise the same control over the clock line that it would in normal operation. This means that, acting as a slave peripheral, the I2C module can stretch the clock line (hold it low) until it has had time to respond to an I2C interrupt.[1]
	I2C_MMCTRL_ENA_SCL_NORMAL = 0x1
	// Position of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Pos = 0x2
	// Bit mask of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Msk = 0x4
	// Bit MATCH_ALL.
	I2C_MMCTRL_MATCH_ALL = 0x4
	// When this bit is cleared, an interrupt will only be generated when a match occurs to one of the (up-to) four address registers described above. That is, the module will respond as a normal slave as far as address-recognition is concerned.
	I2C_MMCTRL_MATCH_ALL_MATCH = 0x0
	// When this bit is set to 1 and the I2C is in monitor mode, an interrupt will be generated on ANY address received. This will enable the part to monitor all traffic on the bus.
	I2C_MMCTRL_MATCH_ALL_ANYADDRESS = 0x1
	// Position of RESERVED field.
	I2C_MMCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C_MMCTRL_RESERVED_Msk = 0xfffffff8

	// ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C_ADR_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C_ADR_GC_Msk = 0x1
	// Bit GC.
	I2C_ADR_GC = 0x1
	// Position of Address field.
	I2C_ADR_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C_ADR_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C_ADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_ADR_RESERVED_Msk = 0xffffff00

	// DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the I2DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
	// Position of Data field.
	I2C_DATA_BUFFER_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C_DATA_BUFFER_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Msk = 0xffffff00

	// MASK0: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
	// Position of RESERVED field.
	I2C_MASK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	I2C_MASK_RESERVED = 0x1
	// Position of MASK field.
	I2C_MASK_MASK_Pos = 0x1
	// Bit mask of MASK field.
	I2C_MASK_MASK_Msk = 0xfe
	// Position of RESERVED field.
	I2C_MASK_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0xffffff00
)

// Constants for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOPPED = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_RUNNING = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_MOD_WDRESET_INTERRUPT = 0x0
	// A watchdog timeout will cause a chip reset.
	WWDT_MOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// The watchdog time-out value (TC) can be changed at any time.
	WWDT_MOD_WDPROTECT_NOT_LOCKED = 0x0
	// The watchdog time-out value (TC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_LOCKED = 0x1
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// CLKSEL: Watchdog clock select register.
	// Position of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Pos = 0x0
	// Bit mask of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Msk = 0x1
	// Bit CLKSEL.
	WWDT_CLKSEL_CLKSEL = 0x1
	// IRC
	WWDT_CLKSEL_CLKSEL_IRC = 0x0
	// Watchdog oscillator (WDOSC)
	WWDT_CLKSEL_CLKSEL_WATCHDOG_OSCILLATOR_ = 0x1
	// Position of RESERVED field.
	WWDT_CLKSEL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	WWDT_CLKSEL_RESERVED_Msk = 0x7ffffffe
	// Position of LOCK field.
	WWDT_CLKSEL_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	WWDT_CLKSEL_LOCK_Msk = 0x80000000
	// Bit LOCK.
	WWDT_CLKSEL_LOCK = 0x80000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Constants for USART: USART
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
	// Position of RBR field.
	USART_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	USART_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	USART_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0)
	// Position of THR field.
	USART_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	USART_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	USART_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLLSB field.
	USART_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	USART_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	USART_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLMSB field.
	USART_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	USART_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	USART_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential USART interrupts. (DLAB=0)
	// Position of RBRINTEN field.
	USART_IER_RBRINTEN_Pos = 0x0
	// Bit mask of RBRINTEN field.
	USART_IER_RBRINTEN_Msk = 0x1
	// Bit RBRINTEN.
	USART_IER_RBRINTEN = 0x1
	// Disable the RDA interrupt.
	USART_IER_RBRINTEN_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupt.
	USART_IER_RBRINTEN_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREINTEN field.
	USART_IER_THREINTEN_Pos = 0x1
	// Bit mask of THREINTEN field.
	USART_IER_THREINTEN_Msk = 0x2
	// Bit THREINTEN.
	USART_IER_THREINTEN = 0x2
	// Disable the THRE interrupt.
	USART_IER_THREINTEN_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupt.
	USART_IER_THREINTEN_ENABLE_THE_THRE_INTE = 0x1
	// Position of RLSINTEN field.
	USART_IER_RLSINTEN_Pos = 0x2
	// Bit mask of RLSINTEN field.
	USART_IER_RLSINTEN_Msk = 0x4
	// Bit RLSINTEN.
	USART_IER_RLSINTEN = 0x4
	// Disable the RLS interrupt.
	USART_IER_RLSINTEN_DISABLE_THE_RLS_INTE = 0x0
	// Enable the RLS interrupt.
	USART_IER_RLSINTEN_ENABLE_THE_RLS_INTER = 0x1
	// Position of MSINTEN field.
	USART_IER_MSINTEN_Pos = 0x3
	// Bit mask of MSINTEN field.
	USART_IER_MSINTEN_Msk = 0x8
	// Bit MSINTEN.
	USART_IER_MSINTEN = 0x8
	// Disable the MS interrupt.
	USART_IER_MSINTEN_DISABLE_THE_MS_INTER = 0x0
	// Enable the MS interrupt.
	USART_IER_MSINTEN_ENABLE_THE_MS_INTERR = 0x1
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0xf0
	// Position of ABEOINTEN field.
	USART_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	USART_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	USART_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	USART_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	USART_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	USART_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	USART_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	USART_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	USART_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	USART_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	USART_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	USART_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	USART_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	USART_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	USART_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	USART_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	USART_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	USART_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	USART_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	USART_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt.
	USART_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// 4 - Modem status
	USART_IIR_INTID_4_MODEM_STATUS = 0x0
	// Position of RESERVED field.
	USART_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_IIR_RESERVED_Msk = 0x30
	// Position of FIFOEN field.
	USART_IIR_FIFOEN_Pos = 0x6
	// Bit mask of FIFOEN field.
	USART_IIR_FIFOEN_Msk = 0xc0
	// Position of ABEOINT field.
	USART_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	USART_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	USART_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	USART_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	USART_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	USART_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	USART_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls USART FIFO usage and modes.
	// Position of FIFOEN field.
	USART_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	USART_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	USART_FCR_FIFOEN = 0x1
	// USART FIFOs are disabled. Must not be used in the application.
	USART_FCR_FIFOEN_DISABLED = 0x0
	// Active high enable for both USART Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper USART operation. Any transition on this bit will automatically clear the USART FIFOs.
	USART_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	USART_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	USART_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	USART_FCR_RXFIFORES = 0x2
	// No impact on either of USART FIFOs.
	USART_FCR_RXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[1] will clear all bytes in USART Rx FIFO, reset the pointer logic. This bit is self-clearing.
	USART_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	USART_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	USART_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	USART_FCR_TXFIFORES = 0x4
	// No impact on either of USART FIFOs.
	USART_FCR_TXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[2] will clear all bytes in USART TX FIFO, reset the pointer logic. This bit is self-clearing.
	USART_FCR_TXFIFORES_CLEAR = 0x1
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USART_FCR_RESERVED = 0x8
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0x30
	// Position of RXTL field.
	USART_FCR_RXTL_Pos = 0x6
	// Bit mask of RXTL field.
	USART_FCR_RXTL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	USART_FCR_RXTL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	USART_FCR_RXTL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	USART_FCR_RXTL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	USART_FCR_RXTL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	USART_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	USART_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	USART_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	USART_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	USART_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	USART_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	USART_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	USART_LCR_SBS_Msk = 0x4
	// Bit SBS.
	USART_LCR_SBS = 0x4
	// 1 stop bit.
	USART_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	USART_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	USART_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	USART_LCR_PE_Msk = 0x8
	// Bit PE.
	USART_LCR_PE = 0x8
	// Disable parity generation and checking.
	USART_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	USART_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	USART_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	USART_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	USART_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	USART_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	USART_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	USART_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	USART_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	USART_LCR_BC_Msk = 0x40
	// Bit BC.
	USART_LCR_BC = 0x40
	// Disable break transmission.
	USART_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin USART TXD is forced to logic 0 when LCR[6] is active high.
	USART_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	USART_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	USART_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	USART_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	USART_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	USART_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	USART_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_LCR_RESERVED_Msk = 0xffffff00

	// MCR: Modem Control Register.
	// Position of DTRCTRL field.
	USART_MCR_DTRCTRL_Pos = 0x0
	// Bit mask of DTRCTRL field.
	USART_MCR_DTRCTRL_Msk = 0x1
	// Bit DTRCTRL.
	USART_MCR_DTRCTRL = 0x1
	// Position of RTSCTRL field.
	USART_MCR_RTSCTRL_Pos = 0x1
	// Bit mask of RTSCTRL field.
	USART_MCR_RTSCTRL_Msk = 0x2
	// Bit RTSCTRL.
	USART_MCR_RTSCTRL = 0x2
	// Position of RESERVED field.
	USART_MCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USART_MCR_RESERVED_Msk = 0xc
	// Position of LMS field.
	USART_MCR_LMS_Pos = 0x4
	// Bit mask of LMS field.
	USART_MCR_LMS_Msk = 0x10
	// Bit LMS.
	USART_MCR_LMS = 0x10
	// Disable modem loopback mode.
	USART_MCR_LMS_DISABLE_MODEM_LOOPBA = 0x0
	// Enable modem loopback mode.
	USART_MCR_LMS_ENABLE_MODEM_LOOPBAC = 0x1
	// Position of RESERVED field.
	USART_MCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USART_MCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USART_MCR_RESERVED = 0x20
	// Position of RTSEN field.
	USART_MCR_RTSEN_Pos = 0x6
	// Bit mask of RTSEN field.
	USART_MCR_RTSEN_Msk = 0x40
	// Bit RTSEN.
	USART_MCR_RTSEN = 0x40
	// Disable auto-rts flow control.
	USART_MCR_RTSEN_DISABLE_AUTO_RTS_FLO = 0x0
	// Enable auto-rts flow control.
	USART_MCR_RTSEN_ENABLE_AUTO_RTS_FLOW = 0x1
	// Position of CTSEN field.
	USART_MCR_CTSEN_Pos = 0x7
	// Bit mask of CTSEN field.
	USART_MCR_CTSEN_Msk = 0x80
	// Bit CTSEN.
	USART_MCR_CTSEN = 0x80
	// Disable auto-cts flow control.
	USART_MCR_CTSEN_DISABLE_AUTO_CTS_FLO = 0x0
	// Enable auto-cts flow control.
	USART_MCR_CTSEN_ENABLE_AUTO_CTS_FLOW = 0x1
	// Position of RESERVED field.
	USART_MCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_MCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	USART_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_LSR_RDR_Msk = 0x1
	// Bit RDR.
	USART_LSR_RDR = 0x1
	// RBR is empty.
	USART_LSR_RDR_RBR_IS_EMPTY_ = 0x0
	// RBR contains valid data.
	USART_LSR_RDR_RBR_CONTAINS_VALID_D = 0x1
	// Position of OE field.
	USART_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	USART_LSR_OE_Msk = 0x2
	// Bit OE.
	USART_LSR_OE = 0x2
	// Overrun error status is inactive.
	USART_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	USART_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	USART_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	USART_LSR_PE_Msk = 0x4
	// Bit PE.
	USART_LSR_PE = 0x4
	// Parity error status is inactive.
	USART_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	USART_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	USART_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	USART_LSR_FE_Msk = 0x8
	// Bit FE.
	USART_LSR_FE = 0x8
	// Framing error status is inactive.
	USART_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	USART_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	USART_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	USART_LSR_BI_Msk = 0x10
	// Bit BI.
	USART_LSR_BI = 0x10
	// Break interrupt status is inactive.
	USART_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	USART_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	USART_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	USART_LSR_THRE_Msk = 0x20
	// Bit THRE.
	USART_LSR_THRE = 0x20
	// THR contains valid data.
	USART_LSR_THRE_THR_CONTAINS_VALID_D = 0x0
	// THR is empty.
	USART_LSR_THRE_THR_IS_EMPTY_ = 0x1
	// Position of TEMT field.
	USART_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	USART_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	USART_LSR_TEMT = 0x40
	// THR and/or the TSR contains valid data.
	USART_LSR_TEMT_VALID_D = 0x0
	// THR and the TSR are empty.
	USART_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	USART_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	USART_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	USART_LSR_RXFE = 0x80
	// RBR contains no USART RX errors or FCR[0]=0.
	USART_LSR_RXFE_NO_ERROR = 0x0
	// USART RBR contains at least one USART RX error.
	USART_LSR_RXFE_ERRO = 0x1
	// Position of TXERR field.
	USART_LSR_TXERR_Pos = 0x8
	// Bit mask of TXERR field.
	USART_LSR_TXERR_Msk = 0x100
	// Bit TXERR.
	USART_LSR_TXERR = 0x100
	// Position of RESERVED field.
	USART_LSR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_LSR_RESERVED_Msk = 0xfffffe00

	// MSR: Modem Status Register.
	// Position of DCTS field.
	USART_MSR_DCTS_Pos = 0x0
	// Bit mask of DCTS field.
	USART_MSR_DCTS_Msk = 0x1
	// Bit DCTS.
	USART_MSR_DCTS = 0x1
	// No change detected on modem input, CTS.
	USART_MSR_DCTS_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, CTS.
	USART_MSR_DCTS_STATE_CHANGE_DETECTE = 0x1
	// Position of DDSR field.
	USART_MSR_DDSR_Pos = 0x1
	// Bit mask of DDSR field.
	USART_MSR_DDSR_Msk = 0x2
	// Bit DDSR.
	USART_MSR_DDSR = 0x2
	// No change detected on modem input, DSR.
	USART_MSR_DDSR_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DSR.
	USART_MSR_DDSR_STATE_CHANGE_DETECTE = 0x1
	// Position of TERI field.
	USART_MSR_TERI_Pos = 0x2
	// Bit mask of TERI field.
	USART_MSR_TERI_Msk = 0x4
	// Bit TERI.
	USART_MSR_TERI = 0x4
	// No change detected on modem input, RI.
	USART_MSR_TERI_NO_CHANGE_DETECTED_O = 0x0
	// Low-to-high transition detected on RI.
	USART_MSR_TERI_LOW_TO_HIGH_TRANSITI = 0x1
	// Position of DDCD field.
	USART_MSR_DDCD_Pos = 0x3
	// Bit mask of DDCD field.
	USART_MSR_DDCD_Msk = 0x8
	// Bit DDCD.
	USART_MSR_DDCD = 0x8
	// No change detected on modem input, DCD.
	USART_MSR_DDCD_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DCD.
	USART_MSR_DDCD_STATE_CHANGE_DETECTE = 0x1
	// Position of CTS field.
	USART_MSR_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART_MSR_CTS_Msk = 0x10
	// Bit CTS.
	USART_MSR_CTS = 0x10
	// Position of DSR field.
	USART_MSR_DSR_Pos = 0x5
	// Bit mask of DSR field.
	USART_MSR_DSR_Msk = 0x20
	// Bit DSR.
	USART_MSR_DSR = 0x20
	// Position of RI field.
	USART_MSR_RI_Pos = 0x6
	// Bit mask of RI field.
	USART_MSR_RI_Msk = 0x40
	// Bit RI.
	USART_MSR_RI = 0x40
	// Position of DCD field.
	USART_MSR_DCD_Pos = 0x7
	// Bit mask of DCD field.
	USART_MSR_DCD_Msk = 0x80
	// Bit DCD.
	USART_MSR_DCD = 0x80
	// Position of RESERVED field.
	USART_MSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_MSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. Eight-bit temporary storage for software.
	// Position of PAD field.
	USART_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	USART_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	USART_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	USART_ACR_START_Pos = 0x0
	// Bit mask of START field.
	USART_ACR_START_Msk = 0x1
	// Bit START.
	USART_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	USART_ACR_START_AUTO_BAUD_STOP_AUTO = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	USART_ACR_START_AUTO_BAUD_START_AUT = 0x1
	// Position of MODE field.
	USART_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	USART_ACR_MODE_Msk = 0x2
	// Bit MODE.
	USART_ACR_MODE = 0x2
	// Mode 0.
	USART_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	USART_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	USART_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	USART_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	USART_ACR_AUTORESTART = 0x4
	// No restart
	USART_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart in case of time-out (counter restarts at next USART Rx falling edge)
	USART_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	USART_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	USART_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	USART_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	USART_ACR_ABEOINTCLR = 0x100
	// Writing a 0 has no impact.
	USART_ACR_ABEOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	USART_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	USART_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	USART_ACR_ABTOINTCLR = 0x200
	// Writing a 0 has no impact.
	USART_ACR_ABTOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	USART_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_ACR_RESERVED_Msk = 0xfffffc00

	// ICR: IrDA Control Register. Enables and configures the IrDA (remote control) mode.
	// Position of IRDAEN field.
	USART_ICR_IRDAEN_Pos = 0x0
	// Bit mask of IRDAEN field.
	USART_ICR_IRDAEN_Msk = 0x1
	// Bit IRDAEN.
	USART_ICR_IRDAEN = 0x1
	// IrDA mode is disabled, USARTn acts as a standard USART.
	USART_ICR_IRDAEN_IRDA_MODE_IS_DISABLE = 0x0
	// IrDA mode is enabled.
	USART_ICR_IRDAEN_IRDA_MODE_IS_ENABLED = 0x1
	// Position of IRDAINV field.
	USART_ICR_IRDAINV_Pos = 0x1
	// Bit mask of IRDAINV field.
	USART_ICR_IRDAINV_Msk = 0x2
	// Bit IRDAINV.
	USART_ICR_IRDAINV = 0x2
	// The serial input is not inverted.
	USART_ICR_IRDAINV_INVERTED = 0x0
	// The serial input is inverted. This has no effect on the serial output.
	USART_ICR_IRDAINV_NOT_INVERTED = 0x1
	// Position of FIXPULSEEN field.
	USART_ICR_FIXPULSEEN_Pos = 0x2
	// Bit mask of FIXPULSEEN field.
	USART_ICR_FIXPULSEEN_Msk = 0x4
	// Bit FIXPULSEEN.
	USART_ICR_FIXPULSEEN = 0x4
	// IrDA fixed pulse width mode disabled.
	USART_ICR_FIXPULSEEN_DISABLED = 0x0
	// IrDA fixed pulse width mode enabled.
	USART_ICR_FIXPULSEEN_ENABLED = 0x1
	// Position of PULSEDIV field.
	USART_ICR_PULSEDIV_Pos = 0x3
	// Bit mask of PULSEDIV field.
	USART_ICR_PULSEDIV_Msk = 0x38
	// 3 / (16 x baud rate)
	USART_ICR_PULSEDIV_3_DIV_16_X_BAUD_RATE = 0x0
	// 2 x TPCLK
	USART_ICR_PULSEDIV_2_X_TPCLK = 0x1
	// 4 x TPCLK
	USART_ICR_PULSEDIV_4_X_TPCLK = 0x2
	// 8 x TPCLK
	USART_ICR_PULSEDIV_8_X_TPCLK = 0x3
	// 16 x TPCLK
	USART_ICR_PULSEDIV_16_X_TPCLK = 0x4
	// 32 x TPCLK
	USART_ICR_PULSEDIV_32_X_TPCLK = 0x5
	// 64 x TPCLK
	USART_ICR_PULSEDIV_64_X_TPCLK = 0x6
	// 128 x TPCLK
	USART_ICR_PULSEDIV_128_X_TPCLK = 0x7
	// Position of RESERVED field.
	USART_ICR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART_ICR_RESERVED_Msk = 0xffffffc0

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	USART_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	USART_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	USART_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	USART_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	USART_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_FDR_RESERVED_Msk = 0xffffff00

	// OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
	// Position of RESERVED field.
	USART_OSR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART_OSR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART_OSR_RESERVED = 0x1
	// Position of OSFRAC field.
	USART_OSR_OSFRAC_Pos = 0x1
	// Bit mask of OSFRAC field.
	USART_OSR_OSFRAC_Msk = 0xe
	// Position of OSINT field.
	USART_OSR_OSINT_Pos = 0x4
	// Bit mask of OSINT field.
	USART_OSR_OSINT_Msk = 0xf0
	// Position of FDINT field.
	USART_OSR_FDINT_Pos = 0x8
	// Bit mask of FDINT field.
	USART_OSR_FDINT_Msk = 0x7f00
	// Position of RESERVED field.
	USART_OSR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USART_OSR_RESERVED_Msk = 0xffff8000

	// TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
	// Position of RESERVED field.
	USART_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	USART_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	USART_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	USART_TER_TXEN = 0x80
	// Position of RESERVED field.
	USART_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_TER_RESERVED_Msk = 0xffffff00

	// HDEN: Half duplex enable register.
	// Position of HDEN field.
	USART_HDEN_HDEN_Pos = 0x0
	// Bit mask of HDEN field.
	USART_HDEN_HDEN_Msk = 0x1
	// Bit HDEN.
	USART_HDEN_HDEN = 0x1
	// Disable half-duplex mode.
	USART_HDEN_HDEN_DISABLE_HALF_DUPLEX_ = 0x0
	// Enable half-duplex mode.
	USART_HDEN_HDEN_ENABLE_HALF_DUPLEX_M = 0x1
	// Position of RESERVED field.
	USART_HDEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_HDEN_RESERVED_Msk = 0xfffffffe

	// SCICTRL: Smart Card Interface Control register. Enables and configures the Smart Card Interface feature.
	// Position of SCIEN field.
	USART_SCICTRL_SCIEN_Pos = 0x0
	// Bit mask of SCIEN field.
	USART_SCICTRL_SCIEN_Msk = 0x1
	// Bit SCIEN.
	USART_SCICTRL_SCIEN = 0x1
	// Smart card interface disabled.
	USART_SCICTRL_SCIEN_SMART_CARD_INTERFACE = 0x0
	// Asynchronous half duplex smart card interface is enabled.
	USART_SCICTRL_SCIEN_ASYNCHRONOUS_HALF_DU = 0x1
	// Position of NACKDIS field.
	USART_SCICTRL_NACKDIS_Pos = 0x1
	// Bit mask of NACKDIS field.
	USART_SCICTRL_NACKDIS_Msk = 0x2
	// Bit NACKDIS.
	USART_SCICTRL_NACKDIS = 0x2
	// A NACK response is enabled.
	USART_SCICTRL_NACKDIS_ENABLED = 0x0
	// A NACK response is inhibited.
	USART_SCICTRL_NACKDIS_DISABLED = 0x1
	// Position of PROTSEL field.
	USART_SCICTRL_PROTSEL_Pos = 0x2
	// Bit mask of PROTSEL field.
	USART_SCICTRL_PROTSEL_Msk = 0x4
	// Bit PROTSEL.
	USART_SCICTRL_PROTSEL = 0x4
	// T = 0
	USART_SCICTRL_PROTSEL_T_EQ_0 = 0x0
	// T = 1
	USART_SCICTRL_PROTSEL_T_EQ_1 = 0x1
	// Position of RESERVED field.
	USART_SCICTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_SCICTRL_RESERVED_Msk = 0x18
	// Position of TXRETRY field.
	USART_SCICTRL_TXRETRY_Pos = 0x5
	// Bit mask of TXRETRY field.
	USART_SCICTRL_TXRETRY_Msk = 0xe0
	// Position of XTRAGUARD field.
	USART_SCICTRL_XTRAGUARD_Pos = 0x8
	// Bit mask of XTRAGUARD field.
	USART_SCICTRL_XTRAGUARD_Msk = 0xff00
	// Position of RESERVED field.
	USART_SCICTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_SCICTRL_RESERVED_Msk = 0xffff0000

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	USART_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	USART_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	USART_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	USART_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt.
	USART_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	USART_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	USART_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	USART_RS485CTRL_RXDIS = 0x2
	// The receiver is enabled.
	USART_RS485CTRL_RXDIS_THE_RECEIVER_IS_ENAB = 0x0
	// The receiver is disabled.
	USART_RS485CTRL_RXDIS_THE_RECEIVER_IS_DISA = 0x1
	// Position of AADEN field.
	USART_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	USART_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	USART_RS485CTRL_AADEN = 0x4
	// Position of SEL field.
	USART_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	USART_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	USART_RS485CTRL_SEL = 0x8
	// If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	USART_RS485CTRL_SEL_RTS = 0x0
	// If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	USART_RS485CTRL_SEL_DTR = 0x1
	// Position of DCTRL field.
	USART_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	USART_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	USART_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	USART_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	USART_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	USART_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	USART_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	USART_RS485CTRL_OINV = 0x20
	// The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	USART_RS485CTRL_OINV_LOW = 0x0
	// The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	USART_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	USART_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	USART_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	USART_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	USART_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	USART_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	USART_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	USART_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RS485DLY_RESERVED_Msk = 0xffffff00

	// SYNCCTRL: Synchronous mode control register.
	// Position of SYNC field.
	USART_SYNCCTRL_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	USART_SYNCCTRL_SYNC_Msk = 0x1
	// Bit SYNC.
	USART_SYNCCTRL_SYNC = 0x1
	// Disabled
	USART_SYNCCTRL_SYNC_DISABLED = 0x0
	// Enabled
	USART_SYNCCTRL_SYNC_ENABLED = 0x1
	// Position of CSRC field.
	USART_SYNCCTRL_CSRC_Pos = 0x1
	// Bit mask of CSRC field.
	USART_SYNCCTRL_CSRC_Msk = 0x2
	// Bit CSRC.
	USART_SYNCCTRL_CSRC = 0x2
	// Synchronous slave mode (SCLK in)
	USART_SYNCCTRL_CSRC_SYNCHRONOUS_SLAVE_MO = 0x0
	// Synchronous master mode (SCLK out)
	USART_SYNCCTRL_CSRC_SYNCHRONOUS_MASTER_M = 0x1
	// Position of FES field.
	USART_SYNCCTRL_FES_Pos = 0x2
	// Bit mask of FES field.
	USART_SYNCCTRL_FES_Msk = 0x4
	// Bit FES.
	USART_SYNCCTRL_FES = 0x4
	// RxD is sampled on the rising edge of SCLK
	USART_SYNCCTRL_FES_RISING = 0x0
	// RxD is sampled on the falling edge of SCLK
	USART_SYNCCTRL_FES_FALLING = 0x1
	// Position of TSBYPASS field.
	USART_SYNCCTRL_TSBYPASS_Pos = 0x3
	// Bit mask of TSBYPASS field.
	USART_SYNCCTRL_TSBYPASS_Msk = 0x8
	// Bit TSBYPASS.
	USART_SYNCCTRL_TSBYPASS = 0x8
	// The input clock is synchronized prior to being used in clock edge detection logic
	USART_SYNCCTRL_TSBYPASS_SYNC = 0x0
	// The input clock is not synchronized prior to being used in clock edge detection logic. This allows for a high er input clock rate at the expense of potential metastability.
	USART_SYNCCTRL_TSBYPASS_NOSYNC = 0x1
	// Position of CSCEN field.
	USART_SYNCCTRL_CSCEN_Pos = 0x4
	// Bit mask of CSCEN field.
	USART_SYNCCTRL_CSCEN_Msk = 0x10
	// Bit CSCEN.
	USART_SYNCCTRL_CSCEN = 0x10
	// SCLK cycles only when characters are being sent on TxD
	USART_SYNCCTRL_CSCEN_SCLK_CYCLES_ONLY_WHE = 0x0
	// SCLK runs continuously (characters can be received on RxD independently from transmission on TxD)
	USART_SYNCCTRL_CSCEN_SCLK_RUNS_CONTINUOUS = 0x1
	// Position of SSDIS field.
	USART_SYNCCTRL_SSDIS_Pos = 0x5
	// Bit mask of SSDIS field.
	USART_SYNCCTRL_SSDIS_Msk = 0x20
	// Bit SSDIS.
	USART_SYNCCTRL_SSDIS = 0x20
	// Send start and stop bits as in other modes.
	USART_SYNCCTRL_SSDIS_SEND = 0x0
	// Do not send start/stop bits.
	USART_SYNCCTRL_SSDIS_DO_NOT_SEND = 0x1
	// Position of CCCLR field.
	USART_SYNCCTRL_CCCLR_Pos = 0x6
	// Bit mask of CCCLR field.
	USART_SYNCCTRL_CCCLR_Msk = 0x40
	// Bit CCCLR.
	USART_SYNCCTRL_CCCLR = 0x40
	// CSCEN is under software control.
	USART_SYNCCTRL_CCCLR_CSCEN_IS_UNDER_SOFTW = 0x0
	// Hardware clears CSCEN after each character is received.
	USART_SYNCCTRL_CCCLR_HARDWARE_CLEARS_CSCE = 0x1
	// Position of RESERVED field.
	USART_SYNCCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_SYNCCTRL_RESERVED_Msk = 0xffffff80
)

// Constants for CT16B0: 16-bit counter/timers CT16B0/1
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT16B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT16B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT16B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT16B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT16B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT16B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT16B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT16B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT16B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT16B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT16B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT16B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT16B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT16B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT16B0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT16B0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT16B0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT16B0_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT16B0_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT16B0_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT16B0_IR_CR2INT = 0x40
	// Position of CR3INT field.
	CT16B0_IR_CR3INT_Pos = 0x7
	// Bit mask of CR3INT field.
	CT16B0_IR_CR3INT_Msk = 0x80
	// Bit CR3INT.
	CT16B0_IR_CR3INT = 0x80
	// Position of RESERVED field.
	CT16B0_IR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT16B0_IR_RESERVED_Msk = 0xffffff00

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT16B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT16B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT16B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT16B0_TCR_CEN_THE_COUNTERS_ARE_DIS = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT16B0_TCR_CEN_THE_TIMER_COUNTER_AN = 0x1
	// Position of CRST field.
	CT16B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT16B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT16B0_TCR_CRST = 0x2
	// Do nothing.
	CT16B0_TCR_CRST_DO_NOTHING_ = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT16B0_TCR_CRST_THE_TIMER_COUNTER_AN = 0x1
	// Position of RESERVED field.
	CT16B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT16B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT16B0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT16B0_TC_TC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_TC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_TC_RESERVED_Msk = 0xffff0000

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT16B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT16B0_PR_PCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PR_RESERVED_Msk = 0xffff0000

	// PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT16B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT16B0_PC_PC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PC_RESERVED_Msk = 0xffff0000

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT16B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT16B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT16B0_MCR_MR0I = 0x1
	// Enabled
	CT16B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT16B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT16B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT16B0_MCR_MR0R = 0x2
	// Enabled
	CT16B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT16B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT16B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT16B0_MCR_MR0S = 0x4
	// Enabled
	CT16B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT16B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT16B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT16B0_MCR_MR1I = 0x8
	// Enabled
	CT16B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT16B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT16B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT16B0_MCR_MR1R = 0x10
	// Enabled
	CT16B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT16B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT16B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT16B0_MCR_MR1S = 0x20
	// Enabled
	CT16B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT16B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT16B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT16B0_MCR_MR2I = 0x40
	// Enabled
	CT16B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT16B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT16B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT16B0_MCR_MR2R = 0x80
	// Enabled
	CT16B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT16B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT16B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT16B0_MCR_MR2S = 0x100
	// Enabled
	CT16B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT16B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT16B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT16B0_MCR_MR3I = 0x200
	// Enabled
	CT16B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT16B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT16B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT16B0_MCR_MR3R = 0x400
	// Enabled
	CT16B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT16B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT16B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT16B0_MCR_MR3S = 0x800
	// Enabled
	CT16B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
	// Position of MATCH field.
	CT16B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT16B0_MR_MATCH_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_MR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_MR_RESERVED_Msk = 0xffff0000

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT16B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT16B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT16B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT16B0_CCR_CAP0RE_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP0RE_DISABLED_ = 0x0
	// Position of CAP0FE field.
	CT16B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT16B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT16B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT16B0_CCR_CAP0FE_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP0FE_DISABLED_ = 0x0
	// Position of CAP0I field.
	CT16B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT16B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT16B0_CCR_CAP0I = 0x4
	// Enabled.
	CT16B0_CCR_CAP0I_ENABLED_ = 0x1
	// Disabled.
	CT16B0_CCR_CAP0I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0xfffffff8

	// CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CT16B0_CAP input.
	// Position of CAP field.
	CT16B0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B0_CR_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_CR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_CR_RESERVED_Msk = 0xffff0000

	// EMR: External Match Register. The EMR controls the match function and the external match pins
	// Position of EM0 field.
	CT16B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT16B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT16B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT16B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT16B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT16B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT16B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT16B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT16B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT16B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT16B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT16B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT16B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT16B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT16B0_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bi_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bi_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	CT16B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT16B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT16B0_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bi_MAT1 pin is LOW if pinned out).
	CT16B0_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bi_MAT1 pin is HIGH if pinned out).
	CT16B0_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	CT16B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT16B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT16B0_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bi_MAT2 pin is LOW if pinned out).
	CT16B0_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bi_MAT2 pin is HIGH if pinned out).
	CT16B0_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	CT16B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT16B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT16B0_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT16Bi_MAT3 pin is LOW if pinned out).
	CT16B0_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT16Bi_MAT3 pin is HIGH if pinned out).
	CT16B0_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	CT16B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT16B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT16B0_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT16B0_CTCR_CTM_TIMER_MODE_EVERY_RI = 0x0
	// Counter Mode: TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_RISING_EDGE = 0x1
	// Counter Mode: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_FALLING_EDGE = 0x2
	// Counter Mode: TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_BOTH_EDGES = 0x3
	// Position of CIS field.
	CT16B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT16B0_CTCR_CIS_Msk = 0xc
	// CT16Bn_CAP0
	CT16B0_CTCR_CIS_CT16BN_CAP0 = 0x0
	// Position of ENCC field.
	CT16B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT16B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT16B0_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT16B0_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT16B0_CTCR_SELCC_Msk = 0xe0
	// Rising Edge of CAP0 clears the timer (if bit 4 is set)
	CT16B0_CTCR_SELCC_RISING_EDGE_OF_CAP0_ = 0x0
	// Falling Edge of CAP0 clears the timer (if bit 4 is set)
	CT16B0_CTCR_SELCC_FALLING_EDGE_OF_CAP0 = 0x1
	// Position of RESERVED field.
	CT16B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT16B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT16B0_PWMC_PWMEN0 = 0x1
	// CT16Bi_MAT0 is controlled by EM0.
	CT16B0_PWMC_PWMEN0_EM0 = 0x0
	// PWM mode is enabled for CT16Bi_MAT0.
	CT16B0_PWMC_PWMEN0_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT16B0_PWMC_PWMEN1 = 0x2
	// CT16Bi_MAT01 is controlled by EM1.
	CT16B0_PWMC_PWMEN1_EM1 = 0x0
	// PWM mode is enabled for CT16Bi_MAT1.
	CT16B0_PWMC_PWMEN1_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT16B0_PWMC_PWMEN2 = 0x4
	// CT16Bi_MAT2 is controlled by EM2.
	CT16B0_PWMC_PWMEN2_EM2 = 0x0
	// PWM mode is enabled for CT16Bi_MAT2.
	CT16B0_PWMC_PWMEN2_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT16B0_PWMC_PWMEN3 = 0x8
	// CT16Bi_MAT3 is controlled by EM3.
	CT16B0_PWMC_PWMEN3_EM3 = 0x0
	// PWM mode is enabled for CT16Bi_MAT3.
	CT16B0_PWMC_PWMEN3_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CT16B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Constants for CT32B0: 32-bit counter/timers CT32B0/1
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT32B0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT32B0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT32B0_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT32B0_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT32B0_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT32B0_IR_CR2INT = 0x40
	// Position of CR3INT field.
	CT32B0_IR_CR3INT_Pos = 0x7
	// Bit mask of CR3INT field.
	CT32B0_IR_CR3INT_Msk = 0x80
	// Bit CR3INT.
	CT32B0_IR_CR3INT = 0x80
	// Position of RESERVED field.
	CT32B0_IR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B0_IR_RESERVED_Msk = 0xffffff00

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT32B0_TCR_CEN_THE_COUNTERS_ARE_DIS = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT32B0_TCR_CEN_THE_TIMER_COUNTER_AN = 0x1
	// Position of CRST field.
	CT32B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B0_TCR_CRST = 0x2
	// Do nothing.
	CT32B0_TCR_CRST_DO_NOTHING_ = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT32B0_TCR_CRST_THE_TIMER_COUNTER_AN = 0x1
	// Position of RESERVED field.
	CT32B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	CT32B0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	CT32B0_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT32B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT32B0_PR_PCVAL_Msk = 0xffffffff

	// PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B0_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B0_MCR_MR0I = 0x1
	// Enabled
	CT32B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT32B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B0_MCR_MR0R = 0x2
	// Enabled
	CT32B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT32B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B0_MCR_MR0S = 0x4
	// Enabled
	CT32B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT32B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B0_MCR_MR1I = 0x8
	// Enabled
	CT32B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT32B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B0_MCR_MR1R = 0x10
	// Enabled
	CT32B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT32B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B0_MCR_MR1S = 0x20
	// Enabled
	CT32B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT32B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B0_MCR_MR2I = 0x40
	// Enabled
	CT32B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT32B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B0_MCR_MR2R = 0x80
	// Enabled
	CT32B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT32B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B0_MCR_MR2S = 0x100
	// Enabled
	CT32B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT32B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B0_MCR_MR3I = 0x200
	// Enabled
	CT32B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT32B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B0_MCR_MR3R = 0x400
	// Enabled
	CT32B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT32B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B0_MCR_MR3S = 0x800
	// Enabled
	CT32B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC.
	// Position of MATCH field.
	CT32B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B0_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT32B0_CCR_CAP0RE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP0RE_DISABLED_ = 0x0
	// Position of CAP0FE field.
	CT32B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT32B0_CCR_CAP0FE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP0FE_DISABLED_ = 0x0
	// Position of CAP0I field.
	CT32B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B0_CCR_CAP0I = 0x4
	// Enabled.
	CT32B0_CCR_CAP0I_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP0I_DISABLED_ = 0x0
	// Position of CAP1RE field.
	CT32B0_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT32B0_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT32B0_CCR_CAP1RE = 0x8
	// Enabled.
	CT32B0_CCR_CAP1RE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP1RE_DISABLED_ = 0x0
	// Position of CAP1FE field.
	CT32B0_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT32B0_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT32B0_CCR_CAP1FE = 0x10
	// Enabled.
	CT32B0_CCR_CAP1FE_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP1FE_DISABLED_ = 0x0
	// Position of CAP1I field.
	CT32B0_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT32B0_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT32B0_CCR_CAP1I = 0x20
	// Enabled.
	CT32B0_CCR_CAP1I_ENABLED_ = 0x1
	// Disabled.
	CT32B0_CCR_CAP1I_DISABLED_ = 0x0
	// Position of RESERVED field.
	CT32B0_CCR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CT32B0_CCR_RESERVED_Msk = 0xffffffc0

	// CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CT32B_CAP0 input.
	// Position of CAP field.
	CT32B0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B0_CR_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
	// Position of EM0 field.
	CT32B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B0_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	CT32B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B0_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT1 pin is LOW if pinned out).
	CT32B0_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT1 pin is HIGH if pinned out).
	CT32B0_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	CT32B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B0_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT2 pin is LOW if pinned out).
	CT32B0_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT2 pin is HIGH if pinned out).
	CT32B0_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	CT32B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B0_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT3 pin is LOW if pinned out).
	CT32B0_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT3 pin is HIGH if pinned out).
	CT32B0_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	CT32B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT32B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT32B0_CTCR_CTM_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	CT32B0_CTCR_CTM_TIMER_MODE_EVERY_RI = 0x0
	// Counter Mode: TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_RISING = 0x1
	// Counter Mode: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_FALLING = 0x2
	// Counter Mode: TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_BOTHEDGES = 0x3
	// Position of CIS field.
	CT32B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT32B0_CTCR_CIS_Msk = 0xc
	// CT32Bn_CAP0
	CT32B0_CTCR_CIS_CT32BN_CAP0 = 0x0
	// CT32Bn_CAP1
	CT32B0_CTCR_CIS_CT32BN_CAP1 = 0x1
	// Position of ENCC field.
	CT32B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT32B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT32B0_CTCR_ENCC = 0x10
	// Position of SElCC field.
	CT32B0_CTCR_SElCC_Pos = 0x5
	// Bit mask of SElCC field.
	CT32B0_CTCR_SElCC_Msk = 0xe0
	// Rising Edge of CAP0 clears the timer (if bit 4 is set)
	CT32B0_CTCR_SElCC_RISING_EDGE_OF_CAP0_ = 0x0
	// Falling Edge of CAP0 clears the timer (if bit 4 is set)
	CT32B0_CTCR_SElCC_FALLING_EDGE_OF_CAP0 = 0x1
	// Rising Edge of CAP1 clears the timer (if bit 4 is set)
	CT32B0_CTCR_SElCC_RISING_EDGE_OF_CAP1_ = 0x2
	// Falling Edge of CAP1 clears the timer (if bit 4 is set)
	CT32B0_CTCR_SElCC_FALLING_EDGE_OF_CAP1 = 0x3
	// Position of RESERVED field.
	CT32B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B0_PWMC_PWMEN0 = 0x1
	// CT32Bi_MAT0 is controlled by EM0.
	CT32B0_PWMC_PWMEN0_EM0 = 0x0
	// PWM mode is enabled for CT32Bi_MAT0.
	CT32B0_PWMC_PWMEN0_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B0_PWMC_PWMEN1 = 0x2
	// CT32Bi_MAT01 is controlled by EM1.
	CT32B0_PWMC_PWMEN1_EM1 = 0x0
	// PWM mode is enabled for CT32Bi_MAT1.
	CT32B0_PWMC_PWMEN1_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B0_PWMC_PWMEN2 = 0x4
	// CT32Bi_MAT2 is controlled by EM2.
	CT32B0_PWMC_PWMEN2_EM2 = 0x0
	// PWM mode is enabled for CT32Bi_MAT2.
	CT32B0_PWMC_PWMEN2_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B0_PWMC_PWMEN3 = 0x8
	// CT32Bi_MAT3 is controlled by EM3.
	CT32B0_PWMC_PWMEN3_EM3 = 0x0
	// PWM mode is enabled for CT132Bi_MAT3.
	CT32B0_PWMC_PWMEN3_PWM_MODE_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CT32B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Constants for ADC: ADC
const (
	// CR: A/D Control Register. The CR register must be written to select the operating mode before A/D conversion can occur.
	// Position of SEL field.
	ADC_CR_SEL_Pos = 0x0
	// Bit mask of SEL field.
	ADC_CR_SEL_Msk = 0xff
	// Position of CLKDIV field.
	ADC_CR_CLKDIV_Pos = 0x8
	// Bit mask of CLKDIV field.
	ADC_CR_CLKDIV_Msk = 0xff00
	// Position of BURST field.
	ADC_CR_BURST_Pos = 0x10
	// Bit mask of BURST field.
	ADC_CR_BURST_Msk = 0x10000
	// Bit BURST.
	ADC_CR_BURST = 0x10000
	// Software-controlled mode: Conversions are software-controlled and require 11 clocks.
	ADC_CR_BURST_SOFTWARE_CONTROLLED_ = 0x0
	// Hardware scan mode: The AD converter does repeated conversions at the rate selected by the CLKS field, scanning (if necessary) through the pins selected by 1s in the SEL field. The first conversion after the start corresponds to the least-significant bit set to 1 in the SEL field, then the next higher bits (pins) set to 1 are scanned if applicable. Repeated conversions can be terminated by clearing this bit, but the conversion in progress when this bit is cleared will be completed. If bit 20 in this register is set (single-burst mode), hardware clears this bit automatically after one set of conversions on all of the selected channels.
	ADC_CR_BURST_HARDWARE_SCAN_MODE_ = 0x1
	// Position of CLKS field.
	ADC_CR_CLKS_Pos = 0x11
	// Bit mask of CLKS field.
	ADC_CR_CLKS_Msk = 0xe0000
	// 11 clocks / 10 bits
	ADC_CR_CLKS_11_CLOCKS = 0x0
	// 10 clocks / 9 bits
	ADC_CR_CLKS_10_CLOCKS = 0x1
	// 9 clocks / 8 bits
	ADC_CR_CLKS_9_CLOCKS = 0x2
	// 8 clocks / 7 bits
	ADC_CR_CLKS_8_CLOCKS = 0x3
	// 7 clocks / 6 bits
	ADC_CR_CLKS_7_CLOCKS = 0x4
	// 6 clocks / 5 bits
	ADC_CR_CLKS_6_CLOCK = 0x5
	// 5 clocks / 4 bits
	ADC_CR_CLKS_5_CLOCKS = 0x6
	// 4 clocks / 3 bits
	ADC_CR_CLKS_4_CLOCKS = 0x7
	// Position of SINGLEBURST field.
	ADC_CR_SINGLEBURST_Pos = 0x14
	// Bit mask of SINGLEBURST field.
	ADC_CR_SINGLEBURST_Msk = 0x100000
	// Bit SINGLEBURST.
	ADC_CR_SINGLEBURST = 0x100000
	// Continuous. Burst mode can only be terminated via a software write to clear bit 16 in this register.
	ADC_CR_SINGLEBURST_CONTINUOUS_BURST = 0x0
	// Single-burst. When the burst mode is selected by writing a 1 to bit 16 in this register, the ADC cycles through a single set of conversions on the selection of channels specified in the SEL field. Once the conversion has been completed on each selected channel, bit 16 is automatically cleared and the conversions stop until a new trigger event occurs.
	ADC_CR_SINGLEBURST_SINGLE_BURST = 0x1
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0x600000
	// Position of START field.
	ADC_CR_START_Pos = 0x17
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x7800000
	// No start (this value should be used when clearing PDN to 0).
	ADC_CR_START_NO_START_THIS_VALUE = 0x0
	// Start conversion now.
	ADC_CR_START_START_CONVERSION_NOW = 0x2
	// Position of EDGE field.
	ADC_CR_EDGE_Pos = 0x1b
	// Bit mask of EDGE field.
	ADC_CR_EDGE_Msk = 0x8000000
	// Bit EDGE.
	ADC_CR_EDGE = 0x8000000
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xf0000000

	// GDR: A/D Global Data Register. Contains the result of the most recent A/D conversion.
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x3f
	// Position of V_VREF field.
	ADC_GDR_V_VREF_Pos = 0x6
	// Bit mask of V_VREF field.
	ADC_GDR_V_VREF_Msk = 0xffc0
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xff0000
	// Position of CHN field.
	ADC_GDR_CHN_Pos = 0x18
	// Bit mask of CHN field.
	ADC_GDR_CHN_Msk = 0x7000000
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x38000000
	// Position of OVERRUN field.
	ADC_GDR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_GDR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_GDR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_GDR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_GDR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_GDR_DONE = 0x80000000

	// SEL: A/D Select Register. Selects between external pins and internal sources.
	// Position of RESERVED field.
	ADC_SEL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEL_RESERVED_Msk = 0x3ff
	// Position of AD5SEL field.
	ADC_SEL_AD5SEL_Pos = 0xa
	// Bit mask of AD5SEL field.
	ADC_SEL_AD5SEL_Msk = 0xc00
	// AD5 pin
	ADC_SEL_AD5SEL_AD5_PIN = 0x0
	// No connection or load
	ADC_SEL_AD5SEL_NO_CONNECTION_OR_LOA = 0x1
	// Core voltage regulator output (1.2 to 1.8V)
	ADC_SEL_AD5SEL_CORE_VOLTAGE_REGULAT = 0x2
	// Reserved. Do not program this value.
	ADC_SEL_AD5SEL_RESERVED_DO_NOT_PRO = 0x3
	// Position of AD6SEL field.
	ADC_SEL_AD6SEL_Pos = 0xc
	// Bit mask of AD6SEL field.
	ADC_SEL_AD6SEL_Msk = 0x3000
	// AD6 pin
	ADC_SEL_AD6SEL_AD6_PIN = 0x0
	// No connection or load
	ADC_SEL_AD6SEL_NO_CONNECTION_OR_LOA = 0x1
	// Internal voltage reference
	ADC_SEL_AD6SEL_INTERNAL_VOLTAGE_REF = 0x2
	// Reserved. Do not program this value.
	ADC_SEL_AD6SEL_RESERVED_DO_NOT_PRO = 0x3
	// Position of AD7SEL field.
	ADC_SEL_AD7SEL_Pos = 0xe
	// Bit mask of AD7SEL field.
	ADC_SEL_AD7SEL_Msk = 0xc000
	// AD7 pin
	ADC_SEL_AD7SEL_AD7_PIN = 0x0
	// No connection or load
	ADC_SEL_AD7SEL_NO_CONNECTION_OR_LOA = 0x1
	// Temperature sensor
	ADC_SEL_AD7SEL_TEMPERATURE_SENSOR = 0x2
	// Reserved. Do not program this value.
	ADC_SEL_AD7SEL_RESERVED_DO_NOT_PRO = 0x3
	// Position of RESERVED field.
	ADC_SEL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_SEL_RESERVED_Msk = 0xffff0000

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
	// Position of ADINTEN field.
	ADC_INTEN_ADINTEN_Pos = 0x0
	// Bit mask of ADINTEN field.
	ADC_INTEN_ADINTEN_Msk = 0xff
	// Position of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Pos = 0x8
	// Bit mask of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Msk = 0x100
	// Bit ADGINTEN.
	ADC_INTEN_ADGINTEN = 0x100
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xfffffe00

	// DR0: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3f
	// Position of V_VREF field.
	ADC_DR_V_VREF_Pos = 0x6
	// Bit mask of V_VREF field.
	ADC_DR_V_VREF_Msk = 0xffc0
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3fff0000
	// Position of OVERRUN field.
	ADC_DR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_DR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_DR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_DR_DONE = 0x80000000

	// STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt flag.
	// Position of DONE field.
	ADC_STAT_DONE_Pos = 0x0
	// Bit mask of DONE field.
	ADC_STAT_DONE_Msk = 0xff
	// Position of OVERRUN field.
	ADC_STAT_OVERRUN_Pos = 0x8
	// Bit mask of OVERRUN field.
	ADC_STAT_OVERRUN_Msk = 0xff00
	// Position of ADINT field.
	ADC_STAT_ADINT_Pos = 0x10
	// Bit mask of ADINT field.
	ADC_STAT_ADINT_Msk = 0x10000
	// Bit ADINT.
	ADC_STAT_ADINT = 0x10000
	// Position of RESERVED field.
	ADC_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ADC_STAT_RESERVED_Msk = 0xfffe0000
)

// Constants for DAC: DAC
const (
	// CR: D/A control register
	// Position of RESERVED field.
	DAC_CR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DAC_CR_RESERVED_Msk = 0x3f
	// Position of VALUE field.
	DAC_CR_VALUE_Pos = 0x6
	// Bit mask of VALUE field.
	DAC_CR_VALUE_Msk = 0xffc0
	// Position of BIAS field.
	DAC_CR_BIAS_Pos = 0x10
	// Bit mask of BIAS field.
	DAC_CR_BIAS_Msk = 0x10000
	// Bit BIAS.
	DAC_CR_BIAS = 0x10000
	// The settling time of the DAC is 1 us max, and the maximum current is 700 uA. This allows a maximum update rate of 1 MHz.
	DAC_CR_BIAS_FAST = 0x0
	// The settling time of the DAC is 2.5 us and the maximum current is 350 uA. This allows a maximum update rate of 400 kHz.
	DAC_CR_BIAS_SLOW = 0x1
	// Position of TRIG field.
	DAC_CR_TRIG_Pos = 0x11
	// Bit mask of TRIG field.
	DAC_CR_TRIG_Msk = 0xe0000
	// Conversion begins when this register is written, and AOUT begins to change to the new voltage immediately. For all other values in this field, AOUT remains at its previous voltage until the selected event has occurred.
	DAC_CR_TRIG_IMMEDIATE = 0x0
	// Conversion is triggered by the selected edge(s) on the analog comparator (level) output
	DAC_CR_TRIG_COMPLEVELOUT = 0x1
	// Conversion is triggered by the selected edge(s) on ATRG0.
	DAC_CR_TRIG_ATRG0EDGE = 0x2
	// Conversion is triggered by the selected edge(s) on ATRG1.
	DAC_CR_TRIG_ATRG1EDGE = 0x3
	// Conversion is triggered by the selected edge(s) on CT32B1_MAT0 [2].
	DAC_CR_TRIG_CT32B1_MAT0EDGE = 0x4
	// Conversion is triggered by the selected edge(s) on CT32B1_MAT1[2].
	DAC_CR_TRIG_CT32B1_MAT1EDGE = 0x5
	// Conversion is triggered by the selected edge(s) on CT16B1_MAT0[2].
	DAC_CR_TRIG_CT16B1_MAT0EDGE = 0x6
	// Conversion is triggered by the selected edge(s) on CT16B1_MAT1[2].
	DAC_CR_TRIG_CT16B1_MAT1EDGE = 0x7
	// Position of RESERVED field.
	DAC_CR_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	DAC_CR_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	DAC_CR_RESERVED = 0x100000
	// Position of EDGESEL field.
	DAC_CR_EDGESEL_Pos = 0x15
	// Bit mask of EDGESEL field.
	DAC_CR_EDGESEL_Msk = 0x600000
	// Falling edges
	DAC_CR_EDGESEL_FALLING = 0x0
	// Rising edges
	DAC_CR_EDGESEL_RISINGs = 0x1
	// Position of TRIGERD field.
	DAC_CR_TRIGERD_Pos = 0x17
	// Bit mask of TRIGERD field.
	DAC_CR_TRIGERD_Msk = 0x800000
	// Bit TRIGERD.
	DAC_CR_TRIGERD = 0x800000
	// Position of RESERVED field.
	DAC_CR_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	DAC_CR_RESERVED_Msk = 0xff000000

	// RESERVED: Reserved
	// Position of RESERVED field.
	DAC_RESERVED_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DAC_RESERVED_RESERVED_Msk = 0xffffffff
)

// Constants for CMP: Comparator
const (
	// CTL: Comparator control register
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0x7
	// Position of EDGESEL field.
	Comparator_CTL_EDGESEL_Pos = 0x3
	// Bit mask of EDGESEL field.
	Comparator_CTL_EDGESEL_Msk = 0x18
	// Falling edges
	Comparator_CTL_EDGESEL_FALLING = 0x0
	// Rising edges
	Comparator_CTL_EDGESEL_RISING = 0x1
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0x20
	// Bit RESERVED.
	Comparator_CTL_RESERVED = 0x20
	// Position of COMPSA field.
	Comparator_CTL_COMPSA_Pos = 0x6
	// Bit mask of COMPSA field.
	Comparator_CTL_COMPSA_Msk = 0x40
	// Bit COMPSA.
	Comparator_CTL_COMPSA = 0x40
	// Uses the comparator output directly.
	Comparator_CTL_COMPSA_DIRECT = 0x0
	// Synchronizes the comparator output to the bus clock for output to other modules.
	Comparator_CTL_COMPSA_SYNCH = 0x1
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	Comparator_CTL_RESERVED = 0x80
	// Position of COMP_VP_SEL field.
	Comparator_CTL_COMP_VP_SEL_Pos = 0x8
	// Bit mask of COMP_VP_SEL field.
	Comparator_CTL_COMP_VP_SEL_Msk = 0x700
	// voltage ladder output
	Comparator_CTL_COMP_VP_SEL_VLADOUT = 0x0
	// ACMPI1
	Comparator_CTL_COMP_VP_SEL_ACMPI1 = 0x1
	// ACMPI2
	Comparator_CTL_COMP_VP_SEL_ACMPI2 = 0x2
	// ACMPI3
	Comparator_CTL_COMP_VP_SEL_ACMPI3 = 0x3
	// ACMPI4
	Comparator_CTL_COMP_VP_SEL_ACMPI4 = 0x4
	// ACMPI5
	Comparator_CTL_COMP_VP_SEL_ACMPI5 = 0x5
	// internal reference voltage
	Comparator_CTL_COMP_VP_SEL_INTVOLTAGEREF = 0x6
	// temperature sensor
	Comparator_CTL_COMP_VP_SEL_TEMPSENSOR = 0x7
	// Position of COMP_VM_SEL field.
	Comparator_CTL_COMP_VM_SEL_Pos = 0xb
	// Bit mask of COMP_VM_SEL field.
	Comparator_CTL_COMP_VM_SEL_Msk = 0x3800
	// voltage ladder output
	Comparator_CTL_COMP_VM_SEL_VLADDOUT = 0x0
	// ACMPI1
	Comparator_CTL_COMP_VM_SEL_ACMPI1 = 0x1
	// ACMPI2
	Comparator_CTL_COMP_VM_SEL_ACMPI2 = 0x2
	// ACMPI3
	Comparator_CTL_COMP_VM_SEL_ACMPI3 = 0x3
	// ACMPI4
	Comparator_CTL_COMP_VM_SEL_ACMPI4 = 0x4
	// ACMPI5
	Comparator_CTL_COMP_VM_SEL_ACMPI5 = 0x5
	// internal reference voltage
	Comparator_CTL_COMP_VM_SEL_INTVOLTAGEREF = 0x6
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0xfc000
	// Position of EDGECLR field.
	Comparator_CTL_EDGECLR_Pos = 0x14
	// Bit mask of EDGECLR field.
	Comparator_CTL_EDGECLR_Msk = 0x100000
	// Bit EDGECLR.
	Comparator_CTL_EDGECLR = 0x100000
	// Position of COMPSTAT field.
	Comparator_CTL_COMPSTAT_Pos = 0x15
	// Bit mask of COMPSTAT field.
	Comparator_CTL_COMPSTAT_Msk = 0x200000
	// Bit COMPSTAT.
	Comparator_CTL_COMPSTAT = 0x200000
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	Comparator_CTL_RESERVED = 0x400000
	// Position of COMPEDGE field.
	Comparator_CTL_COMPEDGE_Pos = 0x17
	// Bit mask of COMPEDGE field.
	Comparator_CTL_COMPEDGE_Msk = 0x800000
	// Bit COMPEDGE.
	Comparator_CTL_COMPEDGE = 0x800000
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	Comparator_CTL_RESERVED = 0x1000000
	// Position of HYS field.
	Comparator_CTL_HYS_Pos = 0x19
	// Bit mask of HYS field.
	Comparator_CTL_HYS_Msk = 0x6000000
	// None (the output will switch as the voltages cross)
	Comparator_CTL_HYS_NOHYSTERESIS = 0x0
	// 5 mV
	Comparator_CTL_HYS_HYS5MV = 0x1
	// 10 mV
	Comparator_CTL_HYS_HSY10MV = 0x2
	// 20 mV
	Comparator_CTL_HYS_HSY20MV = 0x3
	// Position of RESERVED field.
	Comparator_CTL_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	Comparator_CTL_RESERVED_Msk = 0xf8000000

	// LAD: Voltage ladder register
	// Position of LADEN field.
	Comparator_LAD_LADEN_Pos = 0x0
	// Bit mask of LADEN field.
	Comparator_LAD_LADEN_Msk = 0x1
	// Bit LADEN.
	Comparator_LAD_LADEN = 0x1
	// Position of LADSEL field.
	Comparator_LAD_LADSEL_Pos = 0x1
	// Bit mask of LADSEL field.
	Comparator_LAD_LADSEL_Msk = 0x3e
	// Position of LADREF field.
	Comparator_LAD_LADREF_Pos = 0x6
	// Bit mask of LADREF field.
	Comparator_LAD_LADREF_Msk = 0x40
	// Bit LADREF.
	Comparator_LAD_LADREF = 0x40
	// VDD pin
	Comparator_LAD_LADREF_VDDPIN = 0x0
	// VDDCMP pin
	Comparator_LAD_LADREF_VDDCMPPIN = 0x1
	// Position of RESERVED field.
	Comparator_LAD_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	Comparator_LAD_RESERVED_Msk = 0xffffff80
)

// Constants for FMC: Flash controller
const (
	// FLASHCFG: Flash memory access time configuration register
	// Position of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Pos = 0x0
	// Bit mask of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Msk = 0x3
	// 1 system clock flash access time (for system clock frequencies of up to 20 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_1_SYSTEM_CLOCK_FLASH = 0x0
	// 2 system clocks flash access time (for system clock frequencies of up to 40 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_2_SYSTEM_CLOCKS_FLAS = 0x1
	// 3 system clocks flash access time (for system clock frequencies of up to 50 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_3_SYSTEM_CLOCKS_FLAS = 0x2
	// Position of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Msk = 0xfffffffc

	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Pos = 0x0
	// Bit mask of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Msk = 0x1ffff
	// Position of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Pos = 0x11
	// Bit mask of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Msk = 0x20000
	// Bit SIG_START.
	FLASHCTRL_FMSSTOP_SIG_START = 0x20000
	// Signature generation is stopped
	FLASHCTRL_FMSSTOP_SIG_START_SIGNATURE_GENERATION = 0x0
	// Initiate signature generation
	FLASHCTRL_FMSSTOP_SIG_START_INITIATE_SIGNATURE_G = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0xfffc0000

	// FMSW0: Word 0 [31:0]
	// Position of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Pos = 0x0
	// Bit mask of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Msk = 0xffffffff

	// FMSW1: Word 1 [63:32]
	// Position of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Pos = 0x0
	// Bit mask of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Msk = 0xffffffff

	// FMSW2: Word 2 [95:64]
	// Position of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Pos = 0x0
	// Bit mask of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Msk = 0xffffffff

	// FMSW3: Word 3 [127:96]
	// Position of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Pos = 0x0
	// Bit mask of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Msk = 0xffffffff

	// EEMSSTART: EEPROM BIST start address register
	// Position of STARTA field.
	FLASHCTRL_EEMSSTART_STARTA_Pos = 0x0
	// Bit mask of STARTA field.
	FLASHCTRL_EEMSSTART_STARTA_Msk = 0x3fff
	// Position of RESERVED field.
	FLASHCTRL_EEMSSTART_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	FLASHCTRL_EEMSSTART_RESERVED_Msk = 0xffffc000

	// EEMSSTOP: EEPROM BIST stop address register
	// Position of STOPA field.
	FLASHCTRL_EEMSSTOP_STOPA_Pos = 0x0
	// Bit mask of STOPA field.
	FLASHCTRL_EEMSSTOP_STOPA_Msk = 0x3fff
	// Position of RESERVED field.
	FLASHCTRL_EEMSSTOP_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	FLASHCTRL_EEMSSTOP_RESERVED_Msk = 0x3fffc000
	// Position of DEVSEL field.
	FLASHCTRL_EEMSSTOP_DEVSEL_Pos = 0x1e
	// Bit mask of DEVSEL field.
	FLASHCTRL_EEMSSTOP_DEVSEL_Msk = 0x40000000
	// Bit DEVSEL.
	FLASHCTRL_EEMSSTOP_DEVSEL = 0x40000000
	// Position of STRTBIST field.
	FLASHCTRL_EEMSSTOP_STRTBIST_Pos = 0x1f
	// Bit mask of STRTBIST field.
	FLASHCTRL_EEMSSTOP_STRTBIST_Msk = 0x80000000
	// Bit STRTBIST.
	FLASHCTRL_EEMSSTOP_STRTBIST = 0x80000000

	// EEMSSIG: EEPROM 24-bit BIST signature register
	// Position of DATA_SIG field.
	FLASHCTRL_EEMSSIG_DATA_SIG_Pos = 0x0
	// Bit mask of DATA_SIG field.
	FLASHCTRL_EEMSSIG_DATA_SIG_Msk = 0xffff
	// Position of PARITY_SIG field.
	FLASHCTRL_EEMSSIG_PARITY_SIG_Pos = 0x10
	// Bit mask of PARITY_SIG field.
	FLASHCTRL_EEMSSIG_PARITY_SIG_Msk = 0xffff0000

	// FMSTAT: Signature generation status register
	// Position of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Msk = 0x3
	// Position of SIG_DONE field.
	FLASHCTRL_FMSTAT_SIG_DONE_Pos = 0x2
	// Bit mask of SIG_DONE field.
	FLASHCTRL_FMSTAT_SIG_DONE_Msk = 0x4
	// Bit SIG_DONE.
	FLASHCTRL_FMSTAT_SIG_DONE = 0x4
	// Position of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTAT_RESERVED_Msk = 0xfffffff8

	// FMSTATCLR: Signature generation status clear register
	// Position of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Msk = 0x3
	// Position of SIG_DONE_CLR field.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR_Pos = 0x2
	// Bit mask of SIG_DONE_CLR field.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR_Msk = 0x4
	// Bit SIG_DONE_CLR.
	FLASHCTRL_FMSTATCLR_SIG_DONE_CLR = 0x4
	// Position of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSTATCLR_RESERVED_Msk = 0xfffffff8
)

// Constants for SSP0: SSP/SPI
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SSP0_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SSP0_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SSP0_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SSP0_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SSP0_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SSP0_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SSP0_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SSP0_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SSP0_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SSP0_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SSP0_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SSP0_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SSP0_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SSP0_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SSP0_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SSP0_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SSP0_CR0_FRF_Msk = 0x30
	// SPI
	SSP0_CR0_FRF_SPI = 0x0
	// TI
	SSP0_CR0_FRF_TI = 0x1
	// Microwire
	SSP0_CR0_FRF_MICROWIRE = 0x2
	// Position of CPOL field.
	SSP0_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SSP0_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SSP0_CR0_CPOL = 0x40
	// SPI controller maintains the bus clock low between frames.
	SSP0_CR0_CPOL_LOW = 0x0
	// SPI controller maintains the bus clock high between frames.
	SSP0_CR0_CPOL_HIGH = 0x1
	// Position of CPHA field.
	SSP0_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SSP0_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SSP0_CR0_CPHA = 0x80
	// SPI controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP0_CR0_CPHA_FIRSTCLOCK = 0x0
	// SPI controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP0_CR0_CPHA_SECONDCLOCK = 0x1
	// Position of SCR field.
	SSP0_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SSP0_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SSP0_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SSP0_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SSP0_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SSP0_CR1_LBM = 0x1
	// During normal operation.
	SSP0_CR1_LBM_DURING_NORMAL_OPERAT = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP0_CR1_LBM_SERIAL_INPUT_IS_TAKE = 0x1
	// Position of SSE field.
	SSP0_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SSP0_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SSP0_CR1_SSE = 0x2
	// The SPI controller is disabled.
	SSP0_CR1_SSE_DISABLED = 0x0
	// The SPI controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP/SPI registers and interrupt controller registers, before setting this bit.
	SSP0_CR1_SSE_ENABLED = 0x1
	// Position of MS field.
	SSP0_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SSP0_CR1_MS_Msk = 0x4
	// Bit MS.
	SSP0_CR1_MS = 0x4
	// The SPI controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP0_CR1_MS_MASTER = 0x0
	// The SPI controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP0_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SSP0_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SSP0_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SSP0_CR1_SOD = 0x8
	// Position of RESERVED field.
	SSP0_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SSP0_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SSP0_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SSP0_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SSP0_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SSP0_SR_TFE_Msk = 0x1
	// Bit TFE.
	SSP0_SR_TFE = 0x1
	// Position of TNF field.
	SSP0_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SSP0_SR_TNF_Msk = 0x2
	// Bit TNF.
	SSP0_SR_TNF = 0x2
	// Position of RNE field.
	SSP0_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SSP0_SR_RNE_Msk = 0x4
	// Bit RNE.
	SSP0_SR_RNE = 0x4
	// Position of RFF field.
	SSP0_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SSP0_SR_RFF_Msk = 0x8
	// Bit RFF.
	SSP0_SR_RFF = 0x8
	// Position of BSY field.
	SSP0_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SSP0_SR_BSY_Msk = 0x10
	// Bit BSY.
	SSP0_SR_BSY = 0x10
	// Position of RESERVED field.
	SSP0_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SSP0_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SSP0_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SSP0_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SSP0_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SSP0_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SSP0_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SSP0_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SSP0_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SSP0_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SSP0_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SSP0_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SSP0_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SSP0_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SSP0_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SSP0_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SSP0_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SSP0_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SSP0_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SSP0_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SSP0_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SSP0_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SSP0_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SSP0_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SSP0_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SSP0_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SSP0_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SSP0_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SSP0_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SSP0_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SSP0_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SSP0_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SSP0_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SSP0_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SSP0_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SSP0_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SSP0_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SSP0_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SSP0_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SSP0_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SSP0_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SSP0_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SSP0_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SSP0_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SSP0_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SSP0_ICR_RORIC = 0x1
	// Position of RTIC field.
	SSP0_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SSP0_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SSP0_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SSP0_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP0_ICR_RESERVED_Msk = 0xfffffffc
)

// Constants for IOCON: IOCON block
const (
	// RESET_PIO0_0: I/O configuration register for pin RESET/PIO0_0
	// Position of FUNC field.
	IOCON_RESET_PIO0_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_RESET_PIO0_0_FUNC_Msk = 0x7
	// External reset input with fixed 20 ns glitch filter: A LOW on this pin resets the device, causing I/O ports and peripherals to take on their default states and processor execution to begin at address 0.
	IOCON_RESET_PIO0_0_FUNC_RESET = 0x0
	// General purpose digital input/output pin.
	IOCON_RESET_PIO0_0_FUNC_PIO0_0 = 0x1
	// Position of MODE field.
	IOCON_RESET_PIO0_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_RESET_PIO0_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_RESET_PIO0_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_RESET_PIO0_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_RESET_PIO0_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_RESET_PIO0_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_RESET_PIO0_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_RESET_PIO0_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_RESET_PIO0_0_HYS = 0x20
	// Disable.
	IOCON_RESET_PIO0_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_RESET_PIO0_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_RESET_PIO0_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_RESET_PIO0_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_RESET_PIO0_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_RESET_PIO0_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_RESET_PIO0_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_RESET_PIO0_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_RESET_PIO0_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_RESET_PIO0_0_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_RESET_PIO0_0_SLEW_SLOW = 0x0
	// Fast.
	IOCON_RESET_PIO0_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_RESET_PIO0_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_RESET_PIO0_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_RESET_PIO0_0_OD = 0x400
	// Disable.
	IOCON_RESET_PIO0_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_RESET_PIO0_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_RESET_PIO0_0_RESERVED_Msk = 0xfffff800

	// PIO0_1: I/O configuration register for pin PIO0_1/RXD/CLKOUT/ CT32B0_MAT2/SSEL0/ CLKIN
	// Position of FUNC field.
	IOCON_PIO0_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin. A LOW level on this pin during reset starts the ISP command handler.
	IOCON_PIO0_1_FUNC_PIO0_1 = 0x0
	// Receiver data input for USART.
	IOCON_PIO0_1_FUNC_RXD = 0x1
	// Clock output.
	IOCON_PIO0_1_FUNC_CLKOUT = 0x2
	// Match output 2 for 32-bit timer 0.
	IOCON_PIO0_1_FUNC_CT32B0_MAT2 = 0x3
	// Slave Select for SSP0.
	IOCON_PIO0_1_FUNC_SSEL0 = 0x4
	// External clock input.
	IOCON_PIO0_1_FUNC_CLKIN = 0x5
	// Position of MODE field.
	IOCON_PIO0_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_1_HYS = 0x20
	// Disable.
	IOCON_PIO0_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_1_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_1_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_1_OD = 0x400
	// Disable.
	IOCON_PIO0_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0xfffff800

	// PIO0_2: I/O configuration register for pin PIO0_2/SCL/ACMP_O/ TCK/SWCLK/ CT16B0_CAP0
	// Position of FUNC field.
	IOCON_PIO0_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin. High-current sink (20 mA) or standard-current sink (4 mA) programmable; true open-drain for all pin functions. Input glitch filter (50 ns) capable.
	IOCON_PIO0_2_FUNC_PIO0_2 = 0x0
	// I2C-bus clock (true open-drain) input/output. Input glitch filter (50 ns) capable.
	IOCON_PIO0_2_FUNC_SCL = 0x1
	// Analog comparator output.
	IOCON_PIO0_2_FUNC_ACMP_O = 0x2
	// Serial Wire Debug Clock (secondary for LQFP and HVQFN packages). Input glitch filter (50 ns) capable. For the WLCSP20 package only, this pin is configured to the SWCLK function by the boot loader after reset.
	IOCON_PIO0_2_FUNC_TCK_SWCLK = 0x3
	// Capture input 0 for 16-bit timer 0.Input glitch filter (50 ns) capable.
	IOCON_PIO0_2_FUNC_CT16B0_CAP0 = 0x4
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0xf8
	// Position of HS field.
	IOCON_PIO0_2_HS_Pos = 0x8
	// Bit mask of HS field.
	IOCON_PIO0_2_HS_Msk = 0x100
	// Bit HS.
	IOCON_PIO0_2_HS = 0x100
	// Enabled.
	IOCON_PIO0_2_HS_ENABLED = 0x0
	// Disabled.
	IOCON_PIO0_2_HS_DISABLED = 0x1
	// Position of HIDRIVE field.
	IOCON_PIO0_2_HIDRIVE_Pos = 0x9
	// Bit mask of HIDRIVE field.
	IOCON_PIO0_2_HIDRIVE_Msk = 0x200
	// Bit HIDRIVE.
	IOCON_PIO0_2_HIDRIVE = 0x200
	// Standard; 4 mA sink current.
	IOCON_PIO0_2_HIDRIVE_STANDARD = 0x0
	// High; 20 mA sink current.
	IOCON_PIO0_2_HIDRIVE_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0xfffffc00

	// PIO0_3: I/O configuration register for pin PIO0_3/SDA/ACMP_O/ SWDIO/CT16B1_CAP0
	// Position of FUNC field.
	IOCON_PIO0_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin. High-current sink (20 mA) or standard-current sink (4 mA) programmable; true open-drain for all pin functions. Input glitch filter (50 ns) capable.
	IOCON_PIO0_3_FUNC_PIO0_3 = 0x0
	// I2C-bus data (true open-drain) input/output. Input glitch filter (50 ns) capable.
	IOCON_PIO0_3_FUNC_SDA = 0x1
	// Analog comparator output.
	IOCON_PIO0_3_FUNC_ACMP_O = 0x2
	// Serial Wire Debug I/O (secondary for LQFP and HVQFN packages). Input glitch filter (50 ns) capable. For the WLCSP20 package only, this pin is configured to the SWDIO function by the boot loader after reset.
	IOCON_PIO0_3_FUNC_SWDIO = 0x3
	// Capture input 0 for 16-bit timer 1. Input glitch filter (50 ns) capable.
	IOCON_PIO0_3_FUNC_CT16B1_CAP0 = 0x4
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0xf8
	// Position of HS field.
	IOCON_PIO0_3_HS_Pos = 0x8
	// Bit mask of HS field.
	IOCON_PIO0_3_HS_Msk = 0x100
	// Bit HS.
	IOCON_PIO0_3_HS = 0x100
	// Enabled.
	IOCON_PIO0_3_HS_ENABLED = 0x0
	// Disabled.
	IOCON_PIO0_3_HS_DISABLED = 0x1
	// Position of HIDRIVE field.
	IOCON_PIO0_3_HIDRIVE_Pos = 0x9
	// Bit mask of HIDRIVE field.
	IOCON_PIO0_3_HIDRIVE_Msk = 0x200
	// Bit HIDRIVE.
	IOCON_PIO0_3_HIDRIVE = 0x200
	// Standard; 4 mA sink current.
	IOCON_PIO0_3_HIDRIVE_STANDARD = 0x0
	// High; 20 mA sink current.
	IOCON_PIO0_3_HIDRIVE_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0xfffffc00

	// PIO0_4: I/O configuration register for pin PIO0_4/R/AOUT/ CT16B0_MAT1/MOSI0
	// Position of FUNC field.
	IOCON_PIO0_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_4_FUNC_PIO0_4 = 0x0
	// Reserved.
	IOCON_PIO0_4_FUNC_R = 0x1
	// D/A converter output.
	IOCON_PIO0_4_FUNC_AOUT = 0x2
	// Match output 1 for 16-bit timer 0.
	IOCON_PIO0_4_FUNC_CT16B0_MAT1 = 0x3
	// Master Out Slave In for SSP0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_4_FUNC_MOSI0 = 0x4
	// Position of MODE field.
	IOCON_PIO0_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_4_HYS = 0x20
	// Disable.
	IOCON_PIO0_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_4_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_4_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_4_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_4_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_4_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_4_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_4_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_4_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_4_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_4_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_4_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_4_OD = 0x400
	// Disable.
	IOCON_PIO0_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xfffff800

	// TCK_SWCLK_PIO0_5: I/O configuration register for pin TCK/SWCLK/PIO0_5/ R/CT16B0_MAT2/ SCK0
	// Position of FUNC field.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_Msk = 0x7
	// Test clock TCK for JTAG interface and primary (default) Serial Wire Debug Clock. Input glitch filter (10 ns) capable.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_TCK_SWCLK = 0x0
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_PIO0_5 = 0x1
	// Reserved.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_R = 0x2
	// Match output 2 for 16-bit timer 0.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_CT16B0_MAT2 = 0x3
	// Serial clock for SSP0. Input glitch filter (10 ns) capable.
	IOCON_TCK_SWCLK_PIO0_5_FUNC_SCK0 = 0x4
	// Position of MODE field.
	IOCON_TCK_SWCLK_PIO0_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TCK_SWCLK_PIO0_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TCK_SWCLK_PIO0_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TCK_SWCLK_PIO0_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TCK_SWCLK_PIO0_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TCK_SWCLK_PIO0_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TCK_SWCLK_PIO0_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TCK_SWCLK_PIO0_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TCK_SWCLK_PIO0_5_HYS = 0x20
	// Disable.
	IOCON_TCK_SWCLK_PIO0_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TCK_SWCLK_PIO0_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TCK_SWCLK_PIO0_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TCK_SWCLK_PIO0_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_TCK_SWCLK_PIO0_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TCK_SWCLK_PIO0_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TCK_SWCLK_PIO0_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TCK_SWCLK_PIO0_5_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TCK_SWCLK_PIO0_5_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TCK_SWCLK_PIO0_5_ADMODE = 0x80
	// Analog input mode.
	IOCON_TCK_SWCLK_PIO0_5_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TCK_SWCLK_PIO0_5_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TCK_SWCLK_PIO0_5_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TCK_SWCLK_PIO0_5_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TCK_SWCLK_PIO0_5_FILTR = 0x100
	// Filter disabled.
	IOCON_TCK_SWCLK_PIO0_5_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_TCK_SWCLK_PIO0_5_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TCK_SWCLK_PIO0_5_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TCK_SWCLK_PIO0_5_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TCK_SWCLK_PIO0_5_RESERVED = 0x200
	// Position of OD field.
	IOCON_TCK_SWCLK_PIO0_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TCK_SWCLK_PIO0_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_TCK_SWCLK_PIO0_5_OD = 0x400
	// Disable.
	IOCON_TCK_SWCLK_PIO0_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TCK_SWCLK_PIO0_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TCK_SWCLK_PIO0_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TCK_SWCLK_PIO0_5_RESERVED_Msk = 0xfffff800

	// TDI_PIO0_6: I/O configuration register for pin TDI/PIO0_6/AD0/ CT32B0_MAT3/MISO0
	// Position of FUNC field.
	IOCON_TDI_PIO0_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TDI_PIO0_6_FUNC_Msk = 0x7
	// Test Data In for JTAG interface. Input glitch filter (10 ns) capable.
	IOCON_TDI_PIO0_6_FUNC_TDI = 0x0
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_TDI_PIO0_6_FUNC_PIO0_6 = 0x1
	// A/D converter input 0.
	IOCON_TDI_PIO0_6_FUNC_AD0 = 0x2
	// Match output 3 for 32-bit timer 0.
	IOCON_TDI_PIO0_6_FUNC_CT32B0_MAT3 = 0x3
	// Master In Slave Out for SSP0. Input glitch filter (10 ns) capable.
	IOCON_TDI_PIO0_6_FUNC_MISO0 = 0x4
	// Position of MODE field.
	IOCON_TDI_PIO0_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TDI_PIO0_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TDI_PIO0_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TDI_PIO0_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TDI_PIO0_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TDI_PIO0_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TDI_PIO0_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TDI_PIO0_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TDI_PIO0_6_HYS = 0x20
	// Disable.
	IOCON_TDI_PIO0_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TDI_PIO0_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TDI_PIO0_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TDI_PIO0_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_TDI_PIO0_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TDI_PIO0_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TDI_PIO0_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TDI_PIO0_6_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TDI_PIO0_6_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TDI_PIO0_6_ADMODE = 0x80
	// Analog input mode.
	IOCON_TDI_PIO0_6_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TDI_PIO0_6_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TDI_PIO0_6_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TDI_PIO0_6_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TDI_PIO0_6_FILTR = 0x100
	// Filter disabled.
	IOCON_TDI_PIO0_6_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_TDI_PIO0_6_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TDI_PIO0_6_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TDI_PIO0_6_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TDI_PIO0_6_RESERVED = 0x200
	// Position of OD field.
	IOCON_TDI_PIO0_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TDI_PIO0_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_TDI_PIO0_6_OD = 0x400
	// Disable.
	IOCON_TDI_PIO0_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TDI_PIO0_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TDI_PIO0_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TDI_PIO0_6_RESERVED_Msk = 0xfffff800

	// TMS_PIO0_7: I/O configuration register for pin TMS/PIO0_7/AD1/ CT32B1_CAP0/ CT16B0_MAT0
	// Position of FUNC field.
	IOCON_TMS_PIO0_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TMS_PIO0_7_FUNC_Msk = 0x7
	// Test Mode Select for JTAG interface. Input glitch filter (10 ns) capable.
	IOCON_TMS_PIO0_7_FUNC_TMS = 0x0
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_TMS_PIO0_7_FUNC_PIO0_7 = 0x1
	// A/D converter input 1.
	IOCON_TMS_PIO0_7_FUNC_AD1 = 0x2
	// Capture input 0 for 32-bit timer 1. Input glitch filter (10 ns) capable.
	IOCON_TMS_PIO0_7_FUNC_CT32B1_CAP0 = 0x3
	// Match output 2 for 16-bit timer 0.
	IOCON_TMS_PIO0_7_FUNC_CT16B0_MAT0 = 0x4
	// Position of MODE field.
	IOCON_TMS_PIO0_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TMS_PIO0_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TMS_PIO0_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TMS_PIO0_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TMS_PIO0_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TMS_PIO0_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TMS_PIO0_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TMS_PIO0_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TMS_PIO0_7_HYS = 0x20
	// Disable.
	IOCON_TMS_PIO0_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TMS_PIO0_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TMS_PIO0_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TMS_PIO0_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_TMS_PIO0_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TMS_PIO0_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TMS_PIO0_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TMS_PIO0_7_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TMS_PIO0_7_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TMS_PIO0_7_ADMODE = 0x80
	// Analog input mode.
	IOCON_TMS_PIO0_7_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TMS_PIO0_7_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TMS_PIO0_7_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TMS_PIO0_7_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TMS_PIO0_7_FILTR = 0x100
	// Filter disabled.
	IOCON_TMS_PIO0_7_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_TMS_PIO0_7_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TMS_PIO0_7_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TMS_PIO0_7_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TMS_PIO0_7_RESERVED = 0x200
	// Position of OD field.
	IOCON_TMS_PIO0_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TMS_PIO0_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_TMS_PIO0_7_OD = 0x400
	// Disable.
	IOCON_TMS_PIO0_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TMS_PIO0_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TMS_PIO0_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TMS_PIO0_7_RESERVED_Msk = 0xfffff800

	// TDO_PIO0_8: I/O configuration register for pin TDO/PIO0_8/AD2/ CT32B1_MAT0/SCK1
	// Position of FUNC field.
	IOCON_TDO_PIO0_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TDO_PIO0_8_FUNC_Msk = 0x7
	// Test Data Out for JTAG interface.
	IOCON_TDO_PIO0_8_FUNC_TDO = 0x0
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_TDO_PIO0_8_FUNC_PIO0_8 = 0x1
	// A/D converter input 2.
	IOCON_TDO_PIO0_8_FUNC_AD2 = 0x2
	// Match output 0 for 32-bit timer 1.
	IOCON_TDO_PIO0_8_FUNC_CT32B1_MAT0 = 0x3
	// Serial clock for SSP1. Input glitch filter (10 ns) capable.
	IOCON_TDO_PIO0_8_FUNC_SCK1 = 0x4
	// Position of MODE field.
	IOCON_TDO_PIO0_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TDO_PIO0_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TDO_PIO0_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TDO_PIO0_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TDO_PIO0_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TDO_PIO0_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TDO_PIO0_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TDO_PIO0_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TDO_PIO0_8_HYS = 0x20
	// Disable.
	IOCON_TDO_PIO0_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TDO_PIO0_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TDO_PIO0_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TDO_PIO0_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_TDO_PIO0_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TDO_PIO0_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TDO_PIO0_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TDO_PIO0_8_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TDO_PIO0_8_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TDO_PIO0_8_ADMODE = 0x80
	// Analog input mode.
	IOCON_TDO_PIO0_8_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TDO_PIO0_8_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TDO_PIO0_8_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TDO_PIO0_8_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TDO_PIO0_8_FILTR = 0x100
	// Filter disabled.
	IOCON_TDO_PIO0_8_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_TDO_PIO0_8_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TDO_PIO0_8_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TDO_PIO0_8_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TDO_PIO0_8_RESERVED = 0x200
	// Position of OD field.
	IOCON_TDO_PIO0_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TDO_PIO0_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_TDO_PIO0_8_OD = 0x400
	// Disable.
	IOCON_TDO_PIO0_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TDO_PIO0_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TDO_PIO0_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TDO_PIO0_8_RESERVED_Msk = 0xfffff800

	// TRST_PIO0_9: I/O configuration register for pin TRST/PIO0_9/AD3/CT32B1_MAT1/CT16B0_MAT1/CTS
	// Position of FUNC field.
	IOCON_TRST_PIO0_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_TRST_PIO0_9_FUNC_Msk = 0x7
	// Test Reset for JTAG interface. Input glitch filter (10 ns) capable.
	IOCON_TRST_PIO0_9_FUNC_TRST = 0x0
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_TRST_PIO0_9_FUNC_PIO0_9 = 0x1
	// A/D converter, input 3.
	IOCON_TRST_PIO0_9_FUNC_AD3 = 0x2
	// Match output 1 for 32-bit timer 1.
	IOCON_TRST_PIO0_9_FUNC_CT32B1_MAT1 = 0x3
	// Match output 1 for 16-bit timer 0.
	IOCON_TRST_PIO0_9_FUNC_CT16B0_MAT1 = 0x4
	// Clear To Send input for USART. Input glitch filter (10 ns) capable.
	IOCON_TRST_PIO0_9_FUNC_CTS = 0x5
	// Position of MODE field.
	IOCON_TRST_PIO0_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_TRST_PIO0_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_TRST_PIO0_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_TRST_PIO0_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_TRST_PIO0_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_TRST_PIO0_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_TRST_PIO0_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_TRST_PIO0_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_TRST_PIO0_9_HYS = 0x20
	// Disable.
	IOCON_TRST_PIO0_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_TRST_PIO0_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_TRST_PIO0_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_TRST_PIO0_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_TRST_PIO0_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_TRST_PIO0_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_TRST_PIO0_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_TRST_PIO0_9_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_TRST_PIO0_9_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_TRST_PIO0_9_ADMODE = 0x80
	// Analog input mode.
	IOCON_TRST_PIO0_9_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_TRST_PIO0_9_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_TRST_PIO0_9_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_TRST_PIO0_9_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_TRST_PIO0_9_FILTR = 0x100
	// Filter disabled.
	IOCON_TRST_PIO0_9_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_TRST_PIO0_9_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_TRST_PIO0_9_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_TRST_PIO0_9_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_TRST_PIO0_9_RESERVED = 0x200
	// Position of OD field.
	IOCON_TRST_PIO0_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_TRST_PIO0_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_TRST_PIO0_9_OD = 0x400
	// Disable.
	IOCON_TRST_PIO0_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_TRST_PIO0_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_TRST_PIO0_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_TRST_PIO0_9_RESERVED_Msk = 0xfffff800

	// SWDIO_PIO0_10: I/O configuration register for pin SWDIO/PIO0_10/AD4/ CT32B1_MAT2/ CT16B0_MAT2/RTS
	// Position of FUNC field.
	IOCON_SWDIO_PIO0_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_SWDIO_PIO0_10_FUNC_Msk = 0x7
	// Primary (default) Serial Wire Debug I/O for the LQFP48 and HVQFN33 packages. For the WLCSP20 package, use PIO0_3. Input glitch filter (10 ns) capable.
	IOCON_SWDIO_PIO0_10_FUNC_SWDIO = 0x0
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_SWDIO_PIO0_10_FUNC_PIO0_10 = 0x1
	// A/D converter, input 4.
	IOCON_SWDIO_PIO0_10_FUNC_AD4 = 0x2
	// Match output 2 for 32-bit timer 1.
	IOCON_SWDIO_PIO0_10_FUNC_CT32B1_MAT2 = 0x3
	// Match output 2 for 16-bit timer 0.
	IOCON_SWDIO_PIO0_10_FUNC_CT16B0_MAT2 = 0x4
	// Request To Send output for USART.
	IOCON_SWDIO_PIO0_10_FUNC_RTS = 0x5
	// Position of MODE field.
	IOCON_SWDIO_PIO0_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_SWDIO_PIO0_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_SWDIO_PIO0_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_SWDIO_PIO0_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_SWDIO_PIO0_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_SWDIO_PIO0_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_SWDIO_PIO0_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_SWDIO_PIO0_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_SWDIO_PIO0_10_HYS = 0x20
	// Disable.
	IOCON_SWDIO_PIO0_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_SWDIO_PIO0_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_SWDIO_PIO0_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_SWDIO_PIO0_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_SWDIO_PIO0_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_SWDIO_PIO0_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_SWDIO_PIO0_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_SWDIO_PIO0_10_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_SWDIO_PIO0_10_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_SWDIO_PIO0_10_ADMODE = 0x80
	// Analog input mode.
	IOCON_SWDIO_PIO0_10_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_SWDIO_PIO0_10_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_SWDIO_PIO0_10_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_SWDIO_PIO0_10_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_SWDIO_PIO0_10_FILTR = 0x100
	// Filter disabled.
	IOCON_SWDIO_PIO0_10_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_SWDIO_PIO0_10_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO0_10_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO0_10_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_SWDIO_PIO0_10_RESERVED = 0x200
	// Position of OD field.
	IOCON_SWDIO_PIO0_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_SWDIO_PIO0_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_SWDIO_PIO0_10_OD = 0x400
	// Disable.
	IOCON_SWDIO_PIO0_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_SWDIO_PIO0_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_SWDIO_PIO0_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_SWDIO_PIO0_10_RESERVED_Msk = 0xfffff800

	// PIO0_11: I/O configuration register for pin PIO0_11/SCLK/ AD5/CT32B1_MAT3/ CT32B0_CAP0
	// Position of FUNC field.
	IOCON_PIO0_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_11_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_11_FUNC_PIO0_11 = 0x0
	// Serial clock for USART. Input glitch filter (10 ns) capable.
	IOCON_PIO0_11_FUNC_SCLK = 0x1
	// A/D converter, input 5.
	IOCON_PIO0_11_FUNC_AD5 = 0x2
	// Match output 3 for 32-bit timer 1.
	IOCON_PIO0_11_FUNC_CT32B1_MAT3 = 0x3
	// Capture input 0 for 32-bit timer 0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_11_FUNC_CT32B0_CAP0 = 0x4
	// Position of MODE field.
	IOCON_PIO0_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_11_HYS = 0x20
	// Disable.
	IOCON_PIO0_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_11_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_11_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_11_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_11_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_11_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_11_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_11_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_11_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_11_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_11_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_11_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_11_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_11_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_11_OD = 0x400
	// Disable.
	IOCON_PIO0_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_11_RESERVED_Msk = 0xfffff800

	// PIO0_12: I/O configuration register for pin PIO0_12/RXD/ ACMP_O/ CT32B0_MAT0/SCL/ CLKIN
	// Position of FUNC field.
	IOCON_PIO0_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_12_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_12_FUNC_PIO0_12 = 0x0
	// Receiver data input for USART. This pin is used for ISP communication.
	IOCON_PIO0_12_FUNC_RXD = 0x1
	// Analog comparator output.
	IOCON_PIO0_12_FUNC_ACMP_O = 0x2
	// Match output 0 for 32-bit timer 0.
	IOCON_PIO0_12_FUNC_CT32B0_MAT0 = 0x3
	// I2C-bus clock input/output. This is not an I2C-bus open-drain pin[8].
	IOCON_PIO0_12_FUNC_SCL = 0x4
	// External clock input.
	IOCON_PIO0_12_FUNC_CLKIN = 0x5
	// Position of MODE field.
	IOCON_PIO0_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_12_HYS = 0x20
	// Disable.
	IOCON_PIO0_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_12_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_12_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_12_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_12_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_12_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_12_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_12_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_12_OD = 0x400
	// Disable.
	IOCON_PIO0_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_12_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_12_RESERVED_Msk = 0xfffff800

	// PIO0_13: I/O configuration register for pin PIO0_13/TXD/ ACMP_I2/ CT32B0_MAT1/SDA
	// Position of FUNC field.
	IOCON_PIO0_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_13_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_13_FUNC_PIO0_13 = 0x0
	// Transmitter data output for USART. This pin is used for ISP communication.
	IOCON_PIO0_13_FUNC_TXD = 0x1
	// Analog comparator input 2.
	IOCON_PIO0_13_FUNC_ACMP_I2 = 0x2
	// Match output 1 for 32-bit timer 0.
	IOCON_PIO0_13_FUNC_CT32B0_MAT1 = 0x3
	// I2C-bus data input/output. This is not an I2C-bus open-drain pin[8]. Input glitch filter (10 ns) capable.
	IOCON_PIO0_13_FUNC_SDA = 0x4
	// Position of MODE field.
	IOCON_PIO0_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_13_HYS = 0x20
	// Disable.
	IOCON_PIO0_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_13_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_13_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_13_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_13_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_13_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_13_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_13_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_13_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_13_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_13_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_13_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_13_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_13_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_13_OD = 0x400
	// Disable.
	IOCON_PIO0_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_13_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_13_RESERVED_Msk = 0xfffff800

	// PIO0_14: I/O configuration register for pin PIO0_14/MISO1/AD6/CT32B0_CAP1/CT16B1_MAT1/VDDCMP
	// Position of FUNC field.
	IOCON_PIO0_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_14_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_14_FUNC_PIO0_14 = 0x0
	// Master In Slave Out for SSP1. Input glitch filter (10 ns) capable.
	IOCON_PIO0_14_FUNC_MISO1 = 0x1
	// A/D converter, input 6.
	IOCON_PIO0_14_FUNC_AD6 = 0x2
	// Capture input 1 for 32-bit timer 0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_14_FUNC_CT32B0_CAP1 = 0x3
	// Match output 1 for 16-bit timer 1.
	IOCON_PIO0_14_FUNC_CT16B1_MAT1 = 0x4
	// Analog comparator alternate reference voltage.
	IOCON_PIO0_14_FUNC_VDDCMP = 0x5
	// Position of MODE field.
	IOCON_PIO0_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_14_HYS = 0x20
	// Disable.
	IOCON_PIO0_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_14_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_14_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_14_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_14_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_14_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_14_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_14_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_14_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_14_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_14_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_14_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_14_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_14_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_14_OD = 0x400
	// Disable.
	IOCON_PIO0_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_14_RESERVED_Msk = 0xfffff800

	// PIO0_15: I/O configuration register for pin PIO0_15/TXD/AD7/ CT32B0_CAP2/SDA
	// Position of FUNC field.
	IOCON_PIO0_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_15_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_15_FUNC_PIO0_15 = 0x0
	// Transmitter data output for USART.
	IOCON_PIO0_15_FUNC_TXD = 0x1
	// A/D converter, input 7.
	IOCON_PIO0_15_FUNC_AD7 = 0x2
	// Capture input 2 for 32-bit timer 0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_15_FUNC_CT32B0_CAP2 = 0x3
	// I2C-bus data input/output. This is not an I2C-bus open-drain pin[8]. Input glitch filter (10 ns) capable.
	IOCON_PIO0_15_FUNC_SDA = 0x4
	// Position of MODE field.
	IOCON_PIO0_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_15_HYS = 0x20
	// Disable.
	IOCON_PIO0_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_15_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_15_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_15_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_15_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_15_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_15_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_15_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_15_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_15_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_15_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_15_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_15_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_15_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_15_OD = 0x400
	// Disable.
	IOCON_PIO0_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_15_RESERVED_Msk = 0xfffff800

	// PIO0_16: I/O configuration register for pin PIO0_16/ ATRG0/ACMP_I3/ CT16B0_CAP1/SCL
	// Position of FUNC field.
	IOCON_PIO0_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_16_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_16_FUNC_PIO0_16 = 0x0
	// Conversion trigger 0 for ADC or DAC. Input glitch filter (10 ns) capable.
	IOCON_PIO0_16_FUNC_ATRG0 = 0x1
	// Analog comparator input 3.
	IOCON_PIO0_16_FUNC_ACMP_I3 = 0x2
	// Capture input 1 for 16-bit timer 0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_16_FUNC_CT16B0_CAP1 = 0x3
	// I2C-bus clock input/output. This is not an I2C-bus open-drain pin[8]. Input glitch filter (10 ns) capable.
	IOCON_PIO0_16_FUNC_SCL = 0x4
	// Position of MODE field.
	IOCON_PIO0_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_16_HYS = 0x20
	// Disable.
	IOCON_PIO0_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_16_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_16_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_16_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_16_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_16_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_16_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_16_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_16_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_16_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_16_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_16_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_16_OD = 0x400
	// Disable.
	IOCON_PIO0_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0xfffff800

	// PIO0_17: I/O configuration register for pin PIO0_17/ ATRG1/ACMP_I4/ CT16B0_CAP2/ CT16B0_MAT0
	// Position of FUNC field.
	IOCON_PIO0_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_17_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_17_FUNC_PIO0_17 = 0x0
	// Conversion trigger 1 for ADC or DAC. Input glitch filter (10 ns) capable.
	IOCON_PIO0_17_FUNC_ATRG1 = 0x1
	// Analog comparator input 4.
	IOCON_PIO0_17_FUNC_ACMP_I4 = 0x2
	// Capture input 2 for 16-bit timer 0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_17_FUNC_CT16B0_CAP2 = 0x3
	// Match output 0 for 16-bit timer 0.
	IOCON_PIO0_17_FUNC_CT16B0_MAT0 = 0x4
	// Position of MODE field.
	IOCON_PIO0_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_17_HYS = 0x20
	// Disable.
	IOCON_PIO0_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_17_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_17_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_17_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_17_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_17_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_17_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_17_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_17_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_17_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_17_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_17_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_17_OD = 0x400
	// Disable.
	IOCON_PIO0_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0xfffff800

	// PIO0_18: I/O configuration register for pin PIO0_18/R/SSEL0/ CT16B0_CAP0/ CT16B1_CAP1
	// Position of FUNC field.
	IOCON_PIO0_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_18_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_18_FUNC_PIO0_18 = 0x0
	// Reserved.
	IOCON_PIO0_18_FUNC_R = 0x1
	// Slave Select for SSP0.
	IOCON_PIO0_18_FUNC_SSEL0 = 0x2
	// Capture input 0 for 16-bit timer 0.
	IOCON_PIO0_18_FUNC_CT16B0_CAP0 = 0x3
	// Capture input 1 for 16-bit timer 1.
	IOCON_PIO0_18_FUNC_CT16B1_CAP1 = 0x4
	// Position of MODE field.
	IOCON_PIO0_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_18_HYS = 0x20
	// Disable.
	IOCON_PIO0_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_18_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_18_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_18_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_18_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_18_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_18_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_18_OD = 0x400
	// Disable.
	IOCON_PIO0_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_18_RESERVED_Msk = 0xfffff800

	// PIO0_19: I/O configuration register for pin PIO0_19/CLKIN/ CLKOUT/ MOSI0/CT16B1_MAT0
	// Position of FUNC field.
	IOCON_PIO0_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_19_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_19_FUNC_PIO0_19 = 0x0
	// External clock input.
	IOCON_PIO0_19_FUNC_CLKIN = 0x1
	// Clock output.
	IOCON_PIO0_19_FUNC_CLKOUT = 0x2
	// Master Out Slave In for SSP0.
	IOCON_PIO0_19_FUNC_MOSI0 = 0x3
	// Match output 0 for 16-bit timer 1.
	IOCON_PIO0_19_FUNC_CT16B1_MAT0 = 0x4
	// Position of MODE field.
	IOCON_PIO0_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_19_HYS = 0x20
	// Disable.
	IOCON_PIO0_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_19_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_19_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_19_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_19_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_19_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_19_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_19_OD = 0x400
	// Disable.
	IOCON_PIO0_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_19_RESERVED_Msk = 0xfffff800

	// PIO0_20: I/O configuration register for pin PIO0_20/R/SCK0/ CT32B1_CAP0/ CT16B1_MAT2
	// Position of FUNC field.
	IOCON_PIO0_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_20_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_20_FUNC_PIO0_20 = 0x0
	// Reserved.
	IOCON_PIO0_20_FUNC_R = 0x1
	// Serial clock for SSP0.
	IOCON_PIO0_20_FUNC_SCK0 = 0x2
	// Capture input 0 for 32-bit timer 1.
	IOCON_PIO0_20_FUNC_CT32B1_CAP0 = 0x3
	// Match output 2 for 16-bit timer 1.
	IOCON_PIO0_20_FUNC_CT16B1_MAT2 = 0x4
	// Position of MODE field.
	IOCON_PIO0_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_20_HYS = 0x20
	// Disable.
	IOCON_PIO0_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_20_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_20_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_20_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_20_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_20_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_20_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_20_OD = 0x400
	// Disable.
	IOCON_PIO0_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_20_RESERVED_Msk = 0xfffff800

	// PIO0_21: I/O configuration register for pin PIO0_21/CTS/ ACMP_O/ CT32B1_CAP1/SCLK
	// Position of FUNC field.
	IOCON_PIO0_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_21_FUNC_Msk = 0x7
	// General purpose digital input/output pin. If configured as output, this pin is a high-current source output driver (20 mA).
	IOCON_PIO0_21_FUNC_PIO0_21 = 0x0
	// Clear To Send input for USART.
	IOCON_PIO0_21_FUNC_CTS = 0x1
	// Analog comparator output.
	IOCON_PIO0_21_FUNC_ACMP_O = 0x2
	// Capture input 1 for 32-bit timer 1.
	IOCON_PIO0_21_FUNC_CT32B1_CAP1 = 0x3
	// Serial clock for USART.
	IOCON_PIO0_21_FUNC_SCLK = 0x4
	// Position of MODE field.
	IOCON_PIO0_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_21_HYS = 0x20
	// Disable.
	IOCON_PIO0_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_21_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_21_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_21_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_21_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_21_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_21_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_21_OD = 0x400
	// Disable.
	IOCON_PIO0_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_21_RESERVED_Msk = 0xfffff800

	// PIO0_22: I/O configuration register for pin PIO0_22/MISO0/ ACMP_I5/ CT32B1_MAT2/ CT32B1_CAP2
	// Position of FUNC field.
	IOCON_PIO0_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_22_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_22_FUNC_PIO0_22 = 0x0
	// Master In Slave Out for SSP0. Input glitch filter (10 ns) capable.
	IOCON_PIO0_22_FUNC_MISO0 = 0x1
	// Analog comparator input 5.
	IOCON_PIO0_22_FUNC_ACMP_I5 = 0x2
	// Match output 2 for 32-bit timer 1.
	IOCON_PIO0_22_FUNC_CT32B1_MAT2 = 0x3
	// Capture input 2 for 32-bit timer 1. Input glitch filter (10 ns) capable.
	IOCON_PIO0_22_FUNC_CT32B1_CAP2 = 0x4
	// Position of MODE field.
	IOCON_PIO0_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_22_HYS = 0x20
	// Disable.
	IOCON_PIO0_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_22_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_22_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_22_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_22_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_22_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_22_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_22_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_22_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_22_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_22_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_22_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_22_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_22_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_22_OD = 0x400
	// Disable.
	IOCON_PIO0_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_22_RESERVED_Msk = 0xfffff800

	// PIO0_23: I/O configuration register for pin PIO0_23/RTS/ ACMP_O/ CT32B0_CAP0/SCLK
	// Position of FUNC field.
	IOCON_PIO0_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_23_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_23_FUNC_PIO0_23 = 0x0
	// Request To Send output for USART.
	IOCON_PIO0_23_FUNC_RTS = 0x1
	// Analog comparator output.
	IOCON_PIO0_23_FUNC_ACMP_O = 0x2
	// Capture input 0 for 32-bit timer 0.
	IOCON_PIO0_23_FUNC_CT32B0_CAP0 = 0x3
	// Serial clock for USART.
	IOCON_PIO0_23_FUNC_SCLK = 0x4
	// Position of MODE field.
	IOCON_PIO0_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_23_HYS = 0x20
	// Disable.
	IOCON_PIO0_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_23_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_23_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_23_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_23_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_23_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_23_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_23_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_23_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_23_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_23_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_23_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_23_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_23_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_23_OD = 0x400
	// Disable.
	IOCON_PIO0_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_23_RESERVED_Msk = 0xfffff800

	// PIO0_24: I/O configuration register for pin PIO0_24/SCL/CLKIN/ CT16B1_CAP0
	// Position of FUNC field.
	IOCON_PIO0_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_24_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_24_FUNC_PIO0_24 = 0x0
	// I2C-bus clock input/output. This is not an I2C-bus open-drain pin[8].
	IOCON_PIO0_24_FUNC_SCL = 0x1
	// External clock input.
	IOCON_PIO0_24_FUNC_CLKIN = 0x2
	// Capture input 0 for 16-bit timer 1.
	IOCON_PIO0_24_FUNC_CT16B1_CAP0 = 0x3
	// Position of MODE field.
	IOCON_PIO0_24_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_24_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_24_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_24_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_24_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_24_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_24_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_24_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_24_HYS = 0x20
	// Disable.
	IOCON_PIO0_24_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_24_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_24_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_24_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_24_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_24_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_24_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_24_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_24_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_24_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_24_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_24_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_24_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_24_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_24_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_24_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_24_OD = 0x400
	// Disable.
	IOCON_PIO0_24_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_24_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_24_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_24_RESERVED_Msk = 0xfffff800

	// PIO0_25: I/O configuration register for pin PIO0_25/SDA/SSEL1/ CT16B1_MAT0
	// Position of FUNC field.
	IOCON_PIO0_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_25_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_25_FUNC_PIO0_25 = 0x0
	// I2C-bus data input/output. This is not an I2C-bus open-drain pin[8].
	IOCON_PIO0_25_FUNC_SDA = 0x1
	// Slave Select for SSP1.
	IOCON_PIO0_25_FUNC_SSEL1 = 0x2
	// Match output 0 for 16-bit timer 1.
	IOCON_PIO0_25_FUNC_CT16B1_MAT0 = 0x3
	// Position of MODE field.
	IOCON_PIO0_25_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_25_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_25_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_25_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_25_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_25_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_25_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_25_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_25_HYS = 0x20
	// Disable.
	IOCON_PIO0_25_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_25_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_25_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_25_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_25_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_25_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_25_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_25_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_25_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_25_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_25_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_25_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_25_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_25_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_25_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_25_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_25_OD = 0x400
	// Disable.
	IOCON_PIO0_25_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_25_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_25_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_25_RESERVED_Msk = 0xfffff800

	// PIO0_26: I/O configuration register for pin PIO0_26/TXD/MISO1/ CT16B1_CAP1/ CT32B0_CAP2
	// Position of FUNC field.
	IOCON_PIO0_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_26_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_26_FUNC_PIO0_26 = 0x0
	// Transmitter data output for USART.
	IOCON_PIO0_26_FUNC_TXD = 0x1
	// Master In Slave Out for SSP1.
	IOCON_PIO0_26_FUNC_MISO1 = 0x2
	// Capture input 1 for 16-bit timer 1.
	IOCON_PIO0_26_FUNC_CT16B1_CAP1 = 0x3
	// Capture input 2 for 32-bit timer 0.
	IOCON_PIO0_26_FUNC_CT32B0_CAP2 = 0x4
	// Position of MODE field.
	IOCON_PIO0_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_26_HYS = 0x20
	// Disable.
	IOCON_PIO0_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_26_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_26_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_26_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_26_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_26_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_26_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_26_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_26_OD = 0x400
	// Disable.
	IOCON_PIO0_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_26_RESERVED_Msk = 0xfffff800

	// PIO0_27: I/O configuration register for pin PIO0_27/MOSI1/ ACMP_I1/ CT32B1_MAT1/ CT16B1_CAP2
	// Position of FUNC field.
	IOCON_PIO0_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_27_FUNC_Msk = 0x7
	// General purpose digital input/output pin. Input glitch filter (10 ns) capable.
	IOCON_PIO0_27_FUNC_PIO0_27 = 0x0
	// Master Out Slave In for SSP1. Input glitch filter (10 ns) capable.
	IOCON_PIO0_27_FUNC_MOSI1 = 0x1
	// Analog comparator input 1.
	IOCON_PIO0_27_FUNC_ACMP_I1 = 0x2
	// Match output 1 for 32-bit timer 1.
	IOCON_PIO0_27_FUNC_CT32B1_MAT1 = 0x3
	// Capture input 2 for 16-bit timer 1. Input glitch filter (10 ns) capable.
	IOCON_PIO0_27_FUNC_CT16B1_CAP2 = 0x4
	// Position of MODE field.
	IOCON_PIO0_27_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_27_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_27_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_27_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_27_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_27_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_27_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_27_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_27_HYS = 0x20
	// Disable.
	IOCON_PIO0_27_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_27_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_PIO0_27_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_PIO0_27_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_PIO0_27_ADMODE = 0x80
	// Analog input mode.
	IOCON_PIO0_27_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_PIO0_27_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_PIO0_27_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_PIO0_27_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_PIO0_27_FILTR = 0x100
	// Filter disabled.
	IOCON_PIO0_27_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_PIO0_27_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_27_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_27_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_27_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_27_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_27_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_27_OD = 0x400
	// Disable.
	IOCON_PIO0_27_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_27_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_27_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_27_RESERVED_Msk = 0xfffff800

	// PIO0_28: I/O configuration register for pin PIO0_28/DTR/SSEL1/ CT32B0_CAP0
	// Position of FUNC field.
	IOCON_PIO0_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_28_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_28_FUNC_PIO0_28 = 0x0
	// Data Terminal Ready output for USART.
	IOCON_PIO0_28_FUNC_DTR = 0x1
	// Slave Select for SSP1.
	IOCON_PIO0_28_FUNC_SSEL1 = 0x2
	// Capture input 0 for 32-bit timer 0.
	IOCON_PIO0_28_FUNC_CT32B0_CAP0 = 0x3
	// Position of MODE field.
	IOCON_PIO0_28_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_28_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_28_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_28_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_28_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_28_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_28_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_28_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_28_HYS = 0x20
	// Disable.
	IOCON_PIO0_28_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_28_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_28_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_28_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_28_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_28_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_28_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_28_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_28_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_28_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_28_OD = 0x400
	// Disable.
	IOCON_PIO0_28_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_28_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_28_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_28_RESERVED_Msk = 0xfffff800

	// PIO0_29: I/O configuration register for pin PIO0_29/DSR/SCK1/ CT32B0_CAP1
	// Position of FUNC field.
	IOCON_PIO0_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_29_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_29_FUNC_PIO0_29 = 0x0
	// Data Set Ready input for USART.
	IOCON_PIO0_29_FUNC_DSR = 0x1
	// Serial clock for SSP1.
	IOCON_PIO0_29_FUNC_SCK1 = 0x2
	// Capture input 1 for 32-bit timer 0.
	IOCON_PIO0_29_FUNC_CT32B0_CAP1 = 0x3
	// Position of MODE field.
	IOCON_PIO0_29_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_29_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_29_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_29_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_29_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_29_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_29_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_29_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_29_HYS = 0x20
	// Disable.
	IOCON_PIO0_29_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_29_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_29_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_29_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_29_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_29_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_29_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_29_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_29_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_29_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_29_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_29_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_29_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_29_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_29_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_29_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_29_OD = 0x400
	// Disable.
	IOCON_PIO0_29_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_29_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_29_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_29_RESERVED_Msk = 0xfffff800

	// PIO0_30: I/O configuration register for pin PIO0_30/RI/MOSI1/ CT32B0_MAT0/ CT16B0_CAP0
	// Position of FUNC field.
	IOCON_PIO0_30_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_30_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_30_FUNC_PIO0_30 = 0x0
	// Ring Indicator input for USART.
	IOCON_PIO0_30_FUNC_RI = 0x1
	// Master Out Slave In for SSP1.
	IOCON_PIO0_30_FUNC_MOSI1 = 0x2
	// Match output 0 for 32-bit timer 0.
	IOCON_PIO0_30_FUNC_CT32B0_MAT0 = 0x3
	// Capture input 0 for 16-bit timer 0.
	IOCON_PIO0_30_FUNC_CT16B0_CAP0 = 0x4
	// Position of MODE field.
	IOCON_PIO0_30_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_30_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_30_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_30_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_30_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_30_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_30_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_30_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_30_HYS = 0x20
	// Disable.
	IOCON_PIO0_30_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_30_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_30_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_30_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_30_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_30_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_30_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_30_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_30_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_30_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_30_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_30_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_30_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_30_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_30_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_30_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_30_OD = 0x400
	// Disable.
	IOCON_PIO0_30_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_30_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_30_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_30_RESERVED_Msk = 0xfffff800

	// PIO0_31: I/O configuration register for pin PIO0_31/RI/MOSI1/ CT32B1_MAT0/ CT16B1_CAP1
	// Position of FUNC field.
	IOCON_PIO0_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_31_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO0_31_FUNC_PIO0_31 = 0x0
	// Ring Indicator input for USART.
	IOCON_PIO0_31_FUNC_RI = 0x1
	// Master Out Slave In for SSP1.
	IOCON_PIO0_31_FUNC_MOSI1 = 0x2
	// Match output 0 for 32-bit timer 1.
	IOCON_PIO0_31_FUNC_CT32B1_MAT0 = 0x3
	// Capture input 1 for 16-bit timer 1.
	IOCON_PIO0_31_FUNC_CT16B1_CAP1 = 0x4
	// Position of MODE field.
	IOCON_PIO0_31_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_31_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_31_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_31_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_31_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_31_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_31_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_31_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_31_HYS = 0x20
	// Disable.
	IOCON_PIO0_31_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_31_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_31_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_31_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_31_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO0_31_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_31_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_31_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_31_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO0_31_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_31_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_31_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO0_31_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO0_31_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO0_31_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_31_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_31_OD = 0x400
	// Disable.
	IOCON_PIO0_31_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO0_31_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_31_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_31_RESERVED_Msk = 0xfffff800

	// PIO1_0: I/O configuration register for pin PIO1_0/DCD/SCK0/ CT32B1_MAT3/ CT16B0_MAT1
	// Position of FUNC field.
	IOCON_PIO1_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_0_FUNC_PIO1_0 = 0x0
	// Data Carrier Detect input for USART.
	IOCON_PIO1_0_FUNC_DCD = 0x1
	// Serial clock for SSP0.
	IOCON_PIO1_0_FUNC_SCK0 = 0x2
	// Match output 3 for 32-bit timer 1.
	IOCON_PIO1_0_FUNC_CT32B1_MAT3 = 0x3
	// Match output 1 for 16-bit timer 0.
	IOCON_PIO1_0_FUNC_CT16B0_MAT1 = 0x4
	// Position of MODE field.
	IOCON_PIO1_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_0_HYS = 0x20
	// Disable.
	IOCON_PIO1_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_0_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_0_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_0_OD = 0x400
	// Disable.
	IOCON_PIO1_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_0_RESERVED_Msk = 0xfffff800

	// PIO1_1: I/O configuration register for pin PIO1_1/DTR/SSEL0/ CT32B1_MAT3/ CT16B1_MAT0
	// Position of FUNC field.
	IOCON_PIO1_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_1_FUNC_PIO1_1 = 0x0
	// Data Terminal Ready output for USART.
	IOCON_PIO1_1_FUNC_DTR = 0x1
	// Slave Select for SSP0.
	IOCON_PIO1_1_FUNC_SSEL0 = 0x2
	// Match output 3 for 32-bit timer 1.
	IOCON_PIO1_1_FUNC_CT32B1_MAT3 = 0x3
	// Match output 0 for 16-bit timer 1.
	IOCON_PIO1_1_FUNC_CT16B1_MAT0 = 0x4
	// Position of MODE field.
	IOCON_PIO1_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_1_HYS = 0x20
	// Disable.
	IOCON_PIO1_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_1_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_1_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_1_OD = 0x400
	// Disable.
	IOCON_PIO1_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_1_RESERVED_Msk = 0xfffff800

	// PIO1_2: I/O configuration register for pin PIO1_2/DSR/MISO0/ CT16B1_MAT2/ CT16B1_MAT1
	// Position of FUNC field.
	IOCON_PIO1_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_2_FUNC_PIO1_2 = 0x0
	// Data Set Ready input for USART.
	IOCON_PIO1_2_FUNC_DSR = 0x1
	// Master In Slave Out for SSP0.
	IOCON_PIO1_2_FUNC_MISO0 = 0x2
	// Match output 2 for 16-bit timer 1.
	IOCON_PIO1_2_FUNC_CT16B1_MAT2 = 0x3
	// Match output 1 for 16-bit timer 1.
	IOCON_PIO1_2_FUNC_CT16B1_MAT1 = 0x4
	// Position of MODE field.
	IOCON_PIO1_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_2_HYS = 0x20
	// Disable.
	IOCON_PIO1_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_2_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_2_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_2_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_2_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_2_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_2_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_2_OD = 0x400
	// Disable.
	IOCON_PIO1_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_2_RESERVED_Msk = 0xfffff800

	// PIO1_3: I/O configuration register for pin PIO1_3/RI/MOSI0/ CT16B1_CAP0
	// Position of FUNC field.
	IOCON_PIO1_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_3_FUNC_PIO1_3 = 0x0
	// Ring Indicator input for USART.
	IOCON_PIO1_3_FUNC_RI = 0x1
	// Master Out Slave In for SSP0.
	IOCON_PIO1_3_FUNC_MOSI0 = 0x2
	// Capture input 0 for 16-bit timer 1.
	IOCON_PIO1_3_FUNC_CT16B1_CAP0 = 0x3
	// Position of MODE field.
	IOCON_PIO1_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_3_HYS = 0x20
	// Disable.
	IOCON_PIO1_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_3_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_3_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_3_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_3_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_3_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_3_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_3_OD = 0x400
	// Disable.
	IOCON_PIO1_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_3_RESERVED_Msk = 0xfffff800

	// PIO1_4: I/O configuration register for pin PIO1_4/RXD/SSEL1/ CT32B0_MAT1/ CT32B1_CAP0/ CT16B0_CAP1
	// Position of FUNC field.
	IOCON_PIO1_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_4_FUNC_PIO1_4 = 0x0
	// Receiver data input for USART.
	IOCON_PIO1_4_FUNC_RXD = 0x1
	// Slave Select for SSP1.
	IOCON_PIO1_4_FUNC_SSEL1 = 0x2
	// Match output 1 for 32-bit timer 0.
	IOCON_PIO1_4_FUNC_CT32B0_MAT1 = 0x3
	// Capture input 0 for 32-bit timer 1.
	IOCON_PIO1_4_FUNC_CT32B1_CAP0 = 0x4
	// Capture input 1 for 16-bit timer 0.
	IOCON_PIO1_4_FUNC_CT16B0_CAP1 = 0x5
	// Position of MODE field.
	IOCON_PIO1_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_4_HYS = 0x20
	// Disable.
	IOCON_PIO1_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_4_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_4_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_4_OD = 0x400
	// Disable.
	IOCON_PIO1_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_4_RESERVED_Msk = 0xfffff800

	// PIO1_5: I/O configuration register for pin PIO1_5/TXD/SCK1/ CT32B0_MAT2/ CT32B1_CAP1/ CT16B0_CAP2
	// Position of FUNC field.
	IOCON_PIO1_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_5_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_5_FUNC_PIO1_5 = 0x0
	// Transmitter data output for USART.
	IOCON_PIO1_5_FUNC_TXD = 0x1
	// Serial clock for SSP1.
	IOCON_PIO1_5_FUNC_SCK1 = 0x2
	// Match output 2 for 32-bit timer 0.
	IOCON_PIO1_5_FUNC_CT32B0_MAT2 = 0x3
	// Capture input 1 for 32-bit timer 1.
	IOCON_PIO1_5_FUNC_CT32B1_CAP1 = 0x4
	// Capture input 2 for 16-bit timer 0.
	IOCON_PIO1_5_FUNC_CT16B0_CAP2 = 0x5
	// Position of MODE field.
	IOCON_PIO1_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_5_HYS = 0x20
	// Disable.
	IOCON_PIO1_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_5_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_5_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_5_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_5_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_5_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_5_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_5_OD = 0x400
	// Disable.
	IOCON_PIO1_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_5_RESERVED_Msk = 0xfffff800

	// PIO1_6: I/O configuration register for pin PIO1_6/RTS/MOSI1/ CT32B0_MAT3/ CT32B1_CAP2/ CT16B0_MAT0
	// Position of FUNC field.
	IOCON_PIO1_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_6_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_6_FUNC_PIO1_6 = 0x0
	// Request To Send output for USART.
	IOCON_PIO1_6_FUNC_RTS = 0x1
	// Master Out Slave In for SSP1.
	IOCON_PIO1_6_FUNC_MOSI1 = 0x2
	// Match output 3 for 32-bit timer 0.
	IOCON_PIO1_6_FUNC_CT32B0_MAT3 = 0x3
	// Capture input 2 for 32-bit timer 1.
	IOCON_PIO1_6_FUNC_CT32B1_CAP2 = 0x4
	// Match output 0 for 16-bit timer 0.
	IOCON_PIO1_6_FUNC_CT16B0_MAT0 = 0x5
	// Position of MODE field.
	IOCON_PIO1_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_6_HYS = 0x20
	// Disable.
	IOCON_PIO1_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_6_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_6_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_6_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_6_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_6_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_6_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_6_OD = 0x400
	// Disable.
	IOCON_PIO1_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_6_RESERVED_Msk = 0xfffff800

	// PIO1_7: I/O configuration register for pin PIO1_7/CTS/MOSI0/ CT32B1_MAT1/ CT16B0_MAT2/ CT16B1_CAP2
	// Position of FUNC field.
	IOCON_PIO1_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_7_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_7_FUNC_PIO1_7 = 0x0
	// Clear To Send input for USART.
	IOCON_PIO1_7_FUNC_CTS = 0x1
	// Master Out Slave In for SSP0.
	IOCON_PIO1_7_FUNC_MOSI0 = 0x2
	// Match output 1 for 32-bit timer 1.
	IOCON_PIO1_7_FUNC_CT32B1_MAT1 = 0x3
	// Match output 2 for 16-bit timer 0.
	IOCON_PIO1_7_FUNC_CT16B0_MAT2 = 0x4
	// Capture input 2 for 16-bit timer 1.
	IOCON_PIO1_7_FUNC_CT16B1_CAP2 = 0x5
	// Position of MODE field.
	IOCON_PIO1_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_7_HYS = 0x20
	// Disable.
	IOCON_PIO1_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_7_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_7_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_7_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_7_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_7_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_7_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_7_OD = 0x400
	// Disable.
	IOCON_PIO1_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_7_RESERVED_Msk = 0xfffff800

	// PIO1_8: I/O configuration register for pin PIO1_8/RXD / MISO1/ CT32B1_MAT0/ CT16B1_MAT1
	// Position of FUNC field.
	IOCON_PIO1_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_8_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_8_FUNC_PIO1_8 = 0x0
	// Receiver data input for USART.
	IOCON_PIO1_8_FUNC_RXD = 0x1
	// Master In Slave Out for SSP1.
	IOCON_PIO1_8_FUNC_MISO1 = 0x2
	// Match output 0 for 32-bit timer 1.
	IOCON_PIO1_8_FUNC_CT32B1_MAT0 = 0x3
	// Match output 1 for 16-bit timer 1.
	IOCON_PIO1_8_FUNC_CT16B1_MAT1 = 0x4
	// Position of MODE field.
	IOCON_PIO1_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_8_HYS = 0x20
	// Disable.
	IOCON_PIO1_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_8_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_8_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_8_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_8_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_8_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_8_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_8_OD = 0x400
	// Disable.
	IOCON_PIO1_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_8_RESERVED_Msk = 0xfffff800

	// PIO1_9: I/O configuration register for pin PIO1_9/DCD/R/ CT32B1_MAT2 / CT16B1_MAT2
	// Position of FUNC field.
	IOCON_PIO1_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_9_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_PIO1_9_FUNC_PIO1_9 = 0x0
	// Data Carrier Detect input for USART.
	IOCON_PIO1_9_FUNC_DCD = 0x1
	// Reserved.
	IOCON_PIO1_9_FUNC_R = 0x2
	// Match output 2 for 32-bit timer 1.
	IOCON_PIO1_9_FUNC_CT32B1_MAT2 = 0x3
	// Match output 2 for 16-bit timer 1.
	IOCON_PIO1_9_FUNC_CT16B1_MAT2 = 0x4
	// Position of MODE field.
	IOCON_PIO1_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO1_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_9_HYS = 0x20
	// Disable.
	IOCON_PIO1_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO1_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO1_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_PIO1_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_9_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_PIO1_9_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_9_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_9_SLEW = 0x200
	// Slow. More outputs can be switched simultaneously.
	IOCON_PIO1_9_SLEW_SLOW = 0x0
	// Fast.
	IOCON_PIO1_9_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_PIO1_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_9_OD = 0x400
	// Disable.
	IOCON_PIO1_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_PIO1_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_9_RESERVED_Msk = 0xfffff800
)

// Constants for SYSCON: System configuration
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE_IN = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE_INTER = 0x1
	// User Flash Mode. Interrupt vectors are not re-mapped and reside in Flash.
	SYSCON_SYSMEMREMAP_MAP_USER_FLASH_MODE_INT = 0x2
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// PRESETCTRL: Peripheral reset control
	// Position of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Pos = 0x0
	// Bit mask of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Msk = 0x1
	// Bit SSP0_RST_N.
	SYSCON_PRESETCTRL_SSP0_RST_N = 0x1
	// Resets the SSP0 peripheral.
	SYSCON_PRESETCTRL_SSP0_RST_N_RESETS_THE_SSP0_PERI = 0x0
	// SSP0 reset de-asserted.
	SYSCON_PRESETCTRL_SSP0_RST_N_SSP0_RESET_DE_ASSERT = 0x1
	// Position of I2C_RST_N field.
	SYSCON_PRESETCTRL_I2C_RST_N_Pos = 0x1
	// Bit mask of I2C_RST_N field.
	SYSCON_PRESETCTRL_I2C_RST_N_Msk = 0x2
	// Bit I2C_RST_N.
	SYSCON_PRESETCTRL_I2C_RST_N = 0x2
	// Resets the I2C peripheral.
	SYSCON_PRESETCTRL_I2C_RST_N_RESETS_THE_I2C_PERIP = 0x0
	// I2C reset de-asserted.
	SYSCON_PRESETCTRL_I2C_RST_N_I2C_RESET_DE_ASSERTE = 0x1
	// Position of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Pos = 0x2
	// Bit mask of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Msk = 0x4
	// Bit SSP1_RST_N.
	SYSCON_PRESETCTRL_SSP1_RST_N = 0x4
	// Resets the SSP1 peripheral.
	SYSCON_PRESETCTRL_SSP1_RST_N_RESETS_THE_SSP1_PERI = 0x0
	// SSP1 reset de-asserted.
	SYSCON_PRESETCTRL_SSP1_RST_N_SSP1_RESET_DE_ASSERT = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SYSCON_PRESETCTRL_RESERVED = 0x8
	// Position of UART_RST_N field.
	SYSCON_PRESETCTRL_UART_RST_N_Pos = 0x4
	// Bit mask of UART_RST_N field.
	SYSCON_PRESETCTRL_UART_RST_N_Msk = 0x10
	// Bit UART_RST_N.
	SYSCON_PRESETCTRL_UART_RST_N = 0x10
	// Resets the UART peripheral.
	SYSCON_PRESETCTRL_UART_RST_N_RESETS_THE_UART_PERI = 0x0
	// UART reset de-asserted.
	SYSCON_PRESETCTRL_UART_RST_N_UART_RESET_DE_ASSERT = 0x1
	// Position of CT16B0_RST_N field.
	SYSCON_PRESETCTRL_CT16B0_RST_N_Pos = 0x5
	// Bit mask of CT16B0_RST_N field.
	SYSCON_PRESETCTRL_CT16B0_RST_N_Msk = 0x20
	// Bit CT16B0_RST_N.
	SYSCON_PRESETCTRL_CT16B0_RST_N = 0x20
	// Resets the CT16B0 peripheral.
	SYSCON_PRESETCTRL_CT16B0_RST_N_RESETS_THE_CT16B0_PE = 0x0
	// CT16B0 reset de-asserted.
	SYSCON_PRESETCTRL_CT16B0_RST_N_CT16B0_RESET_DE_ASSE = 0x1
	// Position of CT16B1_RST_N field.
	SYSCON_PRESETCTRL_CT16B1_RST_N_Pos = 0x6
	// Bit mask of CT16B1_RST_N field.
	SYSCON_PRESETCTRL_CT16B1_RST_N_Msk = 0x40
	// Bit CT16B1_RST_N.
	SYSCON_PRESETCTRL_CT16B1_RST_N = 0x40
	// Resets the CT16B1 peripheral.
	SYSCON_PRESETCTRL_CT16B1_RST_N_RESETS_THE_CT16B1_PE = 0x0
	// CT16B1 reset de-asserted.
	SYSCON_PRESETCTRL_CT16B1_RST_N_CT16B1_RESET_DE_ASSE = 0x1
	// Position of CT32B0_RST_N field.
	SYSCON_PRESETCTRL_CT32B0_RST_N_Pos = 0x7
	// Bit mask of CT32B0_RST_N field.
	SYSCON_PRESETCTRL_CT32B0_RST_N_Msk = 0x80
	// Bit CT32B0_RST_N.
	SYSCON_PRESETCTRL_CT32B0_RST_N = 0x80
	// Resets the CT32B0 peripheral.
	SYSCON_PRESETCTRL_CT32B0_RST_N_RESETS_THE_CT32B0_PE = 0x0
	// CT32B0 reset de-asserted.
	SYSCON_PRESETCTRL_CT32B0_RST_N_CT32B0_RESET_DE_ASSE = 0x1
	// Position of CT32B1_RST_N field.
	SYSCON_PRESETCTRL_CT32B1_RST_N_Pos = 0x8
	// Bit mask of CT32B1_RST_N field.
	SYSCON_PRESETCTRL_CT32B1_RST_N_Msk = 0x100
	// Bit CT32B1_RST_N.
	SYSCON_PRESETCTRL_CT32B1_RST_N = 0x100
	// Resets the CT32B1 peripheral.
	SYSCON_PRESETCTRL_CT32B1_RST_N_RESETS_THE_CT32B1_PE = 0x0
	// CT32B1 reset de-asserted.
	SYSCON_PRESETCTRL_CT32B1_RST_N_CT32B1_RESET_DE_ASSE = 0x1
	// Position of ACOMP_RST_N field.
	SYSCON_PRESETCTRL_ACOMP_RST_N_Pos = 0x9
	// Bit mask of ACOMP_RST_N field.
	SYSCON_PRESETCTRL_ACOMP_RST_N_Msk = 0x200
	// Bit ACOMP_RST_N.
	SYSCON_PRESETCTRL_ACOMP_RST_N = 0x200
	// Resets the Analog comparator peripheral.
	SYSCON_PRESETCTRL_ACOMP_RST_N_RESETS_THE_ANALOG_CO = 0x0
	// Analog comparator reset de-asserted.
	SYSCON_PRESETCTRL_ACOMP_RST_N_ANALOG_COMPARATOR_RE = 0x1
	// Position of DAC_RST_N field.
	SYSCON_PRESETCTRL_DAC_RST_N_Pos = 0xa
	// Bit mask of DAC_RST_N field.
	SYSCON_PRESETCTRL_DAC_RST_N_Msk = 0x400
	// Bit DAC_RST_N.
	SYSCON_PRESETCTRL_DAC_RST_N = 0x400
	// Resets the DAC peripheral.
	SYSCON_PRESETCTRL_DAC_RST_N_RESETS_THE_DAC_PERIP = 0x0
	// DAC reset de-asserted.
	SYSCON_PRESETCTRL_DAC_RST_N_DAC_RESET_DE_ASSERTE = 0x1
	// Position of ADC_RST_N field.
	SYSCON_PRESETCTRL_ADC_RST_N_Pos = 0xb
	// Bit mask of ADC_RST_N field.
	SYSCON_PRESETCTRL_ADC_RST_N_Msk = 0x800
	// Bit ADC_RST_N.
	SYSCON_PRESETCTRL_ADC_RST_N = 0x800
	// Resets the ADC peripheral.
	SYSCON_PRESETCTRL_ADC_RST_N_RESETS_THE_ADC_PERIP = 0x0
	// ADC reset de-asserted.
	SYSCON_PRESETCTRL_ADC_RST_N_ADC_RESET_DE_ASSERTE = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0xfffff000

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff80

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_OSCILLATOR_IS_NOT_BY = 0x0
	// Bypass enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pins.
	SYSCON_SYSOSCCTRL_BYPASS_BYPASS_ENABLED_PLL_ = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_1__20_MHZ_FREQUENCY = 0x0
	// 15 - 25 MHz frequency range
	SYSCON_SYSOSCCTRL_FREQRANGE_15__25_MHZ_FREQUENC = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// WDTOSCCTRL: Watchdog oscillator control
	// Position of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Msk = 0x1e0
	// Operation is undefined for this value. Startup code should program a non-zero value in this field as soon after reset as possible.
	SYSCON_WDTOSCCTRL_FREQSEL_OPERATION_IS_UNDEFIN = 0x0
	// 0.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_0_6_MHZ = 0x1
	// 1.05 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_05_MHZ = 0x2
	// 1.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_4_MHZ = 0x3
	// 1.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_75_MHZ = 0x4
	// 2.1 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_1_MHZ = 0x5
	// 2.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_4_MHZ = 0x6
	// 2.7 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_7_MHZ = 0x7
	// 3.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_0_MHZ = 0x8
	// 3.25 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_25_MHZ = 0x9
	// 3.5 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_5_MHZ = 0xa
	// 3.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_75_MHZ = 0xb
	// 4.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_0_MHZ = 0xc
	// 4.2 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_2_MHZ = 0xd
	// 4.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_4_MHZ = 0xe
	// 4.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_6_MHZ = 0xf
	// Position of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Msk = 0xfffffe00

	// IRCCTRL: IRC oscillator control
	// Position of TRIM field.
	SYSCON_IRCCTRL_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	SYSCON_IRCCTRL_TRIM_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Msk = 0xfffffe00

	// LFOSCCTRL: LF oscillator control
	// Position of DIVSEL field.
	SYSCON_LFOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_LFOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_LFOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_LFOSCCTRL_FREQSEL_Msk = 0x1e0
	// Operation is undefined for this value. Startup code should program a non-zero value in this field as soon after reset as possible.
	SYSCON_LFOSCCTRL_FREQSEL_OPERATION_IS_UNDEFIN = 0x0
	// 0.6 MHz
	SYSCON_LFOSCCTRL_FREQSEL_0_6_MHZ = 0x1
	// 1.05 MHz
	SYSCON_LFOSCCTRL_FREQSEL_1_05_MHZ = 0x2
	// 1.4 MHz
	SYSCON_LFOSCCTRL_FREQSEL_1_4_MHZ = 0x3
	// 1.75 MHz
	SYSCON_LFOSCCTRL_FREQSEL_1_75_MHZ = 0x4
	// 2.1 MHz
	SYSCON_LFOSCCTRL_FREQSEL_2_1_MHZ = 0x5
	// 2.4 MHz
	SYSCON_LFOSCCTRL_FREQSEL_2_4_MHZ = 0x6
	// 2.7 MHz
	SYSCON_LFOSCCTRL_FREQSEL_2_7_MHZ = 0x7
	// 3.0 MHz
	SYSCON_LFOSCCTRL_FREQSEL_3_0_MHZ = 0x8
	// 3.25 MHz
	SYSCON_LFOSCCTRL_FREQSEL_3_25_MHZ = 0x9
	// 3.5 MHz
	SYSCON_LFOSCCTRL_FREQSEL_3_5_MHZ = 0xa
	// 3.75 MHz
	SYSCON_LFOSCCTRL_FREQSEL_3_75_MHZ = 0xb
	// 4.0 MHz
	SYSCON_LFOSCCTRL_FREQSEL_4_0_MHZ = 0xc
	// 4.2 MHz
	SYSCON_LFOSCCTRL_FREQSEL_4_2_MHZ = 0xd
	// 4.4 MHz
	SYSCON_LFOSCCTRL_FREQSEL_4_4_MHZ = 0xe
	// 4.6 MHz
	SYSCON_LFOSCCTRL_FREQSEL_4_6_MHZ = 0xf
	// Position of RESERVED field.
	SYSCON_LFOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_LFOSCCTRL_RESERVED_Msk = 0xfffffe00

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No RESET event detected
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// RESET detected
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SYSPLLCLKSEL_SEL_IRC = 0x0
	// Crystal Oscillator (XTAL)
	SYSCON_SYSPLLCLKSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// CLKIN pin
	SYSCON_SYSPLLCLKSEL_SEL_CLKIN_PIN = 0x2
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKUEN: System PLL clock source update enable
	// Position of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_SYSPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_SYSPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_SYSPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// MAINCLKSEL: Main clock source select
	// Position of SEL field.
	SYSCON_MAINCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// PLL input
	SYSCON_MAINCLKSEL_SEL_PLL_INPUT = 0x1
	// LF Oscillator
	SYSCON_MAINCLKSEL_SEL_LF_OSCILLATOR = 0x2
	// PLL output
	SYSCON_MAINCLKSEL_SEL_PLL_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Msk = 0xfffffffc

	// MAINCLKUEN: Main clock source update enable
	// Position of ENA field.
	SYSCON_MAINCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_MAINCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_MAINCLKUEN_ENA = 0x1
	// No change
	SYSCON_MAINCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_MAINCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Msk = 0xfffffffe

	// SYSAHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL: System clock control
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL_SYS = 0x1
	// Enable
	SYSCON_SYSAHBCLKCTRL_SYS_ENABLE = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ROM_ENABLE = 0x1
	// Position of RAM field.
	SYSCON_SYSAHBCLKCTRL_RAM_Pos = 0x2
	// Bit mask of RAM field.
	SYSCON_SYSAHBCLKCTRL_RAM_Msk = 0x4
	// Bit RAM.
	SYSCON_SYSAHBCLKCTRL_RAM = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM_ENABLE = 0x1
	// Position of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Pos = 0x3
	// Bit mask of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Msk = 0x8
	// Bit FLASHREG.
	SYSCON_SYSAHBCLKCTRL_FLASHREG = 0x8
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_ENABLED = 0x1
	// Position of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Pos = 0x4
	// Bit mask of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Msk = 0x10
	// Bit FLASHARRAY.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY = 0x10
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_ENABLED = 0x1
	// Position of I2C field.
	SYSCON_SYSAHBCLKCTRL_I2C_Pos = 0x5
	// Bit mask of I2C field.
	SYSCON_SYSAHBCLKCTRL_I2C_Msk = 0x20
	// Bit I2C.
	SYSCON_SYSAHBCLKCTRL_I2C = 0x20
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C_ENABLE = 0x1
	// Position of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Pos = 0x6
	// Bit mask of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Msk = 0x40
	// Bit GPIO.
	SYSCON_SYSAHBCLKCTRL_GPIO = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL_GPIO_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GPIO_ENABLE = 0x1
	// Position of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Pos = 0x7
	// Bit mask of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Msk = 0x80
	// Bit CT16B0.
	SYSCON_SYSAHBCLKCTRL_CT16B0 = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B0_ENABLE = 0x1
	// Position of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Pos = 0x8
	// Bit mask of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Msk = 0x100
	// Bit CT16B1.
	SYSCON_SYSAHBCLKCTRL_CT16B1 = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B1_ENABLE = 0x1
	// Position of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Pos = 0x9
	// Bit mask of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Msk = 0x200
	// Bit CT32B0.
	SYSCON_SYSAHBCLKCTRL_CT32B0 = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B0_ENABLE = 0x1
	// Position of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Pos = 0xa
	// Bit mask of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Msk = 0x400
	// Bit CT32B1.
	SYSCON_SYSAHBCLKCTRL_CT32B1 = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B1_ENABLE = 0x1
	// Position of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Pos = 0xb
	// Bit mask of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Msk = 0x800
	// Bit SSP0.
	SYSCON_SYSAHBCLKCTRL_SSP0 = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP0_ENABLE = 0x1
	// Position of UART field.
	SYSCON_SYSAHBCLKCTRL_UART_Pos = 0xc
	// Bit mask of UART field.
	SYSCON_SYSAHBCLKCTRL_UART_Msk = 0x1000
	// Bit UART.
	SYSCON_SYSAHBCLKCTRL_UART = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL_UART_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_UART_ENABLE = 0x1
	// Position of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Pos = 0xd
	// Bit mask of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Msk = 0x2000
	// Bit ADC.
	SYSCON_SYSAHBCLKCTRL_ADC = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ADC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ADC_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x4000
	// Position of WDT field.
	SYSCON_SYSAHBCLKCTRL_WDT_Pos = 0xf
	// Bit mask of WDT field.
	SYSCON_SYSAHBCLKCTRL_WDT_Msk = 0x8000
	// Bit WDT.
	SYSCON_SYSAHBCLKCTRL_WDT = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL_WDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WDT_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Pos = 0x10
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Msk = 0x10000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL_IOCON = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_IOCON_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x20000
	// Position of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Pos = 0x12
	// Bit mask of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Msk = 0x40000
	// Bit SSP1.
	SYSCON_SYSAHBCLKCTRL_SSP1 = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP1_ENABLE = 0x1
	// Position of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Pos = 0x13
	// Bit mask of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Msk = 0x80000
	// Bit PINT.
	SYSCON_SYSAHBCLKCTRL_PINT = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL_PINT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_PINT_ENABLE = 0x1
	// Position of ACOMP field.
	SYSCON_SYSAHBCLKCTRL_ACOMP_Pos = 0x14
	// Bit mask of ACOMP field.
	SYSCON_SYSAHBCLKCTRL_ACOMP_Msk = 0x100000
	// Bit ACOMP.
	SYSCON_SYSAHBCLKCTRL_ACOMP = 0x100000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ACOMP_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ACOMP_ENABLE = 0x1
	// Position of DAC field.
	SYSCON_SYSAHBCLKCTRL_DAC_Pos = 0x15
	// Bit mask of DAC field.
	SYSCON_SYSAHBCLKCTRL_DAC_Msk = 0x200000
	// Bit DAC.
	SYSCON_SYSAHBCLKCTRL_DAC = 0x200000
	// Disable
	SYSCON_SYSAHBCLKCTRL_DAC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_DAC_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x400000
	// Position of P0INT field.
	SYSCON_SYSAHBCLKCTRL_P0INT_Pos = 0x17
	// Bit mask of P0INT field.
	SYSCON_SYSAHBCLKCTRL_P0INT_Msk = 0x800000
	// Bit P0INT.
	SYSCON_SYSAHBCLKCTRL_P0INT = 0x800000
	// Disable
	SYSCON_SYSAHBCLKCTRL_P0INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_P0INT_ENABLE = 0x1
	// Position of P1INT field.
	SYSCON_SYSAHBCLKCTRL_P1INT_Pos = 0x18
	// Bit mask of P1INT field.
	SYSCON_SYSAHBCLKCTRL_P1INT_Msk = 0x1000000
	// Bit P1INT.
	SYSCON_SYSAHBCLKCTRL_P1INT = 0x1000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_P1INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_P1INT_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0xfe000000

	// SSP0CLKDIV: SSP0 clock divider
	// Position of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Msk = 0xffffff00

	// UARTCLKDIV: UART clock divider
	// Position of DIV field.
	SYSCON_UARTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Msk = 0xffffff00

	// SSP1CLKDIV: SSP1 clock divider
	// Position of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTSEL: CLKOUT clock source select
	// Position of SEL field.
	SYSCON_CLKOUTSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTSEL_SEL_IRC_OSCILLATOR = 0x0
	// Crystal oscillator (XTAL)
	SYSCON_CLKOUTSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// LF oscillator
	SYSCON_CLKOUTSEL_SEL_LF_OSCILLATOR = 0x2
	// Main clock
	SYSCON_CLKOUTSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTUEN: CLKOUT clock source update enable
	// Position of ENA field.
	SYSCON_CLKOUTUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_CLKOUTUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_CLKOUTUEN_ENA = 0x1
	// No change
	SYSCON_CLKOUTUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_CLKOUTUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Msk = 0xfffffffe

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Msk = 0xffffffff

	// PIOPORCAP1: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Msk = 0x3ff
	// Position of RESERVED field.
	SYSCON_PIOPORCAP1_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP1_RESERVED_Msk = 0xfffffc00

	// BODR: Brown-Out Detect
	// Position of RESERVED field.
	SYSCON_BODR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_BODR_RESERVED_Msk = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODR_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODR_BODINTVAL_Msk = 0xc
	// Level 2: the interrupt assertion threshold voltage is 2.52 V; the interrupt de-assertion threshold voltage is 2.66 V.
	SYSCON_BODR_BODINTVAL_LEVEL_2_THE_INTERRU = 0x2
	// Level 3: the interrupt assertion threshold voltage is 2.80 V; the interrupt de-assertion threshold voltage is 2.90 V.
	SYSCON_BODR_BODINTVAL_LEVEL_3_THE_INTERRU = 0x3
	// Position of RESERVED field.
	SYSCON_BODR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_BODR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	SYSCON_BODR_RESERVED = 0x10
	// Position of RESERVED field.
	SYSCON_BODR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	SYSCON_BODR_RESERVED = 0x20
	// Position of BODINT field.
	SYSCON_BODR_BODINT_Pos = 0x6
	// Bit mask of BODINT field.
	SYSCON_BODR_BODINT_Msk = 0x40
	// Bit BODINT.
	SYSCON_BODR_BODINT = 0x40
	// Position of RESERVED field.
	SYSCON_BODR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_BODR_RESERVED_Msk = 0xffffff80

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// NMISRC: NMI Source Control
	// Position of IRQNO field.
	SYSCON_NMISRC_IRQNO_Pos = 0x0
	// Bit mask of IRQNO field.
	SYSCON_NMISRC_IRQNO_Msk = 0x1f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x7fffffe0
	// Position of NMIEN field.
	SYSCON_NMISRC_NMIEN_Pos = 0x1f
	// Bit mask of NMIEN field.
	SYSCON_NMISRC_NMIEN_Msk = 0x80000000
	// Bit NMIEN.
	SYSCON_NMISRC_NMIEN = 0x80000000

	// PINTSEL0: GPIO Pin Interrupt Select register 0
	// Position of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Msk = 0x1f
	// Position of INTPORT field.
	SYSCON_PINTSEL_INTPORT_Pos = 0x5
	// Bit mask of INTPORT field.
	SYSCON_PINTSEL_INTPORT_Msk = 0x20
	// Bit INTPORT.
	SYSCON_PINTSEL_INTPORT = 0x20
	// Position of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Msk = 0xffffffc0

	// PDRUNCFG: Power configuration register
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x1
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Position of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDRUNCFG_IRC_PD = 0x2
	// Powered down
	SYSCON_PDRUNCFG_IRC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRC_PD_POWERED = 0x0
	// Position of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDRUNCFG_FLASH_PD = 0x4
	// Powered down
	SYSCON_PDRUNCFG_FLASH_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_FLASH_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x8
	// Position of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDRUNCFG_ADC_PD = 0x10
	// Powered down
	SYSCON_PDRUNCFG_ADC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_ADC_PD_POWERED = 0x0
	// Position of XTAL_PD field.
	SYSCON_PDRUNCFG_XTAL_PD_Pos = 0x5
	// Bit mask of XTAL_PD field.
	SYSCON_PDRUNCFG_XTAL_PD_Msk = 0x20
	// Bit XTAL_PD.
	SYSCON_PDRUNCFG_XTAL_PD = 0x20
	// Powered down
	SYSCON_PDRUNCFG_XTAL_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_XTAL_PD_POWERED = 0x0
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x40
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x80
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x1000
	// Position of LFOSC_PD field.
	SYSCON_PDRUNCFG_LFOSC_PD_Pos = 0xd
	// Bit mask of LFOSC_PD field.
	SYSCON_PDRUNCFG_LFOSC_PD_Msk = 0x2000
	// Bit LFOSC_PD.
	SYSCON_PDRUNCFG_LFOSC_PD = 0x2000
	// Powered down
	SYSCON_PDRUNCFG_LFOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_LFOSC_PD_POWERED = 0x0
	// Position of DAC_PD field.
	SYSCON_PDRUNCFG_DAC_PD_Pos = 0xe
	// Bit mask of DAC_PD field.
	SYSCON_PDRUNCFG_DAC_PD_Msk = 0x4000
	// Bit DAC_PD.
	SYSCON_PDRUNCFG_DAC_PD = 0x4000
	// Powered down
	SYSCON_PDRUNCFG_DAC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_DAC_PD_POWERED = 0x0
	// Position of TS_PD field.
	SYSCON_PDRUNCFG_TS_PD_Pos = 0xf
	// Bit mask of TS_PD field.
	SYSCON_PDRUNCFG_TS_PD_Msk = 0x8000
	// Bit TS_PD.
	SYSCON_PDRUNCFG_TS_PD = 0x8000
	// Powered down
	SYSCON_PDRUNCFG_TS_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_TS_PD_POWERED = 0x0
	// Position of ACOMP_PD field.
	SYSCON_PDRUNCFG_ACOMP_PD_Pos = 0x10
	// Bit mask of ACOMP_PD field.
	SYSCON_PDRUNCFG_ACOMP_PD_Msk = 0x10000
	// Bit ACOMP_PD.
	SYSCON_PDRUNCFG_ACOMP_PD = 0x10000
	// Powered down
	SYSCON_PDRUNCFG_ACOMP_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDRUNCFG_ACOMP_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xfffe0000

	// DEVICE_ID: Device ID
	// Position of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Msk = 0xffffffff
)

// Constants for GPIO_PIN_INT: GPIO Modification
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE0 field.
	GPIO_PIN_INT_ISEL_PMODE0_Pos = 0x0
	// Bit mask of PMODE0 field.
	GPIO_PIN_INT_ISEL_PMODE0_Msk = 0x1
	// Bit PMODE0.
	GPIO_PIN_INT_ISEL_PMODE0 = 0x1
	// Position of PMODE1 field.
	GPIO_PIN_INT_ISEL_PMODE1_Pos = 0x1
	// Bit mask of PMODE1 field.
	GPIO_PIN_INT_ISEL_PMODE1_Msk = 0x2
	// Bit PMODE1.
	GPIO_PIN_INT_ISEL_PMODE1 = 0x2
	// Position of PMODE2 field.
	GPIO_PIN_INT_ISEL_PMODE2_Pos = 0x2
	// Bit mask of PMODE2 field.
	GPIO_PIN_INT_ISEL_PMODE2_Msk = 0x4
	// Bit PMODE2.
	GPIO_PIN_INT_ISEL_PMODE2 = 0x4
	// Position of PMODE3 field.
	GPIO_PIN_INT_ISEL_PMODE3_Pos = 0x3
	// Bit mask of PMODE3 field.
	GPIO_PIN_INT_ISEL_PMODE3_Msk = 0x8
	// Bit PMODE3.
	GPIO_PIN_INT_ISEL_PMODE3 = 0x8
	// Position of PMODE4 field.
	GPIO_PIN_INT_ISEL_PMODE4_Pos = 0x4
	// Bit mask of PMODE4 field.
	GPIO_PIN_INT_ISEL_PMODE4_Msk = 0x10
	// Bit PMODE4.
	GPIO_PIN_INT_ISEL_PMODE4 = 0x10
	// Position of PMODE5 field.
	GPIO_PIN_INT_ISEL_PMODE5_Pos = 0x5
	// Bit mask of PMODE5 field.
	GPIO_PIN_INT_ISEL_PMODE5_Msk = 0x20
	// Bit PMODE5.
	GPIO_PIN_INT_ISEL_PMODE5 = 0x20
	// Position of PMODE6 field.
	GPIO_PIN_INT_ISEL_PMODE6_Pos = 0x6
	// Bit mask of PMODE6 field.
	GPIO_PIN_INT_ISEL_PMODE6_Msk = 0x40
	// Bit PMODE6.
	GPIO_PIN_INT_ISEL_PMODE6 = 0x40
	// Position of PMODE7 field.
	GPIO_PIN_INT_ISEL_PMODE7_Pos = 0x7
	// Bit mask of PMODE7 field.
	GPIO_PIN_INT_ISEL_PMODE7_Msk = 0x80
	// Bit PMODE7.
	GPIO_PIN_INT_ISEL_PMODE7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin Interrupt Enable (Rising) register
	// Position of ENRL0 field.
	GPIO_PIN_INT_IENR_ENRL0_Pos = 0x0
	// Bit mask of ENRL0 field.
	GPIO_PIN_INT_IENR_ENRL0_Msk = 0x1
	// Bit ENRL0.
	GPIO_PIN_INT_IENR_ENRL0 = 0x1
	// Position of ENRL1 field.
	GPIO_PIN_INT_IENR_ENRL1_Pos = 0x1
	// Bit mask of ENRL1 field.
	GPIO_PIN_INT_IENR_ENRL1_Msk = 0x2
	// Bit ENRL1.
	GPIO_PIN_INT_IENR_ENRL1 = 0x2
	// Position of ENRL2 field.
	GPIO_PIN_INT_IENR_ENRL2_Pos = 0x2
	// Bit mask of ENRL2 field.
	GPIO_PIN_INT_IENR_ENRL2_Msk = 0x4
	// Bit ENRL2.
	GPIO_PIN_INT_IENR_ENRL2 = 0x4
	// Position of ENRL3 field.
	GPIO_PIN_INT_IENR_ENRL3_Pos = 0x3
	// Bit mask of ENRL3 field.
	GPIO_PIN_INT_IENR_ENRL3_Msk = 0x8
	// Bit ENRL3.
	GPIO_PIN_INT_IENR_ENRL3 = 0x8
	// Position of ENRL4 field.
	GPIO_PIN_INT_IENR_ENRL4_Pos = 0x4
	// Bit mask of ENRL4 field.
	GPIO_PIN_INT_IENR_ENRL4_Msk = 0x10
	// Bit ENRL4.
	GPIO_PIN_INT_IENR_ENRL4 = 0x10
	// Position of ENRL5 field.
	GPIO_PIN_INT_IENR_ENRL5_Pos = 0x5
	// Bit mask of ENRL5 field.
	GPIO_PIN_INT_IENR_ENRL5_Msk = 0x20
	// Bit ENRL5.
	GPIO_PIN_INT_IENR_ENRL5 = 0x20
	// Position of ENRL6 field.
	GPIO_PIN_INT_IENR_ENRL6_Pos = 0x6
	// Bit mask of ENRL6 field.
	GPIO_PIN_INT_IENR_ENRL6_Msk = 0x40
	// Bit ENRL6.
	GPIO_PIN_INT_IENR_ENRL6 = 0x40
	// Position of ENRL7 field.
	GPIO_PIN_INT_IENR_ENRL7_Pos = 0x7
	// Bit mask of ENRL7 field.
	GPIO_PIN_INT_IENR_ENRL7_Msk = 0x80
	// Bit ENRL7.
	GPIO_PIN_INT_IENR_ENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Set Pin Interrupt Enable (Rising) register
	// Position of SETENRL0 field.
	GPIO_PIN_INT_SIENR_SETENRL0_Pos = 0x0
	// Bit mask of SETENRL0 field.
	GPIO_PIN_INT_SIENR_SETENRL0_Msk = 0x1
	// Bit SETENRL0.
	GPIO_PIN_INT_SIENR_SETENRL0 = 0x1
	// Position of SETENRL1 field.
	GPIO_PIN_INT_SIENR_SETENRL1_Pos = 0x1
	// Bit mask of SETENRL1 field.
	GPIO_PIN_INT_SIENR_SETENRL1_Msk = 0x2
	// Bit SETENRL1.
	GPIO_PIN_INT_SIENR_SETENRL1 = 0x2
	// Position of SETENRL2 field.
	GPIO_PIN_INT_SIENR_SETENRL2_Pos = 0x2
	// Bit mask of SETENRL2 field.
	GPIO_PIN_INT_SIENR_SETENRL2_Msk = 0x4
	// Bit SETENRL2.
	GPIO_PIN_INT_SIENR_SETENRL2 = 0x4
	// Position of SETENRL3 field.
	GPIO_PIN_INT_SIENR_SETENRL3_Pos = 0x3
	// Bit mask of SETENRL3 field.
	GPIO_PIN_INT_SIENR_SETENRL3_Msk = 0x8
	// Bit SETENRL3.
	GPIO_PIN_INT_SIENR_SETENRL3 = 0x8
	// Position of SETENRL4 field.
	GPIO_PIN_INT_SIENR_SETENRL4_Pos = 0x4
	// Bit mask of SETENRL4 field.
	GPIO_PIN_INT_SIENR_SETENRL4_Msk = 0x10
	// Bit SETENRL4.
	GPIO_PIN_INT_SIENR_SETENRL4 = 0x10
	// Position of SETENRL5 field.
	GPIO_PIN_INT_SIENR_SETENRL5_Pos = 0x5
	// Bit mask of SETENRL5 field.
	GPIO_PIN_INT_SIENR_SETENRL5_Msk = 0x20
	// Bit SETENRL5.
	GPIO_PIN_INT_SIENR_SETENRL5 = 0x20
	// Position of SETENRL6 field.
	GPIO_PIN_INT_SIENR_SETENRL6_Pos = 0x6
	// Bit mask of SETENRL6 field.
	GPIO_PIN_INT_SIENR_SETENRL6_Msk = 0x40
	// Bit SETENRL6.
	GPIO_PIN_INT_SIENR_SETENRL6 = 0x40
	// Position of SETENRL7 field.
	GPIO_PIN_INT_SIENR_SETENRL7_Pos = 0x7
	// Bit mask of SETENRL7 field.
	GPIO_PIN_INT_SIENR_SETENRL7_Msk = 0x80
	// Bit SETENRL7.
	GPIO_PIN_INT_SIENR_SETENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Clear Pin Interrupt Enable (Rising) register
	// Position of CENRL0 field.
	GPIO_PIN_INT_CIENR_CENRL0_Pos = 0x0
	// Bit mask of CENRL0 field.
	GPIO_PIN_INT_CIENR_CENRL0_Msk = 0x1
	// Bit CENRL0.
	GPIO_PIN_INT_CIENR_CENRL0 = 0x1
	// Position of CENRL1 field.
	GPIO_PIN_INT_CIENR_CENRL1_Pos = 0x1
	// Bit mask of CENRL1 field.
	GPIO_PIN_INT_CIENR_CENRL1_Msk = 0x2
	// Bit CENRL1.
	GPIO_PIN_INT_CIENR_CENRL1 = 0x2
	// Position of CENRL2 field.
	GPIO_PIN_INT_CIENR_CENRL2_Pos = 0x2
	// Bit mask of CENRL2 field.
	GPIO_PIN_INT_CIENR_CENRL2_Msk = 0x4
	// Bit CENRL2.
	GPIO_PIN_INT_CIENR_CENRL2 = 0x4
	// Position of CENRL3 field.
	GPIO_PIN_INT_CIENR_CENRL3_Pos = 0x3
	// Bit mask of CENRL3 field.
	GPIO_PIN_INT_CIENR_CENRL3_Msk = 0x8
	// Bit CENRL3.
	GPIO_PIN_INT_CIENR_CENRL3 = 0x8
	// Position of CENRL4 field.
	GPIO_PIN_INT_CIENR_CENRL4_Pos = 0x4
	// Bit mask of CENRL4 field.
	GPIO_PIN_INT_CIENR_CENRL4_Msk = 0x10
	// Bit CENRL4.
	GPIO_PIN_INT_CIENR_CENRL4 = 0x10
	// Position of CENRL5 field.
	GPIO_PIN_INT_CIENR_CENRL5_Pos = 0x5
	// Bit mask of CENRL5 field.
	GPIO_PIN_INT_CIENR_CENRL5_Msk = 0x20
	// Bit CENRL5.
	GPIO_PIN_INT_CIENR_CENRL5 = 0x20
	// Position of CENRL6 field.
	GPIO_PIN_INT_CIENR_CENRL6_Pos = 0x6
	// Bit mask of CENRL6 field.
	GPIO_PIN_INT_CIENR_CENRL6_Msk = 0x40
	// Bit CENRL6.
	GPIO_PIN_INT_CIENR_CENRL6 = 0x40
	// Position of CENRL7 field.
	GPIO_PIN_INT_CIENR_CENRL7_Pos = 0x7
	// Bit mask of CENRL7 field.
	GPIO_PIN_INT_CIENR_CENRL7_Msk = 0x80
	// Bit CENRL7.
	GPIO_PIN_INT_CIENR_CENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin Interrupt Enable Falling Edge / Active Level register
	// Position of ENAF0 field.
	GPIO_PIN_INT_IENF_ENAF0_Pos = 0x0
	// Bit mask of ENAF0 field.
	GPIO_PIN_INT_IENF_ENAF0_Msk = 0x1
	// Bit ENAF0.
	GPIO_PIN_INT_IENF_ENAF0 = 0x1
	// Position of ENAF1 field.
	GPIO_PIN_INT_IENF_ENAF1_Pos = 0x1
	// Bit mask of ENAF1 field.
	GPIO_PIN_INT_IENF_ENAF1_Msk = 0x2
	// Bit ENAF1.
	GPIO_PIN_INT_IENF_ENAF1 = 0x2
	// Position of ENAF2 field.
	GPIO_PIN_INT_IENF_ENAF2_Pos = 0x2
	// Bit mask of ENAF2 field.
	GPIO_PIN_INT_IENF_ENAF2_Msk = 0x4
	// Bit ENAF2.
	GPIO_PIN_INT_IENF_ENAF2 = 0x4
	// Position of ENAF3 field.
	GPIO_PIN_INT_IENF_ENAF3_Pos = 0x3
	// Bit mask of ENAF3 field.
	GPIO_PIN_INT_IENF_ENAF3_Msk = 0x8
	// Bit ENAF3.
	GPIO_PIN_INT_IENF_ENAF3 = 0x8
	// Position of ENAF4 field.
	GPIO_PIN_INT_IENF_ENAF4_Pos = 0x4
	// Bit mask of ENAF4 field.
	GPIO_PIN_INT_IENF_ENAF4_Msk = 0x10
	// Bit ENAF4.
	GPIO_PIN_INT_IENF_ENAF4 = 0x10
	// Position of ENAF5 field.
	GPIO_PIN_INT_IENF_ENAF5_Pos = 0x5
	// Bit mask of ENAF5 field.
	GPIO_PIN_INT_IENF_ENAF5_Msk = 0x20
	// Bit ENAF5.
	GPIO_PIN_INT_IENF_ENAF5 = 0x20
	// Position of ENAF6 field.
	GPIO_PIN_INT_IENF_ENAF6_Pos = 0x6
	// Bit mask of ENAF6 field.
	GPIO_PIN_INT_IENF_ENAF6_Msk = 0x40
	// Bit ENAF6.
	GPIO_PIN_INT_IENF_ENAF6 = 0x40
	// Position of ENAF7 field.
	GPIO_PIN_INT_IENF_ENAF7_Pos = 0x7
	// Bit mask of ENAF7 field.
	GPIO_PIN_INT_IENF_ENAF7_Msk = 0x80
	// Bit ENAF7.
	GPIO_PIN_INT_IENF_ENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Set Pin Interrupt Enable Falling Edge / Active Level register
	// Position of SETENAF0 field.
	GPIO_PIN_INT_SIENF_SETENAF0_Pos = 0x0
	// Bit mask of SETENAF0 field.
	GPIO_PIN_INT_SIENF_SETENAF0_Msk = 0x1
	// Bit SETENAF0.
	GPIO_PIN_INT_SIENF_SETENAF0 = 0x1
	// Position of SETENAF1 field.
	GPIO_PIN_INT_SIENF_SETENAF1_Pos = 0x1
	// Bit mask of SETENAF1 field.
	GPIO_PIN_INT_SIENF_SETENAF1_Msk = 0x2
	// Bit SETENAF1.
	GPIO_PIN_INT_SIENF_SETENAF1 = 0x2
	// Position of SETENAF2 field.
	GPIO_PIN_INT_SIENF_SETENAF2_Pos = 0x2
	// Bit mask of SETENAF2 field.
	GPIO_PIN_INT_SIENF_SETENAF2_Msk = 0x4
	// Bit SETENAF2.
	GPIO_PIN_INT_SIENF_SETENAF2 = 0x4
	// Position of SETENAF3 field.
	GPIO_PIN_INT_SIENF_SETENAF3_Pos = 0x3
	// Bit mask of SETENAF3 field.
	GPIO_PIN_INT_SIENF_SETENAF3_Msk = 0x8
	// Bit SETENAF3.
	GPIO_PIN_INT_SIENF_SETENAF3 = 0x8
	// Position of SETENAF4 field.
	GPIO_PIN_INT_SIENF_SETENAF4_Pos = 0x4
	// Bit mask of SETENAF4 field.
	GPIO_PIN_INT_SIENF_SETENAF4_Msk = 0x10
	// Bit SETENAF4.
	GPIO_PIN_INT_SIENF_SETENAF4 = 0x10
	// Position of SETENAF5 field.
	GPIO_PIN_INT_SIENF_SETENAF5_Pos = 0x5
	// Bit mask of SETENAF5 field.
	GPIO_PIN_INT_SIENF_SETENAF5_Msk = 0x20
	// Bit SETENAF5.
	GPIO_PIN_INT_SIENF_SETENAF5 = 0x20
	// Position of SETENAF6 field.
	GPIO_PIN_INT_SIENF_SETENAF6_Pos = 0x6
	// Bit mask of SETENAF6 field.
	GPIO_PIN_INT_SIENF_SETENAF6_Msk = 0x40
	// Bit SETENAF6.
	GPIO_PIN_INT_SIENF_SETENAF6 = 0x40
	// Position of SETENAF7 field.
	GPIO_PIN_INT_SIENF_SETENAF7_Pos = 0x7
	// Bit mask of SETENAF7 field.
	GPIO_PIN_INT_SIENF_SETENAF7_Msk = 0x80
	// Bit SETENAF7.
	GPIO_PIN_INT_SIENF_SETENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Clear Pin Interrupt Enable Falling Edge / Active Level address
	// Position of CENAF0 field.
	GPIO_PIN_INT_CIENF_CENAF0_Pos = 0x0
	// Bit mask of CENAF0 field.
	GPIO_PIN_INT_CIENF_CENAF0_Msk = 0x1
	// Bit CENAF0.
	GPIO_PIN_INT_CIENF_CENAF0 = 0x1
	// Position of CENAF1 field.
	GPIO_PIN_INT_CIENF_CENAF1_Pos = 0x1
	// Bit mask of CENAF1 field.
	GPIO_PIN_INT_CIENF_CENAF1_Msk = 0x2
	// Bit CENAF1.
	GPIO_PIN_INT_CIENF_CENAF1 = 0x2
	// Position of CENAF2 field.
	GPIO_PIN_INT_CIENF_CENAF2_Pos = 0x2
	// Bit mask of CENAF2 field.
	GPIO_PIN_INT_CIENF_CENAF2_Msk = 0x4
	// Bit CENAF2.
	GPIO_PIN_INT_CIENF_CENAF2 = 0x4
	// Position of CENAF3 field.
	GPIO_PIN_INT_CIENF_CENAF3_Pos = 0x3
	// Bit mask of CENAF3 field.
	GPIO_PIN_INT_CIENF_CENAF3_Msk = 0x8
	// Bit CENAF3.
	GPIO_PIN_INT_CIENF_CENAF3 = 0x8
	// Position of CENAF4 field.
	GPIO_PIN_INT_CIENF_CENAF4_Pos = 0x4
	// Bit mask of CENAF4 field.
	GPIO_PIN_INT_CIENF_CENAF4_Msk = 0x10
	// Bit CENAF4.
	GPIO_PIN_INT_CIENF_CENAF4 = 0x10
	// Position of CENAF5 field.
	GPIO_PIN_INT_CIENF_CENAF5_Pos = 0x5
	// Bit mask of CENAF5 field.
	GPIO_PIN_INT_CIENF_CENAF5_Msk = 0x20
	// Bit CENAF5.
	GPIO_PIN_INT_CIENF_CENAF5 = 0x20
	// Position of CENAF6 field.
	GPIO_PIN_INT_CIENF_CENAF6_Pos = 0x6
	// Bit mask of CENAF6 field.
	GPIO_PIN_INT_CIENF_CENAF6_Msk = 0x40
	// Bit CENAF6.
	GPIO_PIN_INT_CIENF_CENAF6 = 0x40
	// Position of CENAF7 field.
	GPIO_PIN_INT_CIENF_CENAF7_Pos = 0x7
	// Bit mask of CENAF7 field.
	GPIO_PIN_INT_CIENF_CENAF7_Msk = 0x80
	// Bit CENAF7.
	GPIO_PIN_INT_CIENF_CENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin Interrupt Rising Edge register
	// Position of RDET0 field.
	GPIO_PIN_INT_RISE_RDET0_Pos = 0x0
	// Bit mask of RDET0 field.
	GPIO_PIN_INT_RISE_RDET0_Msk = 0x1
	// Bit RDET0.
	GPIO_PIN_INT_RISE_RDET0 = 0x1
	// Position of RDET1 field.
	GPIO_PIN_INT_RISE_RDET1_Pos = 0x1
	// Bit mask of RDET1 field.
	GPIO_PIN_INT_RISE_RDET1_Msk = 0x2
	// Bit RDET1.
	GPIO_PIN_INT_RISE_RDET1 = 0x2
	// Position of RDET2 field.
	GPIO_PIN_INT_RISE_RDET2_Pos = 0x2
	// Bit mask of RDET2 field.
	GPIO_PIN_INT_RISE_RDET2_Msk = 0x4
	// Bit RDET2.
	GPIO_PIN_INT_RISE_RDET2 = 0x4
	// Position of RDET3 field.
	GPIO_PIN_INT_RISE_RDET3_Pos = 0x3
	// Bit mask of RDET3 field.
	GPIO_PIN_INT_RISE_RDET3_Msk = 0x8
	// Bit RDET3.
	GPIO_PIN_INT_RISE_RDET3 = 0x8
	// Position of RDET4 field.
	GPIO_PIN_INT_RISE_RDET4_Pos = 0x4
	// Bit mask of RDET4 field.
	GPIO_PIN_INT_RISE_RDET4_Msk = 0x10
	// Bit RDET4.
	GPIO_PIN_INT_RISE_RDET4 = 0x10
	// Position of RDET5 field.
	GPIO_PIN_INT_RISE_RDET5_Pos = 0x5
	// Bit mask of RDET5 field.
	GPIO_PIN_INT_RISE_RDET5_Msk = 0x20
	// Bit RDET5.
	GPIO_PIN_INT_RISE_RDET5 = 0x20
	// Position of RDET6 field.
	GPIO_PIN_INT_RISE_RDET6_Pos = 0x6
	// Bit mask of RDET6 field.
	GPIO_PIN_INT_RISE_RDET6_Msk = 0x40
	// Bit RDET6.
	GPIO_PIN_INT_RISE_RDET6 = 0x40
	// Position of RDET7 field.
	GPIO_PIN_INT_RISE_RDET7_Pos = 0x7
	// Bit mask of RDET7 field.
	GPIO_PIN_INT_RISE_RDET7_Msk = 0x80
	// Bit RDET7.
	GPIO_PIN_INT_RISE_RDET7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin Interrupt Falling Edge register
	// Position of FDET0 field.
	GPIO_PIN_INT_FALL_FDET0_Pos = 0x0
	// Bit mask of FDET0 field.
	GPIO_PIN_INT_FALL_FDET0_Msk = 0x1
	// Bit FDET0.
	GPIO_PIN_INT_FALL_FDET0 = 0x1
	// Position of FDET1 field.
	GPIO_PIN_INT_FALL_FDET1_Pos = 0x1
	// Bit mask of FDET1 field.
	GPIO_PIN_INT_FALL_FDET1_Msk = 0x2
	// Bit FDET1.
	GPIO_PIN_INT_FALL_FDET1 = 0x2
	// Position of FDET2 field.
	GPIO_PIN_INT_FALL_FDET2_Pos = 0x2
	// Bit mask of FDET2 field.
	GPIO_PIN_INT_FALL_FDET2_Msk = 0x4
	// Bit FDET2.
	GPIO_PIN_INT_FALL_FDET2 = 0x4
	// Position of FDET3 field.
	GPIO_PIN_INT_FALL_FDET3_Pos = 0x3
	// Bit mask of FDET3 field.
	GPIO_PIN_INT_FALL_FDET3_Msk = 0x8
	// Bit FDET3.
	GPIO_PIN_INT_FALL_FDET3 = 0x8
	// Position of FDET4 field.
	GPIO_PIN_INT_FALL_FDET4_Pos = 0x4
	// Bit mask of FDET4 field.
	GPIO_PIN_INT_FALL_FDET4_Msk = 0x10
	// Bit FDET4.
	GPIO_PIN_INT_FALL_FDET4 = 0x10
	// Position of FDET5 field.
	GPIO_PIN_INT_FALL_FDET5_Pos = 0x5
	// Bit mask of FDET5 field.
	GPIO_PIN_INT_FALL_FDET5_Msk = 0x20
	// Bit FDET5.
	GPIO_PIN_INT_FALL_FDET5 = 0x20
	// Position of FDET6 field.
	GPIO_PIN_INT_FALL_FDET6_Pos = 0x6
	// Bit mask of FDET6 field.
	GPIO_PIN_INT_FALL_FDET6_Msk = 0x40
	// Bit FDET6.
	GPIO_PIN_INT_FALL_FDET6 = 0x40
	// Position of FDET7 field.
	GPIO_PIN_INT_FALL_FDET7_Pos = 0x7
	// Bit mask of FDET7 field.
	GPIO_PIN_INT_FALL_FDET7_Msk = 0x80
	// Bit FDET7.
	GPIO_PIN_INT_FALL_FDET7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin Interrupt Status register
	// Position of PSTAT0 field.
	GPIO_PIN_INT_IST_PSTAT0_Pos = 0x0
	// Bit mask of PSTAT0 field.
	GPIO_PIN_INT_IST_PSTAT0_Msk = 0x1
	// Bit PSTAT0.
	GPIO_PIN_INT_IST_PSTAT0 = 0x1
	// Position of PSTAT1 field.
	GPIO_PIN_INT_IST_PSTAT1_Pos = 0x1
	// Bit mask of PSTAT1 field.
	GPIO_PIN_INT_IST_PSTAT1_Msk = 0x2
	// Bit PSTAT1.
	GPIO_PIN_INT_IST_PSTAT1 = 0x2
	// Position of PSTAT2 field.
	GPIO_PIN_INT_IST_PSTAT2_Pos = 0x2
	// Bit mask of PSTAT2 field.
	GPIO_PIN_INT_IST_PSTAT2_Msk = 0x4
	// Bit PSTAT2.
	GPIO_PIN_INT_IST_PSTAT2 = 0x4
	// Position of PSTAT3 field.
	GPIO_PIN_INT_IST_PSTAT3_Pos = 0x3
	// Bit mask of PSTAT3 field.
	GPIO_PIN_INT_IST_PSTAT3_Msk = 0x8
	// Bit PSTAT3.
	GPIO_PIN_INT_IST_PSTAT3 = 0x8
	// Position of PSTAT4 field.
	GPIO_PIN_INT_IST_PSTAT4_Pos = 0x4
	// Bit mask of PSTAT4 field.
	GPIO_PIN_INT_IST_PSTAT4_Msk = 0x10
	// Bit PSTAT4.
	GPIO_PIN_INT_IST_PSTAT4 = 0x10
	// Position of PSTAT5 field.
	GPIO_PIN_INT_IST_PSTAT5_Pos = 0x5
	// Bit mask of PSTAT5 field.
	GPIO_PIN_INT_IST_PSTAT5_Msk = 0x20
	// Bit PSTAT5.
	GPIO_PIN_INT_IST_PSTAT5 = 0x20
	// Position of PSTAT6 field.
	GPIO_PIN_INT_IST_PSTAT6_Pos = 0x6
	// Bit mask of PSTAT6 field.
	GPIO_PIN_INT_IST_PSTAT6_Msk = 0x40
	// Bit PSTAT6.
	GPIO_PIN_INT_IST_PSTAT6 = 0x40
	// Position of PSTAT7 field.
	GPIO_PIN_INT_IST_PSTAT7_Pos = 0x7
	// Bit mask of PSTAT7 field.
	GPIO_PIN_INT_IST_PSTAT7_Msk = 0x80
	// Bit PSTAT7.
	GPIO_PIN_INT_IST_PSTAT7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Msk = 0xffffff00
)

// Constants for GPIO_GROUP_INT0: GPIO group interrupt
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GPIO_GROUP_INT0_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GPIO_GROUP_INT0_CTRL_INT_Msk = 0x1
	// Bit INT.
	GPIO_GROUP_INT0_CTRL_INT = 0x1
	// No interrupt request is pending.
	GPIO_GROUP_INT0_CTRL_INT_NO_INTERRUPT_REQUEST = 0x0
	// Interrupt request is active.
	GPIO_GROUP_INT0_CTRL_INT_INTERRUPT_REQUEST_IS = 0x1
	// Position of COMB field.
	GPIO_GROUP_INT0_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GPIO_GROUP_INT0_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GPIO_GROUP_INT0_CTRL_COMB = 0x2
	// OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GPIO_GROUP_INT0_CTRL_COMB_OR_FUNCTIONALITY_A_ = 0x0
	// AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GPIO_GROUP_INT0_CTRL_COMB_AND_FUNCTIONALITY_A = 0x1
	// Position of TRIG field.
	GPIO_GROUP_INT0_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GPIO_GROUP_INT0_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GPIO_GROUP_INT0_CTRL_TRIG = 0x4
	// Edge-triggered
	GPIO_GROUP_INT0_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered
	GPIO_GROUP_INT0_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GPIO_GROUP_INT0_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GPIO_GROUP_INT0_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL0: GPIO grouped interrupt port 0 polarity register
	// Position of POL_0 field.
	GPIO_GROUP_INT0_PORT_POL_POL_0_Pos = 0x0
	// Bit mask of POL_0 field.
	GPIO_GROUP_INT0_PORT_POL_POL_0_Msk = 0x1
	// Bit POL_0.
	GPIO_GROUP_INT0_PORT_POL_POL_0 = 0x1
	// Position of POL_1 field.
	GPIO_GROUP_INT0_PORT_POL_POL_1_Pos = 0x1
	// Bit mask of POL_1 field.
	GPIO_GROUP_INT0_PORT_POL_POL_1_Msk = 0x2
	// Bit POL_1.
	GPIO_GROUP_INT0_PORT_POL_POL_1 = 0x2
	// Position of POL_2 field.
	GPIO_GROUP_INT0_PORT_POL_POL_2_Pos = 0x2
	// Bit mask of POL_2 field.
	GPIO_GROUP_INT0_PORT_POL_POL_2_Msk = 0x4
	// Bit POL_2.
	GPIO_GROUP_INT0_PORT_POL_POL_2 = 0x4
	// Position of POL_3 field.
	GPIO_GROUP_INT0_PORT_POL_POL_3_Pos = 0x3
	// Bit mask of POL_3 field.
	GPIO_GROUP_INT0_PORT_POL_POL_3_Msk = 0x8
	// Bit POL_3.
	GPIO_GROUP_INT0_PORT_POL_POL_3 = 0x8
	// Position of POL_4 field.
	GPIO_GROUP_INT0_PORT_POL_POL_4_Pos = 0x4
	// Bit mask of POL_4 field.
	GPIO_GROUP_INT0_PORT_POL_POL_4_Msk = 0x10
	// Bit POL_4.
	GPIO_GROUP_INT0_PORT_POL_POL_4 = 0x10
	// Position of POL_5 field.
	GPIO_GROUP_INT0_PORT_POL_POL_5_Pos = 0x5
	// Bit mask of POL_5 field.
	GPIO_GROUP_INT0_PORT_POL_POL_5_Msk = 0x20
	// Bit POL_5.
	GPIO_GROUP_INT0_PORT_POL_POL_5 = 0x20
	// Position of POL_6 field.
	GPIO_GROUP_INT0_PORT_POL_POL_6_Pos = 0x6
	// Bit mask of POL_6 field.
	GPIO_GROUP_INT0_PORT_POL_POL_6_Msk = 0x40
	// Bit POL_6.
	GPIO_GROUP_INT0_PORT_POL_POL_6 = 0x40
	// Position of POL_7 field.
	GPIO_GROUP_INT0_PORT_POL_POL_7_Pos = 0x7
	// Bit mask of POL_7 field.
	GPIO_GROUP_INT0_PORT_POL_POL_7_Msk = 0x80
	// Bit POL_7.
	GPIO_GROUP_INT0_PORT_POL_POL_7 = 0x80
	// Position of POL_8 field.
	GPIO_GROUP_INT0_PORT_POL_POL_8_Pos = 0x8
	// Bit mask of POL_8 field.
	GPIO_GROUP_INT0_PORT_POL_POL_8_Msk = 0x100
	// Bit POL_8.
	GPIO_GROUP_INT0_PORT_POL_POL_8 = 0x100
	// Position of POL_9 field.
	GPIO_GROUP_INT0_PORT_POL_POL_9_Pos = 0x9
	// Bit mask of POL_9 field.
	GPIO_GROUP_INT0_PORT_POL_POL_9_Msk = 0x200
	// Bit POL_9.
	GPIO_GROUP_INT0_PORT_POL_POL_9 = 0x200
	// Position of POL_10 field.
	GPIO_GROUP_INT0_PORT_POL_POL_10_Pos = 0xa
	// Bit mask of POL_10 field.
	GPIO_GROUP_INT0_PORT_POL_POL_10_Msk = 0x400
	// Bit POL_10.
	GPIO_GROUP_INT0_PORT_POL_POL_10 = 0x400
	// Position of POL_11 field.
	GPIO_GROUP_INT0_PORT_POL_POL_11_Pos = 0xb
	// Bit mask of POL_11 field.
	GPIO_GROUP_INT0_PORT_POL_POL_11_Msk = 0x800
	// Bit POL_11.
	GPIO_GROUP_INT0_PORT_POL_POL_11 = 0x800
	// Position of POL_12 field.
	GPIO_GROUP_INT0_PORT_POL_POL_12_Pos = 0xc
	// Bit mask of POL_12 field.
	GPIO_GROUP_INT0_PORT_POL_POL_12_Msk = 0x1000
	// Bit POL_12.
	GPIO_GROUP_INT0_PORT_POL_POL_12 = 0x1000
	// Position of POL_13 field.
	GPIO_GROUP_INT0_PORT_POL_POL_13_Pos = 0xd
	// Bit mask of POL_13 field.
	GPIO_GROUP_INT0_PORT_POL_POL_13_Msk = 0x2000
	// Bit POL_13.
	GPIO_GROUP_INT0_PORT_POL_POL_13 = 0x2000
	// Position of POL_14 field.
	GPIO_GROUP_INT0_PORT_POL_POL_14_Pos = 0xe
	// Bit mask of POL_14 field.
	GPIO_GROUP_INT0_PORT_POL_POL_14_Msk = 0x4000
	// Bit POL_14.
	GPIO_GROUP_INT0_PORT_POL_POL_14 = 0x4000
	// Position of POL_15 field.
	GPIO_GROUP_INT0_PORT_POL_POL_15_Pos = 0xf
	// Bit mask of POL_15 field.
	GPIO_GROUP_INT0_PORT_POL_POL_15_Msk = 0x8000
	// Bit POL_15.
	GPIO_GROUP_INT0_PORT_POL_POL_15 = 0x8000
	// Position of POL_16 field.
	GPIO_GROUP_INT0_PORT_POL_POL_16_Pos = 0x10
	// Bit mask of POL_16 field.
	GPIO_GROUP_INT0_PORT_POL_POL_16_Msk = 0x10000
	// Bit POL_16.
	GPIO_GROUP_INT0_PORT_POL_POL_16 = 0x10000
	// Position of POL_17 field.
	GPIO_GROUP_INT0_PORT_POL_POL_17_Pos = 0x11
	// Bit mask of POL_17 field.
	GPIO_GROUP_INT0_PORT_POL_POL_17_Msk = 0x20000
	// Bit POL_17.
	GPIO_GROUP_INT0_PORT_POL_POL_17 = 0x20000
	// Position of POL_18 field.
	GPIO_GROUP_INT0_PORT_POL_POL_18_Pos = 0x12
	// Bit mask of POL_18 field.
	GPIO_GROUP_INT0_PORT_POL_POL_18_Msk = 0x40000
	// Bit POL_18.
	GPIO_GROUP_INT0_PORT_POL_POL_18 = 0x40000
	// Position of POL_19 field.
	GPIO_GROUP_INT0_PORT_POL_POL_19_Pos = 0x13
	// Bit mask of POL_19 field.
	GPIO_GROUP_INT0_PORT_POL_POL_19_Msk = 0x80000
	// Bit POL_19.
	GPIO_GROUP_INT0_PORT_POL_POL_19 = 0x80000
	// Position of POL_20 field.
	GPIO_GROUP_INT0_PORT_POL_POL_20_Pos = 0x14
	// Bit mask of POL_20 field.
	GPIO_GROUP_INT0_PORT_POL_POL_20_Msk = 0x100000
	// Bit POL_20.
	GPIO_GROUP_INT0_PORT_POL_POL_20 = 0x100000
	// Position of POL_21 field.
	GPIO_GROUP_INT0_PORT_POL_POL_21_Pos = 0x15
	// Bit mask of POL_21 field.
	GPIO_GROUP_INT0_PORT_POL_POL_21_Msk = 0x200000
	// Bit POL_21.
	GPIO_GROUP_INT0_PORT_POL_POL_21 = 0x200000
	// Position of POL_22 field.
	GPIO_GROUP_INT0_PORT_POL_POL_22_Pos = 0x16
	// Bit mask of POL_22 field.
	GPIO_GROUP_INT0_PORT_POL_POL_22_Msk = 0x400000
	// Bit POL_22.
	GPIO_GROUP_INT0_PORT_POL_POL_22 = 0x400000
	// Position of POL_23 field.
	GPIO_GROUP_INT0_PORT_POL_POL_23_Pos = 0x17
	// Bit mask of POL_23 field.
	GPIO_GROUP_INT0_PORT_POL_POL_23_Msk = 0x800000
	// Bit POL_23.
	GPIO_GROUP_INT0_PORT_POL_POL_23 = 0x800000
	// Position of POL_24 field.
	GPIO_GROUP_INT0_PORT_POL_POL_24_Pos = 0x18
	// Bit mask of POL_24 field.
	GPIO_GROUP_INT0_PORT_POL_POL_24_Msk = 0x1000000
	// Bit POL_24.
	GPIO_GROUP_INT0_PORT_POL_POL_24 = 0x1000000
	// Position of POL_25 field.
	GPIO_GROUP_INT0_PORT_POL_POL_25_Pos = 0x19
	// Bit mask of POL_25 field.
	GPIO_GROUP_INT0_PORT_POL_POL_25_Msk = 0x2000000
	// Bit POL_25.
	GPIO_GROUP_INT0_PORT_POL_POL_25 = 0x2000000
	// Position of POL_26 field.
	GPIO_GROUP_INT0_PORT_POL_POL_26_Pos = 0x1a
	// Bit mask of POL_26 field.
	GPIO_GROUP_INT0_PORT_POL_POL_26_Msk = 0x4000000
	// Bit POL_26.
	GPIO_GROUP_INT0_PORT_POL_POL_26 = 0x4000000
	// Position of POL_27 field.
	GPIO_GROUP_INT0_PORT_POL_POL_27_Pos = 0x1b
	// Bit mask of POL_27 field.
	GPIO_GROUP_INT0_PORT_POL_POL_27_Msk = 0x8000000
	// Bit POL_27.
	GPIO_GROUP_INT0_PORT_POL_POL_27 = 0x8000000
	// Position of POL_28 field.
	GPIO_GROUP_INT0_PORT_POL_POL_28_Pos = 0x1c
	// Bit mask of POL_28 field.
	GPIO_GROUP_INT0_PORT_POL_POL_28_Msk = 0x10000000
	// Bit POL_28.
	GPIO_GROUP_INT0_PORT_POL_POL_28 = 0x10000000
	// Position of POL_29 field.
	GPIO_GROUP_INT0_PORT_POL_POL_29_Pos = 0x1d
	// Bit mask of POL_29 field.
	GPIO_GROUP_INT0_PORT_POL_POL_29_Msk = 0x20000000
	// Bit POL_29.
	GPIO_GROUP_INT0_PORT_POL_POL_29 = 0x20000000
	// Position of POL_30 field.
	GPIO_GROUP_INT0_PORT_POL_POL_30_Pos = 0x1e
	// Bit mask of POL_30 field.
	GPIO_GROUP_INT0_PORT_POL_POL_30_Msk = 0x40000000
	// Bit POL_30.
	GPIO_GROUP_INT0_PORT_POL_POL_30 = 0x40000000
	// Position of POL_31 field.
	GPIO_GROUP_INT0_PORT_POL_POL_31_Pos = 0x1f
	// Bit mask of POL_31 field.
	GPIO_GROUP_INT0_PORT_POL_POL_31_Msk = 0x80000000
	// Bit POL_31.
	GPIO_GROUP_INT0_PORT_POL_POL_31 = 0x80000000

	// PORT_ENA0: GPIO grouped interrupt port 0/1 enable register
	// Position of ENA_0 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0_Pos = 0x0
	// Bit mask of ENA_0 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0_Msk = 0x1
	// Bit ENA_0.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0 = 0x1
	// Position of ENA_1 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1_Pos = 0x1
	// Bit mask of ENA_1 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1_Msk = 0x2
	// Bit ENA_1.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1 = 0x2
	// Position of ENA_2 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2_Pos = 0x2
	// Bit mask of ENA_2 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2_Msk = 0x4
	// Bit ENA_2.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2 = 0x4
	// Position of ENA_3 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3_Pos = 0x3
	// Bit mask of ENA_3 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3_Msk = 0x8
	// Bit ENA_3.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3 = 0x8
	// Position of ENA_4 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4_Pos = 0x4
	// Bit mask of ENA_4 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4_Msk = 0x10
	// Bit ENA_4.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4 = 0x10
	// Position of ENA_5 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5_Pos = 0x5
	// Bit mask of ENA_5 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5_Msk = 0x20
	// Bit ENA_5.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5 = 0x20
	// Position of ENA_6 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6_Pos = 0x6
	// Bit mask of ENA_6 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6_Msk = 0x40
	// Bit ENA_6.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6 = 0x40
	// Position of ENA_7 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7_Pos = 0x7
	// Bit mask of ENA_7 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7_Msk = 0x80
	// Bit ENA_7.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7 = 0x80
	// Position of ENA_8 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8_Pos = 0x8
	// Bit mask of ENA_8 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8_Msk = 0x100
	// Bit ENA_8.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8 = 0x100
	// Position of ENA_9 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9_Pos = 0x9
	// Bit mask of ENA_9 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9_Msk = 0x200
	// Bit ENA_9.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9 = 0x200
	// Position of ENA_10 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10_Pos = 0xa
	// Bit mask of ENA_10 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10_Msk = 0x400
	// Bit ENA_10.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10 = 0x400
	// Position of ENA_11 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11_Pos = 0xb
	// Bit mask of ENA_11 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11_Msk = 0x800
	// Bit ENA_11.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11 = 0x800
	// Position of ENA_12 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12_Pos = 0xc
	// Bit mask of ENA_12 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12_Msk = 0x1000
	// Bit ENA_12.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12 = 0x1000
	// Position of ENA_13 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13_Pos = 0xd
	// Bit mask of ENA_13 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13_Msk = 0x2000
	// Bit ENA_13.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13 = 0x2000
	// Position of ENA_14 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14_Pos = 0xe
	// Bit mask of ENA_14 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14_Msk = 0x4000
	// Bit ENA_14.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14 = 0x4000
	// Position of ENA_15 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15_Pos = 0xf
	// Bit mask of ENA_15 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15_Msk = 0x8000
	// Bit ENA_15.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15 = 0x8000
	// Position of ENA_16 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16_Pos = 0x10
	// Bit mask of ENA_16 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16_Msk = 0x10000
	// Bit ENA_16.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16 = 0x10000
	// Position of ENA_17 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17_Pos = 0x11
	// Bit mask of ENA_17 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17_Msk = 0x20000
	// Bit ENA_17.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17 = 0x20000
	// Position of ENA_18 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18_Pos = 0x12
	// Bit mask of ENA_18 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18_Msk = 0x40000
	// Bit ENA_18.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18 = 0x40000
	// Position of ENA_19 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19_Pos = 0x13
	// Bit mask of ENA_19 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19_Msk = 0x80000
	// Bit ENA_19.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19 = 0x80000
	// Position of ENA_20 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20_Pos = 0x14
	// Bit mask of ENA_20 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20_Msk = 0x100000
	// Bit ENA_20.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20 = 0x100000
	// Position of ENA_21 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21_Pos = 0x15
	// Bit mask of ENA_21 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21_Msk = 0x200000
	// Bit ENA_21.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21 = 0x200000
	// Position of ENA_22 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22_Pos = 0x16
	// Bit mask of ENA_22 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22_Msk = 0x400000
	// Bit ENA_22.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22 = 0x400000
	// Position of ENA_23 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23_Pos = 0x17
	// Bit mask of ENA_23 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23_Msk = 0x800000
	// Bit ENA_23.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23 = 0x800000
	// Position of ENA_24 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24_Pos = 0x18
	// Bit mask of ENA_24 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24_Msk = 0x1000000
	// Bit ENA_24.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24 = 0x1000000
	// Position of ENA_25 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25_Pos = 0x19
	// Bit mask of ENA_25 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25_Msk = 0x2000000
	// Bit ENA_25.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25 = 0x2000000
	// Position of ENA_26 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26_Pos = 0x1a
	// Bit mask of ENA_26 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26_Msk = 0x4000000
	// Bit ENA_26.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26 = 0x4000000
	// Position of ENA_27 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27_Pos = 0x1b
	// Bit mask of ENA_27 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27_Msk = 0x8000000
	// Bit ENA_27.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27 = 0x8000000
	// Position of ENA_28 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28_Pos = 0x1c
	// Bit mask of ENA_28 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28_Msk = 0x10000000
	// Bit ENA_28.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28 = 0x10000000
	// Position of ENA_29 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29_Pos = 0x1d
	// Bit mask of ENA_29 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29_Msk = 0x20000000
	// Bit ENA_29.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29 = 0x20000000
	// Position of ENA_30 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30_Pos = 0x1e
	// Bit mask of ENA_30 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30_Msk = 0x40000000
	// Bit ENA_30.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30 = 0x40000000
	// Position of ENA_31 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31_Pos = 0x1f
	// Bit mask of ENA_31 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31_Msk = 0x80000000
	// Bit ENA_31.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31 = 0x80000000
)

// Constants for GPIO_PORT: GPIO port
const (
	// B0: Byte pin registers port 0; pins PIO0_0 to PIO0_31
	// Position of PBYTE field.
	GPIO_PORT_B_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_PORT_B_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_PORT_B_PBYTE = 0x1

	// B32: Byte pin registers port 1
	// Position of PBYTE field.
	GPIO_PORT_B_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_PORT_B_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_PORT_B_PBYTE = 0x1

	// W0: Word pin registers port 0
	// Position of PWORD field.
	GPIO_PORT_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_PORT_W_PWORD_Msk = 0xffffffff

	// W32: Word pin registers port 1
	// Position of PWORD field.
	GPIO_PORT_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_PORT_W_PWORD_Msk = 0xffffffff

	// DIR0: Direction registers port 0/1
	// Position of DIRP0 field.
	GPIO_PORT_DIR_DIRP0_Pos = 0x0
	// Bit mask of DIRP0 field.
	GPIO_PORT_DIR_DIRP0_Msk = 0x1
	// Bit DIRP0.
	GPIO_PORT_DIR_DIRP0 = 0x1
	// Position of DIRP1 field.
	GPIO_PORT_DIR_DIRP1_Pos = 0x1
	// Bit mask of DIRP1 field.
	GPIO_PORT_DIR_DIRP1_Msk = 0x2
	// Bit DIRP1.
	GPIO_PORT_DIR_DIRP1 = 0x2
	// Position of DIRP2 field.
	GPIO_PORT_DIR_DIRP2_Pos = 0x2
	// Bit mask of DIRP2 field.
	GPIO_PORT_DIR_DIRP2_Msk = 0x4
	// Bit DIRP2.
	GPIO_PORT_DIR_DIRP2 = 0x4
	// Position of DIRP3 field.
	GPIO_PORT_DIR_DIRP3_Pos = 0x3
	// Bit mask of DIRP3 field.
	GPIO_PORT_DIR_DIRP3_Msk = 0x8
	// Bit DIRP3.
	GPIO_PORT_DIR_DIRP3 = 0x8
	// Position of DIRP4 field.
	GPIO_PORT_DIR_DIRP4_Pos = 0x4
	// Bit mask of DIRP4 field.
	GPIO_PORT_DIR_DIRP4_Msk = 0x10
	// Bit DIRP4.
	GPIO_PORT_DIR_DIRP4 = 0x10
	// Position of DIRP5 field.
	GPIO_PORT_DIR_DIRP5_Pos = 0x5
	// Bit mask of DIRP5 field.
	GPIO_PORT_DIR_DIRP5_Msk = 0x20
	// Bit DIRP5.
	GPIO_PORT_DIR_DIRP5 = 0x20
	// Position of DIRP6 field.
	GPIO_PORT_DIR_DIRP6_Pos = 0x6
	// Bit mask of DIRP6 field.
	GPIO_PORT_DIR_DIRP6_Msk = 0x40
	// Bit DIRP6.
	GPIO_PORT_DIR_DIRP6 = 0x40
	// Position of DIRP7 field.
	GPIO_PORT_DIR_DIRP7_Pos = 0x7
	// Bit mask of DIRP7 field.
	GPIO_PORT_DIR_DIRP7_Msk = 0x80
	// Bit DIRP7.
	GPIO_PORT_DIR_DIRP7 = 0x80
	// Position of DIRP8 field.
	GPIO_PORT_DIR_DIRP8_Pos = 0x8
	// Bit mask of DIRP8 field.
	GPIO_PORT_DIR_DIRP8_Msk = 0x100
	// Bit DIRP8.
	GPIO_PORT_DIR_DIRP8 = 0x100
	// Position of DIRP9 field.
	GPIO_PORT_DIR_DIRP9_Pos = 0x9
	// Bit mask of DIRP9 field.
	GPIO_PORT_DIR_DIRP9_Msk = 0x200
	// Bit DIRP9.
	GPIO_PORT_DIR_DIRP9 = 0x200
	// Position of DIRP10 field.
	GPIO_PORT_DIR_DIRP10_Pos = 0xa
	// Bit mask of DIRP10 field.
	GPIO_PORT_DIR_DIRP10_Msk = 0x400
	// Bit DIRP10.
	GPIO_PORT_DIR_DIRP10 = 0x400
	// Position of DIRP11 field.
	GPIO_PORT_DIR_DIRP11_Pos = 0xb
	// Bit mask of DIRP11 field.
	GPIO_PORT_DIR_DIRP11_Msk = 0x800
	// Bit DIRP11.
	GPIO_PORT_DIR_DIRP11 = 0x800
	// Position of DIRP12 field.
	GPIO_PORT_DIR_DIRP12_Pos = 0xc
	// Bit mask of DIRP12 field.
	GPIO_PORT_DIR_DIRP12_Msk = 0x1000
	// Bit DIRP12.
	GPIO_PORT_DIR_DIRP12 = 0x1000
	// Position of DIRP13 field.
	GPIO_PORT_DIR_DIRP13_Pos = 0xd
	// Bit mask of DIRP13 field.
	GPIO_PORT_DIR_DIRP13_Msk = 0x2000
	// Bit DIRP13.
	GPIO_PORT_DIR_DIRP13 = 0x2000
	// Position of DIRP14 field.
	GPIO_PORT_DIR_DIRP14_Pos = 0xe
	// Bit mask of DIRP14 field.
	GPIO_PORT_DIR_DIRP14_Msk = 0x4000
	// Bit DIRP14.
	GPIO_PORT_DIR_DIRP14 = 0x4000
	// Position of DIRP15 field.
	GPIO_PORT_DIR_DIRP15_Pos = 0xf
	// Bit mask of DIRP15 field.
	GPIO_PORT_DIR_DIRP15_Msk = 0x8000
	// Bit DIRP15.
	GPIO_PORT_DIR_DIRP15 = 0x8000
	// Position of DIRP16 field.
	GPIO_PORT_DIR_DIRP16_Pos = 0x10
	// Bit mask of DIRP16 field.
	GPIO_PORT_DIR_DIRP16_Msk = 0x10000
	// Bit DIRP16.
	GPIO_PORT_DIR_DIRP16 = 0x10000
	// Position of DIRP17 field.
	GPIO_PORT_DIR_DIRP17_Pos = 0x11
	// Bit mask of DIRP17 field.
	GPIO_PORT_DIR_DIRP17_Msk = 0x20000
	// Bit DIRP17.
	GPIO_PORT_DIR_DIRP17 = 0x20000
	// Position of DIRP18 field.
	GPIO_PORT_DIR_DIRP18_Pos = 0x12
	// Bit mask of DIRP18 field.
	GPIO_PORT_DIR_DIRP18_Msk = 0x40000
	// Bit DIRP18.
	GPIO_PORT_DIR_DIRP18 = 0x40000
	// Position of DIRP19 field.
	GPIO_PORT_DIR_DIRP19_Pos = 0x13
	// Bit mask of DIRP19 field.
	GPIO_PORT_DIR_DIRP19_Msk = 0x80000
	// Bit DIRP19.
	GPIO_PORT_DIR_DIRP19 = 0x80000
	// Position of DIRP20 field.
	GPIO_PORT_DIR_DIRP20_Pos = 0x14
	// Bit mask of DIRP20 field.
	GPIO_PORT_DIR_DIRP20_Msk = 0x100000
	// Bit DIRP20.
	GPIO_PORT_DIR_DIRP20 = 0x100000
	// Position of DIRP21 field.
	GPIO_PORT_DIR_DIRP21_Pos = 0x15
	// Bit mask of DIRP21 field.
	GPIO_PORT_DIR_DIRP21_Msk = 0x200000
	// Bit DIRP21.
	GPIO_PORT_DIR_DIRP21 = 0x200000
	// Position of DIRP22 field.
	GPIO_PORT_DIR_DIRP22_Pos = 0x16
	// Bit mask of DIRP22 field.
	GPIO_PORT_DIR_DIRP22_Msk = 0x400000
	// Bit DIRP22.
	GPIO_PORT_DIR_DIRP22 = 0x400000
	// Position of DIRP23 field.
	GPIO_PORT_DIR_DIRP23_Pos = 0x17
	// Bit mask of DIRP23 field.
	GPIO_PORT_DIR_DIRP23_Msk = 0x800000
	// Bit DIRP23.
	GPIO_PORT_DIR_DIRP23 = 0x800000
	// Position of DIRP24 field.
	GPIO_PORT_DIR_DIRP24_Pos = 0x18
	// Bit mask of DIRP24 field.
	GPIO_PORT_DIR_DIRP24_Msk = 0x1000000
	// Bit DIRP24.
	GPIO_PORT_DIR_DIRP24 = 0x1000000
	// Position of DIRP25 field.
	GPIO_PORT_DIR_DIRP25_Pos = 0x19
	// Bit mask of DIRP25 field.
	GPIO_PORT_DIR_DIRP25_Msk = 0x2000000
	// Bit DIRP25.
	GPIO_PORT_DIR_DIRP25 = 0x2000000
	// Position of DIRP26 field.
	GPIO_PORT_DIR_DIRP26_Pos = 0x1a
	// Bit mask of DIRP26 field.
	GPIO_PORT_DIR_DIRP26_Msk = 0x4000000
	// Bit DIRP26.
	GPIO_PORT_DIR_DIRP26 = 0x4000000
	// Position of DIRP27 field.
	GPIO_PORT_DIR_DIRP27_Pos = 0x1b
	// Bit mask of DIRP27 field.
	GPIO_PORT_DIR_DIRP27_Msk = 0x8000000
	// Bit DIRP27.
	GPIO_PORT_DIR_DIRP27 = 0x8000000
	// Position of DIRP28 field.
	GPIO_PORT_DIR_DIRP28_Pos = 0x1c
	// Bit mask of DIRP28 field.
	GPIO_PORT_DIR_DIRP28_Msk = 0x10000000
	// Bit DIRP28.
	GPIO_PORT_DIR_DIRP28 = 0x10000000
	// Position of DIRP29 field.
	GPIO_PORT_DIR_DIRP29_Pos = 0x1d
	// Bit mask of DIRP29 field.
	GPIO_PORT_DIR_DIRP29_Msk = 0x20000000
	// Bit DIRP29.
	GPIO_PORT_DIR_DIRP29 = 0x20000000
	// Position of DIRP30 field.
	GPIO_PORT_DIR_DIRP30_Pos = 0x1e
	// Bit mask of DIRP30 field.
	GPIO_PORT_DIR_DIRP30_Msk = 0x40000000
	// Bit DIRP30.
	GPIO_PORT_DIR_DIRP30 = 0x40000000
	// Position of DIRP31 field.
	GPIO_PORT_DIR_DIRP31_Pos = 0x1f
	// Bit mask of DIRP31 field.
	GPIO_PORT_DIR_DIRP31_Msk = 0x80000000
	// Bit DIRP31.
	GPIO_PORT_DIR_DIRP31 = 0x80000000

	// MASK0: Mask register port 0/1
	// Position of MASKP0 field.
	GPIO_PORT_MASK_MASKP0_Pos = 0x0
	// Bit mask of MASKP0 field.
	GPIO_PORT_MASK_MASKP0_Msk = 0x1
	// Bit MASKP0.
	GPIO_PORT_MASK_MASKP0 = 0x1
	// Position of MASKP1 field.
	GPIO_PORT_MASK_MASKP1_Pos = 0x1
	// Bit mask of MASKP1 field.
	GPIO_PORT_MASK_MASKP1_Msk = 0x2
	// Bit MASKP1.
	GPIO_PORT_MASK_MASKP1 = 0x2
	// Position of MASKP2 field.
	GPIO_PORT_MASK_MASKP2_Pos = 0x2
	// Bit mask of MASKP2 field.
	GPIO_PORT_MASK_MASKP2_Msk = 0x4
	// Bit MASKP2.
	GPIO_PORT_MASK_MASKP2 = 0x4
	// Position of MASKP3 field.
	GPIO_PORT_MASK_MASKP3_Pos = 0x3
	// Bit mask of MASKP3 field.
	GPIO_PORT_MASK_MASKP3_Msk = 0x8
	// Bit MASKP3.
	GPIO_PORT_MASK_MASKP3 = 0x8
	// Position of MASKP4 field.
	GPIO_PORT_MASK_MASKP4_Pos = 0x4
	// Bit mask of MASKP4 field.
	GPIO_PORT_MASK_MASKP4_Msk = 0x10
	// Bit MASKP4.
	GPIO_PORT_MASK_MASKP4 = 0x10
	// Position of MASKP5 field.
	GPIO_PORT_MASK_MASKP5_Pos = 0x5
	// Bit mask of MASKP5 field.
	GPIO_PORT_MASK_MASKP5_Msk = 0x20
	// Bit MASKP5.
	GPIO_PORT_MASK_MASKP5 = 0x20
	// Position of MASKP6 field.
	GPIO_PORT_MASK_MASKP6_Pos = 0x6
	// Bit mask of MASKP6 field.
	GPIO_PORT_MASK_MASKP6_Msk = 0x40
	// Bit MASKP6.
	GPIO_PORT_MASK_MASKP6 = 0x40
	// Position of MASKP7 field.
	GPIO_PORT_MASK_MASKP7_Pos = 0x7
	// Bit mask of MASKP7 field.
	GPIO_PORT_MASK_MASKP7_Msk = 0x80
	// Bit MASKP7.
	GPIO_PORT_MASK_MASKP7 = 0x80
	// Position of MASKP8 field.
	GPIO_PORT_MASK_MASKP8_Pos = 0x8
	// Bit mask of MASKP8 field.
	GPIO_PORT_MASK_MASKP8_Msk = 0x100
	// Bit MASKP8.
	GPIO_PORT_MASK_MASKP8 = 0x100
	// Position of MASKP9 field.
	GPIO_PORT_MASK_MASKP9_Pos = 0x9
	// Bit mask of MASKP9 field.
	GPIO_PORT_MASK_MASKP9_Msk = 0x200
	// Bit MASKP9.
	GPIO_PORT_MASK_MASKP9 = 0x200
	// Position of MASKP10 field.
	GPIO_PORT_MASK_MASKP10_Pos = 0xa
	// Bit mask of MASKP10 field.
	GPIO_PORT_MASK_MASKP10_Msk = 0x400
	// Bit MASKP10.
	GPIO_PORT_MASK_MASKP10 = 0x400
	// Position of MASKP11 field.
	GPIO_PORT_MASK_MASKP11_Pos = 0xb
	// Bit mask of MASKP11 field.
	GPIO_PORT_MASK_MASKP11_Msk = 0x800
	// Bit MASKP11.
	GPIO_PORT_MASK_MASKP11 = 0x800
	// Position of MASKP12 field.
	GPIO_PORT_MASK_MASKP12_Pos = 0xc
	// Bit mask of MASKP12 field.
	GPIO_PORT_MASK_MASKP12_Msk = 0x1000
	// Bit MASKP12.
	GPIO_PORT_MASK_MASKP12 = 0x1000
	// Position of MASKP13 field.
	GPIO_PORT_MASK_MASKP13_Pos = 0xd
	// Bit mask of MASKP13 field.
	GPIO_PORT_MASK_MASKP13_Msk = 0x2000
	// Bit MASKP13.
	GPIO_PORT_MASK_MASKP13 = 0x2000
	// Position of MASKP14 field.
	GPIO_PORT_MASK_MASKP14_Pos = 0xe
	// Bit mask of MASKP14 field.
	GPIO_PORT_MASK_MASKP14_Msk = 0x4000
	// Bit MASKP14.
	GPIO_PORT_MASK_MASKP14 = 0x4000
	// Position of MASKP15 field.
	GPIO_PORT_MASK_MASKP15_Pos = 0xf
	// Bit mask of MASKP15 field.
	GPIO_PORT_MASK_MASKP15_Msk = 0x8000
	// Bit MASKP15.
	GPIO_PORT_MASK_MASKP15 = 0x8000
	// Position of MASKP16 field.
	GPIO_PORT_MASK_MASKP16_Pos = 0x10
	// Bit mask of MASKP16 field.
	GPIO_PORT_MASK_MASKP16_Msk = 0x10000
	// Bit MASKP16.
	GPIO_PORT_MASK_MASKP16 = 0x10000
	// Position of MASKP17 field.
	GPIO_PORT_MASK_MASKP17_Pos = 0x11
	// Bit mask of MASKP17 field.
	GPIO_PORT_MASK_MASKP17_Msk = 0x20000
	// Bit MASKP17.
	GPIO_PORT_MASK_MASKP17 = 0x20000
	// Position of MASKP18 field.
	GPIO_PORT_MASK_MASKP18_Pos = 0x12
	// Bit mask of MASKP18 field.
	GPIO_PORT_MASK_MASKP18_Msk = 0x40000
	// Bit MASKP18.
	GPIO_PORT_MASK_MASKP18 = 0x40000
	// Position of MASKP19 field.
	GPIO_PORT_MASK_MASKP19_Pos = 0x13
	// Bit mask of MASKP19 field.
	GPIO_PORT_MASK_MASKP19_Msk = 0x80000
	// Bit MASKP19.
	GPIO_PORT_MASK_MASKP19 = 0x80000
	// Position of MASKP20 field.
	GPIO_PORT_MASK_MASKP20_Pos = 0x14
	// Bit mask of MASKP20 field.
	GPIO_PORT_MASK_MASKP20_Msk = 0x100000
	// Bit MASKP20.
	GPIO_PORT_MASK_MASKP20 = 0x100000
	// Position of MASKP21 field.
	GPIO_PORT_MASK_MASKP21_Pos = 0x15
	// Bit mask of MASKP21 field.
	GPIO_PORT_MASK_MASKP21_Msk = 0x200000
	// Bit MASKP21.
	GPIO_PORT_MASK_MASKP21 = 0x200000
	// Position of MASKP22 field.
	GPIO_PORT_MASK_MASKP22_Pos = 0x16
	// Bit mask of MASKP22 field.
	GPIO_PORT_MASK_MASKP22_Msk = 0x400000
	// Bit MASKP22.
	GPIO_PORT_MASK_MASKP22 = 0x400000
	// Position of MASKP23 field.
	GPIO_PORT_MASK_MASKP23_Pos = 0x17
	// Bit mask of MASKP23 field.
	GPIO_PORT_MASK_MASKP23_Msk = 0x800000
	// Bit MASKP23.
	GPIO_PORT_MASK_MASKP23 = 0x800000
	// Position of MASKP24 field.
	GPIO_PORT_MASK_MASKP24_Pos = 0x18
	// Bit mask of MASKP24 field.
	GPIO_PORT_MASK_MASKP24_Msk = 0x1000000
	// Bit MASKP24.
	GPIO_PORT_MASK_MASKP24 = 0x1000000
	// Position of MASKP25 field.
	GPIO_PORT_MASK_MASKP25_Pos = 0x19
	// Bit mask of MASKP25 field.
	GPIO_PORT_MASK_MASKP25_Msk = 0x2000000
	// Bit MASKP25.
	GPIO_PORT_MASK_MASKP25 = 0x2000000
	// Position of MASKP26 field.
	GPIO_PORT_MASK_MASKP26_Pos = 0x1a
	// Bit mask of MASKP26 field.
	GPIO_PORT_MASK_MASKP26_Msk = 0x4000000
	// Bit MASKP26.
	GPIO_PORT_MASK_MASKP26 = 0x4000000
	// Position of MASKP27 field.
	GPIO_PORT_MASK_MASKP27_Pos = 0x1b
	// Bit mask of MASKP27 field.
	GPIO_PORT_MASK_MASKP27_Msk = 0x8000000
	// Bit MASKP27.
	GPIO_PORT_MASK_MASKP27 = 0x8000000
	// Position of MASKP28 field.
	GPIO_PORT_MASK_MASKP28_Pos = 0x1c
	// Bit mask of MASKP28 field.
	GPIO_PORT_MASK_MASKP28_Msk = 0x10000000
	// Bit MASKP28.
	GPIO_PORT_MASK_MASKP28 = 0x10000000
	// Position of MASKP29 field.
	GPIO_PORT_MASK_MASKP29_Pos = 0x1d
	// Bit mask of MASKP29 field.
	GPIO_PORT_MASK_MASKP29_Msk = 0x20000000
	// Bit MASKP29.
	GPIO_PORT_MASK_MASKP29 = 0x20000000
	// Position of MASKP30 field.
	GPIO_PORT_MASK_MASKP30_Pos = 0x1e
	// Bit mask of MASKP30 field.
	GPIO_PORT_MASK_MASKP30_Msk = 0x40000000
	// Bit MASKP30.
	GPIO_PORT_MASK_MASKP30 = 0x40000000
	// Position of MASKP31 field.
	GPIO_PORT_MASK_MASKP31_Pos = 0x1f
	// Bit mask of MASKP31 field.
	GPIO_PORT_MASK_MASKP31_Msk = 0x80000000
	// Bit MASKP31.
	GPIO_PORT_MASK_MASKP31 = 0x80000000

	// PIN0: Portpin register port 0
	// Position of PORT0 field.
	GPIO_PORT_PIN_PORT0_Pos = 0x0
	// Bit mask of PORT0 field.
	GPIO_PORT_PIN_PORT0_Msk = 0x1
	// Bit PORT0.
	GPIO_PORT_PIN_PORT0 = 0x1
	// Position of PORT1 field.
	GPIO_PORT_PIN_PORT1_Pos = 0x1
	// Bit mask of PORT1 field.
	GPIO_PORT_PIN_PORT1_Msk = 0x2
	// Bit PORT1.
	GPIO_PORT_PIN_PORT1 = 0x2
	// Position of PORT2 field.
	GPIO_PORT_PIN_PORT2_Pos = 0x2
	// Bit mask of PORT2 field.
	GPIO_PORT_PIN_PORT2_Msk = 0x4
	// Bit PORT2.
	GPIO_PORT_PIN_PORT2 = 0x4
	// Position of PORT3 field.
	GPIO_PORT_PIN_PORT3_Pos = 0x3
	// Bit mask of PORT3 field.
	GPIO_PORT_PIN_PORT3_Msk = 0x8
	// Bit PORT3.
	GPIO_PORT_PIN_PORT3 = 0x8
	// Position of PORT4 field.
	GPIO_PORT_PIN_PORT4_Pos = 0x4
	// Bit mask of PORT4 field.
	GPIO_PORT_PIN_PORT4_Msk = 0x10
	// Bit PORT4.
	GPIO_PORT_PIN_PORT4 = 0x10
	// Position of PORT5 field.
	GPIO_PORT_PIN_PORT5_Pos = 0x5
	// Bit mask of PORT5 field.
	GPIO_PORT_PIN_PORT5_Msk = 0x20
	// Bit PORT5.
	GPIO_PORT_PIN_PORT5 = 0x20
	// Position of PORT6 field.
	GPIO_PORT_PIN_PORT6_Pos = 0x6
	// Bit mask of PORT6 field.
	GPIO_PORT_PIN_PORT6_Msk = 0x40
	// Bit PORT6.
	GPIO_PORT_PIN_PORT6 = 0x40
	// Position of PORT7 field.
	GPIO_PORT_PIN_PORT7_Pos = 0x7
	// Bit mask of PORT7 field.
	GPIO_PORT_PIN_PORT7_Msk = 0x80
	// Bit PORT7.
	GPIO_PORT_PIN_PORT7 = 0x80
	// Position of PORT8 field.
	GPIO_PORT_PIN_PORT8_Pos = 0x8
	// Bit mask of PORT8 field.
	GPIO_PORT_PIN_PORT8_Msk = 0x100
	// Bit PORT8.
	GPIO_PORT_PIN_PORT8 = 0x100
	// Position of PORT9 field.
	GPIO_PORT_PIN_PORT9_Pos = 0x9
	// Bit mask of PORT9 field.
	GPIO_PORT_PIN_PORT9_Msk = 0x200
	// Bit PORT9.
	GPIO_PORT_PIN_PORT9 = 0x200
	// Position of PORT10 field.
	GPIO_PORT_PIN_PORT10_Pos = 0xa
	// Bit mask of PORT10 field.
	GPIO_PORT_PIN_PORT10_Msk = 0x400
	// Bit PORT10.
	GPIO_PORT_PIN_PORT10 = 0x400
	// Position of PORT11 field.
	GPIO_PORT_PIN_PORT11_Pos = 0xb
	// Bit mask of PORT11 field.
	GPIO_PORT_PIN_PORT11_Msk = 0x800
	// Bit PORT11.
	GPIO_PORT_PIN_PORT11 = 0x800
	// Position of PORT12 field.
	GPIO_PORT_PIN_PORT12_Pos = 0xc
	// Bit mask of PORT12 field.
	GPIO_PORT_PIN_PORT12_Msk = 0x1000
	// Bit PORT12.
	GPIO_PORT_PIN_PORT12 = 0x1000
	// Position of PORT13 field.
	GPIO_PORT_PIN_PORT13_Pos = 0xd
	// Bit mask of PORT13 field.
	GPIO_PORT_PIN_PORT13_Msk = 0x2000
	// Bit PORT13.
	GPIO_PORT_PIN_PORT13 = 0x2000
	// Position of PORT14 field.
	GPIO_PORT_PIN_PORT14_Pos = 0xe
	// Bit mask of PORT14 field.
	GPIO_PORT_PIN_PORT14_Msk = 0x4000
	// Bit PORT14.
	GPIO_PORT_PIN_PORT14 = 0x4000
	// Position of PORT15 field.
	GPIO_PORT_PIN_PORT15_Pos = 0xf
	// Bit mask of PORT15 field.
	GPIO_PORT_PIN_PORT15_Msk = 0x8000
	// Bit PORT15.
	GPIO_PORT_PIN_PORT15 = 0x8000
	// Position of PORT16 field.
	GPIO_PORT_PIN_PORT16_Pos = 0x10
	// Bit mask of PORT16 field.
	GPIO_PORT_PIN_PORT16_Msk = 0x10000
	// Bit PORT16.
	GPIO_PORT_PIN_PORT16 = 0x10000
	// Position of PORT17 field.
	GPIO_PORT_PIN_PORT17_Pos = 0x11
	// Bit mask of PORT17 field.
	GPIO_PORT_PIN_PORT17_Msk = 0x20000
	// Bit PORT17.
	GPIO_PORT_PIN_PORT17 = 0x20000
	// Position of PORT18 field.
	GPIO_PORT_PIN_PORT18_Pos = 0x12
	// Bit mask of PORT18 field.
	GPIO_PORT_PIN_PORT18_Msk = 0x40000
	// Bit PORT18.
	GPIO_PORT_PIN_PORT18 = 0x40000
	// Position of PORT19 field.
	GPIO_PORT_PIN_PORT19_Pos = 0x13
	// Bit mask of PORT19 field.
	GPIO_PORT_PIN_PORT19_Msk = 0x80000
	// Bit PORT19.
	GPIO_PORT_PIN_PORT19 = 0x80000
	// Position of PORT20 field.
	GPIO_PORT_PIN_PORT20_Pos = 0x14
	// Bit mask of PORT20 field.
	GPIO_PORT_PIN_PORT20_Msk = 0x100000
	// Bit PORT20.
	GPIO_PORT_PIN_PORT20 = 0x100000
	// Position of PORT21 field.
	GPIO_PORT_PIN_PORT21_Pos = 0x15
	// Bit mask of PORT21 field.
	GPIO_PORT_PIN_PORT21_Msk = 0x200000
	// Bit PORT21.
	GPIO_PORT_PIN_PORT21 = 0x200000
	// Position of PORT22 field.
	GPIO_PORT_PIN_PORT22_Pos = 0x16
	// Bit mask of PORT22 field.
	GPIO_PORT_PIN_PORT22_Msk = 0x400000
	// Bit PORT22.
	GPIO_PORT_PIN_PORT22 = 0x400000
	// Position of PORT23 field.
	GPIO_PORT_PIN_PORT23_Pos = 0x17
	// Bit mask of PORT23 field.
	GPIO_PORT_PIN_PORT23_Msk = 0x800000
	// Bit PORT23.
	GPIO_PORT_PIN_PORT23 = 0x800000
	// Position of PORT24 field.
	GPIO_PORT_PIN_PORT24_Pos = 0x18
	// Bit mask of PORT24 field.
	GPIO_PORT_PIN_PORT24_Msk = 0x1000000
	// Bit PORT24.
	GPIO_PORT_PIN_PORT24 = 0x1000000
	// Position of PORT25 field.
	GPIO_PORT_PIN_PORT25_Pos = 0x19
	// Bit mask of PORT25 field.
	GPIO_PORT_PIN_PORT25_Msk = 0x2000000
	// Bit PORT25.
	GPIO_PORT_PIN_PORT25 = 0x2000000
	// Position of PORT26 field.
	GPIO_PORT_PIN_PORT26_Pos = 0x1a
	// Bit mask of PORT26 field.
	GPIO_PORT_PIN_PORT26_Msk = 0x4000000
	// Bit PORT26.
	GPIO_PORT_PIN_PORT26 = 0x4000000
	// Position of PORT27 field.
	GPIO_PORT_PIN_PORT27_Pos = 0x1b
	// Bit mask of PORT27 field.
	GPIO_PORT_PIN_PORT27_Msk = 0x8000000
	// Bit PORT27.
	GPIO_PORT_PIN_PORT27 = 0x8000000
	// Position of PORT28 field.
	GPIO_PORT_PIN_PORT28_Pos = 0x1c
	// Bit mask of PORT28 field.
	GPIO_PORT_PIN_PORT28_Msk = 0x10000000
	// Bit PORT28.
	GPIO_PORT_PIN_PORT28 = 0x10000000
	// Position of PORT29 field.
	GPIO_PORT_PIN_PORT29_Pos = 0x1d
	// Bit mask of PORT29 field.
	GPIO_PORT_PIN_PORT29_Msk = 0x20000000
	// Bit PORT29.
	GPIO_PORT_PIN_PORT29 = 0x20000000
	// Position of PORT30 field.
	GPIO_PORT_PIN_PORT30_Pos = 0x1e
	// Bit mask of PORT30 field.
	GPIO_PORT_PIN_PORT30_Msk = 0x40000000
	// Bit PORT30.
	GPIO_PORT_PIN_PORT30 = 0x40000000
	// Position of PORT31 field.
	GPIO_PORT_PIN_PORT31_Pos = 0x1f
	// Bit mask of PORT31 field.
	GPIO_PORT_PIN_PORT31_Msk = 0x80000000
	// Bit PORT31.
	GPIO_PORT_PIN_PORT31 = 0x80000000

	// MPIN0: Masked port register port 0/1
	// Position of MPORTP0 field.
	GPIO_PORT_MPIN_MPORTP0_Pos = 0x0
	// Bit mask of MPORTP0 field.
	GPIO_PORT_MPIN_MPORTP0_Msk = 0x1
	// Bit MPORTP0.
	GPIO_PORT_MPIN_MPORTP0 = 0x1
	// Position of MPORTP1 field.
	GPIO_PORT_MPIN_MPORTP1_Pos = 0x1
	// Bit mask of MPORTP1 field.
	GPIO_PORT_MPIN_MPORTP1_Msk = 0x2
	// Bit MPORTP1.
	GPIO_PORT_MPIN_MPORTP1 = 0x2
	// Position of MPORTP2 field.
	GPIO_PORT_MPIN_MPORTP2_Pos = 0x2
	// Bit mask of MPORTP2 field.
	GPIO_PORT_MPIN_MPORTP2_Msk = 0x4
	// Bit MPORTP2.
	GPIO_PORT_MPIN_MPORTP2 = 0x4
	// Position of MPORTP3 field.
	GPIO_PORT_MPIN_MPORTP3_Pos = 0x3
	// Bit mask of MPORTP3 field.
	GPIO_PORT_MPIN_MPORTP3_Msk = 0x8
	// Bit MPORTP3.
	GPIO_PORT_MPIN_MPORTP3 = 0x8
	// Position of MPORTP4 field.
	GPIO_PORT_MPIN_MPORTP4_Pos = 0x4
	// Bit mask of MPORTP4 field.
	GPIO_PORT_MPIN_MPORTP4_Msk = 0x10
	// Bit MPORTP4.
	GPIO_PORT_MPIN_MPORTP4 = 0x10
	// Position of MPORTP5 field.
	GPIO_PORT_MPIN_MPORTP5_Pos = 0x5
	// Bit mask of MPORTP5 field.
	GPIO_PORT_MPIN_MPORTP5_Msk = 0x20
	// Bit MPORTP5.
	GPIO_PORT_MPIN_MPORTP5 = 0x20
	// Position of MPORTP6 field.
	GPIO_PORT_MPIN_MPORTP6_Pos = 0x6
	// Bit mask of MPORTP6 field.
	GPIO_PORT_MPIN_MPORTP6_Msk = 0x40
	// Bit MPORTP6.
	GPIO_PORT_MPIN_MPORTP6 = 0x40
	// Position of MPORTP7 field.
	GPIO_PORT_MPIN_MPORTP7_Pos = 0x7
	// Bit mask of MPORTP7 field.
	GPIO_PORT_MPIN_MPORTP7_Msk = 0x80
	// Bit MPORTP7.
	GPIO_PORT_MPIN_MPORTP7 = 0x80
	// Position of MPORTP8 field.
	GPIO_PORT_MPIN_MPORTP8_Pos = 0x8
	// Bit mask of MPORTP8 field.
	GPIO_PORT_MPIN_MPORTP8_Msk = 0x100
	// Bit MPORTP8.
	GPIO_PORT_MPIN_MPORTP8 = 0x100
	// Position of MPORTP9 field.
	GPIO_PORT_MPIN_MPORTP9_Pos = 0x9
	// Bit mask of MPORTP9 field.
	GPIO_PORT_MPIN_MPORTP9_Msk = 0x200
	// Bit MPORTP9.
	GPIO_PORT_MPIN_MPORTP9 = 0x200
	// Position of MPORTP10 field.
	GPIO_PORT_MPIN_MPORTP10_Pos = 0xa
	// Bit mask of MPORTP10 field.
	GPIO_PORT_MPIN_MPORTP10_Msk = 0x400
	// Bit MPORTP10.
	GPIO_PORT_MPIN_MPORTP10 = 0x400
	// Position of MPORTP11 field.
	GPIO_PORT_MPIN_MPORTP11_Pos = 0xb
	// Bit mask of MPORTP11 field.
	GPIO_PORT_MPIN_MPORTP11_Msk = 0x800
	// Bit MPORTP11.
	GPIO_PORT_MPIN_MPORTP11 = 0x800
	// Position of MPORTP12 field.
	GPIO_PORT_MPIN_MPORTP12_Pos = 0xc
	// Bit mask of MPORTP12 field.
	GPIO_PORT_MPIN_MPORTP12_Msk = 0x1000
	// Bit MPORTP12.
	GPIO_PORT_MPIN_MPORTP12 = 0x1000
	// Position of MPORTP13 field.
	GPIO_PORT_MPIN_MPORTP13_Pos = 0xd
	// Bit mask of MPORTP13 field.
	GPIO_PORT_MPIN_MPORTP13_Msk = 0x2000
	// Bit MPORTP13.
	GPIO_PORT_MPIN_MPORTP13 = 0x2000
	// Position of MPORTP14 field.
	GPIO_PORT_MPIN_MPORTP14_Pos = 0xe
	// Bit mask of MPORTP14 field.
	GPIO_PORT_MPIN_MPORTP14_Msk = 0x4000
	// Bit MPORTP14.
	GPIO_PORT_MPIN_MPORTP14 = 0x4000
	// Position of MPORTP15 field.
	GPIO_PORT_MPIN_MPORTP15_Pos = 0xf
	// Bit mask of MPORTP15 field.
	GPIO_PORT_MPIN_MPORTP15_Msk = 0x8000
	// Bit MPORTP15.
	GPIO_PORT_MPIN_MPORTP15 = 0x8000
	// Position of MPORTP16 field.
	GPIO_PORT_MPIN_MPORTP16_Pos = 0x10
	// Bit mask of MPORTP16 field.
	GPIO_PORT_MPIN_MPORTP16_Msk = 0x10000
	// Bit MPORTP16.
	GPIO_PORT_MPIN_MPORTP16 = 0x10000
	// Position of MPORTP17 field.
	GPIO_PORT_MPIN_MPORTP17_Pos = 0x11
	// Bit mask of MPORTP17 field.
	GPIO_PORT_MPIN_MPORTP17_Msk = 0x20000
	// Bit MPORTP17.
	GPIO_PORT_MPIN_MPORTP17 = 0x20000
	// Position of MPORTP18 field.
	GPIO_PORT_MPIN_MPORTP18_Pos = 0x12
	// Bit mask of MPORTP18 field.
	GPIO_PORT_MPIN_MPORTP18_Msk = 0x40000
	// Bit MPORTP18.
	GPIO_PORT_MPIN_MPORTP18 = 0x40000
	// Position of MPORTP19 field.
	GPIO_PORT_MPIN_MPORTP19_Pos = 0x13
	// Bit mask of MPORTP19 field.
	GPIO_PORT_MPIN_MPORTP19_Msk = 0x80000
	// Bit MPORTP19.
	GPIO_PORT_MPIN_MPORTP19 = 0x80000
	// Position of MPORTP20 field.
	GPIO_PORT_MPIN_MPORTP20_Pos = 0x14
	// Bit mask of MPORTP20 field.
	GPIO_PORT_MPIN_MPORTP20_Msk = 0x100000
	// Bit MPORTP20.
	GPIO_PORT_MPIN_MPORTP20 = 0x100000
	// Position of MPORTP21 field.
	GPIO_PORT_MPIN_MPORTP21_Pos = 0x15
	// Bit mask of MPORTP21 field.
	GPIO_PORT_MPIN_MPORTP21_Msk = 0x200000
	// Bit MPORTP21.
	GPIO_PORT_MPIN_MPORTP21 = 0x200000
	// Position of MPORTP22 field.
	GPIO_PORT_MPIN_MPORTP22_Pos = 0x16
	// Bit mask of MPORTP22 field.
	GPIO_PORT_MPIN_MPORTP22_Msk = 0x400000
	// Bit MPORTP22.
	GPIO_PORT_MPIN_MPORTP22 = 0x400000
	// Position of MPORTP23 field.
	GPIO_PORT_MPIN_MPORTP23_Pos = 0x17
	// Bit mask of MPORTP23 field.
	GPIO_PORT_MPIN_MPORTP23_Msk = 0x800000
	// Bit MPORTP23.
	GPIO_PORT_MPIN_MPORTP23 = 0x800000
	// Position of MPORTP24 field.
	GPIO_PORT_MPIN_MPORTP24_Pos = 0x18
	// Bit mask of MPORTP24 field.
	GPIO_PORT_MPIN_MPORTP24_Msk = 0x1000000
	// Bit MPORTP24.
	GPIO_PORT_MPIN_MPORTP24 = 0x1000000
	// Position of MPORTP25 field.
	GPIO_PORT_MPIN_MPORTP25_Pos = 0x19
	// Bit mask of MPORTP25 field.
	GPIO_PORT_MPIN_MPORTP25_Msk = 0x2000000
	// Bit MPORTP25.
	GPIO_PORT_MPIN_MPORTP25 = 0x2000000
	// Position of MPORTP26 field.
	GPIO_PORT_MPIN_MPORTP26_Pos = 0x1a
	// Bit mask of MPORTP26 field.
	GPIO_PORT_MPIN_MPORTP26_Msk = 0x4000000
	// Bit MPORTP26.
	GPIO_PORT_MPIN_MPORTP26 = 0x4000000
	// Position of MPORTP27 field.
	GPIO_PORT_MPIN_MPORTP27_Pos = 0x1b
	// Bit mask of MPORTP27 field.
	GPIO_PORT_MPIN_MPORTP27_Msk = 0x8000000
	// Bit MPORTP27.
	GPIO_PORT_MPIN_MPORTP27 = 0x8000000
	// Position of MPORTP28 field.
	GPIO_PORT_MPIN_MPORTP28_Pos = 0x1c
	// Bit mask of MPORTP28 field.
	GPIO_PORT_MPIN_MPORTP28_Msk = 0x10000000
	// Bit MPORTP28.
	GPIO_PORT_MPIN_MPORTP28 = 0x10000000
	// Position of MPORTP29 field.
	GPIO_PORT_MPIN_MPORTP29_Pos = 0x1d
	// Bit mask of MPORTP29 field.
	GPIO_PORT_MPIN_MPORTP29_Msk = 0x20000000
	// Bit MPORTP29.
	GPIO_PORT_MPIN_MPORTP29 = 0x20000000
	// Position of MPORTP30 field.
	GPIO_PORT_MPIN_MPORTP30_Pos = 0x1e
	// Bit mask of MPORTP30 field.
	GPIO_PORT_MPIN_MPORTP30_Msk = 0x40000000
	// Bit MPORTP30.
	GPIO_PORT_MPIN_MPORTP30 = 0x40000000
	// Position of MPORTP31 field.
	GPIO_PORT_MPIN_MPORTP31_Pos = 0x1f
	// Bit mask of MPORTP31 field.
	GPIO_PORT_MPIN_MPORTP31_Msk = 0x80000000
	// Bit MPORTP31.
	GPIO_PORT_MPIN_MPORTP31 = 0x80000000

	// SET0: Write: Set register for port 0/1 Read: output bits for port 0/1
	// Position of SETP0 field.
	GPIO_PORT_SET_SETP0_Pos = 0x0
	// Bit mask of SETP0 field.
	GPIO_PORT_SET_SETP0_Msk = 0x1
	// Bit SETP0.
	GPIO_PORT_SET_SETP0 = 0x1
	// Position of SETP1 field.
	GPIO_PORT_SET_SETP1_Pos = 0x1
	// Bit mask of SETP1 field.
	GPIO_PORT_SET_SETP1_Msk = 0x2
	// Bit SETP1.
	GPIO_PORT_SET_SETP1 = 0x2
	// Position of SETP2 field.
	GPIO_PORT_SET_SETP2_Pos = 0x2
	// Bit mask of SETP2 field.
	GPIO_PORT_SET_SETP2_Msk = 0x4
	// Bit SETP2.
	GPIO_PORT_SET_SETP2 = 0x4
	// Position of SETP3 field.
	GPIO_PORT_SET_SETP3_Pos = 0x3
	// Bit mask of SETP3 field.
	GPIO_PORT_SET_SETP3_Msk = 0x8
	// Bit SETP3.
	GPIO_PORT_SET_SETP3 = 0x8
	// Position of SETP4 field.
	GPIO_PORT_SET_SETP4_Pos = 0x4
	// Bit mask of SETP4 field.
	GPIO_PORT_SET_SETP4_Msk = 0x10
	// Bit SETP4.
	GPIO_PORT_SET_SETP4 = 0x10
	// Position of SETP5 field.
	GPIO_PORT_SET_SETP5_Pos = 0x5
	// Bit mask of SETP5 field.
	GPIO_PORT_SET_SETP5_Msk = 0x20
	// Bit SETP5.
	GPIO_PORT_SET_SETP5 = 0x20
	// Position of SETP6 field.
	GPIO_PORT_SET_SETP6_Pos = 0x6
	// Bit mask of SETP6 field.
	GPIO_PORT_SET_SETP6_Msk = 0x40
	// Bit SETP6.
	GPIO_PORT_SET_SETP6 = 0x40
	// Position of SETP7 field.
	GPIO_PORT_SET_SETP7_Pos = 0x7
	// Bit mask of SETP7 field.
	GPIO_PORT_SET_SETP7_Msk = 0x80
	// Bit SETP7.
	GPIO_PORT_SET_SETP7 = 0x80
	// Position of SETP8 field.
	GPIO_PORT_SET_SETP8_Pos = 0x8
	// Bit mask of SETP8 field.
	GPIO_PORT_SET_SETP8_Msk = 0x100
	// Bit SETP8.
	GPIO_PORT_SET_SETP8 = 0x100
	// Position of SETP9 field.
	GPIO_PORT_SET_SETP9_Pos = 0x9
	// Bit mask of SETP9 field.
	GPIO_PORT_SET_SETP9_Msk = 0x200
	// Bit SETP9.
	GPIO_PORT_SET_SETP9 = 0x200
	// Position of SETP10 field.
	GPIO_PORT_SET_SETP10_Pos = 0xa
	// Bit mask of SETP10 field.
	GPIO_PORT_SET_SETP10_Msk = 0x400
	// Bit SETP10.
	GPIO_PORT_SET_SETP10 = 0x400
	// Position of SETP11 field.
	GPIO_PORT_SET_SETP11_Pos = 0xb
	// Bit mask of SETP11 field.
	GPIO_PORT_SET_SETP11_Msk = 0x800
	// Bit SETP11.
	GPIO_PORT_SET_SETP11 = 0x800
	// Position of SETP12 field.
	GPIO_PORT_SET_SETP12_Pos = 0xc
	// Bit mask of SETP12 field.
	GPIO_PORT_SET_SETP12_Msk = 0x1000
	// Bit SETP12.
	GPIO_PORT_SET_SETP12 = 0x1000
	// Position of SETP13 field.
	GPIO_PORT_SET_SETP13_Pos = 0xd
	// Bit mask of SETP13 field.
	GPIO_PORT_SET_SETP13_Msk = 0x2000
	// Bit SETP13.
	GPIO_PORT_SET_SETP13 = 0x2000
	// Position of SETP14 field.
	GPIO_PORT_SET_SETP14_Pos = 0xe
	// Bit mask of SETP14 field.
	GPIO_PORT_SET_SETP14_Msk = 0x4000
	// Bit SETP14.
	GPIO_PORT_SET_SETP14 = 0x4000
	// Position of SETP15 field.
	GPIO_PORT_SET_SETP15_Pos = 0xf
	// Bit mask of SETP15 field.
	GPIO_PORT_SET_SETP15_Msk = 0x8000
	// Bit SETP15.
	GPIO_PORT_SET_SETP15 = 0x8000
	// Position of SETP16 field.
	GPIO_PORT_SET_SETP16_Pos = 0x10
	// Bit mask of SETP16 field.
	GPIO_PORT_SET_SETP16_Msk = 0x10000
	// Bit SETP16.
	GPIO_PORT_SET_SETP16 = 0x10000
	// Position of SETP17 field.
	GPIO_PORT_SET_SETP17_Pos = 0x11
	// Bit mask of SETP17 field.
	GPIO_PORT_SET_SETP17_Msk = 0x20000
	// Bit SETP17.
	GPIO_PORT_SET_SETP17 = 0x20000
	// Position of SETP18 field.
	GPIO_PORT_SET_SETP18_Pos = 0x12
	// Bit mask of SETP18 field.
	GPIO_PORT_SET_SETP18_Msk = 0x40000
	// Bit SETP18.
	GPIO_PORT_SET_SETP18 = 0x40000
	// Position of SETP19 field.
	GPIO_PORT_SET_SETP19_Pos = 0x13
	// Bit mask of SETP19 field.
	GPIO_PORT_SET_SETP19_Msk = 0x80000
	// Bit SETP19.
	GPIO_PORT_SET_SETP19 = 0x80000
	// Position of SETP20 field.
	GPIO_PORT_SET_SETP20_Pos = 0x14
	// Bit mask of SETP20 field.
	GPIO_PORT_SET_SETP20_Msk = 0x100000
	// Bit SETP20.
	GPIO_PORT_SET_SETP20 = 0x100000
	// Position of SETP21 field.
	GPIO_PORT_SET_SETP21_Pos = 0x15
	// Bit mask of SETP21 field.
	GPIO_PORT_SET_SETP21_Msk = 0x200000
	// Bit SETP21.
	GPIO_PORT_SET_SETP21 = 0x200000
	// Position of SETP22 field.
	GPIO_PORT_SET_SETP22_Pos = 0x16
	// Bit mask of SETP22 field.
	GPIO_PORT_SET_SETP22_Msk = 0x400000
	// Bit SETP22.
	GPIO_PORT_SET_SETP22 = 0x400000
	// Position of SETP23 field.
	GPIO_PORT_SET_SETP23_Pos = 0x17
	// Bit mask of SETP23 field.
	GPIO_PORT_SET_SETP23_Msk = 0x800000
	// Bit SETP23.
	GPIO_PORT_SET_SETP23 = 0x800000
	// Position of SETP24 field.
	GPIO_PORT_SET_SETP24_Pos = 0x18
	// Bit mask of SETP24 field.
	GPIO_PORT_SET_SETP24_Msk = 0x1000000
	// Bit SETP24.
	GPIO_PORT_SET_SETP24 = 0x1000000
	// Position of SETP25 field.
	GPIO_PORT_SET_SETP25_Pos = 0x19
	// Bit mask of SETP25 field.
	GPIO_PORT_SET_SETP25_Msk = 0x2000000
	// Bit SETP25.
	GPIO_PORT_SET_SETP25 = 0x2000000
	// Position of SETP26 field.
	GPIO_PORT_SET_SETP26_Pos = 0x1a
	// Bit mask of SETP26 field.
	GPIO_PORT_SET_SETP26_Msk = 0x4000000
	// Bit SETP26.
	GPIO_PORT_SET_SETP26 = 0x4000000
	// Position of SETP27 field.
	GPIO_PORT_SET_SETP27_Pos = 0x1b
	// Bit mask of SETP27 field.
	GPIO_PORT_SET_SETP27_Msk = 0x8000000
	// Bit SETP27.
	GPIO_PORT_SET_SETP27 = 0x8000000
	// Position of SETP28 field.
	GPIO_PORT_SET_SETP28_Pos = 0x1c
	// Bit mask of SETP28 field.
	GPIO_PORT_SET_SETP28_Msk = 0x10000000
	// Bit SETP28.
	GPIO_PORT_SET_SETP28 = 0x10000000
	// Position of SETP29 field.
	GPIO_PORT_SET_SETP29_Pos = 0x1d
	// Bit mask of SETP29 field.
	GPIO_PORT_SET_SETP29_Msk = 0x20000000
	// Bit SETP29.
	GPIO_PORT_SET_SETP29 = 0x20000000
	// Position of SETP30 field.
	GPIO_PORT_SET_SETP30_Pos = 0x1e
	// Bit mask of SETP30 field.
	GPIO_PORT_SET_SETP30_Msk = 0x40000000
	// Bit SETP30.
	GPIO_PORT_SET_SETP30 = 0x40000000
	// Position of SETP31 field.
	GPIO_PORT_SET_SETP31_Pos = 0x1f
	// Bit mask of SETP31 field.
	GPIO_PORT_SET_SETP31_Msk = 0x80000000
	// Bit SETP31.
	GPIO_PORT_SET_SETP31 = 0x80000000

	// CLR0: Clear port 0/1
	// Position of CLRP00 field.
	GPIO_PORT_CLR_CLRP00_Pos = 0x0
	// Bit mask of CLRP00 field.
	GPIO_PORT_CLR_CLRP00_Msk = 0x1
	// Bit CLRP00.
	GPIO_PORT_CLR_CLRP00 = 0x1
	// Position of CLRP01 field.
	GPIO_PORT_CLR_CLRP01_Pos = 0x1
	// Bit mask of CLRP01 field.
	GPIO_PORT_CLR_CLRP01_Msk = 0x2
	// Bit CLRP01.
	GPIO_PORT_CLR_CLRP01 = 0x2
	// Position of CLRP02 field.
	GPIO_PORT_CLR_CLRP02_Pos = 0x2
	// Bit mask of CLRP02 field.
	GPIO_PORT_CLR_CLRP02_Msk = 0x4
	// Bit CLRP02.
	GPIO_PORT_CLR_CLRP02 = 0x4
	// Position of CLRP03 field.
	GPIO_PORT_CLR_CLRP03_Pos = 0x3
	// Bit mask of CLRP03 field.
	GPIO_PORT_CLR_CLRP03_Msk = 0x8
	// Bit CLRP03.
	GPIO_PORT_CLR_CLRP03 = 0x8
	// Position of CLRP04 field.
	GPIO_PORT_CLR_CLRP04_Pos = 0x4
	// Bit mask of CLRP04 field.
	GPIO_PORT_CLR_CLRP04_Msk = 0x10
	// Bit CLRP04.
	GPIO_PORT_CLR_CLRP04 = 0x10
	// Position of CLRP05 field.
	GPIO_PORT_CLR_CLRP05_Pos = 0x5
	// Bit mask of CLRP05 field.
	GPIO_PORT_CLR_CLRP05_Msk = 0x20
	// Bit CLRP05.
	GPIO_PORT_CLR_CLRP05 = 0x20
	// Position of CLRP06 field.
	GPIO_PORT_CLR_CLRP06_Pos = 0x6
	// Bit mask of CLRP06 field.
	GPIO_PORT_CLR_CLRP06_Msk = 0x40
	// Bit CLRP06.
	GPIO_PORT_CLR_CLRP06 = 0x40
	// Position of CLRP07 field.
	GPIO_PORT_CLR_CLRP07_Pos = 0x7
	// Bit mask of CLRP07 field.
	GPIO_PORT_CLR_CLRP07_Msk = 0x80
	// Bit CLRP07.
	GPIO_PORT_CLR_CLRP07 = 0x80
	// Position of CLRP08 field.
	GPIO_PORT_CLR_CLRP08_Pos = 0x8
	// Bit mask of CLRP08 field.
	GPIO_PORT_CLR_CLRP08_Msk = 0x100
	// Bit CLRP08.
	GPIO_PORT_CLR_CLRP08 = 0x100
	// Position of CLRP09 field.
	GPIO_PORT_CLR_CLRP09_Pos = 0x9
	// Bit mask of CLRP09 field.
	GPIO_PORT_CLR_CLRP09_Msk = 0x200
	// Bit CLRP09.
	GPIO_PORT_CLR_CLRP09 = 0x200
	// Position of CLRP010 field.
	GPIO_PORT_CLR_CLRP010_Pos = 0xa
	// Bit mask of CLRP010 field.
	GPIO_PORT_CLR_CLRP010_Msk = 0x400
	// Bit CLRP010.
	GPIO_PORT_CLR_CLRP010 = 0x400
	// Position of CLRP011 field.
	GPIO_PORT_CLR_CLRP011_Pos = 0xb
	// Bit mask of CLRP011 field.
	GPIO_PORT_CLR_CLRP011_Msk = 0x800
	// Bit CLRP011.
	GPIO_PORT_CLR_CLRP011 = 0x800
	// Position of CLRP012 field.
	GPIO_PORT_CLR_CLRP012_Pos = 0xc
	// Bit mask of CLRP012 field.
	GPIO_PORT_CLR_CLRP012_Msk = 0x1000
	// Bit CLRP012.
	GPIO_PORT_CLR_CLRP012 = 0x1000
	// Position of CLRP013 field.
	GPIO_PORT_CLR_CLRP013_Pos = 0xd
	// Bit mask of CLRP013 field.
	GPIO_PORT_CLR_CLRP013_Msk = 0x2000
	// Bit CLRP013.
	GPIO_PORT_CLR_CLRP013 = 0x2000
	// Position of CLRP014 field.
	GPIO_PORT_CLR_CLRP014_Pos = 0xe
	// Bit mask of CLRP014 field.
	GPIO_PORT_CLR_CLRP014_Msk = 0x4000
	// Bit CLRP014.
	GPIO_PORT_CLR_CLRP014 = 0x4000
	// Position of CLRP015 field.
	GPIO_PORT_CLR_CLRP015_Pos = 0xf
	// Bit mask of CLRP015 field.
	GPIO_PORT_CLR_CLRP015_Msk = 0x8000
	// Bit CLRP015.
	GPIO_PORT_CLR_CLRP015 = 0x8000
	// Position of CLRP016 field.
	GPIO_PORT_CLR_CLRP016_Pos = 0x10
	// Bit mask of CLRP016 field.
	GPIO_PORT_CLR_CLRP016_Msk = 0x10000
	// Bit CLRP016.
	GPIO_PORT_CLR_CLRP016 = 0x10000
	// Position of CLRP017 field.
	GPIO_PORT_CLR_CLRP017_Pos = 0x11
	// Bit mask of CLRP017 field.
	GPIO_PORT_CLR_CLRP017_Msk = 0x20000
	// Bit CLRP017.
	GPIO_PORT_CLR_CLRP017 = 0x20000
	// Position of CLRP018 field.
	GPIO_PORT_CLR_CLRP018_Pos = 0x12
	// Bit mask of CLRP018 field.
	GPIO_PORT_CLR_CLRP018_Msk = 0x40000
	// Bit CLRP018.
	GPIO_PORT_CLR_CLRP018 = 0x40000
	// Position of CLRP019 field.
	GPIO_PORT_CLR_CLRP019_Pos = 0x13
	// Bit mask of CLRP019 field.
	GPIO_PORT_CLR_CLRP019_Msk = 0x80000
	// Bit CLRP019.
	GPIO_PORT_CLR_CLRP019 = 0x80000
	// Position of CLRP020 field.
	GPIO_PORT_CLR_CLRP020_Pos = 0x14
	// Bit mask of CLRP020 field.
	GPIO_PORT_CLR_CLRP020_Msk = 0x100000
	// Bit CLRP020.
	GPIO_PORT_CLR_CLRP020 = 0x100000
	// Position of CLRP021 field.
	GPIO_PORT_CLR_CLRP021_Pos = 0x15
	// Bit mask of CLRP021 field.
	GPIO_PORT_CLR_CLRP021_Msk = 0x200000
	// Bit CLRP021.
	GPIO_PORT_CLR_CLRP021 = 0x200000
	// Position of CLRP022 field.
	GPIO_PORT_CLR_CLRP022_Pos = 0x16
	// Bit mask of CLRP022 field.
	GPIO_PORT_CLR_CLRP022_Msk = 0x400000
	// Bit CLRP022.
	GPIO_PORT_CLR_CLRP022 = 0x400000
	// Position of CLRP023 field.
	GPIO_PORT_CLR_CLRP023_Pos = 0x17
	// Bit mask of CLRP023 field.
	GPIO_PORT_CLR_CLRP023_Msk = 0x800000
	// Bit CLRP023.
	GPIO_PORT_CLR_CLRP023 = 0x800000
	// Position of CLRP024 field.
	GPIO_PORT_CLR_CLRP024_Pos = 0x18
	// Bit mask of CLRP024 field.
	GPIO_PORT_CLR_CLRP024_Msk = 0x1000000
	// Bit CLRP024.
	GPIO_PORT_CLR_CLRP024 = 0x1000000
	// Position of CLRP025 field.
	GPIO_PORT_CLR_CLRP025_Pos = 0x19
	// Bit mask of CLRP025 field.
	GPIO_PORT_CLR_CLRP025_Msk = 0x2000000
	// Bit CLRP025.
	GPIO_PORT_CLR_CLRP025 = 0x2000000
	// Position of CLRP026 field.
	GPIO_PORT_CLR_CLRP026_Pos = 0x1a
	// Bit mask of CLRP026 field.
	GPIO_PORT_CLR_CLRP026_Msk = 0x4000000
	// Bit CLRP026.
	GPIO_PORT_CLR_CLRP026 = 0x4000000
	// Position of CLRP027 field.
	GPIO_PORT_CLR_CLRP027_Pos = 0x1b
	// Bit mask of CLRP027 field.
	GPIO_PORT_CLR_CLRP027_Msk = 0x8000000
	// Bit CLRP027.
	GPIO_PORT_CLR_CLRP027 = 0x8000000
	// Position of CLRP028 field.
	GPIO_PORT_CLR_CLRP028_Pos = 0x1c
	// Bit mask of CLRP028 field.
	GPIO_PORT_CLR_CLRP028_Msk = 0x10000000
	// Bit CLRP028.
	GPIO_PORT_CLR_CLRP028 = 0x10000000
	// Position of CLRP029 field.
	GPIO_PORT_CLR_CLRP029_Pos = 0x1d
	// Bit mask of CLRP029 field.
	GPIO_PORT_CLR_CLRP029_Msk = 0x20000000
	// Bit CLRP029.
	GPIO_PORT_CLR_CLRP029 = 0x20000000
	// Position of CLRP030 field.
	GPIO_PORT_CLR_CLRP030_Pos = 0x1e
	// Bit mask of CLRP030 field.
	GPIO_PORT_CLR_CLRP030_Msk = 0x40000000
	// Bit CLRP030.
	GPIO_PORT_CLR_CLRP030 = 0x40000000
	// Position of CLRP031 field.
	GPIO_PORT_CLR_CLRP031_Pos = 0x1f
	// Bit mask of CLRP031 field.
	GPIO_PORT_CLR_CLRP031_Msk = 0x80000000
	// Bit CLRP031.
	GPIO_PORT_CLR_CLRP031 = 0x80000000

	// NOT0: Toggle port 0/1
	// Position of NOTP0 field.
	GPIO_PORT_NOT_NOTP0_Pos = 0x0
	// Bit mask of NOTP0 field.
	GPIO_PORT_NOT_NOTP0_Msk = 0x1
	// Bit NOTP0.
	GPIO_PORT_NOT_NOTP0 = 0x1
	// Position of NOTP1 field.
	GPIO_PORT_NOT_NOTP1_Pos = 0x1
	// Bit mask of NOTP1 field.
	GPIO_PORT_NOT_NOTP1_Msk = 0x2
	// Bit NOTP1.
	GPIO_PORT_NOT_NOTP1 = 0x2
	// Position of NOTP2 field.
	GPIO_PORT_NOT_NOTP2_Pos = 0x2
	// Bit mask of NOTP2 field.
	GPIO_PORT_NOT_NOTP2_Msk = 0x4
	// Bit NOTP2.
	GPIO_PORT_NOT_NOTP2 = 0x4
	// Position of NOTP3 field.
	GPIO_PORT_NOT_NOTP3_Pos = 0x3
	// Bit mask of NOTP3 field.
	GPIO_PORT_NOT_NOTP3_Msk = 0x8
	// Bit NOTP3.
	GPIO_PORT_NOT_NOTP3 = 0x8
	// Position of NOTP4 field.
	GPIO_PORT_NOT_NOTP4_Pos = 0x4
	// Bit mask of NOTP4 field.
	GPIO_PORT_NOT_NOTP4_Msk = 0x10
	// Bit NOTP4.
	GPIO_PORT_NOT_NOTP4 = 0x10
	// Position of NOTP5 field.
	GPIO_PORT_NOT_NOTP5_Pos = 0x5
	// Bit mask of NOTP5 field.
	GPIO_PORT_NOT_NOTP5_Msk = 0x20
	// Bit NOTP5.
	GPIO_PORT_NOT_NOTP5 = 0x20
	// Position of NOTP6 field.
	GPIO_PORT_NOT_NOTP6_Pos = 0x6
	// Bit mask of NOTP6 field.
	GPIO_PORT_NOT_NOTP6_Msk = 0x40
	// Bit NOTP6.
	GPIO_PORT_NOT_NOTP6 = 0x40
	// Position of NOTP7 field.
	GPIO_PORT_NOT_NOTP7_Pos = 0x7
	// Bit mask of NOTP7 field.
	GPIO_PORT_NOT_NOTP7_Msk = 0x80
	// Bit NOTP7.
	GPIO_PORT_NOT_NOTP7 = 0x80
	// Position of NOTP8 field.
	GPIO_PORT_NOT_NOTP8_Pos = 0x8
	// Bit mask of NOTP8 field.
	GPIO_PORT_NOT_NOTP8_Msk = 0x100
	// Bit NOTP8.
	GPIO_PORT_NOT_NOTP8 = 0x100
	// Position of NOTP9 field.
	GPIO_PORT_NOT_NOTP9_Pos = 0x9
	// Bit mask of NOTP9 field.
	GPIO_PORT_NOT_NOTP9_Msk = 0x200
	// Bit NOTP9.
	GPIO_PORT_NOT_NOTP9 = 0x200
	// Position of NOTP10 field.
	GPIO_PORT_NOT_NOTP10_Pos = 0xa
	// Bit mask of NOTP10 field.
	GPIO_PORT_NOT_NOTP10_Msk = 0x400
	// Bit NOTP10.
	GPIO_PORT_NOT_NOTP10 = 0x400
	// Position of NOTP11 field.
	GPIO_PORT_NOT_NOTP11_Pos = 0xb
	// Bit mask of NOTP11 field.
	GPIO_PORT_NOT_NOTP11_Msk = 0x800
	// Bit NOTP11.
	GPIO_PORT_NOT_NOTP11 = 0x800
	// Position of NOTP12 field.
	GPIO_PORT_NOT_NOTP12_Pos = 0xc
	// Bit mask of NOTP12 field.
	GPIO_PORT_NOT_NOTP12_Msk = 0x1000
	// Bit NOTP12.
	GPIO_PORT_NOT_NOTP12 = 0x1000
	// Position of NOTP13 field.
	GPIO_PORT_NOT_NOTP13_Pos = 0xd
	// Bit mask of NOTP13 field.
	GPIO_PORT_NOT_NOTP13_Msk = 0x2000
	// Bit NOTP13.
	GPIO_PORT_NOT_NOTP13 = 0x2000
	// Position of NOTP14 field.
	GPIO_PORT_NOT_NOTP14_Pos = 0xe
	// Bit mask of NOTP14 field.
	GPIO_PORT_NOT_NOTP14_Msk = 0x4000
	// Bit NOTP14.
	GPIO_PORT_NOT_NOTP14 = 0x4000
	// Position of NOTP15 field.
	GPIO_PORT_NOT_NOTP15_Pos = 0xf
	// Bit mask of NOTP15 field.
	GPIO_PORT_NOT_NOTP15_Msk = 0x8000
	// Bit NOTP15.
	GPIO_PORT_NOT_NOTP15 = 0x8000
	// Position of NOTP16 field.
	GPIO_PORT_NOT_NOTP16_Pos = 0x10
	// Bit mask of NOTP16 field.
	GPIO_PORT_NOT_NOTP16_Msk = 0x10000
	// Bit NOTP16.
	GPIO_PORT_NOT_NOTP16 = 0x10000
	// Position of NOTP17 field.
	GPIO_PORT_NOT_NOTP17_Pos = 0x11
	// Bit mask of NOTP17 field.
	GPIO_PORT_NOT_NOTP17_Msk = 0x20000
	// Bit NOTP17.
	GPIO_PORT_NOT_NOTP17 = 0x20000
	// Position of NOTP18 field.
	GPIO_PORT_NOT_NOTP18_Pos = 0x12
	// Bit mask of NOTP18 field.
	GPIO_PORT_NOT_NOTP18_Msk = 0x40000
	// Bit NOTP18.
	GPIO_PORT_NOT_NOTP18 = 0x40000
	// Position of NOTP19 field.
	GPIO_PORT_NOT_NOTP19_Pos = 0x13
	// Bit mask of NOTP19 field.
	GPIO_PORT_NOT_NOTP19_Msk = 0x80000
	// Bit NOTP19.
	GPIO_PORT_NOT_NOTP19 = 0x80000
	// Position of NOTP20 field.
	GPIO_PORT_NOT_NOTP20_Pos = 0x14
	// Bit mask of NOTP20 field.
	GPIO_PORT_NOT_NOTP20_Msk = 0x100000
	// Bit NOTP20.
	GPIO_PORT_NOT_NOTP20 = 0x100000
	// Position of NOTP21 field.
	GPIO_PORT_NOT_NOTP21_Pos = 0x15
	// Bit mask of NOTP21 field.
	GPIO_PORT_NOT_NOTP21_Msk = 0x200000
	// Bit NOTP21.
	GPIO_PORT_NOT_NOTP21 = 0x200000
	// Position of NOTP22 field.
	GPIO_PORT_NOT_NOTP22_Pos = 0x16
	// Bit mask of NOTP22 field.
	GPIO_PORT_NOT_NOTP22_Msk = 0x400000
	// Bit NOTP22.
	GPIO_PORT_NOT_NOTP22 = 0x400000
	// Position of NOTP23 field.
	GPIO_PORT_NOT_NOTP23_Pos = 0x17
	// Bit mask of NOTP23 field.
	GPIO_PORT_NOT_NOTP23_Msk = 0x800000
	// Bit NOTP23.
	GPIO_PORT_NOT_NOTP23 = 0x800000
	// Position of NOTP24 field.
	GPIO_PORT_NOT_NOTP24_Pos = 0x18
	// Bit mask of NOTP24 field.
	GPIO_PORT_NOT_NOTP24_Msk = 0x1000000
	// Bit NOTP24.
	GPIO_PORT_NOT_NOTP24 = 0x1000000
	// Position of NOTP25 field.
	GPIO_PORT_NOT_NOTP25_Pos = 0x19
	// Bit mask of NOTP25 field.
	GPIO_PORT_NOT_NOTP25_Msk = 0x2000000
	// Bit NOTP25.
	GPIO_PORT_NOT_NOTP25 = 0x2000000
	// Position of NOTP26 field.
	GPIO_PORT_NOT_NOTP26_Pos = 0x1a
	// Bit mask of NOTP26 field.
	GPIO_PORT_NOT_NOTP26_Msk = 0x4000000
	// Bit NOTP26.
	GPIO_PORT_NOT_NOTP26 = 0x4000000
	// Position of NOTP27 field.
	GPIO_PORT_NOT_NOTP27_Pos = 0x1b
	// Bit mask of NOTP27 field.
	GPIO_PORT_NOT_NOTP27_Msk = 0x8000000
	// Bit NOTP27.
	GPIO_PORT_NOT_NOTP27 = 0x8000000
	// Position of NOTP28 field.
	GPIO_PORT_NOT_NOTP28_Pos = 0x1c
	// Bit mask of NOTP28 field.
	GPIO_PORT_NOT_NOTP28_Msk = 0x10000000
	// Bit NOTP28.
	GPIO_PORT_NOT_NOTP28 = 0x10000000
	// Position of NOTP29 field.
	GPIO_PORT_NOT_NOTP29_Pos = 0x1d
	// Bit mask of NOTP29 field.
	GPIO_PORT_NOT_NOTP29_Msk = 0x20000000
	// Bit NOTP29.
	GPIO_PORT_NOT_NOTP29 = 0x20000000
	// Position of NOTP30 field.
	GPIO_PORT_NOT_NOTP30_Pos = 0x1e
	// Bit mask of NOTP30 field.
	GPIO_PORT_NOT_NOTP30_Msk = 0x40000000
	// Bit NOTP30.
	GPIO_PORT_NOT_NOTP30 = 0x40000000
	// Position of NOTP31 field.
	GPIO_PORT_NOT_NOTP31_Pos = 0x1f
	// Bit mask of NOTP31 field.
	GPIO_PORT_NOT_NOTP31_Msk = 0x80000000
	// Bit NOTP31.
	GPIO_PORT_NOT_NOTP31 = 0x80000000
)
