"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const commandRunner_1 = require("../../src/utils/commandRunner");
const chai_1 = require("chai");
const workspaceManager_1 = require("../../src/services/workspaceManager");
const node_1 = require("vscode-languageserver/node");
const helper_1 = require("../helper");
const path = __importStar(require("path"));
const fs_1 = require("fs");
describe("commandRunner", () => {
    const packageJsonPath = require.resolve("../../package.json");
    const packageJsonContents = (0, fs_1.readFileSync)(packageJsonPath).toString();
    const pkgJSON = JSON.parse(packageJsonContents);
    const tests = [
        {
            args: [
                path.join(path.resolve(__dirname, "..", ".."), "bin", "ansible-language-server"),
                "--version",
            ],
            rc: 0,
            stdout: `${pkgJSON["version"]}`,
            stderr: "",
            pythonInterpreterPath: "",
        },
        {
            args: ["ansible-config", "dump"],
            rc: 0,
            stdout: "ANSIBLE_FORCE_COLOR",
            stderr: "",
            pythonInterpreterPath: "",
        },
        {
            args: ["ansible", "--version"],
            rc: 0,
            stdout: "configured module search path",
            stderr: "",
            pythonInterpreterPath: "",
        },
        {
            args: ["ansible-lint", "--version"],
            rc: 0,
            stdout: "using ansible",
            stderr: "",
            pythonInterpreterPath: "",
        },
        {
            args: ["ansible-playbook", "missing-file"],
            rc: 1,
            stdout: "",
            stderr: "ERROR! the playbook: missing-file could not be found",
            pythonInterpreterPath: "",
        },
        {
            args: [
                "python",
                "-c",
                "\"import os; print(os.environ.get('VIRTUAL_ENV'))\"",
            ],
            rc: 0,
            stdout: "path-before-python",
            stderr: "",
            pythonInterpreterPath: "path-before-python/bin/python",
        },
    ];
    tests.forEach(({ args, rc, stdout, stderr, pythonInterpreterPath }) => {
        it(`call ${args.join(" ")}`, async function () {
            this.timeout(10000);
            // try to enforce ansible to output ANSI in order to check if we are
            // still able to disable it at runtime in order to keep output parseable.
            process.env.ANSIBLE_FORCE_COLOR = "1";
            process.argv.push("--node-ipc");
            const connection = (0, node_1.createConnection)();
            const workspaceManager = new workspaceManager_1.WorkspaceManager(connection);
            const textDoc = (0, helper_1.getDoc)("yaml/ancestryBuilder.yml");
            const context = workspaceManager.getContext(textDoc.uri);
            if (context) {
                const settings = await context.documentSettings.get(textDoc.uri);
                if (pythonInterpreterPath) {
                    settings.python.interpreterPath = pythonInterpreterPath;
                }
                const commandRunner = new commandRunner_1.CommandRunner(connection, context, settings);
                try {
                    const proc = await commandRunner.runCommand(args[0], args.slice(1).join(" "));
                    (0, chai_1.expect)(proc.stdout, proc.stderr).contains(stdout);
                    (0, chai_1.expect)(proc.stderr, proc.stdout).contains(stderr);
                }
                catch (e) {
                    if (e instanceof chai_1.AssertionError) {
                        throw e;
                    }
                    if (e instanceof Error) {
                        const err = e;
                        (0, chai_1.expect)(err.code).equals(rc);
                        (0, chai_1.expect)(err.stdout).contains(stdout);
                        (0, chai_1.expect)(err.stderr).contains(stderr);
                    }
                }
            }
        });
    });
});
