/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import javax.swing.JOptionPane;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.Base;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.legacy.PApplet;

public class UpdateCheck
implements Runnable {
    Base base;
    String downloadURL = "https://www.arduino.cc/latest.txt";
    static final long ONE_DAY = 86400000L;

    public UpdateCheck(Base base) {
        Thread thread = new Thread(this);
        this.base = base;
        thread.start();
    }

    @Override
    public void run() {
        long id;
        String idString = PreferencesData.get((String)"update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            Random r = new Random();
            id = r.nextLong();
            PreferencesData.set((String)"update.id", (String)String.valueOf(id));
        }
        try {
            long when;
            String info = URLEncoder.encode(id + "\t" + PApplet.nf((int)10819, (int)4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch"), "UTF-8");
            int latest = this.readInt(this.downloadURL + "?" + info);
            String lastString = PreferencesData.get((String)"update.last");
            long now = System.currentTimeMillis();
            if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
                return;
            }
            PreferencesData.set((String)"update.last", (String)String.valueOf(now));
            String prompt = I18n.tr((String)"A new version of Arduino is available,\nwould you like to visit the Arduino download page?");
            if (this.base.activeEditor != null && latest > 10819) {
                Object[] options = new Object[]{I18n.tr((String)"Yes"), I18n.tr((String)"No")};
                int result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, I18n.tr((String)"Update"), 0, 3, null, options, options[0]);
                if (result == 0) {
                    Base.openURL("https://www.arduino.cc/en/software");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readInt(String filename) throws IOException {
        int n;
        URL url = new URL(filename);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            n = Integer.parseInt(reader.readLine());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        return n;
    }
}

