/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.FileTypeAdapter;

public class CodeExplorerConfigurations {
    private static final String CODE_EXPLORER_JSON_FILE = "codeExplorer.json";
    private static final File DEFAULT_CONFIGURATION_FILE = new File(Compat.getApplicationUserDirectory(), "codeExplorer.json");
    private List<CodeExplorerConfiguration> configurations;
    private static final Gson OBJECT_MAPPER = new GsonBuilder().registerTypeAdapter(File.class, (Object)new FileTypeAdapter()).setPrettyPrinting().create();
    private static final Type CONFIGURATIONS_TYPE = new TypeToken<List<CodeExplorerConfiguration>>(){}.getType();

    public CodeExplorerConfigurations(List<CodeExplorerConfiguration> configurations) {
        this.configurations = configurations;
    }

    public List<CodeExplorerConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<CodeExplorerConfiguration> configurations) {
        this.configurations = configurations;
    }

    public void saveConfiguration() {
        this.saveConfiguration(DEFAULT_CONFIGURATION_FILE);
    }

    void saveConfiguration(File file) {
        try (FileWriter writer = new FileWriter(file);){
            OBJECT_MAPPER.toJson(this.configurations, (Appendable)writer);
        }
        catch (JsonIOException | IOException e) {
            LogUtils.severe((Throwable)e);
        }
    }

    public static CodeExplorerConfigurations loadConfigurations() {
        File configurationFile = DEFAULT_CONFIGURATION_FILE;
        return CodeExplorerConfigurations.loadConfigurations(configurationFile);
    }

    static CodeExplorerConfigurations loadConfigurations(File configurationFile) {
        ArrayList<CodeExplorerConfiguration> configurations = !configurationFile.exists() ? new ArrayList() : CodeExplorerConfigurations.fromJsonFile(configurationFile);
        return new CodeExplorerConfigurations(configurations);
    }

    private static List<CodeExplorerConfiguration> fromJsonFile(File configurationFile) {
        List list;
        FileReader reader = new FileReader(configurationFile);
        try {
            List configurations = (List)OBJECT_MAPPER.fromJson((Reader)reader, CONFIGURATIONS_TYPE);
            configurations.forEach(CodeExplorerConfiguration::applyConfigurationRules);
            list = configurations;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException e) {
                LogUtils.severe((Throwable)e);
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }
}

