/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.ExportAction;
import org.freeplane.features.export.mindmapmode.ExportBranchesAction;
import org.freeplane.features.export.mindmapmode.ExportBranchesToHTML;
import org.freeplane.features.export.mindmapmode.ExportDialog;
import org.freeplane.features.export.mindmapmode.ExportToHTML;
import org.freeplane.features.export.mindmapmode.ExportToImage;
import org.freeplane.features.export.mindmapmode.ExportToOoWriter;
import org.freeplane.features.export.mindmapmode.ExportWithXSLT;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.export.mindmapmode.XsltExportEngineFactory;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;

public class ExportController
implements IExtension {
    private final HashMap<FileFilter, IExportEngine> mapExportEngines = new HashMap();
    private final ArrayList<FileFilter> mapExportFileFilters = new ArrayList();
    private final HashMap<FileFilter, IExportEngine> branchExportEngines = new HashMap();
    private final ArrayList<FileFilter> branchExportFileFilters = new ArrayList();
    private boolean fileFiltersSorted;

    public static void install(ExportController exportController) {
        Controller.getCurrentModeController().addExtension(ExportController.class, (IExtension)exportController);
    }

    public ExportController(String xmlDescriptorFile) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new ExportAction());
        modeController.addAction((AFreeplaneAction)new ExportBranchesAction());
        ExportToHTML exportToHTML = new ExportToHTML();
        this.addMapExportEngine(exportToHTML.getFileFilter(), exportToHTML);
        ExportBranchesToHTML exportBranchesToHTML = new ExportBranchesToHTML();
        this.addBranchExportEngine(exportBranchesToHTML.getFileFilter(), exportBranchesToHTML);
        ExportToOoWriter exportToOoWriter = new ExportToOoWriter();
        this.addMapExportEngine(exportToOoWriter.getFileFilter(), exportToOoWriter);
        this.addBranchExportEngine(exportToOoWriter.getFileFilter(), exportToOoWriter);
        this.createImageExporters();
        this.createXSLTExportActions(xmlDescriptorFile);
        new XsltExportEngineFactory().gatherXsltScripts(this);
        this.fileFiltersSorted = false;
    }

    private void sortFileFilters() {
        if (!this.fileFiltersSorted) {
            this.fileFiltersSorted = true;
            Comparator<FileFilter> fileFilterComparator = new Comparator<FileFilter>(){

                @Override
                public int compare(FileFilter f1, FileFilter f2) {
                    return f1.getDescription().compareToIgnoreCase(f2.getDescription());
                }
            };
            Collections.sort(this.mapExportFileFilters, fileFilterComparator);
            Collections.sort(this.branchExportFileFilters, fileFilterComparator);
        }
    }

    public void createImageExporters() {
        ExportToImage pngExport = new ExportToImage("png", "Portable Network Graphic (PNG)");
        this.addMapExportEngine(pngExport.getFileFilter(), pngExport);
        ExportToImage jpgExport = new ExportToImage("jpg", "Compressed image (JPEG)");
        this.addMapExportEngine(jpgExport.getFileFilter(), jpgExport);
    }

    private void createXSLTExportActions(String xmlDescriptorFile) {
        URL resource = ResourceController.getResourceController().getResource(xmlDescriptorFile);
        try (InputStream xmlDescriptorStream = resource.openStream();){
            IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
            StdXMLReader reader = new StdXMLReader(xmlDescriptorStream);
            parser.setReader((IXMLReader)reader);
            XMLElement xml = (XMLElement)parser.parse();
            Enumeration actionDescriptors = xml.enumerateChildren();
            while (actionDescriptors.hasMoreElements()) {
                XMLElement descriptor = (XMLElement)actionDescriptors.nextElement();
                String name = descriptor.getAttribute("name", null);
                XMLElement xmlProperties = descriptor.getFirstChildNamed("properties");
                Properties properties = xmlProperties.getAttributes();
                ExportWithXSLT action = new ExportWithXSLT(name, properties);
                FileFilter fileFilter = action.getFileFilter();
                this.addMapExportEngine(fileFilter, action);
                if (!Boolean.parseBoolean(properties.getProperty("branch_export"))) continue;
                this.addBranchExportEngine(fileFilter, action);
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }

    public void addMapExportEngine(FileFilter filter, IExportEngine exporter) {
        if (!this.mapExportEngines.values().contains(exporter)) {
            this.mapExportFileFilters.add(filter);
            this.mapExportEngines.put(filter, exporter);
            this.fileFiltersSorted = false;
        }
    }

    public void addBranchExportEngine(FileFilter filter, IExportEngine exporter) {
        if (!this.branchExportEngines.values().contains(exporter)) {
            this.branchExportFileFilters.add(filter);
            this.branchExportEngines.put(filter, exporter);
            this.fileFiltersSorted = false;
        }
    }

    public HashMap<FileFilter, IExportEngine> getMapExportEngines() {
        return this.mapExportEngines;
    }

    public HashMap<FileFilter, IExportEngine> getBranchExportEngines() {
        return this.branchExportEngines;
    }

    public List<FileFilter> getMapExportFileFilters() {
        this.sortFileFilters();
        return this.mapExportFileFilters;
    }

    public List<FileFilter> getBranchExportFileFilters() {
        this.sortFileFilters();
        return this.branchExportFileFilters;
    }

    public static ExportController getContoller() {
        return ExportController.getController(Controller.getCurrentModeController());
    }

    public static ExportController getController(ModeController modeController) {
        return (ExportController)modeController.getExtension(ExportController.class);
    }

    public boolean checkCurrentMap(MapModel map) {
        if (map.equals(Controller.getCurrentController().getMap())) {
            return true;
        }
        UITools.errorMessage((Object)TextUtils.getText((String)"export_works_for_current_map_only"));
        return false;
    }

    ExportDialog createMapExportDialog() {
        return new ExportDialog(this.getMapExportFileFilters(), this.getMapExportEngines(), "ExportAction.text");
    }

    ExportDialog createBranchExportDialog() {
        return new ExportDialog(this.getBranchExportFileFilters(), this.getBranchExportEngines(), "ExportBranchesAction.text");
    }
}

