/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij;

import java.lang.ref.Reference;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.BundleBase;
import org.jetbrains.kotlin.com.intellij.Utf8ResourceControl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.DefaultBundleService;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();
    private Reference<ResourceBundle.Control> myControl;
    private Reference<ResourceBundle> myBundle;
    private Reference<ResourceBundle> myDefaultBundle;
    @NonNls
    private final String myPathToBundle;

    public AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(0);
        }
        this.myPathToBundle = pathToBundle;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getMessage(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(1);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(2);
        }
        return AbstractBundle.message(this.getResourceBundle(this.getClass().getClassLoader()), key, params);
    }

    public @NotNull Supplier<@Nls String> getLazyMessage(@NotNull @NonNls String key, Object ... params) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(6);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(7);
        }
        Supplier<String> supplier = () -> this.getMessage(key, params);
        if (supplier == null) {
            AbstractBundle.$$$reportNull$$$0(8);
        }
        return supplier;
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params) {
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(15);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(16);
        }
        if (params == null) {
            AbstractBundle.$$$reportNull$$$0(17);
        }
        String string2 = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string2 == null) {
            AbstractBundle.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader2) {
        boolean isDefault;
        ResourceBundle bundle;
        if (classLoader2 == null) {
            AbstractBundle.$$$reportNull$$$0(23);
        }
        if ((bundle = SoftReference.dereference((isDefault = DefaultBundleService.isDefaultBundle()) ? this.myDefaultBundle : this.myBundle)) == null) {
            bundle = this.resolveResourceBundle(this.myPathToBundle, classLoader2);
            java.lang.ref.SoftReference<ResourceBundle> ref = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.myDefaultBundle = ref;
            } else {
                this.myBundle = ref;
            }
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(24);
        }
        return resourceBundle;
    }

    @NotNull
    private ResourceBundle resolveResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        ResourceBundle resourceBundle;
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(28);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(29);
        }
        try {
            ResourceBundle.Control control = this.getResourceBundleControl();
            resourceBundle = this.findBundle(pathToBundle, loader, control);
        }
        catch (MissingResourceException e) {
            LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
            ResourceBundle.clearCache(loader);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            if (resourceBundle2 == null) {
                AbstractBundle.$$$reportNull$$$0(31);
            }
            return resourceBundle2;
        }
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(30);
        }
        return resourceBundle;
    }

    private ResourceBundle.Control getResourceBundleControl() {
        ResourceBundle.Control control = SoftReference.dereference(this.myControl);
        if (control == null) {
            control = SystemInfo.isJavaVersionAtLeast(9) ? ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES) : Utf8ResourceControl.INSTANCE;
            this.myControl = new SoftReference<ResourceBundle.Control>(control);
        }
        return control;
    }

    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(32);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(33);
        }
        if (control == null) {
            AbstractBundle.$$$reportNull$$$0(34);
        }
        return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/AbstractBundle";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/AbstractBundle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyMessage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPartialMessage";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLazyMessage";
                break;
            }
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "messageOrNull";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

